/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Like$;
import org.apache.spark.sql.catalyst.expressions.StringRegexExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.StringUtils$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="str _FUNC_ pattern - Returns true if str matches pattern, null if any arguments are null, false otherwise.", arguments="\n    Arguments:\n      * str - a string expression\n      * pattern - a string expression. The pattern is a string which is matched literally, with\n          exception to the following special symbols:\n\n          _ matches any one character in the input (similar to . in posix regular expressions)\n\n          % matches zero or more characters in the input (similar to .* in posix regular\n          expressions)\n\n          The escape character is '\\'. If an escape character precedes a special symbol or another\n          escape character, the following character is matched literally. It is invalid to escape\n          any other character.\n\n          Since Spark 2.0, string literals are unescaped in our SQL parser. For example, in order\n          to match \"\\abc\", the pattern should be \"\\\\abc\".\n\n          When SQL config 'spark.sql.parser.escapedStringLiterals' is enabled, it fallbacks\n          to Spark 1.6 behavior regarding string literal parsing. For example, if the config is\n          enabled, the pattern to match \"\\abc\" should be \"\\abc\".\n  ", examples="\n    Examples:\n      > SELECT '%SystemDrive%\\Users\\John' _FUNC_ '\\%SystemDrive\\%\\\\Users%'\n      true\n  ", note="\n    Use RLIKE to match with standard regular expressions.\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005-f\u0001B\u0001\u0003\u0001>\u0011A\u0001T5lK*\u00111\u0001B\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001!QQ\u0002CA\t\u0013\u001b\u0005\u0011\u0011BA\n\u0003\u0005U\u0019FO]5oOJ+w-\u001a=FqB\u0014Xm]:j_:\u0004\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u00167%\u0011AD\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t=\u0001\u0011)\u001a!C\u0001?\u0005!A.\u001a4u+\u0005\u0001\u0003CA\t\"\u0013\t\u0011#A\u0001\u0006FqB\u0014Xm]:j_:D\u0001\u0002\n\u0001\u0003\u0012\u0003\u0006I\u0001I\u0001\u0006Y\u00164G\u000f\t\u0005\tM\u0001\u0011)\u001a!C\u0001?\u0005)!/[4ii\"A\u0001\u0006\u0001B\tB\u0003%\u0001%\u0001\u0004sS\u001eDG\u000f\t\u0005\u0006U\u0001!\taK\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00071jc\u0006\u0005\u0002\u0012\u0001!)a$\u000ba\u0001A!)a%\u000ba\u0001A!)\u0001\u0007\u0001C!c\u00051Qm]2ba\u0016$\"AM\u001f\u0011\u0005MRdB\u0001\u001b9!\t)d#D\u00017\u0015\t9d\"\u0001\u0004=e>|GOP\u0005\u0003sY\ta\u0001\u0015:fI\u00164\u0017BA\u001e=\u0005\u0019\u0019FO]5oO*\u0011\u0011H\u0006\u0005\u0006}=\u0002\rAM\u0001\u0002m\")\u0001\t\u0001C!\u0003\u00069Q.\u0019;dQ\u0016\u001cHc\u0001\"F!B\u0011QcQ\u0005\u0003\tZ\u0011qAQ8pY\u0016\fg\u000eC\u0003G\u007f\u0001\u0007q)A\u0003sK\u001e,\u0007\u0010\u0005\u0002I\u001d6\t\u0011J\u0003\u0002G\u0015*\u00111\nT\u0001\u0005kRLGNC\u0001N\u0003\u0011Q\u0017M^1\n\u0005=K%a\u0002)biR,'O\u001c\u0005\u0006#~\u0002\rAM\u0001\u0004gR\u0014\b\"B*\u0001\t\u0003\"\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003IBQA\u0016\u0001\u0005R]\u000b\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\u0007as6\r\u0005\u0002Z96\t!L\u0003\u0002\\\u0005\u000591m\u001c3fO\u0016t\u0017BA/[\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007\"B0V\u0001\u0004\u0001\u0017aA2uqB\u0011\u0011,Y\u0005\u0003Ej\u0013abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0003e+\u0002\u0007\u0001,\u0001\u0002fm\"9a\rAA\u0001\n\u00039\u0017\u0001B2paf$2\u0001\f5j\u0011\u001dqR\r%AA\u0002\u0001BqAJ3\u0011\u0002\u0003\u0007\u0001\u0005C\u0004l\u0001E\u0005I\u0011\u00017\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\tQN\u000b\u0002!].\nq\u000e\u0005\u0002qk6\t\u0011O\u0003\u0002sg\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003iZ\t!\"\u00198o_R\fG/[8o\u0013\t1\u0018OA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016Dq\u0001\u001f\u0001\u0012\u0002\u0013\u0005A.\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\t\u000fi\u0004\u0011\u0011!C!w\u0006i\u0001O]8ek\u000e$\bK]3gSb,\u0012\u0001 \t\u0004{\u0006\u0005Q\"\u0001@\u000b\u0005}d\u0015\u0001\u00027b]\u001eL!a\u000f@\t\u0013\u0005\u0015\u0001!!A\u0005\u0002\u0005\u001d\u0011\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u0005!\r)\u00121B\u0005\u0004\u0003\u001b1\"aA%oi\"I\u0011\u0011\u0003\u0001\u0002\u0002\u0013\u0005\u00111C\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t)\"a\u0007\u0011\u0007U\t9\"C\u0002\u0002\u001aY\u00111!\u00118z\u0011)\ti\"a\u0004\u0002\u0002\u0003\u0007\u0011\u0011B\u0001\u0004q\u0012\n\u0004\"CA\u0011\u0001\u0005\u0005I\u0011IA\u0012\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\u0013!\u0019\t9#!\f\u0002\u00165\u0011\u0011\u0011\u0006\u0006\u0004\u0003W1\u0012AC2pY2,7\r^5p]&!\u0011qFA\u0015\u0005!IE/\u001a:bi>\u0014\b\"CA\u001a\u0001\u0005\u0005I\u0011AA\u001b\u0003!\u0019\u0017M\\#rk\u0006dGc\u0001\"\u00028!Q\u0011QDA\u0019\u0003\u0003\u0005\r!!\u0006\t\u0013\u0005m\u0002!!A\u0005B\u0005u\u0012AB3rk\u0006d7\u000fF\u0002C\u0003\u007fA!\"!\b\u0002:\u0005\u0005\t\u0019AA\u000bQM\u0001\u00111IA%\u0003\u0017\ny%!\u0015\u0002V\u0005]\u00131LA/!\r\t\u0012QI\u0005\u0004\u0003\u000f\u0012!!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003\u001b\n!n\u001d;sA}3UKT\"`AA\fG\u000f^3s]\u0002j\u0003EU3ukJt7\u000f\t;sk\u0016\u0004\u0013N\u001a\u0011tiJ\u0004S.\u0019;dQ\u0016\u001c\b\u0005]1ui\u0016\u0014h\u000e\f\u0011ok2d\u0007%\u001b4!C:L\b%\u0019:hk6,g\u000e^:!CJ,\u0007E\\;mY2\u0002c-\u00197tK\u0002zG\u000f[3so&\u001cXML\u0001\nCJ<W/\\3oiN\f#!a\u0015\u0002\u0011oQ\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006I:ue\u0002j\u0003%\u0019\u0011tiJLgn\u001a\u0011fqB\u0014Xm]:j_:T\u0001\u0005\t\u0011!A\u0001R\u0003\u0005]1ui\u0016\u0014h\u000eI\u0017!C\u0002\u001aHO]5oO\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0018!)\",\u0007\u0005]1ui\u0016\u0014h\u000eI5tA\u0005\u00043\u000f\u001e:j]\u001e\u0004s\u000f[5dQ\u0002J7\u000fI7bi\u000eDW\r\u001a\u0011mSR,'/\u00197ms2\u0002s/\u001b;i\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\u001a=dKB$\u0018n\u001c8!i>\u0004C\u000f[3!M>dGn\\<j]\u001e\u00043\u000f]3dS\u0006d\u0007e]=nE>d7O\u000f\u0006\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002s\fI7bi\u000eDWm\u001d\u0011b]f\u0004sN\\3!G\"\f'/Y2uKJ\u0004\u0013N\u001c\u0011uQ\u0016\u0004\u0013N\u001c9vi\u0002B3/[7jY\u0006\u0014\b\u0005^8!]\u0001Jg\u000e\t9pg&D\bE]3hk2\f'\u000fI3yaJ,7o]5p]NL#B\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0015\u0002S.\u0019;dQ\u0016\u001c\bE_3s_\u0002z'\u000fI7pe\u0016\u00043\r[1sC\u000e$XM]:!S:\u0004C\u000f[3!S:\u0004X\u000f\u001e\u0011)g&l\u0017\u000e\\1sAQ|\u0007E\f\u0016!S:\u0004\u0003o\\:jq\u0002\u0012XmZ;mCJT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011fqB\u0014Xm]:j_:\u001c\u0018F\u0003\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\"\u0006.\u001a\u0011fg\u000e\f\u0007/\u001a\u0011dQ\u0006\u0014\u0018m\u0019;fe\u0002J7\u000fI\u0014]O9\u0002\u0013J\u001a\u0011b]\u0002*7oY1qK\u0002\u001a\u0007.\u0019:bGR,'\u000f\t9sK\u000e,G-Z:!C\u0002\u001a\b/Z2jC2\u00043/_7c_2\u0004sN\u001d\u0011b]>$\b.\u001a:\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002Sm]2ba\u0016\u00043\r[1sC\u000e$XM\u001d\u0017!i\",\u0007EZ8mY><\u0018N\\4!G\"\f'/Y2uKJ\u0004\u0013n\u001d\u0011nCR\u001c\u0007.\u001a3!Y&$XM]1mYft\u0003%\u0013;!SN\u0004\u0013N\u001c<bY&$\u0007\u0005^8!KN\u001c\u0017\r]3\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0013M\\=!_RDWM\u001d\u0011dQ\u0006\u0014\u0018m\u0019;fe:R!\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!'&t7-\u001a\u0011Ta\u0006\u00148\u000e\t\u001a/a1\u00023\u000f\u001e:j]\u001e\u0004C.\u001b;fe\u0006d7\u000fI1sK\u0002*h.Z:dCB,G\rI5oA=,(\u000fI*R\u0019\u0002\u0002\u0018M]:fe:\u0002ci\u001c:!Kb\fW\u000e\u001d7fY\u0001Jg\u000eI8sI\u0016\u0014(\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!i>\u0004S.\u0019;dQ\u0002\u0012C,\u00192dE1\u0002C\u000f[3!a\u0006$H/\u001a:oAMDw.\u001e7eA\t,\u0007E\t/]C\n\u001c'E\f\u0006\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002s\u000b[3oAM\u000bF\nI2p]\u001aLw\rI\u0014ta\u0006\u00148NL:rY:\u0002\u0018M]:fe:*7oY1qK\u0012\u001cFO]5oO2KG/\u001a:bYN<\u0003%[:!K:\f'\r\\3eY\u0001JG\u000f\t4bY2\u0014\u0017mY6t\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005^8!'B\f'o\u001b\u00112]Y\u0002#-\u001a5bm&|'\u000f\t:fO\u0006\u0014H-\u001b8hAM$(/\u001b8hA1LG/\u001a:bY\u0002\u0002\u0018M]:j]\u001et\u0003ER8sA\u0015D\u0018-\u001c9mK2\u0002\u0013N\u001a\u0011uQ\u0016\u00043m\u001c8gS\u001e\u0004\u0013n\u001d\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001*g.\u00192mK\u0012d\u0003\u0005\u001e5fAA\fG\u000f^3s]\u0002\"x\u000eI7bi\u000eD\u0007E\t/bE\u000e\u0014\u0003e\u001d5pk2$\u0007EY3!Eq\u000b'm\u0019\u0012/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005e\u0013a\u001a\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!O\u0015\u001a\u0016p\u001d;f[\u0012\u0013\u0018N^3&9V\u001bXM]:]\u0015>Dgn\n\u0011`\rVs5i\u0018\u0011(9\u0016\u001a\u0016p\u001d;f[\u0012\u0013\u0018N^3]KqcVk]3sg\u0016:#\u0002\t\u0011!A\u0001\u0002CO];f\u0015\u0001\u0002\u0013\u0001\u00028pi\u0016\f#!a\u0018\u0002{)\u0001\u0003\u0005\t\u0011Vg\u0016\u0004#\u000bT%L\u000b\u0002\"x\u000eI7bi\u000eD\u0007e^5uQ\u0002\u001aH/\u00198eCJ$\u0007E]3hk2\f'\u000fI3yaJ,7o]5p]Nt#\u0002\t\u0011\b\u0013\u0005\r$!!A\t\u0002\u0005\u0015\u0014\u0001\u0002'jW\u0016\u00042!EA4\r!\t!!!A\t\u0002\u0005%4#BA4\u0003WR\u0002cBA7\u0003g\u0002\u0003\u0005L\u0007\u0003\u0003_R1!!\u001d\u0017\u0003\u001d\u0011XO\u001c;j[\u0016LA!!\u001e\u0002p\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\t\u000f)\n9\u0007\"\u0001\u0002zQ\u0011\u0011Q\r\u0005\n'\u0006\u001d\u0014\u0011!C#\u0003{\"\u0012\u0001 \u0005\u000b\u0003\u0003\u000b9'!A\u0005\u0002\u0006\r\u0015!B1qa2LH#\u0002\u0017\u0002\u0006\u0006\u001d\u0005B\u0002\u0010\u0002\u0000\u0001\u0007\u0001\u0005\u0003\u0004'\u0003\u007f\u0002\r\u0001\t\u0005\u000b\u0003\u0017\u000b9'!A\u0005\u0002\u00065\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003\u001f\u000bY\nE\u0003\u0016\u0003#\u000b)*C\u0002\u0002\u0014Z\u0011aa\u00149uS>t\u0007#B\u000b\u0002\u0018\u0002\u0002\u0013bAAM-\t1A+\u001e9mKJB\u0011\"!(\u0002\n\u0006\u0005\t\u0019\u0001\u0017\u0002\u0007a$\u0003\u0007\u0003\u0006\u0002\"\u0006\u001d\u0014\u0011!C\u0005\u0003G\u000b1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u0015\t\u0004{\u0006\u001d\u0016bAAU}\n1qJ\u00196fGR\u0004")
public class Like
extends StringRegexExpression
implements scala.Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(Like like) {
        return Like$.MODULE$.unapply(like);
    }

    public static Function1<Tuple2<Expression, Expression>, Like> tupled() {
        return Like$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Like>> curried() {
        return Like$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String escape(String v) {
        return StringUtils$.MODULE$.escapeLikeRegex(v);
    }

    @Override
    public boolean matches(Pattern regex, String str) {
        return regex.matcher(str).matches();
    }

    @Override
    public String toString() {
        return new StringBuilder(6).append(this.left()).append(" LIKE ").append(this.right()).toString();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        String patternClass = Pattern.class.getName();
        String escapeFunc = new StringBuilder(16).append(new StringOps(Predef$.MODULE$.augmentString(StringUtils$.MODULE$.getClass().getName())).stripSuffix("$")).append(".escapeLikeRegex").toString();
        if (this.right().foldable()) {
            Object rVal = this.right().eval(this.right().eval$default$1());
            if (rVal != null) {
                String regexStr = StringEscapeUtils.escapeJava((String)this.escape(((UTF8String)rVal).toString()));
                String pattern = ctx.addMutableState(patternClass, "patternLike", (Function1<String, String>)(Function1 & Serializable & scala.Serializable)v -> new StringBuilder(16).append((String)v).append(" = ").append(patternClass).append(".compile(\"").append(regexStr).append("\");").toString(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
                ExprCode eval = this.left().genCode(ctx);
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          boolean ", " = ", ";\n          ", " ", " = ", ";\n          if (!", ") {\n            ", " = ", ".matcher(", ".toString()).matches();\n          }\n        "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval.code(), ev.isNull(), eval.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), ev.isNull(), ev.value(), pattern, eval.value()})), ev.copy$default$2(), ev.copy$default$3());
            } else {
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          boolean ", " = true;\n          ", " ", " = ", ";\n        "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2())})), ev.copy$default$2(), ev.copy$default$3());
            }
        } else {
            String pattern = ctx.freshName("pattern");
            String rightStr = ctx.freshName("rightStr");
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(eval1, eval2) -> new StringBuilder(116).append("\n          String ").append(rightStr).append(" = ").append((String)eval2).append(".toString();\n          ").append(patternClass).append(" ").append(pattern).append(" = ").append(patternClass).append(".compile(").append(escapeFunc).append("(").append(rightStr).append("));\n          ").append(ev.value()).append(" = ").append(pattern).append(".matcher(").append((String)eval1).append(".toString()).matches();\n        ").toString());
        }
        return exprCode;
    }

    public Like copy(Expression left, Expression right) {
        return new Like(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "Like";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Like;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Like)) return false;
        boolean bl = true;
        if (!bl) return false;
        Like like = (Like)x$1;
        Expression expression = this.left();
        Expression expression2 = like.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = like.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!like.canEqual(this)) return false;
        return true;
    }

    public Like(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

