/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FormatNumber$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(expr1, expr2) - Formats the number `expr1` like '#,###,###.##', rounded to `expr2`\n      decimal places. If `expr2` is 0, the result has no decimal point or fractional part.\n      `expr2` also accept a user specified format.\n      This is supposed to function like MySQL's FORMAT.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(12332.123456, 4);\n       12,332.1235\n      > SELECT _FUNC_(12332.123456, '##################.###');\n       12332.123\n  ")
@ScalaSignature(bytes="\u0006\u0001\t=b\u0001B\u0001\u0003\u0001>\u0011ABR8s[\u0006$h*^7cKJT!a\u0001\u0003\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u000b\u0019\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0006\u0001A!r#\b\t\u0003#Ii\u0011AA\u0005\u0003'\t\u0011\u0001CQ5oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005E)\u0012B\u0001\f\u0003\u0005E)\u0005\u0010]3diNLe\u000e];u)f\u0004Xm\u001d\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\b!J|G-^2u!\tAb$\u0003\u0002 3\ta1+\u001a:jC2L'0\u00192mK\"A\u0011\u0005\u0001BK\u0002\u0013\u0005!%A\u0001y+\u0005\u0019\u0003CA\t%\u0013\t)#A\u0001\u0006FqB\u0014Xm]:j_:D\u0001b\n\u0001\u0003\u0012\u0003\u0006IaI\u0001\u0003q\u0002B\u0001\"\u000b\u0001\u0003\u0016\u0004%\tAI\u0001\u0002I\"A1\u0006\u0001B\tB\u0003%1%\u0001\u0002eA!)Q\u0006\u0001C\u0001]\u00051A(\u001b8jiz\"2a\f\u00192!\t\t\u0002\u0001C\u0003\"Y\u0001\u00071\u0005C\u0003*Y\u0001\u00071\u0005C\u00034\u0001\u0011\u0005#%\u0001\u0003mK\u001a$\b\"B\u001b\u0001\t\u0003\u0012\u0013!\u0002:jO\"$\b\"B\u001c\u0001\t\u0003B\u0014\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003e\u0002\"AO\u001f\u000e\u0003mR!\u0001\u0010\u0004\u0002\u000bQL\b/Z:\n\u0005yZ$\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u000b\u0001\u0003A\u0011I!\u0002\u00119,H\u000e\\1cY\u0016,\u0012A\u0011\t\u00031\rK!\u0001R\r\u0003\u000f\t{w\u000e\\3b]\")a\t\u0001C!\u000f\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003!\u00032!S)U\u001d\tQuJ\u0004\u0002L\u001d6\tAJ\u0003\u0002N\u001d\u00051AH]8pizJ\u0011AG\u0005\u0003!f\tq\u0001]1dW\u0006<W-\u0003\u0002S'\n\u00191+Z9\u000b\u0005AK\u0002C\u0001\u001eV\u0013\t16H\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\"9\u0001\f\u0001b\u0001\n\u0013I\u0016!\u00043fM\u0006,H\u000e\u001e$pe6\fG/F\u0001[!\tY\u0006-D\u0001]\u0015\tif,\u0001\u0003mC:<'\"A0\u0002\t)\fg/Y\u0005\u0003Cr\u0013aa\u0015;sS:<\u0007BB2\u0001A\u0003%!,\u0001\beK\u001a\fW\u000f\u001c;G_Jl\u0017\r\u001e\u0011\t\u000f\u0015\u0004\u0001\u0019!C\u0005M\u0006iA.Y:u\t&sGOV1mk\u0016,\u0012a\u001a\t\u00041!T\u0017BA5\u001a\u0005\u0019y\u0005\u000f^5p]B\u0011\u0001d[\u0005\u0003Yf\u00111!\u00138u\u0011\u001dq\u0007\u00011A\u0005\n=\f\u0011\u0003\\1ti\u0012Ke\u000e\u001e,bYV,w\fJ3r)\t\u00018\u000f\u0005\u0002\u0019c&\u0011!/\u0007\u0002\u0005+:LG\u000fC\u0004u[\u0006\u0005\t\u0019A4\u0002\u0007a$\u0013\u0007\u0003\u0004w\u0001\u0001\u0006KaZ\u0001\u000fY\u0006\u001cH\u000fR%oiZ\u000bG.^3!Q\t)\b\u0010\u0005\u0002\u0019s&\u0011!0\u0007\u0002\niJ\fgn]5f]RDq\u0001 \u0001A\u0002\u0013%Q0\u0001\tmCN$Hi\u0015;sS:<g+\u00197vKV\ta\u0010E\u0002\u0019Q~\u0004B!!\u0001\u0002\n9!\u00111AA\u0003!\tY\u0015$C\u0002\u0002\be\ta\u0001\u0015:fI\u00164\u0017bA1\u0002\f)\u0019\u0011qA\r\t\u0013\u0005=\u0001\u00011A\u0005\n\u0005E\u0011\u0001\u00067bgR$5\u000b\u001e:j]\u001e4\u0016\r\\;f?\u0012*\u0017\u000fF\u0002q\u0003'A\u0001\u0002^A\u0007\u0003\u0003\u0005\rA \u0005\b\u0003/\u0001\u0001\u0015)\u0003\u007f\u0003Ea\u0017m\u001d;E'R\u0014\u0018N\\4WC2,X\r\t\u0015\u0004\u0003+A\bBCA\u000f\u0001!\u0015\r\u0011\"\u0003\u0002 \u00059\u0001/\u0019;uKJtWCAA\u0011!\rY\u00161E\u0005\u0004\u0003Ka&\u0001D*ue&twMQ;gM\u0016\u0014\bfAA\u000eq\"Q\u00111\u0006\u0001\t\u0006\u0004%I!!\f\u0002\u00199,XNY3s\r>\u0014X.\u0019;\u0016\u0005\u0005=\u0002\u0003BA\u0019\u0003oi!!a\r\u000b\u0007\u0005Ub,\u0001\u0003uKb$\u0018\u0002BA\u001d\u0003g\u0011Q\u0002R3dS6\fGNR8s[\u0006$\bfAA\u0015q\"9\u0011q\b\u0001\u0005R\u0005\u0005\u0013\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dGCBA\"\u0003\u0013\ni\u0005E\u0002\u0019\u0003\u000bJ1!a\u0012\u001a\u0005\r\te.\u001f\u0005\t\u0003\u0017\ni\u00041\u0001\u0002D\u00059\u0001p\u00142kK\u000e$\b\u0002CA(\u0003{\u0001\r!a\u0011\u0002\u000f\u0011|%M[3di\"9\u00111\u000b\u0001\u0005B\u0005U\u0013!\u00033p\u000f\u0016t7i\u001c3f)\u0019\t9&a\u0019\u0002nA!\u0011\u0011LA0\u001b\t\tYFC\u0002\u0002^\t\tqaY8eK\u001e,g.\u0003\u0003\u0002b\u0005m#\u0001C#yaJ\u001cu\u000eZ3\t\u0011\u0005\u0015\u0014\u0011\u000ba\u0001\u0003O\n1a\u0019;y!\u0011\tI&!\u001b\n\t\u0005-\u00141\f\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011!\ty'!\u0015A\u0002\u0005]\u0013AA3w\u0011\u001d\t\u0019\b\u0001C!\u0003k\n!\u0002\u001d:fiRLh*Y7f+\u0005y\b\"CA=\u0001\u0005\u0005I\u0011AA>\u0003\u0011\u0019w\u000e]=\u0015\u000b=\ni(a \t\u0011\u0005\n9\b%AA\u0002\rB\u0001\"KA<!\u0003\u0005\ra\t\u0005\n\u0003\u0007\u0003\u0011\u0013!C\u0001\u0003\u000b\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\b*\u001a1%!#,\u0005\u0005-\u0005\u0003BAG\u0003/k!!a$\u000b\t\u0005E\u00151S\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!&\u001a\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00033\u000byIA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"!(\u0001#\u0003%\t!!\"\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e!A\u0011\u0011\u0015\u0001\u0002\u0002\u0013\u0005\u0013,A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e\u001f\u0005\n\u0003K\u0003\u0011\u0011!C\u0001\u0003O\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\u0012A\u001b\u0005\n\u0003W\u0003\u0011\u0011!C\u0001\u0003[\u000ba\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002D\u0005=\u0006\u0002\u0003;\u0002*\u0006\u0005\t\u0019\u00016\t\u0013\u0005M\u0006!!A\u0005B\u0005U\u0016a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005]\u0006CBA]\u0003\u007f\u000b\u0019%\u0004\u0002\u0002<*\u0019\u0011QX\r\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002B\u0006m&\u0001C%uKJ\fGo\u001c:\t\u0013\u0005\u0015\u0007!!A\u0005\u0002\u0005\u001d\u0017\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007\t\u000bI\rC\u0005u\u0003\u0007\f\t\u00111\u0001\u0002D!I\u0011Q\u001a\u0001\u0002\u0002\u0013\u0005\u0013qZ\u0001\u0007KF,\u0018\r\\:\u0015\u0007\t\u000b\t\u000eC\u0005u\u0003\u0017\f\t\u00111\u0001\u0002D!Z\u0001!!6\u0002\\\u0006u\u0017\u0011]Ar!\r\t\u0012q[\u0005\u0004\u00033\u0014!!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003?\f!q\n\u0006!A\u0001\u0002sLR+O\u0007~CS\r\u001f9sc1\u0002S\r\u001f9se%\u0002S\u0006\t$pe6\fGo\u001d\u0011uQ\u0016\u0004c.^7cKJ\u0004\u0003-\u001a=qeF\u0002\u0007\u0005\\5lK\u0002:3\u0005L\u0012$G1\u001a3e\t\u0018$G\u001db\u0003E]8v]\u0012,G\r\t;pA\u0001,\u0007\u0010\u001d:3A*\u0001\u0003\u0005\t\u0011!A\u0011,7-[7bY\u0002\u0002H.Y2fg:\u0002\u0013J\u001a\u0011aKb\u0004(O\r1!SN\u0004\u0003\u0007\f\u0011uQ\u0016\u0004#/Z:vYR\u0004\u0003.Y:!]>\u0004C-Z2j[\u0006d\u0007\u0005]8j]R\u0004sN\u001d\u0011ge\u0006\u001cG/[8oC2\u0004\u0003/\u0019:u])\u0001\u0003\u0005\t\u0011!A\u0001,\u0007\u0010\u001d:3A\u0002\nGn]8!C\u000e\u001cW\r\u001d;!C\u0002*8/\u001a:!gB,7-\u001b4jK\u0012\u0004cm\u001c:nCRt#\u0002\t\u0011!A\u0001\u0002C\u000b[5tA%\u001c\be];qa>\u001cX\r\u001a\u0011u_\u00022WO\\2uS>t\u0007\u0005\\5lK\u0002j\u0015pU)MOM\u0004ci\u0014*N\u0003Rs#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!:\u0002\u0003sQ\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\r\u001a4gIr\u0013GM\u001a5kYb\u0003\u0005N\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AE\u0012DfM\u001a3]E\u00124'\u000e\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)cI\u001a4G\r\u00182eM\"TG\u000e\u0017!O\r\u001a3eI\u0012$G\r\u001a3eI\u0012$G\r\u001a3e\t\u0018$G\r:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112eM\u001a$GL\u00193g)\u0001\u0003eB\u0005\u0002j\n\t\t\u0011#\u0001\u0002l\u0006aai\u001c:nCRtU/\u001c2feB\u0019\u0011#!<\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003_\u001cR!!<\u0002rv\u0001r!a=\u0002z\u000e\u001as&\u0004\u0002\u0002v*\u0019\u0011q_\r\u0002\u000fI,h\u000e^5nK&!\u00111`A{\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u0005\b[\u00055H\u0011AA\u0000)\t\tY\u000f\u0003\u0006\u0003\u0004\u00055\u0018\u0011!C#\u0005\u000b\t\u0001\u0002^8TiJLgn\u001a\u000b\u00025\"Q!\u0011BAw\u0003\u0003%\tIa\u0003\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b=\u0012iAa\u0004\t\r\u0005\u00129\u00011\u0001$\u0011\u0019I#q\u0001a\u0001G!Q!1CAw\u0003\u0003%\tI!\u0006\u0002\u000fUt\u0017\r\u001d9msR!!q\u0003B\u0010!\u0011A\u0002N!\u0007\u0011\u000ba\u0011YbI\u0012\n\u0007\tu\u0011D\u0001\u0004UkBdWM\r\u0005\n\u0005C\u0011\t\"!AA\u0002=\n1\u0001\u001f\u00131\u0011)\u0011)#!<\u0002\u0002\u0013%!qE\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003*A\u00191La\u000b\n\u0007\t5BL\u0001\u0004PE*,7\r\u001e")
public class FormatNumber
extends BinaryExpression
implements ExpectsInputTypes,
scala.Serializable {
    private transient StringBuffer pattern;
    private transient DecimalFormat numberFormat;
    private final Expression x;
    private final Expression d;
    private final String defaultFormat;
    private transient Option<Object> lastDIntValue;
    private transient Option<String> lastDStringValue;
    private volatile transient byte bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(FormatNumber formatNumber) {
        return FormatNumber$.MODULE$.unapply(formatNumber);
    }

    public static Function1<Tuple2<Expression, Expression>, FormatNumber> tupled() {
        return FormatNumber$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, FormatNumber>> curried() {
        return FormatNumber$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression x() {
        return this.x;
    }

    public Expression d() {
        return this.d;
    }

    @Override
    public Expression left() {
        return this.x();
    }

    @Override
    public Expression right() {
        return this.d();
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{NumericType$.MODULE$, TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{IntegerType$.MODULE$, StringType$.MODULE$}))}));
    }

    private String defaultFormat() {
        return this.defaultFormat;
    }

    private Option<Object> lastDIntValue() {
        return this.lastDIntValue;
    }

    private void lastDIntValue_$eq(Option<Object> x$1) {
        this.lastDIntValue = x$1;
    }

    private Option<String> lastDStringValue() {
        return this.lastDStringValue;
    }

    private void lastDStringValue_$eq(Option<String> x$1) {
        this.lastDStringValue = x$1;
    }

    private StringBuffer pattern$lzycompute() {
        FormatNumber formatNumber = this;
        synchronized (formatNumber) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.pattern = new StringBuffer();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.pattern;
    }

    private StringBuffer pattern() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.pattern$lzycompute() : this.pattern;
    }

    private DecimalFormat numberFormat$lzycompute() {
        FormatNumber formatNumber = this;
        synchronized (formatNumber) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.numberFormat = new DecimalFormat("", new DecimalFormatSymbols(Locale.US));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.numberFormat;
    }

    private DecimalFormat numberFormat() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.numberFormat$lzycompute() : this.numberFormat;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object nullSafeEval(Object xObject, Object dObject) {
        block24: {
            block25: {
                block23: {
                    var7_3 = this.right().dataType();
                    if (!IntegerType$.MODULE$.equals(var7_3)) break block23;
                    dValue = BoxesRunTime.unboxToInt((Object)dObject);
                    if (dValue < 0) {
                        return null;
                    }
                    var9_5 = this.lastDIntValue();
                    if (var9_5 instanceof Some && (last = BoxesRunTime.unboxToInt((Object)(var10_6 = (Some)var9_5).value())) == dValue) {
                        var6_8 = BoxedUnit.UNIT;
                    } else {
                        this.pattern().delete(0, this.pattern().length());
                        this.pattern().append(this.defaultFormat());
                        if (dValue > 0) {
                            this.pattern().append(".");
                            for (i = 0; i < dValue; ++i) {
                                this.pattern().append("0");
                            }
                        }
                        this.lastDIntValue_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)dValue)));
                        this.numberFormat().applyLocalizedPattern(this.pattern().toString());
                        var6_9 = BoxedUnit.UNIT;
                    }
                    var4_11 = BoxedUnit.UNIT;
                    break block24;
                }
                if (!StringType$.MODULE$.equals(var7_3)) break block25;
                dValue = ((UTF8String)dObject).toString();
                var14_14 = this.lastDStringValue();
                if (!(var14_14 instanceof Some)) ** GOTO lbl-1000
                var15_15 = (Some)var14_14;
                v0 = last = (String)var15_15.value();
                var17_17 = dValue;
                if (!(v0 != null ? v0.equals(var17_17) == false : var17_17 != null)) {
                    var5_18 = BoxedUnit.UNIT;
                } else lbl-1000:
                // 2 sources

                {
                    this.pattern().delete(0, this.pattern().length());
                    this.lastDStringValue_$eq((Option<String>)new Some((Object)dValue));
                    if (dValue.isEmpty()) {
                        this.numberFormat().applyLocalizedPattern(this.defaultFormat());
                        v1 = BoxedUnit.UNIT;
                    } else {
                        this.numberFormat().applyLocalizedPattern(dValue);
                        v1 = BoxedUnit.UNIT;
                    }
                    var5_19 = v1;
                }
                var4_12 = BoxedUnit.UNIT;
                break block24;
            }
            throw new MatchError((Object)var7_3);
        }
        var18_20 = this.x().dataType();
        if (ByteType$.MODULE$.equals(var18_20)) {
            var3_21 = UTF8String.fromString((String)this.numberFormat().format(BoxesRunTime.unboxToByte((Object)xObject)));
        } else if (ShortType$.MODULE$.equals(var18_20)) {
            var3_21 = UTF8String.fromString((String)this.numberFormat().format(BoxesRunTime.unboxToShort((Object)xObject)));
        } else if (FloatType$.MODULE$.equals(var18_20)) {
            var3_21 = UTF8String.fromString((String)this.numberFormat().format(BoxesRunTime.unboxToFloat((Object)xObject)));
        } else if (IntegerType$.MODULE$.equals(var18_20)) {
            var3_21 = UTF8String.fromString((String)this.numberFormat().format(BoxesRunTime.unboxToInt((Object)xObject)));
        } else if (LongType$.MODULE$.equals(var18_20)) {
            var3_21 = UTF8String.fromString((String)this.numberFormat().format(BoxesRunTime.unboxToLong((Object)xObject)));
        } else if (DoubleType$.MODULE$.equals(var18_20)) {
            var3_21 = UTF8String.fromString((String)this.numberFormat().format(BoxesRunTime.unboxToDouble((Object)xObject)));
        } else if (var18_20 instanceof DecimalType) {
            var3_21 = UTF8String.fromString((String)this.numberFormat().format(((Decimal)xObject).toJavaBigDecimal()));
        } else {
            throw new MatchError((Object)var18_20);
        }
        return var3_21;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(num, d) -> {
            String string;
            String sb = StringBuffer.class.getName();
            String df = DecimalFormat.class.getName();
            String dfs = DecimalFormatSymbols.class.getName();
            String l = Locale.class.getName();
            String usLocale = "US";
            String numberFormat = ctx.addMutableState(df, "numberFormat", (Function1<String, String>)(Function1 & Serializable & scala.Serializable)v -> new StringBuilder(21).append((String)v).append(" = new ").append(df).append("(\"\", new ").append(dfs).append("(").append(l).append(".").append(usLocale).append("));").toString(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
            DataType dataType = this.right().dataType();
            if (IntegerType$.MODULE$.equals(dataType)) {
                String pattern = ctx.addMutableState(sb, "pattern", (Function1<String, String>)(Function1 & Serializable & scala.Serializable)v -> new StringBuilder(10).append((String)v).append(" = new ").append(sb).append("();").toString(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
                String i = ctx.freshName("i");
                String lastDValue = ctx.addMutableState("int", "lastDValue", (Function1<String, String>)(Function1 & Serializable & scala.Serializable)v -> new StringBuilder(8).append((String)v).append(" = -100;").toString(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
                string = new StringBuilder(528).append("\n            if (").append((String)d).append(" >= 0) {\n              ").append(pattern).append(".delete(0, ").append(pattern).append(".length());\n              if (").append((String)d).append(" != ").append(lastDValue).append(") {\n                ").append(pattern).append(".append(\"").append(this.defaultFormat()).append("\");\n\n                if (").append((String)d).append(" > 0) {\n                  ").append(pattern).append(".append(\".\");\n                  for (int ").append(i).append(" = 0; ").append(i).append(" < ").append((String)d).append("; ").append(i).append("++) {\n                    ").append(pattern).append(".append(\"0\");\n                  }\n                }\n                ").append(lastDValue).append(" = ").append((String)d).append(";\n                ").append(numberFormat).append(".applyLocalizedPattern(").append(pattern).append(".toString());\n              }\n              ").append(ev.value()).append(" = UTF8String.fromString(").append(numberFormat).append(".format(").append(this.typeHelper$1((String)num)).append("));\n            } else {\n              ").append(ev.value()).append(" = null;\n              ").append(ev.isNull()).append(" = true;\n            }\n           ").toString();
            } else if (StringType$.MODULE$.equals(dataType)) {
                String lastDValue = ctx.addMutableState("String", "lastDValue", (Function1<String, String>)(Function1 & Serializable & scala.Serializable)v -> new StringBuilder(8).append((String)v).append(" = null;").toString(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
                String dValue = ctx.freshName("dValue");
                string = new StringBuilder(316).append("\n            String ").append(dValue).append(" = ").append((String)d).append(".toString();\n            if (!").append(dValue).append(".equals(").append(lastDValue).append(")) {\n              ").append(lastDValue).append(" = ").append(dValue).append(";\n              if (").append(dValue).append(".isEmpty()) {\n                ").append(numberFormat).append(".applyLocalizedPattern(\"").append(this.defaultFormat()).append("\");\n              } else {\n                ").append(numberFormat).append(".applyLocalizedPattern(").append(dValue).append(");\n              }\n            }\n            ").append(ev.value()).append(" = UTF8String.fromString(").append(numberFormat).append(".format(").append(this.typeHelper$1((String)num)).append("));\n           ").toString();
            } else {
                throw new MatchError((Object)dataType);
            }
            return string;
        });
    }

    @Override
    public String prettyName() {
        return "format_number";
    }

    public FormatNumber copy(Expression x, Expression d) {
        return new FormatNumber(x, d);
    }

    public Expression copy$default$1() {
        return this.x();
    }

    public Expression copy$default$2() {
        return this.d();
    }

    @Override
    public String productPrefix() {
        return "FormatNumber";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.x();
                break;
            }
            case 1: {
                expression = this.d();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FormatNumber;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FormatNumber)) return false;
        boolean bl = true;
        if (!bl) return false;
        FormatNumber formatNumber = (FormatNumber)x$1;
        Expression expression = this.x();
        Expression expression2 = formatNumber.x();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.d();
        Expression expression4 = formatNumber.d();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!formatNumber.canEqual(this)) return false;
        return true;
    }

    private final String typeHelper$1(String p) {
        DataType dataType = this.x().dataType();
        String string = dataType instanceof DecimalType ? new StringBuilder(19).append(p).append(".toJavaBigDecimal()").toString() : String.valueOf(p);
        return string;
    }

    public FormatNumber(Expression x, Expression d) {
        this.x = x;
        this.d = d;
        ExpectsInputTypes.$init$(this);
        this.defaultFormat = "#,###,###,###,###,###,##0";
        this.lastDIntValue = None$.MODULE$;
        this.lastDStringValue = None$.MODULE$;
    }
}

