/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.CaseWhen$;
import org.apache.spark.sql.catalyst.expressions.ComplexTypeMergingExpression;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.JavaCode$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ExpressionDescription(usage="CASE WHEN expr1 THEN expr2 [WHEN expr3 THEN expr4]* [ELSE expr5] END - When `expr1` = true, returns `expr2`; else when `expr3` = true, returns `expr4`; else returns `expr5`.", arguments="\n    Arguments:\n      * expr1, expr3 - the branch condition expressions should all be boolean type.\n      * expr2, expr4, expr5 - the branch value expressions and else value expression should all be\n          same type or coercible to a common type.\n  ", examples="\n    Examples:\n      > SELECT CASE WHEN 1 > 0 THEN 1 WHEN 2 > 0 THEN 2.0 ELSE 1.2 END;\n       1\n      > SELECT CASE WHEN 1 < 0 THEN 1 WHEN 2 > 0 THEN 2.0 ELSE 1.2 END;\n       2\n      > SELECT CASE WHEN 1 < 0 THEN 1 WHEN 2 < 0 THEN 2.0 END;\n       NULL\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005mh\u0001B\u0001\u0003\u0001>\u0011\u0001bQ1tK^CWM\u001c\u0006\u0003\u0007\u0011\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011QAB\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M)\u0001\u0001\u0005\u000b\u0018;A\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007CA\t\u0016\u0013\t1\"A\u0001\u000fD_6\u0004H.\u001a=UsB,W*\u001a:hS:<W\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\u0019M+'/[1mSj\f'\r\\3\u0011\u0005aq\u0012BA\u0010\u001a\u0005\u001d\u0001&o\u001c3vGRD\u0001\"\t\u0001\u0003\u0016\u0004%\tAI\u0001\tEJ\fgn\u00195fgV\t1\u0005E\u0002%Y=r!!\n\u0016\u000f\u0005\u0019JS\"A\u0014\u000b\u0005!r\u0011A\u0002\u001fs_>$h(C\u0001\u001b\u0013\tY\u0013$A\u0004qC\u000e\\\u0017mZ3\n\u00055r#aA*fc*\u00111&\u0007\t\u00051A\u0002\u0002#\u0003\u000223\t1A+\u001e9mKJB\u0001b\r\u0001\u0003\u0012\u0003\u0006IaI\u0001\nEJ\fgn\u00195fg\u0002B\u0001\"\u000e\u0001\u0003\u0016\u0004%\tAN\u0001\nK2\u001cXMV1mk\u0016,\u0012a\u000e\t\u00041a\u0002\u0012BA\u001d\u001a\u0005\u0019y\u0005\u000f^5p]\"A1\b\u0001B\tB\u0003%q'\u0001\u0006fYN,g+\u00197vK\u0002BQ!\u0010\u0001\u0005\u0002y\na\u0001P5oSRtDcA A\u0003B\u0011\u0011\u0003\u0001\u0005\u0006Cq\u0002\ra\t\u0005\bkq\u0002\n\u00111\u00018\u0011\u0015\u0019\u0005\u0001\"\u0011E\u0003!\u0019\u0007.\u001b7ee\u0016tW#A#\u0011\u0007\u0011b\u0003\u0003\u0003\u0005H\u0001!\u0015\r\u0011\"\u0011I\u0003QIg\u000e];u)f\u0004Xm\u001d$pe6+'oZ5oOV\t\u0011\nE\u0002%Y)\u0003\"a\u0013(\u000e\u00031S!!\u0014\u0004\u0002\u000bQL\b/Z:\n\u0005=c%\u0001\u0003#bi\u0006$\u0016\u0010]3)\u0005\u0019\u000b\u0006C\u0001\rS\u0013\t\u0019\u0016DA\u0005ue\u0006t7/[3oi\")Q\u000b\u0001C!-\u0006Aa.\u001e7mC\ndW-F\u0001X!\tA\u0002,\u0003\u0002Z3\t9!i\\8mK\u0006t\u0007\"B.\u0001\t\u0003b\u0016aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cH#A/\u0011\u0005y\u000bW\"A0\u000b\u0005\u0001$\u0011\u0001C1oC2L8/[:\n\u0005\t|&a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\t\u000b\u0011\u0004A\u0011I3\u0002\t\u00154\u0018\r\u001c\u000b\u0003M&\u0004\"\u0001G4\n\u0005!L\"aA!os\"9!n\u0019I\u0001\u0002\u0004Y\u0017!B5oaV$\bC\u00017n\u001b\u0005!\u0011B\u00018\u0005\u0005-Ie\u000e^3s]\u0006d'k\\<\t\u000bA\u0004A\u0011I9\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012A\u001d\t\u0003g^t!\u0001^;\u0011\u0005\u0019J\u0012B\u0001<\u001a\u0003\u0019\u0001&/\u001a3fM&\u0011\u00010\u001f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005YL\u0002\"B\u0004\u0001\t\u0003ZX#\u0001:\t\u000bu\u0004A\u0011\t@\u0002\u0013\u0011|w)\u001a8D_\u0012,G#B@\u0002\f\u0005U\u0001\u0003BA\u0001\u0003\u000fi!!a\u0001\u000b\u0007\u0005\u0015!!A\u0004d_\u0012,w-\u001a8\n\t\u0005%\u00111\u0001\u0002\t\u000bb\u0004(oQ8eK\"9\u0011Q\u0002?A\u0002\u0005=\u0011aA2uqB!\u0011\u0011AA\t\u0013\u0011\t\u0019\"a\u0001\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"1\u0011q\u0003?A\u0002}\f!!\u001a<\t\u0013\u0005m\u0001!!A\u0005\u0002\u0005u\u0011\u0001B2paf$RaPA\u0010\u0003CA\u0001\"IA\r!\u0003\u0005\ra\t\u0005\tk\u0005e\u0001\u0013!a\u0001o!I\u0011Q\u0005\u0001\u0012\u0002\u0013\u0005\u0011qE\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tICK\u0002$\u0003WY#!!\f\u0011\t\u0005=\u0012\u0011H\u0007\u0003\u0003cQA!a\r\u00026\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003oI\u0012AC1o]>$\u0018\r^5p]&!\u00111HA\u0019\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003\u007f\u0001\u0011\u0013!C\u0001\u0003\u0003\nabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002D)\u001aq'a\u000b\t\u0013\u0005\u001d\u0003!!A\u0005B\u0005%\u0013!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002LA!\u0011QJA,\u001b\t\tyE\u0003\u0003\u0002R\u0005M\u0013\u0001\u00027b]\u001eT!!!\u0016\u0002\t)\fg/Y\u0005\u0004q\u0006=\u0003\"CA.\u0001\u0005\u0005I\u0011AA/\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ty\u0006E\u0002\u0019\u0003CJ1!a\u0019\u001a\u0005\rIe\u000e\u001e\u0005\n\u0003O\u0002\u0011\u0011!C\u0001\u0003S\na\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002g\u0003WB!\"!\u001c\u0002f\u0005\u0005\t\u0019AA0\u0003\rAH%\r\u0005\n\u0003c\u0002\u0011\u0011!C!\u0003g\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003k\u0002R!a\u001e\u0002~\u0019l!!!\u001f\u000b\u0007\u0005m\u0014$\u0001\u0006d_2dWm\u0019;j_:LA!a \u0002z\tA\u0011\n^3sCR|'\u000fC\u0005\u0002\u0004\u0002\t\t\u0011\"\u0001\u0002\u0006\u0006A1-\u00198FcV\fG\u000eF\u0002X\u0003\u000fC\u0011\"!\u001c\u0002\u0002\u0006\u0005\t\u0019\u00014\t\u0013\u0005-\u0005!!A\u0005B\u00055\u0015AB3rk\u0006d7\u000fF\u0002X\u0003\u001fC\u0011\"!\u001c\u0002\n\u0006\u0005\t\u0019\u00014)\u001f\u0001\t\u0019*!'\u0002\u001c\u0006}\u0015\u0011UAS\u0003O\u00032!EAK\u0013\r\t9J\u0001\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\ti*AA.\u0007\u0006\u001bV\tI,I\u000b:\u0003S\r\u001f9sc\u0001\"\u0006*\u0012(!Kb\u0004(O\r\u0011\\/\"+e\nI3yaJ\u001c\u0004\u0005\u0016%F\u001d\u0002*\u0007\u0010\u001d:5;*\u00023,\u0012'T\u000b\u0002*\u0007\u0010\u001d:6;\u0002*e\n\u0012\u0011.A]CWM\u001c\u0011aKb\u0004(/\r1!{\u0001\"(/^3-AI,G/\u001e:og\u0002\u0002W\r\u001f9se\u0001\\\u0004%\u001a7tK\u0002:\b.\u001a8!A\u0016D\bO]\u001aaAu\u0002CO];fY\u0001\u0012X\r^;s]N\u0004\u0003-\u001a=qeR\u00027\bI3mg\u0016\u0004#/\u001a;ve:\u001c\b\u0005Y3yaJ,\u0004ML\u0001\nCJ<W/\\3oiN\f#!a)\u0002\u0003sT\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006I3yaJ\fD\u0006I3yaJ\u001c\u0004%\f\u0011uQ\u0016\u0004#M]1oG\"\u00043m\u001c8eSRLwN\u001c\u0011fqB\u0014Xm]:j_:\u001c\be\u001d5pk2$\u0007%\u00197mA\t,\u0007EY8pY\u0016\fg\u000e\t;za\u0016t#\u0002\t\u0011!A\u0001\u0002#\u0006I3yaJ\u0014D\u0006I3yaJ$D\u0006I3yaJ,\u0004%\f\u0011uQ\u0016\u0004#M]1oG\"\u0004c/\u00197vK\u0002*\u0007\u0010\u001d:fgNLwN\\:!C:$\u0007%\u001a7tK\u00022\u0018\r\\;fA\u0015D\bO]3tg&|g\u000eI:i_VdG\rI1mY\u0002\u0012WM\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AM\fW.\u001a\u0011usB,\u0007e\u001c:!G>,'oY5cY\u0016\u0004Co\u001c\u0011bA\r|W.\\8oAQL\b/\u001a\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003S\u000b\u0011Q \u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!\u0007\u0006\u001bV\tI,I\u000b:\u0003\u0013\u0007\t !a\u0001\"\u0006*\u0012(!c\u0001:\u0006*\u0012(!e\u0001r\u0004\u0005\r\u0011U\u0011\u0016s\u0005E\r\u00181A\u0015c5+\u0012\u00112]I\u0002SI\u0014#<\u0015\u0001\u0002\u0003\u0005\t\u0011!AER\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006eQ!T\u000b\u0002:\u0006*\u0012(!c\u0001b\u0004\u0005\r\u0011U\u0011\u0016s\u0005%\r\u0011X\u0011\u0016s\u0005E\r\u0011?AA\u0002C\u000bS#OAIr\u0003\u0007I#M'\u0016\u0003\u0013G\f\u001a!\u000b:#5H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA\r\u000b5+\u0012\u0011X\u0011\u0016s\u0005%\r\u0011=AA\u0002C\u000bS#OAE\u0002s\u000bS#OAI\u0002C\b\t\u0019!)\"+e\n\t\u001a/a\u0001*e\nR\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!\u001dVcEJ\u0003\u0011!\u000f\u001d\tiK\u0001E\u0001\u0003_\u000b\u0001bQ1tK^CWM\u001c\t\u0004#\u0005EfAB\u0001\u0003\u0011\u0003\t\u0019lE\u0003\u00022\u0006Uv\u0003E\u0002\u0019\u0003oK1!!/\u001a\u0005\u0019\te.\u001f*fM\"9Q(!-\u0005\u0002\u0005uFCAAX\u0011!\t\t-!-\u0005\u0002\u0005\r\u0017!B1qa2LH#B \u0002F\u0006\u001d\u0007BB\u0011\u0002@\u0002\u00071\u0005\u0003\u00046\u0003\u007f\u0003\r\u0001\u0005\u0005\t\u0003\u0017\f\t\f\"\u0001\u0002N\u0006\u00012M]3bi\u00164%o\\7QCJ\u001cXM\u001d\u000b\u0004\u007f\u0005=\u0007BB\u0011\u0002J\u0002\u0007Q\t\u0003\u0006\u0002B\u0006E\u0016\u0011!CA\u0003'$RaPAk\u0003/Da!IAi\u0001\u0004\u0019\u0003\u0002C\u001b\u0002RB\u0005\t\u0019A\u001c\t\u0015\u0005m\u0017\u0011WA\u0001\n\u0003\u000bi.A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005}\u00171\u001d\t\u00051a\n\t\u000f\u0005\u0003\u0019a\r:\u0004\"CAs\u00033\f\t\u00111\u0001@\u0003\rAH\u0005\r\u0005\u000b\u0003S\f\t,%A\u0005\u0002\u0005\u0005\u0013aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\t\u0015\u00055\u0018\u0011WI\u0001\n\u0003\t\t%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HE\r\u0005\u000b\u0003c\f\t,!A\u0005\n\u0005M\u0018a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!>\u0011\t\u00055\u0013q_\u0005\u0005\u0003s\fyE\u0001\u0004PE*,7\r\u001e")
public class CaseWhen
extends Expression
implements ComplexTypeMergingExpression,
scala.Serializable {
    private transient Seq<DataType> inputTypesForMerging;
    private final Seq<Tuple2<Expression, Expression>> branches;
    private final Option<Expression> elseValue;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Expression> $lessinit$greater$default$2() {
        return CaseWhen$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Expression> apply$default$2() {
        return CaseWhen$.MODULE$.apply$default$2();
    }

    public static Option<Tuple2<Seq<Tuple2<Expression, Expression>>, Option<Expression>>> unapply(CaseWhen caseWhen) {
        return CaseWhen$.MODULE$.unapply(caseWhen);
    }

    public static CaseWhen createFromParser(Seq<Expression> seq) {
        return CaseWhen$.MODULE$.createFromParser(seq);
    }

    @Override
    public void dataTypeCheck() {
        ComplexTypeMergingExpression.dataTypeCheck$(this);
    }

    @Override
    public DataType dataType() {
        return ComplexTypeMergingExpression.dataType$(this);
    }

    public Seq<Tuple2<Expression, Expression>> branches() {
        return this.branches;
    }

    public Option<Expression> elseValue() {
        return this.elseValue;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)((TraversableLike)this.branches().flatMap((Function1 & Serializable & scala.Serializable)b -> {
            Expression expression = (Expression)b._1();
            Expression expression2 = (Expression)b._2();
            return Nil$.MODULE$.$colon$colon((Object)expression2).$colon$colon((Object)expression);
        }, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.elseValue()), Seq$.MODULE$.canBuildFrom());
    }

    private Seq<DataType> inputTypesForMerging$lzycompute() {
        CaseWhen caseWhen = this;
        synchronized (caseWhen) {
            if (!this.bitmap$trans$0) {
                this.inputTypesForMerging = (Seq)((TraversableLike)this.branches().map((Function1 & Serializable & scala.Serializable)x$6 -> ((Expression)x$6._2()).dataType(), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.elseValue().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.dataType())), Seq$.MODULE$.canBuildFrom());
                this.bitmap$trans$0 = true;
            }
        }
        return this.inputTypesForMerging;
    }

    @Override
    public Seq<DataType> inputTypesForMerging() {
        return !this.bitmap$trans$0 ? this.inputTypesForMerging$lzycompute() : this.inputTypesForMerging;
    }

    @Override
    public boolean nullable() {
        return this.branches().exists((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)CaseWhen.$anonfun$nullable$1(x$8))) || BoxesRunTime.unboxToBoolean((Object)this.elseValue().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.nullable())).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult;
        if (TypeCoercion$.MODULE$.haveSameType(this.inputTypesForMerging())) {
            if (this.branches().forall((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)CaseWhen.$anonfun$checkInputDataTypes$1(x$10)))) {
                typeCheckResult = TypeCheckResult$TypeCheckSuccess$.MODULE$;
            } else {
                int index = this.branches().indexWhere((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)CaseWhen.$anonfun$checkInputDataTypes$2(x$11)));
                typeCheckResult = new TypeCheckResult.TypeCheckFailure(new StringBuilder(57).append("WHEN expressions in CaseWhen should all be boolean type, ").append(new StringBuilder(37).append("but the ").append(index + 1).append("th when expression's type is ").append(((Tuple2)this.branches().apply(index))._1()).toString()).toString());
            }
        } else {
            typeCheckResult = new TypeCheckResult.TypeCheckFailure("THEN and ELSE expressions should all be same type or coercible to a common type");
        }
        return typeCheckResult;
    }

    @Override
    public Object eval(InternalRow input) {
        int size = this.branches().size();
        for (int i = 0; i < size; ++i) {
            if (!Boolean.TRUE.equals(((Expression)((Tuple2)this.branches().apply(i))._1()).eval(input))) continue;
            return ((Expression)((Tuple2)this.branches().apply(i))._2()).eval(input);
        }
        if (this.elseValue().isDefined()) {
            return ((Expression)this.elseValue().get()).eval(input);
        }
        return null;
    }

    @Override
    public String toString() {
        String cases = ((TraversableOnce)this.branches().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Expression c = (Expression)tuple2._1();
            Expression v = (Expression)tuple2._2();
            String string = new StringBuilder(12).append(" WHEN ").append(c).append(" THEN ").append(v).toString();
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString();
        String elseCase = (String)this.elseValue().map((Function1 & Serializable & scala.Serializable)x$12 -> new StringBuilder(6).append(" ELSE ").append(x$12).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        return new StringBuilder(8).append("CASE").append(cases).append(elseCase).append(" END").toString();
    }

    @Override
    public String sql() {
        String cases = ((TraversableOnce)this.branches().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Expression c = (Expression)tuple2._1();
            Expression v = (Expression)tuple2._2();
            String string = new StringBuilder(12).append(" WHEN ").append(c.sql()).append(" THEN ").append(v.sql()).toString();
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString();
        String elseCase = (String)this.elseValue().map((Function1 & Serializable & scala.Serializable)x$13 -> new StringBuilder(6).append(" ELSE ").append(x$13.sql()).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        return new StringBuilder(8).append("CASE").append(cases).append(elseCase).append(" END").toString();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        Seq allConditions;
        int NOT_MATCHED = -1;
        int HAS_NONNULL = 0;
        int HAS_NULL = 1;
        String resultState = ctx.freshName("caseWhenResultState");
        ev.value_$eq(JavaCode$.MODULE$.global(ctx.addMutableState(CodeGenerator$.MODULE$.javaType(this.dataType()), ExprValue$.MODULE$.exprValueToString(ev.value()), ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5()), this.dataType()));
        Seq cases = (Seq)this.branches().map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Expression condExpr = (Expression)tuple2._1();
            Expression valueExpr = (Expression)tuple2._2();
            ExprCode cond = condExpr.genCode(ctx);
            ExprCode res = valueExpr.genCode(ctx);
            String string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(137).append("\n         |").append(cond.code()).append("\n         |if (!").append(cond.isNull()).append(" && ").append(cond.value()).append(") {\n         |  ").append(res.code()).append("\n         |  ").append(resultState).append(" = (byte)(").append(res.isNull()).append(" ? ").append(HAS_NULL).append(" : ").append(HAS_NONNULL).append(");\n         |  ").append(ev.value()).append(" = ").append(res.value()).append(";\n         |  continue;\n         |}\n       ").toString())).stripMargin();
            return string;
        }, Seq$.MODULE$.canBuildFrom());
        Option elseCode = this.elseValue().map((Function1 & Serializable & scala.Serializable)elseExpr -> {
            ExprCode res = elseExpr.genCode(ctx);
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(63).append("\n         |").append(res.code()).append("\n         |").append(resultState).append(" = (byte)(").append(res.isNull()).append(" ? ").append(HAS_NULL).append(" : ").append(HAS_NONNULL).append(");\n         |").append(ev.value()).append(" = ").append(res.value()).append(";\n       ").toString())).stripMargin();
        });
        Seq x$15 = allConditions = (Seq)cases.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(elseCode), Seq$.MODULE$.canBuildFrom());
        String x$16 = "caseWhen";
        String x$17 = "byte";
        Function1 & Serializable & scala.Serializable x$18 = (Function1 & Serializable & scala.Serializable)func -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(114).append("\n           |").append("byte").append(" ").append(resultState).append(" = ").append(NOT_MATCHED).append(";\n           |do {\n           |  ").append((String)func).append("\n           |} while (false);\n           |return ").append(resultState).append(";\n         ").toString())).stripMargin();
        Function1 & Serializable & scala.Serializable x$19 = (Function1 & Serializable & scala.Serializable)x$14 -> ((TraversableOnce)x$14.map((Function1 & Serializable & scala.Serializable)funcCall -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(89).append("\n           |").append(resultState).append(" = ").append((String)funcCall).append(";\n           |if (").append(resultState).append(" != ").append(NOT_MATCHED).append(") {\n           |  continue;\n           |}\n         ").toString())).stripMargin(), Seq$.MODULE$.canBuildFrom())).mkString();
        Seq<Tuple2<String, String>> x$20 = ctx.splitExpressionsWithCurrentInputs$default$3();
        String codes = ctx.splitExpressionsWithCurrentInputs((Seq<String>)x$15, x$16, x$20, x$17, (Function1<String, String>)x$18, (Function1<Seq<String>, String>)x$19);
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", " ", " = ", ";\n         |do {\n         |  ", "\n         |} while (false);\n         |// TRUE if any condition is met and the result is null, or no any condition is met.\n         |final boolean ", " = (", " != ", ");\n       "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"byte", resultState, BoxesRunTime.boxToInteger((int)NOT_MATCHED), codes, ev.isNull(), resultState, BoxesRunTime.boxToInteger((int)HAS_NONNULL)})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
    }

    public CaseWhen copy(Seq<Tuple2<Expression, Expression>> branches, Option<Expression> elseValue) {
        return new CaseWhen(branches, elseValue);
    }

    public Seq<Tuple2<Expression, Expression>> copy$default$1() {
        return this.branches();
    }

    public Option<Expression> copy$default$2() {
        return this.elseValue();
    }

    @Override
    public String productPrefix() {
        return "CaseWhen";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Seq<Tuple2<Expression, Expression>> seq;
        int n = x$1;
        switch (n) {
            case 0: {
                seq = this.branches();
                break;
            }
            case 1: {
                seq = this.elseValue();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return seq;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CaseWhen;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CaseWhen)) return false;
        boolean bl = true;
        if (!bl) return false;
        CaseWhen caseWhen = (CaseWhen)x$1;
        Seq<Tuple2<Expression, Expression>> seq = this.branches();
        Seq<Tuple2<Expression, Expression>> seq2 = caseWhen.branches();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Option<Expression> option = this.elseValue();
        Option<Expression> option2 = caseWhen.elseValue();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!caseWhen.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$nullable$1(Tuple2 x$8) {
        return ((Expression)x$8._2()).nullable();
    }

    public static final /* synthetic */ boolean $anonfun$checkInputDataTypes$1(Tuple2 x$10) {
        DataType dataType = ((Expression)x$10._1()).dataType();
        BooleanType$ booleanType$ = BooleanType$.MODULE$;
        return !(dataType != null ? !dataType.equals(booleanType$) : booleanType$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$checkInputDataTypes$2(Tuple2 x$11) {
        DataType dataType = ((Expression)x$11._1()).dataType();
        BooleanType$ booleanType$ = BooleanType$.MODULE$;
        return dataType == null ? booleanType$ != null : !dataType.equals(booleanType$);
    }

    public CaseWhen(Seq<Tuple2<Expression, Expression>> branches, Option<Expression> elseValue) {
        this.branches = branches;
        this.elseValue = elseValue;
        ComplexTypeMergingExpression.$init$(this);
    }
}

