/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.DatabaseAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.analysis.NoSuchPartitionException;
import org.apache.spark.sql.catalyst.analysis.NoSuchPartitionsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.PartitionAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.PartitionsAlreadyExistException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogFunction;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalog;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogUtils$;
import org.apache.spark.sql.catalyst.catalog.FunctionResource;
import org.apache.spark.sql.catalyst.catalog.InMemoryCatalog$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.util.StringUtils$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\rEf\u0001B\u0001\u0003\u0001=\u0011q\"\u00138NK6|'/_\"bi\u0006dwn\u001a\u0006\u0003\u0007\u0011\tqaY1uC2|wM\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001!Y\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007CA\f\u0019\u001b\u0005\u0011\u0011BA\r\u0003\u0005=)\u0005\u0010^3s]\u0006d7)\u0019;bY><\u0007\u0002C\u000e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\t\r|gN\u001a\t\u0003;yi\u0011\u0001C\u0005\u0003?!\u0011\u0011b\u00159be.\u001cuN\u001c4\t\u0011\u0005\u0002!\u0011!Q\u0001\n\t\nA\u0002[1e_>\u00048i\u001c8gS\u001e\u0004\"aI\u0014\u000e\u0003\u0011R!aG\u0013\u000b\u0005\u0019R\u0011A\u00025bI>|\u0007/\u0003\u0002)I\ti1i\u001c8gS\u001e,(/\u0019;j_:DQA\u000b\u0001\u0005\u0002-\na\u0001P5oSRtDc\u0001\u0017.]A\u0011q\u0003\u0001\u0005\b7%\u0002\n\u00111\u0001\u001d\u0011\u001d\t\u0013\u0006%AA\u0002\t2A\u0001\r\u0001\u0005c\tIA+\u00192mK\u0012+7oY\n\u0003_AA\u0001bM\u0018\u0003\u0002\u0004%\t\u0001N\u0001\u0006i\u0006\u0014G.Z\u000b\u0002kA\u0011qCN\u0005\u0003o\t\u0011AbQ1uC2|w\rV1cY\u0016D\u0001\"O\u0018\u0003\u0002\u0004%\tAO\u0001\ni\u0006\u0014G.Z0%KF$\"a\u000f \u0011\u0005Ea\u0014BA\u001f\u0013\u0005\u0011)f.\u001b;\t\u000f}B\u0014\u0011!a\u0001k\u0005\u0019\u0001\u0010J\u0019\t\u0011\u0005{#\u0011!Q!\nU\na\u0001^1cY\u0016\u0004\u0003\"\u0002\u00160\t\u0003\u0019EC\u0001#G!\t)u&D\u0001\u0001\u0011\u0015\u0019$\t1\u00016\u0011\u001dAuF1A\u0005\u0002%\u000b!\u0002]1si&$\u0018n\u001c8t+\u0005Q\u0005\u0003B&Q%fk\u0011\u0001\u0014\u0006\u0003\u001b:\u000bq!\\;uC\ndWM\u0003\u0002P%\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Ec%a\u0002%bg\"l\u0015\r\u001d\t\u0003'Zs!a\u0006+\n\u0005U\u0013\u0011\u0001D\"bi\u0006dwn\u001a+za\u0016\u001c\u0018BA,Y\u0005I!\u0016M\u00197f!\u0006\u0014H/\u001b;j_:\u001c\u0006/Z2\u000b\u0005U\u0013\u0001CA\f[\u0013\tY&AA\u000bDCR\fGn\\4UC\ndW\rU1si&$\u0018n\u001c8\t\ru{\u0003\u0015!\u0003K\u0003-\u0001\u0018M\u001d;ji&|gn\u001d\u0011\u0007\t}\u0003A\u0001\u0019\u0002\r\t\u0006$\u0018MY1tK\u0012+7oY\n\u0003=BA\u0001B\u00190\u0003\u0002\u0004%\taY\u0001\u0003I\n,\u0012\u0001\u001a\t\u0003/\u0015L!A\u001a\u0002\u0003\u001f\r\u000bG/\u00197pO\u0012\u000bG/\u00192bg\u0016D\u0001\u0002\u001b0\u0003\u0002\u0004%\t![\u0001\u0007I\n|F%Z9\u0015\u0005mR\u0007bB h\u0003\u0003\u0005\r\u0001\u001a\u0005\tYz\u0013\t\u0011)Q\u0005I\u0006\u0019AM\u0019\u0011\t\u000b)rF\u0011\u00018\u0015\u0005=\u0004\bCA#_\u0011\u0015\u0011W\u000e1\u0001e\u0011\u001d\u0011hL1A\u0005\u0002M\fa\u0001^1cY\u0016\u001cX#\u0001;\u0011\t-\u0003V\u000f\u0012\t\u0003mvt!a^>\u0011\u0005a\u0014R\"A=\u000b\u0005it\u0011A\u0002\u001fs_>$h(\u0003\u0002}%\u00051\u0001K]3eK\u001aL!A`@\u0003\rM#(/\u001b8h\u0015\ta(\u0003C\u0004\u0002\u0004y\u0003\u000b\u0011\u0002;\u0002\u000fQ\f'\r\\3tA!I\u0011q\u00010C\u0002\u0013\u0005\u0011\u0011B\u0001\nMVt7\r^5p]N,\"!a\u0003\u0011\u000b-\u0003V/!\u0004\u0011\u0007]\ty!C\u0002\u0002\u0012\t\u0011qbQ1uC2|wMR;oGRLwN\u001c\u0005\t\u0003+q\u0006\u0015!\u0003\u0002\f\u0005Qa-\u001e8di&|gn\u001d\u0011\t\u0011\r\u0001!\u0019!C\u0005\u00033)\"!a\u0007\u0011\t-\u0003Vo\u001c\u0005\t\u0003?\u0001\u0001\u0015!\u0003\u0002\u001c\u0005A1-\u0019;bY><\u0007\u0005C\u0004\u0002$\u0001!I!!\n\u0002\u001fA\f'\u000f^5uS>tW\t_5tiN$\u0002\"a\n\u0002.\u0005=\u0012\u0011\u0007\t\u0004#\u0005%\u0012bAA\u0016%\t9!i\\8mK\u0006t\u0007B\u00022\u0002\"\u0001\u0007Q\u000f\u0003\u00044\u0003C\u0001\r!\u001e\u0005\b\u0003g\t\t\u00031\u0001S\u0003\u0011\u0019\b/Z2\t\u000f\u0005]\u0002\u0001\"\u0003\u0002:\u0005)\"/Z9vSJ,G+\u00192mK:{G/\u0012=jgR\u001cH#B\u001e\u0002<\u0005u\u0002B\u00022\u00026\u0001\u0007Q\u000f\u0003\u00044\u0003k\u0001\r!\u001e\u0005\b\u0003\u0003\u0002A\u0011BA\"\u0003Y\u0011X-];je\u0016\u0004\u0016M\u001d;ji&|gn]#ySN$HcB\u001e\u0002F\u0005\u001d\u0013\u0011\n\u0005\u0007E\u0006}\u0002\u0019A;\t\rM\ny\u00041\u0001v\u0011!\tY%a\u0010A\u0002\u00055\u0013!B:qK\u000e\u001c\b#BA(\u00033\u0012f\u0002BA)\u0003+r1\u0001_A*\u0013\u0005\u0019\u0012bAA,%\u00059\u0001/Y2lC\u001e,\u0017\u0002BA.\u0003;\u00121aU3r\u0015\r\t9F\u0005\u0005\b\u0003C\u0002A\u0011BA2\u0003e\u0011X-];je\u0016\u0004\u0016M\u001d;ji&|gn\u001d(pi\u0016C\u0018n\u001d;\u0015\u000fm\n)'a\u001a\u0002j!1!-a\u0018A\u0002UDaaMA0\u0001\u0004)\b\u0002CA&\u0003?\u0002\r!!\u0014\t\u000f\u00055\u0004\u0001\"\u0011\u0002p\u0005q1M]3bi\u0016$\u0015\r^1cCN,G#B\u001e\u0002r\u0005U\u0004bBA:\u0003W\u0002\r\u0001Z\u0001\rI\n$UMZ5oSRLwN\u001c\u0005\t\u0003o\nY\u00071\u0001\u0002(\u0005q\u0011n\u001a8pe\u0016Le-\u0012=jgR\u001c\bbBA>\u0001\u0011\u0005\u0013QP\u0001\rIJ|\u0007\u000fR1uC\n\f7/\u001a\u000b\bw\u0005}\u0014\u0011QAC\u0011\u0019\u0011\u0017\u0011\u0010a\u0001k\"A\u00111QA=\u0001\u0004\t9#A\tjO:|'/Z%g\u001d>$X\t_5tiND\u0001\"a\"\u0002z\u0001\u0007\u0011qE\u0001\bG\u0006\u001c8-\u00193f\u0011\u001d\tY\t\u0001C!\u0003\u001b\u000bQ\"\u00197uKJ$\u0015\r^1cCN,GcA\u001e\u0002\u0010\"9\u00111OAE\u0001\u0004!\u0007bBAJ\u0001\u0011\u0005\u0013QS\u0001\fO\u0016$H)\u0019;bE\u0006\u001cX\rF\u0002e\u0003/CaAYAI\u0001\u0004)\bbBAN\u0001\u0011\u0005\u0013QT\u0001\u000fI\u0006$\u0018MY1tK\u0016C\u0018n\u001d;t)\u0011\t9#a(\t\r\t\fI\n1\u0001v\u0011\u001d\t\u0019\u000b\u0001C!\u0003K\u000bQ\u0002\\5ti\u0012\u000bG/\u00192bg\u0016\u001cHCAAT!\u0015\ty%!\u0017v\u0011\u001d\t\u0019\u000b\u0001C!\u0003W#B!a*\u0002.\"9\u0011qVAU\u0001\u0004)\u0018a\u00029biR,'O\u001c\u0005\b\u0003g\u0003A\u0011IA[\u0003I\u0019X\r^\"veJ,g\u000e\u001e#bi\u0006\u0014\u0017m]3\u0015\u0007m\n9\f\u0003\u0004c\u0003c\u0003\r!\u001e\u0005\b\u0003w\u0003A\u0011IA_\u0003-\u0019'/Z1uKR\u000b'\r\\3\u0015\u000bm\ny,a1\t\u000f\u0005\u0005\u0017\u0011\u0018a\u0001k\u0005yA/\u00192mK\u0012+g-\u001b8ji&|g\u000e\u0003\u0005\u0002x\u0005e\u0006\u0019AA\u0014\u0011\u001d\t9\r\u0001C!\u0003\u0013\f\u0011\u0002\u001a:paR\u000b'\r\\3\u0015\u0013m\nY-!4\u0002P\u0006E\u0007B\u00022\u0002F\u0002\u0007Q\u000f\u0003\u00044\u0003\u000b\u0004\r!\u001e\u0005\t\u0003\u0007\u000b)\r1\u0001\u0002(!A\u00111[Ac\u0001\u0004\t9#A\u0003qkJ<W\rC\u0004\u0002X\u0002!\t%!7\u0002\u0017I,g.Y7f)\u0006\u0014G.\u001a\u000b\bw\u0005m\u0017Q\\Aq\u0011\u0019\u0011\u0017Q\u001ba\u0001k\"9\u0011q\\Ak\u0001\u0004)\u0018aB8mI:\u000bW.\u001a\u0005\b\u0003G\f)\u000e1\u0001v\u0003\u001dqWm\u001e(b[\u0016Dq!a:\u0001\t\u0003\nI/\u0001\u0006bYR,'\u000fV1cY\u0016$2aOAv\u0011\u001d\t\t-!:A\u0002UBq!a<\u0001\t\u0003\n\t0\u0001\u000bbYR,'\u000fV1cY\u0016$\u0015\r^1TG\",W.\u0019\u000b\bw\u0005M\u0018Q_A|\u0011\u0019\u0011\u0017Q\u001ea\u0001k\"11'!<A\u0002UD\u0001\"!?\u0002n\u0002\u0007\u00111`\u0001\u000e]\u0016<H)\u0019;b'\u000eDW-\\1\u0011\t\u0005u(1A\u0007\u0003\u0003\u007fT1A!\u0001\u0007\u0003\u0015!\u0018\u0010]3t\u0013\u0011\u0011)!a@\u0003\u0015M#(/^2u)f\u0004X\rC\u0004\u0003\n\u0001!\tEa\u0003\u0002\u001f\u0005dG/\u001a:UC\ndWm\u0015;biN$ra\u000fB\u0007\u0005\u001f\u0011\t\u0002\u0003\u0004c\u0005\u000f\u0001\r!\u001e\u0005\u0007g\t\u001d\u0001\u0019A;\t\u0011\tM!q\u0001a\u0001\u0005+\tQa\u001d;biN\u0004R!\u0005B\f\u00057I1A!\u0007\u0013\u0005\u0019y\u0005\u000f^5p]B\u0019qC!\b\n\u0007\t}!AA\tDCR\fGn\\4Ti\u0006$\u0018n\u001d;jGNDqAa\t\u0001\t\u0003\u0012)#\u0001\u0005hKR$\u0016M\u00197f)\u0015)$q\u0005B\u0015\u0011\u0019\u0011'\u0011\u0005a\u0001k\"11G!\tA\u0002UDqA!\f\u0001\t\u0003\u0012y#A\u0006uC\ndW-\u0012=jgR\u001cHCBA\u0014\u0005c\u0011\u0019\u0004\u0003\u0004c\u0005W\u0001\r!\u001e\u0005\u0007g\t-\u0002\u0019A;\t\u000f\t]\u0002\u0001\"\u0011\u0003:\u0005QA.[:u)\u0006\u0014G.Z:\u0015\t\u0005\u001d&1\b\u0005\u0007E\nU\u0002\u0019A;\t\u000f\t]\u0002\u0001\"\u0011\u0003@Q1\u0011q\u0015B!\u0005\u0007BaA\u0019B\u001f\u0001\u0004)\bbBAX\u0005{\u0001\r!\u001e\u0005\b\u0005\u000f\u0002A\u0011\tB%\u0003%aw.\u00193UC\ndW\rF\u0006<\u0005\u0017\u0012iEa\u0014\u0003T\t]\u0003B\u00022\u0003F\u0001\u0007Q\u000f\u0003\u00044\u0005\u000b\u0002\r!\u001e\u0005\b\u0005#\u0012)\u00051\u0001v\u0003!aw.\u00193QCRD\u0007\u0002\u0003B+\u0005\u000b\u0002\r!a\n\u0002\u0017%\u001cxJ^3soJLG/\u001a\u0005\t\u00053\u0012)\u00051\u0001\u0002(\u0005Q\u0011n]*sG2{7-\u00197\t\u000f\tu\u0003\u0001\"\u0011\u0003`\u0005iAn\\1e!\u0006\u0014H/\u001b;j_:$rb\u000fB1\u0005G\u0012)Ga\u001a\u0003l\t5$\u0011\u000f\u0005\u0007E\nm\u0003\u0019A;\t\rM\u0012Y\u00061\u0001v\u0011\u001d\u0011\tFa\u0017A\u0002UDqA!\u001b\u0003\\\u0001\u0007!+A\u0005qCJ$\u0018\u000e^5p]\"A!Q\u000bB.\u0001\u0004\t9\u0003\u0003\u0005\u0003p\tm\u0003\u0019AA\u0014\u0003EIg\u000e[3sSR$\u0016M\u00197f'B,7m\u001d\u0005\t\u00053\u0012Y\u00061\u0001\u0002(!9!Q\u000f\u0001\u0005B\t]\u0014!\u00067pC\u0012$\u0015P\\1nS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u000ew\te$1\u0010B?\u0005\u007f\u0012\tI!\"\t\r\t\u0014\u0019\b1\u0001v\u0011\u0019\u0019$1\u000fa\u0001k\"9!\u0011\u000bB:\u0001\u0004)\bb\u0002B5\u0005g\u0002\rA\u0015\u0005\t\u0005\u0007\u0013\u0019\b1\u0001\u0002(\u00059!/\u001a9mC\u000e,\u0007\u0002\u0003BD\u0005g\u0002\rA!#\u0002\u000b9,X\u000e\u0012)\u0011\u0007E\u0011Y)C\u0002\u0003\u000eJ\u00111!\u00138u\u0011\u001d\u0011\t\n\u0001C!\u0005'\u000b\u0001c\u0019:fCR,\u0007+\u0019:uSRLwN\\:\u0015\u0013m\u0012)Ja&\u0003\u001a\n}\u0005B\u00022\u0003\u0010\u0002\u0007Q\u000f\u0003\u00044\u0005\u001f\u0003\r!\u001e\u0005\t\u00057\u0013y\t1\u0001\u0003\u001e\u0006)\u0001/\u0019:ugB)\u0011qJA-3\"A\u0011q\u000fBH\u0001\u0004\t9\u0003C\u0004\u0003$\u0002!\tE!*\u0002\u001d\u0011\u0014x\u000e\u001d)beRLG/[8ogRi1Ha*\u0003*\n-&q\u0016BY\u0005gCaA\u0019BQ\u0001\u0004)\bBB\u001a\u0003\"\u0002\u0007Q\u000f\u0003\u0005\u0003.\n\u0005\u0006\u0019AA'\u0003%\u0001\u0018M\u001d;Ta\u0016\u001c7\u000f\u0003\u0005\u0002\u0004\n\u0005\u0006\u0019AA\u0014\u0011!\t\u0019N!)A\u0002\u0005\u001d\u0002\u0002\u0003B[\u0005C\u0003\r!a\n\u0002\u0015I,G/Y5o\t\u0006$\u0018\rC\u0004\u0003:\u0002!\tEa/\u0002!I,g.Y7f!\u0006\u0014H/\u001b;j_:\u001cH#C\u001e\u0003>\n}&\u0011\u0019Bb\u0011\u0019\u0011'q\u0017a\u0001k\"11Ga.A\u0002UD\u0001\"a\u0013\u00038\u0002\u0007\u0011Q\n\u0005\t\u0005\u000b\u00149\f1\u0001\u0002N\u0005Aa.Z<Ta\u0016\u001c7\u000fC\u0004\u0003J\u0002!\tEa3\u0002\u001f\u0005dG/\u001a:QCJ$\u0018\u000e^5p]N$ra\u000fBg\u0005\u001f\u0014\t\u000e\u0003\u0004c\u0005\u000f\u0004\r!\u001e\u0005\u0007g\t\u001d\u0007\u0019A;\t\u0011\tm%q\u0019a\u0001\u0005;CqA!6\u0001\t\u0003\u00129.\u0001\u0007hKR\u0004\u0016M\u001d;ji&|g\u000eF\u0004Z\u00053\u0014YN!8\t\r\t\u0014\u0019\u000e1\u0001v\u0011\u0019\u0019$1\u001ba\u0001k\"9\u00111\u0007Bj\u0001\u0004\u0011\u0006b\u0002Bq\u0001\u0011\u0005#1]\u0001\u0013O\u0016$\b+\u0019:uSRLwN\\(qi&|g\u000e\u0006\u0005\u0003f\n\u001d(\u0011\u001eBv!\u0011\t\"qC-\t\r\t\u0014y\u000e1\u0001v\u0011\u0019\u0019$q\u001ca\u0001k\"9\u00111\u0007Bp\u0001\u0004\u0011\u0006b\u0002Bx\u0001\u0011\u0005#\u0011_\u0001\u0013Y&\u001cH\u000fU1si&$\u0018n\u001c8OC6,7\u000f\u0006\u0005\u0002(\nM(Q\u001fB|\u0011\u0019\u0011'Q\u001ea\u0001k\"11G!<A\u0002UD!B!?\u0003nB\u0005\t\u0019\u0001B~\u0003-\u0001\u0018M\u001d;jC2\u001c\u0006/Z2\u0011\tE\u00119B\u0015\u0005\b\u0005\u007f\u0004A\u0011IB\u0001\u00039a\u0017n\u001d;QCJ$\u0018\u000e^5p]N$\u0002B!(\u0004\u0004\r\u00151q\u0001\u0005\u0007E\nu\b\u0019A;\t\rM\u0012i\u00101\u0001v\u0011)\u0011IP!@\u0011\u0002\u0003\u0007!1 \u0005\b\u0007\u0017\u0001A\u0011IB\u0007\u0003Ya\u0017n\u001d;QCJ$\u0018\u000e^5p]N\u0014\u0015PR5mi\u0016\u0014HC\u0003BO\u0007\u001f\u0019\tba\u0005\u0004&!1!m!\u0003A\u0002UDaaMB\u0005\u0001\u0004)\b\u0002CB\u000b\u0007\u0013\u0001\raa\u0006\u0002\u0015A\u0014X\rZ5dCR,7\u000f\u0005\u0004\u0002P\u0005e3\u0011\u0004\t\u0005\u00077\u0019\t#\u0004\u0002\u0004\u001e)\u00191q\u0004\u0003\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0005\u0007G\u0019iB\u0001\u0006FqB\u0014Xm]:j_:Dqaa\n\u0004\n\u0001\u0007Q/A\teK\u001a\fW\u000f\u001c;US6,'l\u001c8f\u0013\u0012Dqaa\u000b\u0001\t\u0003\u001ai#\u0001\bde\u0016\fG/\u001a$v]\u000e$\u0018n\u001c8\u0015\u000bm\u001ayc!\r\t\r\t\u001cI\u00031\u0001v\u0011!\u0019\u0019d!\u000bA\u0002\u00055\u0011\u0001\u00024v]\u000eDqaa\u000e\u0001\t\u0003\u001aI$\u0001\u0007ee>\u0004h)\u001e8di&|g\u000eF\u0003<\u0007w\u0019i\u0004\u0003\u0004c\u0007k\u0001\r!\u001e\u0005\b\u0007\u007f\u0019)\u00041\u0001v\u0003!1WO\\2OC6,\u0007bBB\"\u0001\u0011\u00053QI\u0001\u000eC2$XM\u001d$v]\u000e$\u0018n\u001c8\u0015\u000bm\u001a9e!\u0013\t\r\t\u001c\t\u00051\u0001v\u0011!\u0019\u0019d!\u0011A\u0002\u00055\u0001bBB'\u0001\u0011\u00053qJ\u0001\u000fe\u0016t\u0017-\\3Gk:\u001cG/[8o)\u001dY4\u0011KB*\u0007+BaAYB&\u0001\u0004)\bbBAp\u0007\u0017\u0002\r!\u001e\u0005\b\u0003G\u001cY\u00051\u0001v\u0011\u001d\u0019I\u0006\u0001C!\u00077\n1bZ3u\rVt7\r^5p]R1\u0011QBB/\u0007?BaAYB,\u0001\u0004)\bbBB \u0007/\u0002\r!\u001e\u0005\b\u0007G\u0002A\u0011IB3\u000391WO\\2uS>tW\t_5tiN$b!a\n\u0004h\r%\u0004B\u00022\u0004b\u0001\u0007Q\u000fC\u0004\u0004@\r\u0005\u0004\u0019A;\t\u000f\r5\u0004\u0001\"\u0011\u0004p\u0005iA.[:u\rVt7\r^5p]N$b!a*\u0004r\rM\u0004B\u00022\u0004l\u0001\u0007Q\u000fC\u0004\u00020\u000e-\u0004\u0019A;\t\u0013\r]\u0004!%A\u0005B\re\u0014\u0001\b7jgR\u0004\u0016M\u001d;ji&|gNT1nKN$C-\u001a4bk2$HeM\u000b\u0003\u0007wRCAa?\u0004~-\u00121q\u0010\t\u0005\u0007\u0003\u001bY)\u0004\u0002\u0004\u0004*!1QQBD\u0003%)hn\u00195fG.,GMC\u0002\u0004\nJ\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0019iia!\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0004\u0012\u0002\t\n\u0011\"\u0011\u0004z\u0005AB.[:u!\u0006\u0014H/\u001b;j_:\u001cH\u0005Z3gCVdG\u000fJ\u001a\b\u0013\rU%!!A\t\u0002\r]\u0015aD%o\u001b\u0016lwN]=DCR\fGn\\4\u0011\u0007]\u0019IJ\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012ABN'\r\u0019I\n\u0005\u0005\bU\reE\u0011ABP)\t\u00199\n\u0003\u0006\u0004$\u000ee\u0015\u0013!C\u0001\u0007K\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\nTCABTU\ra2Q\u0010\u0005\u000b\u0007W\u001bI*%A\u0005\u0002\r5\u0016a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0006\u0002\u00040*\u001a!e! ")
public class InMemoryCatalog
implements ExternalCatalog {
    private final Configuration hadoopConfig;
    private final HashMap<String, DatabaseDesc> catalog;

    public static Configuration $lessinit$greater$default$2() {
        return InMemoryCatalog$.MODULE$.$lessinit$greater$default$2();
    }

    public static SparkConf $lessinit$greater$default$1() {
        return InMemoryCatalog$.MODULE$.$lessinit$greater$default$1();
    }

    @Override
    public void requireDbExists(String db) {
        ExternalCatalog.requireDbExists$(this, db);
    }

    @Override
    public void requireTableExists(String db, String table) {
        ExternalCatalog.requireTableExists$(this, db, table);
    }

    @Override
    public void requireFunctionExists(String db, String funcName) {
        ExternalCatalog.requireFunctionExists$(this, db, funcName);
    }

    @Override
    public void requireFunctionNotExists(String db, String funcName) {
        ExternalCatalog.requireFunctionNotExists$(this, db, funcName);
    }

    private HashMap<String, DatabaseDesc> catalog() {
        return this.catalog;
    }

    private boolean partitionExists(String db, String table, Map<String, String> spec) {
        this.requireTableExists(db, table);
        return ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().contains(spec);
    }

    private void requireTableNotExists(String db, String table) {
        if (this.tableExists(db, table)) {
            throw new TableAlreadyExistsException(db, table);
        }
    }

    private void requirePartitionsExist(String db, String table, Seq<Map<String, String>> specs) {
        specs.foreach((Function1 & Serializable & scala.Serializable)s -> {
            InMemoryCatalog.$anonfun$requirePartitionsExist$1(this, db, table, s);
            return BoxedUnit.UNIT;
        });
    }

    private void requirePartitionsNotExist(String db, String table, Seq<Map<String, String>> specs) {
        specs.foreach((Function1 & Serializable & scala.Serializable)s -> {
            InMemoryCatalog.$anonfun$requirePartitionsNotExist$1(this, db, table, s);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void createDatabase(CatalogDatabase dbDefinition, boolean ignoreIfExists) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            BoxedUnit boxedUnit;
            if (this.catalog().contains((Object)dbDefinition.name())) {
                if (!ignoreIfExists) {
                    throw new DatabaseAlreadyExistsException(dbDefinition.name());
                }
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.liftedTree1$1(dbDefinition);
                boxedUnit = this.catalog().put((Object)dbDefinition.name(), (Object)new DatabaseDesc(this, dbDefinition));
            }
        }
    }

    @Override
    public void dropDatabase(String db, boolean ignoreIfNotExists, boolean cascade) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            BoxedUnit boxedUnit;
            if (this.catalog().contains((Object)db)) {
                if (!cascade) {
                    if (((DatabaseDesc)this.catalog().apply((Object)db)).tables().nonEmpty()) {
                        throw new AnalysisException(new StringBuilder(49).append("Database ").append(db).append(" is not empty. One or more tables exist.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    }
                    if (((DatabaseDesc)this.catalog().apply((Object)db)).functions().nonEmpty()) {
                        throw new AnalysisException(new StringBuilder(54).append("Database '").append(db).append("' is not empty. One or more functions exist.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    }
                }
                CatalogDatabase dbDefinition = ((DatabaseDesc)this.catalog().apply((Object)db)).db();
                this.liftedTree2$1(dbDefinition);
                boxedUnit = this.catalog().remove((Object)db);
            } else {
                if (!ignoreIfNotExists) {
                    throw new NoSuchDatabaseException(db);
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    @Override
    public synchronized void alterDatabase(CatalogDatabase dbDefinition) {
        this.requireDbExists(dbDefinition.name());
        ((DatabaseDesc)this.catalog().apply((Object)dbDefinition.name())).db_$eq(dbDefinition);
    }

    @Override
    public synchronized CatalogDatabase getDatabase(String db) {
        this.requireDbExists(db);
        return ((DatabaseDesc)this.catalog().apply((Object)db)).db();
    }

    @Override
    public synchronized boolean databaseExists(String db) {
        return this.catalog().contains((Object)db);
    }

    @Override
    public synchronized Seq<String> listDatabases() {
        return (Seq)this.catalog().keySet().toSeq().sorted((Ordering)Ordering.String$.MODULE$);
    }

    @Override
    public synchronized Seq<String> listDatabases(String pattern) {
        return StringUtils$.MODULE$.filterPattern(this.listDatabases(), pattern);
    }

    @Override
    public void setCurrentDatabase(String db) {
    }

    @Override
    public void createTable(CatalogTable tableDefinition, boolean ignoreIfExists) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            BoxedUnit boxedUnit;
            Predef$.MODULE$.assert(tableDefinition.identifier().database().isDefined());
            String db = (String)tableDefinition.identifier().database().get();
            this.requireDbExists(db);
            String table = tableDefinition.identifier().table();
            if (this.tableExists(db, table)) {
                if (!ignoreIfExists) {
                    throw new TableAlreadyExistsException(db, table);
                }
                boxedUnit = BoxedUnit.UNIT;
            } else {
                Map tableProp;
                CatalogTable catalogTable;
                boolean needDefaultTableLocation;
                CatalogTableType catalogTableType = tableDefinition.tableType();
                CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
                boolean bl = !(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null) && tableDefinition.storage().locationUri().isEmpty() ? true : (needDefaultTableLocation = false);
                if (needDefaultTableLocation) {
                    Path defaultTableLocation = new Path(new Path(((DatabaseDesc)this.catalog().apply((Object)db)).db().locationUri()), table);
                    this.liftedTree3$1(table, defaultTableLocation);
                    catalogTable = tableDefinition.withNewStorage((Option<URI>)new Some((Object)defaultTableLocation.toUri()), tableDefinition.withNewStorage$default$2(), tableDefinition.withNewStorage$default$3(), tableDefinition.withNewStorage$default$4(), tableDefinition.withNewStorage$default$5(), tableDefinition.withNewStorage$default$6());
                } else {
                    catalogTable = tableDefinition;
                }
                CatalogTable tableWithLocation = catalogTable;
                Map x$4 = tableProp = (Map)tableWithLocation.properties().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)InMemoryCatalog.$anonfun$createTable$1(x$1)));
                TableIdentifier x$5 = tableWithLocation.copy$default$1();
                CatalogTableType x$6 = tableWithLocation.copy$default$2();
                CatalogStorageFormat x$7 = tableWithLocation.copy$default$3();
                StructType x$8 = tableWithLocation.copy$default$4();
                Option<String> x$9 = tableWithLocation.copy$default$5();
                Seq<String> x$10 = tableWithLocation.copy$default$6();
                Option<BucketSpec> x$11 = tableWithLocation.copy$default$7();
                String x$12 = tableWithLocation.copy$default$8();
                long x$13 = tableWithLocation.copy$default$9();
                long x$14 = tableWithLocation.copy$default$10();
                String x$15 = tableWithLocation.copy$default$11();
                Option<CatalogStatistics> x$16 = tableWithLocation.copy$default$13();
                Option<String> x$17 = tableWithLocation.copy$default$14();
                Option<String> x$18 = tableWithLocation.copy$default$15();
                Seq<String> x$19 = tableWithLocation.copy$default$16();
                boolean x$20 = tableWithLocation.copy$default$17();
                boolean x$21 = tableWithLocation.copy$default$18();
                Map<String, String> x$22 = tableWithLocation.copy$default$19();
                boxedUnit = ((DatabaseDesc)this.catalog().apply((Object)db)).tables().put((Object)table, (Object)new TableDesc(this, tableWithLocation.copy(x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Map<String, String>)x$4, x$16, x$17, x$18, x$19, x$20, x$21, x$22)));
            }
        }
    }

    @Override
    public void dropTable(String db, String table, boolean ignoreIfNotExists, boolean purge) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            BoxedUnit boxedUnit;
            this.requireDbExists(db);
            if (this.tableExists(db, table)) {
                Object object;
                CatalogTable tableMeta = this.getTable(db, table);
                CatalogTableType catalogTableType = tableMeta.tableType();
                CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
                if (!(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null)) {
                    Seq locationAllParts = (Seq)((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().values().toSeq().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.location(), Seq$.MODULE$.canBuildFrom());
                    locationAllParts.foreach((Function1 & Serializable & scala.Serializable)loc -> BoxesRunTime.boxToBoolean((boolean)InMemoryCatalog.$anonfun$dropTable$2(this, loc)));
                    Predef$.MODULE$.assert(tableMeta.storage().locationUri().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Managed table should always have table location, as we will assign a default location to it if it doesn't have one.");
                    Path dir = new Path(tableMeta.location());
                    object = BoxesRunTime.boxToBoolean((boolean)this.liftedTree4$1(table, dir));
                } else {
                    object = BoxedUnit.UNIT;
                }
                boxedUnit = ((DatabaseDesc)this.catalog().apply((Object)db)).tables().remove((Object)table);
            } else {
                if (!ignoreIfNotExists) {
                    throw new NoSuchTableException(db, table);
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    @Override
    public void renameTable(String db, String oldName, String newName) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireTableExists(db, oldName);
            this.requireTableNotExists(db, newName);
            TableDesc oldDesc = (TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)oldName);
            CatalogTable qual$1 = oldDesc.table();
            TableIdentifier x$23 = new TableIdentifier(newName, (Option<String>)new Some((Object)db));
            CatalogTableType x$24 = qual$1.copy$default$2();
            CatalogStorageFormat x$25 = qual$1.copy$default$3();
            StructType x$26 = qual$1.copy$default$4();
            Option<String> x$27 = qual$1.copy$default$5();
            Seq<String> x$28 = qual$1.copy$default$6();
            Option<BucketSpec> x$29 = qual$1.copy$default$7();
            String x$30 = qual$1.copy$default$8();
            long x$31 = qual$1.copy$default$9();
            long x$32 = qual$1.copy$default$10();
            String x$33 = qual$1.copy$default$11();
            Map<String, String> x$34 = qual$1.copy$default$12();
            Option<CatalogStatistics> x$35 = qual$1.copy$default$13();
            Option<String> x$36 = qual$1.copy$default$14();
            Option<String> x$37 = qual$1.copy$default$15();
            Seq<String> x$38 = qual$1.copy$default$16();
            boolean x$39 = qual$1.copy$default$17();
            boolean x$40 = qual$1.copy$default$18();
            Map<String, String> x$41 = qual$1.copy$default$19();
            oldDesc.table_$eq(qual$1.copy(x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40, x$41));
            CatalogTableType catalogTableType = oldDesc.table().tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
            if (!(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null)) {
                Predef$.MODULE$.assert(oldDesc.table().storage().locationUri().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Managed table should always have table location, as we will assign a default location to it if it doesn't have one.");
                Path oldDir = new Path(oldDesc.table().location());
                Path newDir = new Path(new Path(((DatabaseDesc)this.catalog().apply((Object)db)).db().locationUri()), newName);
                this.liftedTree5$1(oldName, newName, oldDir, newDir);
                CatalogTable qual$2 = oldDesc.table();
                Some x$42 = new Some((Object)newDir.toUri());
                Option<String> x$43 = qual$2.withNewStorage$default$2();
                Option<String> x$44 = qual$2.withNewStorage$default$3();
                boolean x$45 = qual$2.withNewStorage$default$4();
                Option<String> x$46 = qual$2.withNewStorage$default$5();
                Map<String, String> x$47 = qual$2.withNewStorage$default$6();
                oldDesc.table_$eq(qual$2.withNewStorage((Option<URI>)x$42, x$43, x$44, x$45, x$46, x$47));
            }
            ((DatabaseDesc)this.catalog().apply((Object)db)).tables().put((Object)newName, (Object)oldDesc);
            ((DatabaseDesc)this.catalog().apply((Object)db)).tables().remove((Object)oldName);
        }
    }

    @Override
    public synchronized void alterTable(CatalogTable tableDefinition) {
        Map updatedProperties;
        Predef$.MODULE$.assert(tableDefinition.identifier().database().isDefined());
        String db = (String)tableDefinition.identifier().database().get();
        this.requireTableExists(db, tableDefinition.identifier().table());
        Map x$48 = updatedProperties = (Map)tableDefinition.properties().filter((Function1 & Serializable & scala.Serializable)kv -> BoxesRunTime.boxToBoolean((boolean)InMemoryCatalog.$anonfun$alterTable$1(kv)));
        TableIdentifier x$49 = tableDefinition.copy$default$1();
        CatalogTableType x$50 = tableDefinition.copy$default$2();
        CatalogStorageFormat x$51 = tableDefinition.copy$default$3();
        StructType x$52 = tableDefinition.copy$default$4();
        Option<String> x$53 = tableDefinition.copy$default$5();
        Seq<String> x$54 = tableDefinition.copy$default$6();
        Option<BucketSpec> x$55 = tableDefinition.copy$default$7();
        String x$56 = tableDefinition.copy$default$8();
        long x$57 = tableDefinition.copy$default$9();
        long x$58 = tableDefinition.copy$default$10();
        String x$59 = tableDefinition.copy$default$11();
        Option<CatalogStatistics> x$60 = tableDefinition.copy$default$13();
        Option<String> x$61 = tableDefinition.copy$default$14();
        Option<String> x$62 = tableDefinition.copy$default$15();
        Seq<String> x$63 = tableDefinition.copy$default$16();
        boolean x$64 = tableDefinition.copy$default$17();
        boolean x$65 = tableDefinition.copy$default$18();
        Map<String, String> x$66 = tableDefinition.copy$default$19();
        CatalogTable newTableDefinition = tableDefinition.copy(x$49, x$50, x$51, x$52, x$53, x$54, x$55, x$56, x$57, x$58, x$59, (Map<String, String>)x$48, x$60, x$61, x$62, x$63, x$64, x$65, x$66);
        ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)tableDefinition.identifier().table())).table_$eq(newTableDefinition);
    }

    @Override
    public synchronized void alterTableDataSchema(String db, String table, StructType newDataSchema) {
        StructType newSchema;
        this.requireTableExists(db, table);
        CatalogTable origTable = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).table();
        StructType x$67 = newSchema = StructType$.MODULE$.apply((Seq<StructField>)((Seq)newDataSchema.$plus$plus(origTable.partitionSchema(), Seq$.MODULE$.canBuildFrom())));
        TableIdentifier x$68 = origTable.copy$default$1();
        CatalogTableType x$69 = origTable.copy$default$2();
        CatalogStorageFormat x$70 = origTable.copy$default$3();
        Option<String> x$71 = origTable.copy$default$5();
        Seq<String> x$72 = origTable.copy$default$6();
        Option<BucketSpec> x$73 = origTable.copy$default$7();
        String x$74 = origTable.copy$default$8();
        long x$75 = origTable.copy$default$9();
        long x$76 = origTable.copy$default$10();
        String x$77 = origTable.copy$default$11();
        Map<String, String> x$78 = origTable.copy$default$12();
        Option<CatalogStatistics> x$79 = origTable.copy$default$13();
        Option<String> x$80 = origTable.copy$default$14();
        Option<String> x$81 = origTable.copy$default$15();
        Seq<String> x$82 = origTable.copy$default$16();
        boolean x$83 = origTable.copy$default$17();
        boolean x$84 = origTable.copy$default$18();
        Map<String, String> x$85 = origTable.copy$default$19();
        ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).table_$eq(origTable.copy(x$68, x$69, x$70, x$67, x$71, x$72, x$73, x$74, x$75, x$76, x$77, x$78, x$79, x$80, x$81, x$82, x$83, x$84, x$85));
    }

    @Override
    public synchronized void alterTableStats(String db, String table, Option<CatalogStatistics> stats) {
        this.requireTableExists(db, table);
        CatalogTable origTable = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).table();
        Option<CatalogStatistics> x$86 = stats;
        TableIdentifier x$87 = origTable.copy$default$1();
        CatalogTableType x$88 = origTable.copy$default$2();
        CatalogStorageFormat x$89 = origTable.copy$default$3();
        StructType x$90 = origTable.copy$default$4();
        Option<String> x$91 = origTable.copy$default$5();
        Seq<String> x$92 = origTable.copy$default$6();
        Option<BucketSpec> x$93 = origTable.copy$default$7();
        String x$94 = origTable.copy$default$8();
        long x$95 = origTable.copy$default$9();
        long x$96 = origTable.copy$default$10();
        String x$97 = origTable.copy$default$11();
        Map<String, String> x$98 = origTable.copy$default$12();
        Option<String> x$99 = origTable.copy$default$14();
        Option<String> x$100 = origTable.copy$default$15();
        Seq<String> x$101 = origTable.copy$default$16();
        boolean x$102 = origTable.copy$default$17();
        boolean x$103 = origTable.copy$default$18();
        Map<String, String> x$104 = origTable.copy$default$19();
        ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).table_$eq(origTable.copy(x$87, x$88, x$89, x$90, x$91, x$92, x$93, x$94, x$95, x$96, x$97, x$98, x$86, x$99, x$100, x$101, x$102, x$103, x$104));
    }

    @Override
    public synchronized CatalogTable getTable(String db, String table) {
        this.requireTableExists(db, table);
        return ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).table();
    }

    @Override
    public synchronized boolean tableExists(String db, String table) {
        this.requireDbExists(db);
        return ((DatabaseDesc)this.catalog().apply((Object)db)).tables().contains((Object)table);
    }

    @Override
    public synchronized Seq<String> listTables(String db) {
        this.requireDbExists(db);
        return (Seq)((DatabaseDesc)this.catalog().apply((Object)db)).tables().keySet().toSeq().sorted((Ordering)Ordering.String$.MODULE$);
    }

    @Override
    public synchronized Seq<String> listTables(String db, String pattern) {
        return StringUtils$.MODULE$.filterPattern(this.listTables(db), pattern);
    }

    @Override
    public void loadTable(String db, String table, String loadPath, boolean isOverwrite, boolean isSrcLocal) {
        throw new UnsupportedOperationException("loadTable is not implemented");
    }

    @Override
    public void loadPartition(String db, String table, String loadPath, Map<String, String> partition, boolean isOverwrite, boolean inheritTableSpecs, boolean isSrcLocal) {
        throw new UnsupportedOperationException("loadPartition is not implemented.");
    }

    @Override
    public void loadDynamicPartitions(String db, String table, String loadPath, Map<String, String> partition, boolean replace, int numDP) {
        throw new UnsupportedOperationException("loadDynamicPartitions is not implemented.");
    }

    @Override
    public synchronized void createPartitions(String db, String table, Seq<CatalogTablePartition> parts, boolean ignoreIfExists) {
        Seq dupSpecs;
        this.requireTableExists(db, table);
        HashMap<Map<String, String>, CatalogTablePartition> existingParts = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions();
        if (!ignoreIfExists && (dupSpecs = (Seq)parts.collect((PartialFunction)new scala.Serializable(null, existingParts){
            public static final long serialVersionUID = 0L;
            private final HashMap existingParts$1;

            public final <A1 extends CatalogTablePartition, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = this.existingParts$1.contains(A1.spec()) ? A1.spec() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(CatalogTablePartition x1) {
                CatalogTablePartition catalogTablePartition = x1;
                boolean bl = this.existingParts$1.contains(catalogTablePartition.spec());
                return bl;
            }
            {
                this.existingParts$1 = existingParts$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).nonEmpty()) {
            throw new PartitionsAlreadyExistException(db, table, (Seq<Map<String, String>>)dupSpecs);
        }
        CatalogTable tableMeta = this.getTable(db, table);
        Seq<String> partitionColumnNames = tableMeta.partitionColumnNames();
        Path tablePath = new Path(tableMeta.location());
        parts.foreach((Function1 & Serializable & scala.Serializable)p -> {
            Path partitionPath = (Path)p.storage().locationUri().map((Function1 & Serializable & scala.Serializable)x$3 -> new Path(x$3)).getOrElse((Function0 & Serializable & scala.Serializable)() -> ExternalCatalogUtils$.MODULE$.generatePartitionPath(p.spec(), partitionColumnNames, tablePath));
            try {
                FileSystem fs = tablePath.getFileSystem($this.hadoopConfig);
                Object object = !fs.exists(partitionPath) ? BoxesRunTime.boxToBoolean((boolean)fs.mkdirs(partitionPath)) : BoxedUnit.UNIT;
            }
            catch (IOException e) {
                throw new SparkException(new StringBuilder(32).append("Unable to create partition path ").append(partitionPath).toString(), (Throwable)e);
            }
            CatalogStorageFormat x$105 = p.storage().copy((Option<URI>)new Some((Object)partitionPath.toUri()), p.storage().copy$default$2(), p.storage().copy$default$3(), p.storage().copy$default$4(), p.storage().copy$default$5(), p.storage().copy$default$6());
            Map<String, String> x$106 = p.copy$default$1();
            Map<String, String> x$107 = p.copy$default$3();
            long x$108 = p.copy$default$4();
            long x$109 = p.copy$default$5();
            Option<CatalogStatistics> x$110 = p.copy$default$6();
            return existingParts.put(p.spec(), (Object)p.copy(x$106, x$105, x$107, x$108, x$109, x$110));
        });
    }

    @Override
    public synchronized void dropPartitions(String db, String table, Seq<Map<String, String>> partSpecs, boolean ignoreIfNotExists, boolean purge, boolean retainData) {
        boolean bl;
        Seq missingSpecs;
        this.requireTableExists(db, table);
        HashMap<Map<String, String>, CatalogTablePartition> existingParts = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions();
        if (!ignoreIfNotExists && (missingSpecs = (Seq)partSpecs.collect((PartialFunction)new scala.Serializable(null, existingParts){
            public static final long serialVersionUID = 0L;
            private final HashMap existingParts$2;

            public final <A1 extends Map<String, String>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                Object object = !this.existingParts$2.contains(A1) ? A1 : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Map<String, String> x2) {
                Map<String, String> map = x2;
                boolean bl = !this.existingParts$2.contains(map);
                return bl;
            }
            {
                this.existingParts$2 = existingParts$2;
            }
        }, Seq$.MODULE$.canBuildFrom())).nonEmpty()) {
            throw new NoSuchPartitionsException(db, table, (Seq<Map<String, String>>)missingSpecs);
        }
        if (retainData) {
            bl = false;
        } else {
            CatalogTableType catalogTableType = this.getTable(db, table).tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
            bl = !(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null);
        }
        boolean shouldRemovePartitionLocation = bl;
        partSpecs.foreach((Function1 & Serializable & scala.Serializable)p -> {
            Object object;
            if (existingParts.contains(p) && shouldRemovePartitionLocation) {
                boolean bl;
                Path partitionPath = new Path(((CatalogTablePartition)existingParts.apply(p)).location());
                try {
                    FileSystem fs = partitionPath.getFileSystem($this.hadoopConfig);
                    bl = fs.delete(partitionPath, true);
                }
                catch (IOException e) {
                    throw new SparkException(new StringBuilder(32).append("Unable to delete partition path ").append(partitionPath).toString(), (Throwable)e);
                }
                object = BoxesRunTime.boxToBoolean((boolean)bl);
            } else {
                object = BoxedUnit.UNIT;
            }
            return existingParts.remove(p);
        });
    }

    @Override
    public synchronized void renamePartitions(String db, String table, Seq<Map<String, String>> specs, Seq<Map<String, String>> newSpecs) {
        Predef$.MODULE$.require(specs.size() == newSpecs.size(), (Function0 & Serializable & scala.Serializable)() -> "number of old and new partition specs differ");
        this.requirePartitionsExist(db, table, specs);
        this.requirePartitionsNotExist(db, table, newSpecs);
        CatalogTable tableMeta = this.getTable(db, table);
        Seq<String> partitionColumnNames = tableMeta.partitionColumnNames();
        Path tablePath = new Path(tableMeta.location());
        CatalogTableType catalogTableType = this.getTable(db, table).tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
        boolean shouldUpdatePartitionLocation = !(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null);
        HashMap<Map<String, String>, CatalogTablePartition> existingParts = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions();
        ((IterableLike)specs.zip(newSpecs, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            CatalogTablePartition catalogTablePartition;
            Map newSpec;
            Map oldSpec;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                oldSpec = (Map)tuple2._1();
                newSpec = (Map)tuple2._2();
                CatalogTablePartition oldPartition = this.getPartition(db, table, (Map<String, String>)oldSpec);
                if (shouldUpdatePartitionLocation) {
                    Path oldPartPath = new Path(oldPartition.location());
                    Path newPartPath = ExternalCatalogUtils$.MODULE$.generatePartitionPath((Map<String, String>)newSpec, partitionColumnNames, tablePath);
                    try {
                        FileSystem fs = tablePath.getFileSystem($this.hadoopConfig);
                        fs.rename(oldPartPath, newPartPath);
                    }
                    catch (IOException e) {
                        throw new SparkException(new StringBuilder(32).append("Unable to rename partition path ").append(oldPartPath).toString(), (Throwable)e);
                    }
                    catalogTablePartition = oldPartition.copy((Map<String, String>)newSpec, oldPartition.storage().copy((Option<URI>)new Some((Object)newPartPath.toUri()), oldPartition.storage().copy$default$2(), oldPartition.storage().copy$default$3(), oldPartition.storage().copy$default$4(), oldPartition.storage().copy$default$5(), oldPartition.storage().copy$default$6()), oldPartition.copy$default$3(), oldPartition.copy$default$4(), oldPartition.copy$default$5(), oldPartition.copy$default$6());
                } else {
                    catalogTablePartition = oldPartition.copy((Map<String, String>)newSpec, oldPartition.copy$default$2(), oldPartition.copy$default$3(), oldPartition.copy$default$4(), oldPartition.copy$default$5(), oldPartition.copy$default$6());
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            CatalogTablePartition newPartition = catalogTablePartition;
            existingParts.remove((Object)oldSpec);
            Option option = existingParts.put((Object)newSpec, (Object)newPartition);
            return option;
        });
    }

    @Override
    public synchronized void alterPartitions(String db, String table, Seq<CatalogTablePartition> parts) {
        this.requirePartitionsExist(db, table, (Seq<Map<String, String>>)((Seq)parts.map((Function1 & Serializable & scala.Serializable)p -> p.spec(), Seq$.MODULE$.canBuildFrom())));
        parts.foreach((Function1 & Serializable & scala.Serializable)p -> ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().put(p.spec(), p));
    }

    @Override
    public synchronized CatalogTablePartition getPartition(String db, String table, Map<String, String> spec) {
        this.requirePartitionsExist(db, table, (Seq<Map<String, String>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{spec}))));
        return (CatalogTablePartition)((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().apply(spec);
    }

    @Override
    public synchronized Option<CatalogTablePartition> getPartitionOption(String db, String table, Map<String, String> spec) {
        return !this.partitionExists(db, table, spec) ? None$.MODULE$ : Option$.MODULE$.apply(((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().apply(spec));
    }

    @Override
    public synchronized Seq<String> listPartitionNames(String db, String table, Option<Map<String, String>> partialSpec) {
        Seq<String> partitionColumnNames = this.getTable(db, table).partitionColumnNames();
        return (Seq)((SeqLike)this.listPartitions(db, table, partialSpec).map((Function1 & Serializable & scala.Serializable)partition -> ((TraversableOnce)partitionColumnNames.map((Function1 & Serializable & scala.Serializable)name -> new StringBuilder(1).append(ExternalCatalogUtils$.MODULE$.escapePathName((String)name)).append("=").append(ExternalCatalogUtils$.MODULE$.escapePathName((String)partition.spec().apply(name))).toString(), Seq$.MODULE$.canBuildFrom())).mkString("/"), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$);
    }

    @Override
    public Option<Map<String, String>> listPartitionNames$default$3() {
        return None$.MODULE$;
    }

    @Override
    public synchronized Seq<CatalogTablePartition> listPartitions(String db, String table, Option<Map<String, String>> partialSpec) {
        Seq seq;
        this.requireTableExists(db, table);
        Option<Map<String, String>> option = partialSpec;
        if (None$.MODULE$.equals(option)) {
            seq = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().values().toSeq();
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Map partial = (Map)some.value();
            seq = (Seq)((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().toSeq().collect((PartialFunction)new scala.Serializable(null, partial){
                public static final long serialVersionUID = 0L;
                private final Map partial$1;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Tuple2<Map<String, String>, CatalogTablePartition>, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x3;
                    if (A1 != null) {
                        Map spec = (Map)A1._1();
                        CatalogTablePartition partition = (CatalogTablePartition)A1._2();
                        if (ExternalCatalogUtils$.MODULE$.isPartialPartitionSpec((Map<String, String>)this.partial$1, (Map<String, String>)spec)) {
                            object = partition;
                            return (B1)object;
                        }
                    }
                    object = function1.apply(x3);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Tuple2<Map<String, String>, CatalogTablePartition> x3) {
                    Map spec;
                    Tuple2<Map<String, String>, CatalogTablePartition> tuple2 = x3;
                    boolean bl = tuple2 != null && ExternalCatalogUtils$.MODULE$.isPartialPartitionSpec((Map<String, String>)this.partial$1, (Map<String, String>)(spec = (Map)tuple2._1()));
                    return bl;
                }
                {
                    this.partial$1 = partial$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
        } else {
            throw new MatchError(option);
        }
        return seq;
    }

    @Override
    public Option<Map<String, String>> listPartitions$default$3() {
        return None$.MODULE$;
    }

    @Override
    public Seq<CatalogTablePartition> listPartitionsByFilter(String db, String table, Seq<Expression> predicates, String defaultTimeZoneId) {
        CatalogTable catalogTable = this.getTable(db, table);
        Seq<CatalogTablePartition> allPartitions = this.listPartitions(db, table, this.listPartitions$default$3());
        return ExternalCatalogUtils$.MODULE$.prunePartitionsByFilter(catalogTable, allPartitions, predicates, defaultTimeZoneId);
    }

    @Override
    public void createFunction(String db, CatalogFunction func) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireDbExists(db);
            this.requireFunctionNotExists(db, func.identifier().funcName());
            ((DatabaseDesc)this.catalog().apply((Object)db)).functions().put((Object)func.identifier().funcName(), (Object)func);
        }
    }

    @Override
    public void dropFunction(String db, String funcName) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireFunctionExists(db, funcName);
            ((DatabaseDesc)this.catalog().apply((Object)db)).functions().remove((Object)funcName);
        }
    }

    @Override
    public void alterFunction(String db, CatalogFunction func) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireDbExists(db);
            this.requireFunctionExists(db, func.identifier().funcName());
            ((DatabaseDesc)this.catalog().apply((Object)db)).functions().put((Object)func.identifier().funcName(), (Object)func);
        }
    }

    @Override
    public void renameFunction(String db, String oldName, String newName) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireFunctionExists(db, oldName);
            this.requireFunctionNotExists(db, newName);
            CatalogFunction qual$3 = this.getFunction(db, oldName);
            FunctionIdentifier x$111 = new FunctionIdentifier(newName, (Option<String>)new Some((Object)db));
            String x$112 = qual$3.copy$default$2();
            Seq<FunctionResource> x$113 = qual$3.copy$default$3();
            CatalogFunction newFunc = qual$3.copy(x$111, x$112, x$113);
            ((DatabaseDesc)this.catalog().apply((Object)db)).functions().remove((Object)oldName);
            ((DatabaseDesc)this.catalog().apply((Object)db)).functions().put((Object)newName, (Object)newFunc);
        }
    }

    @Override
    public synchronized CatalogFunction getFunction(String db, String funcName) {
        this.requireFunctionExists(db, funcName);
        return (CatalogFunction)((DatabaseDesc)this.catalog().apply((Object)db)).functions().apply((Object)funcName);
    }

    @Override
    public synchronized boolean functionExists(String db, String funcName) {
        this.requireDbExists(db);
        return ((DatabaseDesc)this.catalog().apply((Object)db)).functions().contains((Object)funcName);
    }

    @Override
    public synchronized Seq<String> listFunctions(String db, String pattern) {
        this.requireDbExists(db);
        return StringUtils$.MODULE$.filterPattern((Seq<String>)((DatabaseDesc)this.catalog().apply((Object)db)).functions().keysIterator().toSeq(), pattern);
    }

    public static final /* synthetic */ void $anonfun$requirePartitionsExist$1(InMemoryCatalog $this, String db$1, String table$1, Map s) {
        if (!$this.partitionExists(db$1, table$1, (Map<String, String>)s)) {
            throw new NoSuchPartitionException(db$1, table$1, (Map<String, String>)s);
        }
    }

    public static final /* synthetic */ void $anonfun$requirePartitionsNotExist$1(InMemoryCatalog $this, String db$2, String table$2, Map s) {
        if ($this.partitionExists(db$2, table$2, (Map<String, String>)s)) {
            throw new PartitionAlreadyExistsException(db$2, table$2, (Map<String, String>)s);
        }
    }

    private final boolean liftedTree1$1(CatalogDatabase dbDefinition$1) {
        boolean bl;
        try {
            Path location = new Path(dbDefinition$1.locationUri());
            FileSystem fs = location.getFileSystem(this.hadoopConfig);
            bl = fs.mkdirs(location);
        }
        catch (IOException e) {
            throw new SparkException(new StringBuilder(37).append("Unable to create database ").append(dbDefinition$1.name()).append(" as failed ").append(new StringBuilder(24).append("to create its directory ").append(dbDefinition$1.locationUri()).toString()).toString(), (Throwable)e);
        }
        return bl;
    }

    private final boolean liftedTree2$1(CatalogDatabase dbDefinition$2) {
        boolean bl;
        try {
            Path location = new Path(dbDefinition$2.locationUri());
            FileSystem fs = location.getFileSystem(this.hadoopConfig);
            bl = fs.delete(location, true);
        }
        catch (IOException e) {
            throw new SparkException(new StringBuilder(35).append("Unable to drop database ").append(dbDefinition$2.name()).append(" as failed ").append(new StringBuilder(24).append("to delete its directory ").append(dbDefinition$2.locationUri()).toString()).toString(), (Throwable)e);
        }
        return bl;
    }

    private final boolean liftedTree3$1(String table$3, Path defaultTableLocation$1) {
        boolean bl;
        try {
            FileSystem fs = defaultTableLocation$1.getFileSystem(this.hadoopConfig);
            bl = fs.mkdirs(defaultTableLocation$1);
        }
        catch (IOException e) {
            throw new SparkException(new StringBuilder(34).append("Unable to create table ").append(table$3).append(" as failed ").append(new StringBuilder(24).append("to create its directory ").append(defaultTableLocation$1).toString()).toString(), (Throwable)e);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$createTable$1(Tuple2 x$1) {
        Object object = x$1._1();
        String string = "comment";
        return object == null ? string != null : !object.equals(string);
    }

    public static final /* synthetic */ boolean $anonfun$dropTable$2(InMemoryCatalog $this, URI loc) {
        boolean bl;
        Path partitionPath = new Path(loc);
        try {
            FileSystem fs = partitionPath.getFileSystem($this.hadoopConfig);
            bl = fs.delete(partitionPath, true);
        }
        catch (IOException e) {
            throw new SparkException(new StringBuilder(32).append("Unable to delete partition path ").append(partitionPath).toString(), (Throwable)e);
        }
        return bl;
    }

    private final boolean liftedTree4$1(String table$4, Path dir$1) {
        boolean bl;
        try {
            FileSystem fs = dir$1.getFileSystem(this.hadoopConfig);
            bl = fs.delete(dir$1, true);
        }
        catch (IOException e) {
            throw new SparkException(new StringBuilder(32).append("Unable to drop table ").append(table$4).append(" as failed ").append(new StringBuilder(24).append("to delete its directory ").append(dir$1).toString()).toString(), (Throwable)e);
        }
        return bl;
    }

    private final boolean liftedTree5$1(String oldName$1, String newName$1, Path oldDir$1, Path newDir$1) {
        boolean bl;
        try {
            FileSystem fs = oldDir$1.getFileSystem(this.hadoopConfig);
            bl = fs.rename(oldDir$1, newDir$1);
        }
        catch (IOException e) {
            throw new SparkException(new StringBuilder(38).append("Unable to rename table ").append(oldName$1).append(" to ").append(newName$1).append(" as failed ").append(new StringBuilder(24).append("to rename its directory ").append(oldDir$1).toString()).toString(), (Throwable)e);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$alterTable$1(Tuple2 kv) {
        Object object = kv._1();
        String string = "comment";
        return object == null ? string != null : !object.equals(string);
    }

    public InMemoryCatalog(SparkConf conf, Configuration hadoopConfig) {
        this.hadoopConfig = hadoopConfig;
        ExternalCatalog.$init$(this);
        this.catalog = new HashMap();
    }

    public class DatabaseDesc {
        private CatalogDatabase db;
        private final HashMap<String, TableDesc> tables;
        private final HashMap<String, CatalogFunction> functions;
        public final /* synthetic */ InMemoryCatalog $outer;

        public CatalogDatabase db() {
            return this.db;
        }

        public void db_$eq(CatalogDatabase x$1) {
            this.db = x$1;
        }

        public HashMap<String, TableDesc> tables() {
            return this.tables;
        }

        public HashMap<String, CatalogFunction> functions() {
            return this.functions;
        }

        public /* synthetic */ InMemoryCatalog org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$DatabaseDesc$$$outer() {
            return this.$outer;
        }

        public DatabaseDesc(InMemoryCatalog $outer, CatalogDatabase db) {
            this.db = db;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.tables = new HashMap();
            this.functions = new HashMap();
        }
    }

    public class TableDesc {
        private CatalogTable table;
        private final HashMap<Map<String, String>, CatalogTablePartition> partitions;
        public final /* synthetic */ InMemoryCatalog $outer;

        public CatalogTable table() {
            return this.table;
        }

        public void table_$eq(CatalogTable x$1) {
            this.table = x$1;
        }

        public HashMap<Map<String, String>, CatalogTablePartition> partitions() {
            return this.partitions;
        }

        public /* synthetic */ InMemoryCatalog org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$TableDesc$$$outer() {
            return this.$outer;
        }

        public TableDesc(InMemoryCatalog $outer, CatalogTable table) {
            this.table = table;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.partitions = new HashMap();
        }
    }
}

