/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.analysis.TempTableAlreadyExistsException;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.StringUtils$;
import scala.Option;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00055a\u0001B\u0001\u0003\u0001=\u0011Qc\u00127pE\u0006dG+Z7q-&,w/T1oC\u001e,'O\u0003\u0002\u0004\t\u000591-\u0019;bY><'BA\u0003\u0007\u0003!\u0019\u0017\r^1msN$(BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011C\u0001\u0001\u0011!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fM\"Aq\u0003\u0001BC\u0002\u0013\u0005\u0001$\u0001\u0005eCR\f'-Y:f+\u0005I\u0002C\u0001\u000e\"\u001d\tYr\u0004\u0005\u0002\u001d%5\tQD\u0003\u0002\u001f\u001d\u00051AH]8pizJ!\u0001\t\n\u0002\rA\u0013X\rZ3g\u0013\t\u00113E\u0001\u0004TiJLgn\u001a\u0006\u0003AIA\u0001\"\n\u0001\u0003\u0002\u0003\u0006I!G\u0001\nI\u0006$\u0018MY1tK\u0002BQa\n\u0001\u0005\u0002!\na\u0001P5oSRtDCA\u0015,!\tQ\u0003!D\u0001\u0003\u0011\u00159b\u00051\u0001\u001a\u0011\u001di\u0003A1A\u0005\n9\nqB^5fo\u0012+g-\u001b8ji&|gn]\u000b\u0002_A!\u0001'N\r8\u001b\u0005\t$B\u0001\u001a4\u0003\u001diW\u000f^1cY\u0016T!\u0001\u000e\n\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u00027c\t9\u0001*Y:i\u001b\u0006\u0004\bC\u0001\u001d>\u001b\u0005I$B\u0001\u001e<\u0003\u001dawnZ5dC2T!\u0001\u0010\u0003\u0002\u000bAd\u0017M\\:\n\u0005yJ$a\u0003'pO&\u001c\u0017\r\u001c)mC:Da\u0001\u0011\u0001!\u0002\u0013y\u0013\u0001\u0005<jK^$UMZ5oSRLwN\\:!Q\u0011y$\tT'\u0011\u0005\rSU\"\u0001#\u000b\u0005\u00153\u0015AC2p]\u000e,(O]3oi*\u0011q\tS\u0001\u000bC:tw\u000e^1uS>t'\"A%\u0002\u000b)\fg/\u0019=\n\u0005-#%!C$vCJ$W\r\u001a\"z\u0003\u00151\u0018\r\\;fC\u0005q\u0015\u0001\u0002;iSNDQ\u0001\u0015\u0001\u0005\u0002E\u000b1aZ3u)\t\u0011V\u000bE\u0002\u0012'^J!\u0001\u0016\n\u0003\r=\u0003H/[8o\u0011\u00151v\n1\u0001\u001a\u0003\u0011q\u0017-\\3\t\u000ba\u0003A\u0011A-\u0002\r\r\u0014X-\u0019;f)\u0011QVL\u00181\u0011\u0005EY\u0016B\u0001/\u0013\u0005\u0011)f.\u001b;\t\u000bY;\u0006\u0019A\r\t\u000b};\u0006\u0019A\u001c\u0002\u001dYLWm\u001e#fM&t\u0017\u000e^5p]\")\u0011m\u0016a\u0001E\u0006\u0001rN^3se&$W-\u00134Fq&\u001cHo\u001d\t\u0003#\rL!\u0001\u001a\n\u0003\u000f\t{w\u000e\\3b]\")a\r\u0001C\u0001O\u00061Q\u000f\u001d3bi\u0016$2A\u00195j\u0011\u00151V\r1\u0001\u001a\u0011\u0015yV\r1\u00018\u0011\u0015Y\u0007\u0001\"\u0001m\u0003\u0019\u0011X-\\8wKR\u0011!-\u001c\u0005\u0006-*\u0004\r!\u0007\u0005\u0006_\u0002!\t\u0001]\u0001\u0007e\u0016t\u0017-\\3\u0015\u0007\t\f8\u000fC\u0003s]\u0002\u0007\u0011$A\u0004pY\u0012t\u0015-\\3\t\u000bQt\u0007\u0019A\r\u0002\u000f9,wOT1nK\")a\u000f\u0001C\u0001o\u0006iA.[:u-&,wOT1nKN$2\u0001_A\u0002!\rIh0\u0007\b\u0003urt!\u0001H>\n\u0003MI!! \n\u0002\u000fA\f7m[1hK&\u0019q0!\u0001\u0003\u0007M+\u0017O\u0003\u0002~%!1\u0011QA;A\u0002e\tq\u0001]1ui\u0016\u0014h\u000eC\u0004\u0002\n\u0001!\t!a\u0003\u0002\u000b\rdW-\u0019:\u0015\u0003i\u0003")
public class GlobalTempViewManager {
    private final String database;
    @GuardedBy(value="this")
    private final HashMap<String, LogicalPlan> viewDefinitions;

    public String database() {
        return this.database;
    }

    private HashMap<String, LogicalPlan> viewDefinitions() {
        return this.viewDefinitions;
    }

    public synchronized Option<LogicalPlan> get(String name) {
        return this.viewDefinitions().get((Object)name);
    }

    public void create(String name, LogicalPlan viewDefinition, boolean overrideIfExists) {
        GlobalTempViewManager globalTempViewManager = this;
        synchronized (globalTempViewManager) {
            if (!overrideIfExists && this.viewDefinitions().contains((Object)name)) {
                throw new TempTableAlreadyExistsException(name);
            }
            this.viewDefinitions().put((Object)name, (Object)viewDefinition);
        }
    }

    public synchronized boolean update(String name, LogicalPlan viewDefinition) {
        boolean bl;
        if (this.viewDefinitions().contains((Object)name)) {
            this.viewDefinitions().put((Object)name, (Object)viewDefinition);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public synchronized boolean remove(String name) {
        return this.viewDefinitions().remove((Object)name).isDefined();
    }

    public synchronized boolean rename(String oldName, String newName) {
        boolean bl;
        if (this.viewDefinitions().contains((Object)oldName)) {
            if (this.viewDefinitions().contains((Object)newName)) {
                throw new AnalysisException(new StringBuilder(68).append("rename temporary view from '").append(oldName).append("' to '").append(newName).append("': destination view already exists").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            LogicalPlan viewDefinition = (LogicalPlan)this.viewDefinitions().apply((Object)oldName);
            this.viewDefinitions().remove((Object)oldName);
            this.viewDefinitions().put((Object)newName, (Object)viewDefinition);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public synchronized Seq<String> listViewNames(String pattern) {
        return StringUtils$.MODULE$.filterPattern((Seq<String>)this.viewDefinitions().keys().toSeq(), pattern);
    }

    public synchronized void clear() {
        this.viewDefinitions().clear();
    }

    public GlobalTempViewManager(String database) {
        this.database = database;
        this.viewDefinitions = new HashMap();
    }
}

