/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.maven.surefire.junitcore.TestMethod;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.SimpleReportEntry;
import org.junit.runner.Description;

public class TestSet {
    private static final InheritableThreadLocal<TestSet> TEST_SET = new InheritableThreadLocal();
    private final Description testSetDescription;
    private final Collection<TestMethod> testMethods = new ConcurrentLinkedQueue<TestMethod>();
    private final AtomicBoolean played = new AtomicBoolean();
    private volatile boolean allScheduled;
    private volatile int numberOfCompletedChildren;
    private volatile int numberOfTests;

    public TestSet(Description testSetDescription) {
        this.testSetDescription = testSetDescription;
    }

    public void replay(RunListener target) {
        if (this.played.compareAndSet(false, true)) {
            try {
                ReportEntry report = this.createReportEntry(null);
                target.testSetStarting(report);
                long startTile = 0L;
                long endTime = 0L;
                for (TestMethod testMethod : this.testMethods) {
                    if (startTile == 0L || testMethod.getStartTime() < startTile) {
                        startTile = testMethod.getStartTime();
                    }
                    if (endTime == 0L || testMethod.getEndTime() > endTime) {
                        endTime = testMethod.getEndTime();
                    }
                    testMethod.replay(target);
                }
                int elapsed = (int)(endTime - startTile);
                report = this.createReportEntry(elapsed);
                target.testSetCompleted(report);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public TestMethod createThreadAttachedTestMethod(ReportEntry description) {
        TestMethod testMethod = new TestMethod(description, this);
        this.addTestMethod(testMethod);
        testMethod.attachToThread();
        return testMethod;
    }

    private ReportEntry createReportEntry(Integer elapsed) {
        ArrayList children;
        boolean isJunit3;
        String className = this.testSetDescription.getClassName();
        boolean bl = isJunit3 = className == null;
        String classNameToUse = isJunit3 ? ((children = this.testSetDescription.getChildren()).isEmpty() ? this.testSetDescription.toString() : ((Description)children.get(0)).getClassName()) : className;
        return new SimpleReportEntry(classNameToUse, classNameToUse, elapsed);
    }

    public void incrementTestMethodCount() {
        ++this.numberOfTests;
    }

    private void addTestMethod(TestMethod testMethod) {
        this.testMethods.add(testMethod);
    }

    public void incrementFinishedTests(RunListener reporterManager, boolean reportImmediately) {
        ++this.numberOfCompletedChildren;
        if (this.allScheduled && this.isAllTestsDone() && reportImmediately) {
            this.replay(reporterManager);
        }
    }

    public void setAllScheduled(RunListener reporterManager) {
        this.allScheduled = true;
        if (this.isAllTestsDone()) {
            this.replay(reporterManager);
        }
    }

    private boolean isAllTestsDone() {
        return this.numberOfTests == this.numberOfCompletedChildren;
    }

    public void attachToThread() {
        TEST_SET.set(this);
    }

    public static TestSet getThreadTestSet() {
        return (TestSet)TEST_SET.get();
    }
}

