/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.api.sharedpreferences;

import android.content.SharedPreferences;
import org.androidannotations.api.sharedpreferences.SharedPreferencesCompat;

public abstract class AbstractPrefField<T> {
    protected final T defaultValue;
    protected final SharedPreferences sharedPreferences;
    protected final String key;

    public AbstractPrefField(SharedPreferences sharedPreferences, String key, T defaultValue) {
        this.sharedPreferences = sharedPreferences;
        this.key = key;
        this.defaultValue = defaultValue;
    }

    public final boolean exists() {
        return this.sharedPreferences.contains(this.key);
    }

    public String key() {
        return this.key;
    }

    public final T get() {
        return this.getOr(this.defaultValue);
    }

    public abstract T getOr(T var1);

    public final void put(T value) {
        this.putInternal(value == null ? this.defaultValue : value);
    }

    protected abstract void putInternal(T var1);

    public final void remove() {
        this.apply(this.edit().remove(this.key));
    }

    protected SharedPreferences.Editor edit() {
        return this.sharedPreferences.edit();
    }

    protected final void apply(SharedPreferences.Editor editor) {
        SharedPreferencesCompat.apply(editor);
    }
}

