/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.activiti.bpmn.constants.BpmnXMLConstants;
import org.activiti.bpmn.converter.child.BaseChildElementParser;
import org.activiti.bpmn.converter.export.ActivitiListenerExport;
import org.activiti.bpmn.converter.export.FailedJobRetryCountExport;
import org.activiti.bpmn.converter.export.MultiInstanceExport;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.Artifact;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CancelEventDefinition;
import org.activiti.bpmn.model.CompensateEventDefinition;
import org.activiti.bpmn.model.DataObject;
import org.activiti.bpmn.model.ErrorEventDefinition;
import org.activiti.bpmn.model.Event;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.FormProperty;
import org.activiti.bpmn.model.FormValue;
import org.activiti.bpmn.model.Gateway;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.TerminateEventDefinition;
import org.activiti.bpmn.model.ThrowEvent;
import org.activiti.bpmn.model.TimerEventDefinition;
import org.activiti.bpmn.model.UserTask;
import org.activiti.bpmn.model.ValuedDataObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseBpmnXMLConverter
implements BpmnXMLConstants {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BaseBpmnXMLConverter.class);
    protected static final List<ExtensionAttribute> defaultElementAttributes = Arrays.asList(new ExtensionAttribute("id"), new ExtensionAttribute("name"));
    protected static final List<ExtensionAttribute> defaultActivityAttributes = Arrays.asList(new ExtensionAttribute("http://activiti.org/bpmn", "async"), new ExtensionAttribute("http://activiti.org/bpmn", "exclusive"), new ExtensionAttribute("default"), new ExtensionAttribute("http://activiti.org/bpmn", "isForCompensation"));

    public void convertToBpmnModel(XMLStreamReader xtr, BpmnModel model, Process activeProcess, List<SubProcess> activeSubProcessList) throws Exception {
        String elementId = xtr.getAttributeValue(null, "id");
        String elementName = xtr.getAttributeValue(null, "name");
        boolean async = this.parseAsync(xtr);
        boolean notExclusive = this.parseNotExclusive(xtr);
        String defaultFlow = xtr.getAttributeValue(null, "default");
        boolean isForCompensation = this.parseForCompensation(xtr);
        BaseElement parsedElement = this.convertXMLToElement(xtr, model);
        if (parsedElement instanceof Artifact) {
            Artifact currentArtifact = (Artifact)parsedElement;
            currentArtifact.setId(elementId);
            if (!activeSubProcessList.isEmpty()) {
                activeSubProcessList.get(activeSubProcessList.size() - 1).addArtifact(currentArtifact);
            } else {
                activeProcess.addArtifact(currentArtifact);
            }
        }
        if (parsedElement instanceof FlowElement) {
            SubProcess subProcess;
            FlowElement currentFlowElement = (FlowElement)parsedElement;
            currentFlowElement.setId(elementId);
            currentFlowElement.setName(elementName);
            if (currentFlowElement instanceof FlowNode) {
                FlowNode flowNode = (FlowNode)currentFlowElement;
                flowNode.setAsynchronous(async);
                flowNode.setNotExclusive(notExclusive);
                if (currentFlowElement instanceof Activity) {
                    Activity activity = (Activity)currentFlowElement;
                    activity.setForCompensation(isForCompensation);
                    if (StringUtils.isNotEmpty((CharSequence)defaultFlow)) {
                        activity.setDefaultFlow(defaultFlow);
                    }
                }
                if (currentFlowElement instanceof Gateway) {
                    Gateway gateway = (Gateway)currentFlowElement;
                    if (StringUtils.isNotEmpty((CharSequence)defaultFlow)) {
                        gateway.setDefaultFlow(defaultFlow);
                    }
                }
            }
            if (currentFlowElement instanceof DataObject) {
                if (!activeSubProcessList.isEmpty()) {
                    subProcess = activeSubProcessList.get(activeSubProcessList.size() - 1);
                    subProcess.getDataObjects().add((ValuedDataObject)parsedElement);
                } else {
                    activeProcess.getDataObjects().add((ValuedDataObject)parsedElement);
                }
            }
            if (!activeSubProcessList.isEmpty()) {
                subProcess = activeSubProcessList.get(activeSubProcessList.size() - 1);
                subProcess.addFlowElement(currentFlowElement);
            } else {
                activeProcess.addFlowElement(currentFlowElement);
            }
        }
    }

    public void convertToXML(XMLStreamWriter xtw, BaseElement baseElement, BpmnModel model) throws Exception {
        Activity activity;
        FlowElement flowElement;
        xtw.writeStartElement(this.getXMLElementName());
        boolean didWriteExtensionStartElement = false;
        this.writeDefaultAttribute("id", baseElement.getId(), xtw);
        if (baseElement instanceof FlowElement) {
            this.writeDefaultAttribute("name", ((FlowElement)baseElement).getName(), xtw);
        }
        if (baseElement instanceof FlowNode) {
            Gateway gateway;
            FlowElement defaultFlowElement;
            FlowNode flowNode = (FlowNode)baseElement;
            if (flowNode.isAsynchronous()) {
                this.writeQualifiedAttribute("async", "true", xtw);
                if (flowNode.isNotExclusive()) {
                    this.writeQualifiedAttribute("exclusive", "false", xtw);
                }
            }
            if (baseElement instanceof Activity) {
                Activity activity2 = (Activity)baseElement;
                if (activity2.isForCompensation()) {
                    this.writeDefaultAttribute("isForCompensation", "true", xtw);
                }
                if (StringUtils.isNotEmpty((CharSequence)activity2.getDefaultFlow()) && (defaultFlowElement = model.getFlowElement(activity2.getDefaultFlow())) instanceof SequenceFlow) {
                    this.writeDefaultAttribute("default", activity2.getDefaultFlow(), xtw);
                }
            }
            if (baseElement instanceof Gateway && StringUtils.isNotEmpty((CharSequence)(gateway = (Gateway)baseElement).getDefaultFlow()) && (defaultFlowElement = model.getFlowElement(gateway.getDefaultFlow())) instanceof SequenceFlow) {
                this.writeDefaultAttribute("default", gateway.getDefaultFlow(), xtw);
            }
        }
        this.writeAdditionalAttributes(baseElement, model, xtw);
        if (baseElement instanceof FlowElement && StringUtils.isNotEmpty((CharSequence)(flowElement = (FlowElement)baseElement).getDocumentation())) {
            xtw.writeStartElement("documentation");
            xtw.writeCharacters(flowElement.getDocumentation());
            xtw.writeEndElement();
        }
        didWriteExtensionStartElement = this.writeExtensionChildElements(baseElement, didWriteExtensionStartElement, xtw);
        didWriteExtensionStartElement = this.writeListeners(baseElement, didWriteExtensionStartElement, xtw);
        didWriteExtensionStartElement = BpmnXMLUtil.writeExtensionElements(baseElement, didWriteExtensionStartElement, model.getNamespaces(), xtw);
        if (baseElement instanceof Activity) {
            activity = (Activity)baseElement;
            FailedJobRetryCountExport.writeFailedJobRetryCount(activity, xtw);
        }
        if (didWriteExtensionStartElement) {
            xtw.writeEndElement();
        }
        if (baseElement instanceof Activity) {
            activity = (Activity)baseElement;
            MultiInstanceExport.writeMultiInstance(activity, xtw);
        }
        this.writeAdditionalChildElements(baseElement, model, xtw);
        xtw.writeEndElement();
    }

    protected abstract Class<? extends BaseElement> getBpmnElementType();

    protected abstract BaseElement convertXMLToElement(XMLStreamReader var1, BpmnModel var2) throws Exception;

    protected abstract String getXMLElementName();

    protected abstract void writeAdditionalAttributes(BaseElement var1, BpmnModel var2, XMLStreamWriter var3) throws Exception;

    protected boolean writeExtensionChildElements(BaseElement element, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        return didWriteExtensionStartElement;
    }

    protected abstract void writeAdditionalChildElements(BaseElement var1, BpmnModel var2, XMLStreamWriter var3) throws Exception;

    protected void parseChildElements(String elementName, BaseElement parentElement, BpmnModel model, XMLStreamReader xtr) throws Exception {
        this.parseChildElements(elementName, parentElement, null, model, xtr);
    }

    protected void parseChildElements(String elementName, BaseElement parentElement, Map<String, BaseChildElementParser> additionalParsers, BpmnModel model, XMLStreamReader xtr) throws Exception {
        HashMap<String, BaseChildElementParser> childParsers = new HashMap<String, BaseChildElementParser>();
        if (additionalParsers != null) {
            childParsers.putAll(additionalParsers);
        }
        BpmnXMLUtil.parseChildElements(elementName, parentElement, xtr, childParsers, model);
    }

    protected ExtensionElement parseExtensionElement(XMLStreamReader xtr) throws Exception {
        ExtensionElement extensionElement = new ExtensionElement();
        extensionElement.setName(xtr.getLocalName());
        if (StringUtils.isNotEmpty((CharSequence)xtr.getNamespaceURI())) {
            extensionElement.setNamespace(xtr.getNamespaceURI());
        }
        if (StringUtils.isNotEmpty((CharSequence)xtr.getPrefix())) {
            extensionElement.setNamespacePrefix(xtr.getPrefix());
        }
        BpmnXMLUtil.addCustomAttributes(xtr, (BaseElement)extensionElement, defaultElementAttributes);
        boolean readyWithExtensionElement = false;
        while (!readyWithExtensionElement && xtr.hasNext()) {
            xtr.next();
            if (xtr.isCharacters() || 12 == xtr.getEventType()) {
                if (!StringUtils.isNotEmpty((CharSequence)xtr.getText().trim())) continue;
                extensionElement.setElementText(xtr.getText().trim());
                continue;
            }
            if (xtr.isStartElement()) {
                ExtensionElement childExtensionElement = this.parseExtensionElement(xtr);
                extensionElement.addChildElement(childExtensionElement);
                continue;
            }
            if (!xtr.isEndElement() || !extensionElement.getName().equalsIgnoreCase(xtr.getLocalName())) continue;
            readyWithExtensionElement = true;
        }
        return extensionElement;
    }

    protected boolean parseAsync(XMLStreamReader xtr) {
        boolean async = false;
        String asyncString = xtr.getAttributeValue("http://activiti.org/bpmn", "async");
        if ("true".equalsIgnoreCase(asyncString)) {
            async = true;
        }
        return async;
    }

    protected boolean parseNotExclusive(XMLStreamReader xtr) {
        boolean notExclusive = false;
        String exclusiveString = xtr.getAttributeValue("http://activiti.org/bpmn", "exclusive");
        if ("false".equalsIgnoreCase(exclusiveString)) {
            notExclusive = true;
        }
        return notExclusive;
    }

    protected boolean parseForCompensation(XMLStreamReader xtr) {
        boolean isForCompensation = false;
        String compensationString = xtr.getAttributeValue(null, "isForCompensation");
        if ("true".equalsIgnoreCase(compensationString)) {
            isForCompensation = true;
        }
        return isForCompensation;
    }

    protected List<String> parseDelimitedList(String expression) {
        return BpmnXMLUtil.parseDelimitedList(expression);
    }

    protected String convertToDelimitedString(List<String> stringList) {
        return BpmnXMLUtil.convertToDelimitedString(stringList);
    }

    protected boolean writeFormProperties(FlowElement flowElement, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        List propertyList = null;
        if (flowElement instanceof UserTask) {
            propertyList = ((UserTask)flowElement).getFormProperties();
        } else if (flowElement instanceof StartEvent) {
            propertyList = ((StartEvent)flowElement).getFormProperties();
        }
        if (propertyList != null) {
            for (FormProperty property : propertyList) {
                if (!StringUtils.isNotEmpty((CharSequence)property.getId())) continue;
                if (!didWriteExtensionStartElement) {
                    xtw.writeStartElement("extensionElements");
                    didWriteExtensionStartElement = true;
                }
                xtw.writeStartElement("activiti", "formProperty", "http://activiti.org/bpmn");
                this.writeDefaultAttribute("id", property.getId(), xtw);
                this.writeDefaultAttribute("name", property.getName(), xtw);
                this.writeDefaultAttribute("type", property.getType(), xtw);
                this.writeDefaultAttribute("expression", property.getExpression(), xtw);
                this.writeDefaultAttribute("variable", property.getVariable(), xtw);
                this.writeDefaultAttribute("default", property.getDefaultExpression(), xtw);
                this.writeDefaultAttribute("datePattern", property.getDatePattern(), xtw);
                if (!property.isReadable()) {
                    this.writeDefaultAttribute("readable", "false", xtw);
                }
                if (!property.isWriteable()) {
                    this.writeDefaultAttribute("writable", "false", xtw);
                }
                if (property.isRequired()) {
                    this.writeDefaultAttribute("required", "true", xtw);
                }
                for (FormValue formValue : property.getFormValues()) {
                    if (!StringUtils.isNotEmpty((CharSequence)formValue.getId())) continue;
                    xtw.writeStartElement("activiti", "value", "http://activiti.org/bpmn");
                    xtw.writeAttribute("id", formValue.getId());
                    xtw.writeAttribute("name", formValue.getName());
                    xtw.writeEndElement();
                }
                xtw.writeEndElement();
            }
        }
        return didWriteExtensionStartElement;
    }

    protected boolean writeListeners(BaseElement element, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        return ActivitiListenerExport.writeListeners(element, didWriteExtensionStartElement, xtw);
    }

    protected void writeEventDefinitions(Event parentEvent, List<EventDefinition> eventDefinitions, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        for (EventDefinition eventDefinition : eventDefinitions) {
            if (eventDefinition instanceof TimerEventDefinition) {
                this.writeTimerDefinition(parentEvent, (TimerEventDefinition)eventDefinition, xtw);
                continue;
            }
            if (eventDefinition instanceof SignalEventDefinition) {
                this.writeSignalDefinition(parentEvent, (SignalEventDefinition)eventDefinition, xtw);
                continue;
            }
            if (eventDefinition instanceof MessageEventDefinition) {
                this.writeMessageDefinition(parentEvent, (MessageEventDefinition)eventDefinition, model, xtw);
                continue;
            }
            if (eventDefinition instanceof ErrorEventDefinition) {
                this.writeErrorDefinition(parentEvent, (ErrorEventDefinition)eventDefinition, xtw);
                continue;
            }
            if (eventDefinition instanceof TerminateEventDefinition) {
                this.writeTerminateDefinition(parentEvent, (TerminateEventDefinition)eventDefinition, xtw);
                continue;
            }
            if (eventDefinition instanceof CancelEventDefinition) {
                this.writeCancelDefinition(parentEvent, (CancelEventDefinition)eventDefinition, xtw);
                continue;
            }
            if (!(eventDefinition instanceof CompensateEventDefinition)) continue;
            this.writeCompensateDefinition(parentEvent, (CompensateEventDefinition)eventDefinition, xtw);
        }
    }

    protected void writeTimerDefinition(Event parentEvent, TimerEventDefinition timerDefinition, XMLStreamWriter xtw) throws Exception {
        boolean didWriteExtensionStartElement;
        xtw.writeStartElement("timerEventDefinition");
        if (StringUtils.isNotEmpty((CharSequence)timerDefinition.getCalendarName())) {
            this.writeQualifiedAttribute("businessCalendarName", timerDefinition.getCalendarName(), xtw);
        }
        if (didWriteExtensionStartElement = BpmnXMLUtil.writeExtensionElements((BaseElement)timerDefinition, false, xtw)) {
            xtw.writeEndElement();
        }
        if (StringUtils.isNotEmpty((CharSequence)timerDefinition.getTimeDate())) {
            xtw.writeStartElement("timeDate");
            xtw.writeCharacters(timerDefinition.getTimeDate());
            xtw.writeEndElement();
        } else if (StringUtils.isNotEmpty((CharSequence)timerDefinition.getTimeCycle())) {
            xtw.writeStartElement("timeCycle");
            if (StringUtils.isNotEmpty((CharSequence)timerDefinition.getEndDate())) {
                xtw.writeAttribute("activiti", "http://activiti.org/bpmn", "endDate", timerDefinition.getEndDate());
            }
            xtw.writeCharacters(timerDefinition.getTimeCycle());
            xtw.writeEndElement();
        } else if (StringUtils.isNotEmpty((CharSequence)timerDefinition.getTimeDuration())) {
            xtw.writeStartElement("timeDuration");
            xtw.writeCharacters(timerDefinition.getTimeDuration());
            xtw.writeEndElement();
        }
        xtw.writeEndElement();
    }

    protected void writeSignalDefinition(Event parentEvent, SignalEventDefinition signalDefinition, XMLStreamWriter xtw) throws Exception {
        boolean didWriteExtensionStartElement;
        xtw.writeStartElement("signalEventDefinition");
        this.writeDefaultAttribute("signalRef", signalDefinition.getSignalRef(), xtw);
        if (parentEvent instanceof ThrowEvent && signalDefinition.isAsync()) {
            BpmnXMLUtil.writeQualifiedAttribute("async", "true", xtw);
        }
        if (didWriteExtensionStartElement = BpmnXMLUtil.writeExtensionElements((BaseElement)signalDefinition, false, xtw)) {
            xtw.writeEndElement();
        }
        xtw.writeEndElement();
    }

    protected void writeCancelDefinition(Event parentEvent, CancelEventDefinition cancelEventDefinition, XMLStreamWriter xtw) throws Exception {
        xtw.writeStartElement("cancelEventDefinition");
        boolean didWriteExtensionStartElement = BpmnXMLUtil.writeExtensionElements((BaseElement)cancelEventDefinition, false, xtw);
        if (didWriteExtensionStartElement) {
            xtw.writeEndElement();
        }
        xtw.writeEndElement();
    }

    protected void writeCompensateDefinition(Event parentEvent, CompensateEventDefinition compensateEventDefinition, XMLStreamWriter xtw) throws Exception {
        xtw.writeStartElement("compensateEventDefinition");
        this.writeDefaultAttribute("activityRef", compensateEventDefinition.getActivityRef(), xtw);
        boolean didWriteExtensionStartElement = BpmnXMLUtil.writeExtensionElements((BaseElement)compensateEventDefinition, false, xtw);
        if (didWriteExtensionStartElement) {
            xtw.writeEndElement();
        }
        xtw.writeEndElement();
    }

    protected void writeMessageDefinition(Event parentEvent, MessageEventDefinition messageDefinition, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        boolean didWriteExtensionStartElement;
        xtw.writeStartElement("messageEventDefinition");
        String messageRef = messageDefinition.getMessageRef();
        if (StringUtils.isNotEmpty((CharSequence)messageRef)) {
            if (messageRef.startsWith(model.getTargetNamespace())) {
                messageRef = messageRef.replace(model.getTargetNamespace(), "");
                messageRef = messageRef.replaceFirst(":", "");
            } else {
                for (String prefix : model.getNamespaces().keySet()) {
                    String namespace = model.getNamespace(prefix);
                    if (!messageRef.startsWith(namespace)) continue;
                    messageRef = messageRef.replace(model.getTargetNamespace(), "");
                    messageRef = prefix + messageRef;
                }
            }
        }
        this.writeDefaultAttribute("messageRef", messageRef, xtw);
        if (StringUtils.isNotEmpty((CharSequence)messageDefinition.getCorrelationKey())) {
            xtw.writeAttribute("activiti", "http://activiti.org/bpmn", "correlationKey", messageDefinition.getCorrelationKey());
        }
        if (StringUtils.isNotEmpty((CharSequence)messageDefinition.getMessageExpression())) {
            xtw.writeAttribute("activiti", "http://activiti.org/bpmn", "messageExpression", messageDefinition.getMessageExpression());
        }
        if (didWriteExtensionStartElement = BpmnXMLUtil.writeExtensionElements((BaseElement)messageDefinition, false, xtw)) {
            xtw.writeEndElement();
        }
        xtw.writeEndElement();
    }

    protected void writeErrorDefinition(Event parentEvent, ErrorEventDefinition errorDefinition, XMLStreamWriter xtw) throws Exception {
        xtw.writeStartElement("errorEventDefinition");
        this.writeDefaultAttribute("errorRef", errorDefinition.getErrorCode(), xtw);
        boolean didWriteExtensionStartElement = BpmnXMLUtil.writeExtensionElements((BaseElement)errorDefinition, false, xtw);
        if (didWriteExtensionStartElement) {
            xtw.writeEndElement();
        }
        xtw.writeEndElement();
    }

    protected void writeTerminateDefinition(Event parentEvent, TerminateEventDefinition terminateDefinition, XMLStreamWriter xtw) throws Exception {
        boolean didWriteExtensionStartElement;
        xtw.writeStartElement("terminateEventDefinition");
        if (terminateDefinition.isTerminateAll()) {
            this.writeQualifiedAttribute("terminateAll", "true", xtw);
        }
        if (terminateDefinition.isTerminateMultiInstance()) {
            this.writeQualifiedAttribute("terminateMultiInstance", "true", xtw);
        }
        if (didWriteExtensionStartElement = BpmnXMLUtil.writeExtensionElements((BaseElement)terminateDefinition, false, xtw)) {
            xtw.writeEndElement();
        }
        xtw.writeEndElement();
    }

    protected void writeDefaultAttribute(String attributeName, String value, XMLStreamWriter xtw) throws Exception {
        BpmnXMLUtil.writeDefaultAttribute(attributeName, value, xtw);
    }

    protected void writeQualifiedAttribute(String attributeName, String value, XMLStreamWriter xtw) throws Exception {
        BpmnXMLUtil.writeQualifiedAttribute(attributeName, value, xtw);
    }
}

