/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.metrics.impl.internal;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaParserVisitorAdapter;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.metrics.impl.ClassFanOutMetric;
import net.sourceforge.pmd.lang.metrics.MetricOptions;
import org.apache.commons.lang3.mutable.MutableInt;

public class ClassFanOutVisitor
extends JavaParserVisitorAdapter {
    private static final String JAVA_LANG_PACKAGE_NAME = "java.lang";
    protected Set<Class<?>> classes = new HashSet();
    private final boolean includeJavaLang;

    public ClassFanOutVisitor(MetricOptions options, JavaNode topNode) {
        this.includeJavaLang = options.getOptions().contains((Object)ClassFanOutMetric.ClassFanOutOption.INCLUDE_JAVA_LANG);
    }

    @Override
    public Object visit(ASTClassOrInterfaceType node, Object data) {
        this.check(node, (MutableInt)data);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTName node, Object data) {
        this.check(node, (MutableInt)data);
        return super.visit(node, data);
    }

    private void check(TypeNode node, MutableInt counter) {
        if (!this.classes.contains(node.getType()) && this.shouldBeIncluded(node.getType())) {
            this.classes.add(node.getType());
            counter.increment();
        }
    }

    private boolean shouldBeIncluded(Class<?> classToCheck) {
        if (this.includeJavaLang || classToCheck == null) {
            return true;
        }
        Package packageToCheck = classToCheck.getPackage();
        if (packageToCheck == null) {
            return true;
        }
        return !JAVA_LANG_PACKAGE_NAME.equals(packageToCheck.getName());
    }
}

