/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.mule.tccTransaction.service.impl;

import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import net.lulihu.ObjectKit.LogKit;
import net.lulihu.ObjectKit.StrKit;
import net.lulihu.mule.tccTransaction.MuleTccConfig;
import net.lulihu.mule.tccTransaction.MuleTccTransactionSelfHealingProgram;
import net.lulihu.mule.tccTransaction.enums.RepositorySupportEnum;
import net.lulihu.mule.tccTransaction.enums.SerializeEnum;
import net.lulihu.mule.tccTransaction.eventExecutor.disruptor.DisruptorAsynchronousEventServiceImpl;
import net.lulihu.mule.tccTransaction.exception.MuleTccException;
import net.lulihu.mule.tccTransaction.kit.ServiceLoaderKit;
import net.lulihu.mule.tccTransaction.serializer.KryoSerializer;
import net.lulihu.mule.tccTransaction.serializer.ObjectSerializer;
import net.lulihu.mule.tccTransaction.service.MuleTccBootService;
import net.lulihu.mule.tccTransaction.service.TransactionCoordinatorRepositoryService;
import net.lulihu.mule.tccTransaction.service.TransactionCoordinatorService;
import net.lulihu.mule.tccTransaction.service.TransactionExecutorEventService;
import net.lulihu.mule.tccTransaction.service.TransactionSelfHealingProgramService;
import net.lulihu.mule.tccTransaction.service.coordinator.DefaultTransactionCoordinatorServiceImpl;
import net.lulihu.mule.tccTransaction.service.coordinator.db.DBTransactionCoordinatorRepositoryServiceImpl;
import net.lulihu.mule.tccTransaction.service.factory.TransactionFactoryComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMuleTccBootServiceImpl
implements MuleTccBootService {
    private static final Logger log = LoggerFactory.getLogger(DefaultMuleTccBootServiceImpl.class);
    private final TransactionCoordinatorService transactionCoordinatorService;
    private final TransactionExecutorEventService transactionExecutorEventService;
    private final TransactionSelfHealingProgramService transactionSelfHealingProgramService;
    private final String applicationName;

    public DefaultMuleTccBootServiceImpl(String applicationName) {
        this(applicationName, new DefaultTransactionCoordinatorServiceImpl(), new DisruptorAsynchronousEventServiceImpl(), new MuleTccTransactionSelfHealingProgram());
    }

    public DefaultMuleTccBootServiceImpl(TransactionCoordinatorService transactionCoordinatorService) {
        this(transactionCoordinatorService, new DisruptorAsynchronousEventServiceImpl(), new MuleTccTransactionSelfHealingProgram());
    }

    public DefaultMuleTccBootServiceImpl(TransactionCoordinatorService transactionCoordinatorService, TransactionExecutorEventService transactionExecutorEventService, TransactionSelfHealingProgramService transactionSelfHealingProgramService) {
        this(null, transactionCoordinatorService, transactionExecutorEventService, transactionSelfHealingProgramService);
    }

    public DefaultMuleTccBootServiceImpl(String applicationName, TransactionCoordinatorService transactionCoordinatorService, TransactionExecutorEventService transactionExecutorEventService, TransactionSelfHealingProgramService transactionSelfHealingProgramService) {
        this.transactionCoordinatorService = transactionCoordinatorService;
        this.transactionExecutorEventService = transactionExecutorEventService;
        this.applicationName = applicationName;
        this.transactionSelfHealingProgramService = transactionSelfHealingProgramService;
        TransactionFactoryComponent.registered(transactionExecutorEventService);
        TransactionFactoryComponent.registered(transactionSelfHealingProgramService);
    }

    @Override
    public void initialization(MuleTccConfig config) throws Exception {
        if (StrKit.isBlank((String)config.getApplicationName())) {
            config.setApplicationName(Optional.ofNullable(this.applicationName()).orElseGet(() -> {
                throw new MuleTccException("\u672a\u8bbe\u7f6e\u5e94\u7528\u7a0b\u5e8f\u540d\u79f0\uff0c\u5c06\u5bfc\u81f4\u7a0b\u5e8f\u540e\u7eed\u65e0\u6cd5\u5bf9\u5e94\u50a8\u5b58\u5e93");
            }));
        }
        TransactionCoordinatorRepositoryService repositoryService = this.loadRepositorySupport(config);
        this.transactionCoordinatorService.initTransactionCoordinator(repositoryService, config);
        this.transactionExecutorEventService.initialization(config, this.transactionCoordinatorService);
        this.transactionSelfHealingProgramService.initialization(this.transactionCoordinatorService, config);
    }

    @Override
    public String applicationName() {
        return this.applicationName;
    }

    private TransactionCoordinatorRepositoryService loadRepositorySupport(MuleTccConfig config) {
        TransactionCoordinatorRepositoryService repositoryService = this.selectCoordinatorRepository(config.getRepositorySupport());
        ObjectSerializer objectSerializer = this.selectSerializedObject(config.getSerializer());
        repositoryService.setSerializer(objectSerializer);
        return repositoryService;
    }

    private ObjectSerializer selectSerializedObject(String serializer) {
        SerializeEnum serializeEnum = SerializeEnum.acquire(serializer);
        ServiceLoader<ObjectSerializer> objectSerializers = ServiceLoaderKit.loadAll(ObjectSerializer.class);
        for (ObjectSerializer objectSerializer : objectSerializers) {
            if (!Objects.equals((Object)serializeEnum, (Object)objectSerializer.getScheme())) continue;
            LogKit.debug((Logger)log, (String)"Mule Tcc \u9009\u53d6\u4e8b\u52a1\u534f\u8c03\u5668\u5e8f\u5217\u5316\u5bf9\u8c61\u3010{}\u3011", () -> new Object[]{objectSerializer.getClass()});
            return objectSerializer;
        }
        LogKit.warn((Logger)log, (String)"\u9519\u8bef\u7684\u5e8f\u5217\u5316\u53c2\u6570\u8bbe\u7f6e\u3010{}\u3011\uff0c\u5c06\u4f7f\u7528kryo\u4f5c\u4e3a\u50a8\u5b58\u5e93\u5e8f\u5217\u5316\u5bf9\u8c61", (Object)serializer);
        return new KryoSerializer();
    }

    private TransactionCoordinatorRepositoryService selectCoordinatorRepository(String repository) {
        RepositorySupportEnum repositorySupport = RepositorySupportEnum.acquire(repository);
        ServiceLoader<TransactionCoordinatorRepositoryService> repositoryServices = ServiceLoaderKit.loadAll(TransactionCoordinatorRepositoryService.class);
        for (TransactionCoordinatorRepositoryService repositoryService : repositoryServices) {
            if (!Objects.equals((Object)repositorySupport, (Object)repositoryService.getScheme())) continue;
            LogKit.debug((Logger)log, (String)"Mule Tcc \u9009\u53d6\u4e8b\u52a1\u534f\u8c03\u5668\u50a8\u5b58\u5e93\u5bf9\u8c61\u3010{}\u3011", () -> new Object[]{repositoryService.getClass()});
            return repositoryService;
        }
        LogKit.warn((Logger)log, (String)"\u9519\u8bef\u7684\u50a8\u5b58\u5e93\u8bbe\u7f6e\u3010{}\u3011\uff0c\u5c06\u4f7f\u7528db\u4f5c\u4e3a\u50a8\u5b58\u5e93", (Object)repository);
        return new DBTransactionCoordinatorRepositoryServiceImpl();
    }
}

