/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.mule.tccTransaction.service.handler;

import java.lang.reflect.Method;
import net.lulihu.ObjectKit.ThreadLocalKit;
import net.lulihu.mule.tccTransaction.enums.MuleActionEnum;
import net.lulihu.mule.tccTransaction.enums.MuleRoleEnum;
import net.lulihu.mule.tccTransaction.kit.ServletRequestLocalKit;
import net.lulihu.mule.tccTransaction.kit.TransactionContextLocalKit;
import net.lulihu.mule.tccTransaction.kit.TransactionKit;
import net.lulihu.mule.tccTransaction.kit.TransactionLogLocalKit;
import net.lulihu.mule.tccTransaction.model.MuleTransaction;
import net.lulihu.mule.tccTransaction.model.TransactionContext;
import net.lulihu.mule.tccTransaction.service.handler.AbstractTransactionHandlerService;

public class RPCTransactionHandler
extends AbstractTransactionHandlerService {
    @Override
    public boolean support(TransactionContext context) {
        return context.getRole() == MuleRoleEnum.RPC.getCode();
    }

    @Override
    public boolean beforeHandler(Class<?> beanClass, Method method, Object[] args) {
        TransactionContext context = TransactionContextLocalKit.get();
        MuleActionEnum actionEnum = MuleActionEnum.acquire(context.getAction());
        switch (actionEnum) {
            case TRYING: {
                MuleTransaction muleTransaction = TransactionKit.buildMuleTransaction(context.getTransId(), MuleRoleEnum.RPC, beanClass, method, args);
                TransactionLogLocalKit.set(muleTransaction);
                this.transactionExecutorService.saveTransaction(muleTransaction);
                return true;
            }
            case CONFIRMING: {
                context.setRole(MuleRoleEnum.CALLBACK_EXECUTION.getCode());
                this.transactionExecutorService.rpcConfirm(context);
                break;
            }
            case CANCELING: {
                context.setRole(MuleRoleEnum.CALLBACK_EXECUTION.getCode());
                this.transactionExecutorService.rpcCancel(context);
                break;
            }
            case DELETE: {
                context.setRole(MuleRoleEnum.DELETE.getCode());
                this.transactionExecutorService.deleteByContext(context);
            }
        }
        return false;
    }

    @Override
    public void afterHandler() {
        MuleTransaction muleTransaction = TransactionLogLocalKit.get();
        if (muleTransaction != null) {
            muleTransaction.setStatus(MuleActionEnum.AFTER_TRYING.getCode());
            this.transactionExecutorService.updateStatus(muleTransaction);
        }
        if (ServletRequestLocalKit.notRequest()) {
            ThreadLocalKit.clearAll();
        }
    }

    @Override
    public String componentName() {
        return "RPC\u8fdc\u7a0b\u53c2\u4e0e\u8005\u5904\u7406\u5668";
    }
}

