/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.mule.tccTransaction.service.handler;

import java.lang.reflect.Method;
import net.lulihu.mule.tccTransaction.enums.MuleRoleEnum;
import net.lulihu.mule.tccTransaction.kit.TransactionKit;
import net.lulihu.mule.tccTransaction.kit.TransactionLogLocalKit;
import net.lulihu.mule.tccTransaction.model.MuleParticipant;
import net.lulihu.mule.tccTransaction.model.MuleTransaction;
import net.lulihu.mule.tccTransaction.model.TransactionContext;
import net.lulihu.mule.tccTransaction.service.handler.AbstractTransactionHandlerService;

public class LocalTransactionHandler
extends AbstractTransactionHandlerService {
    @Override
    public boolean support(TransactionContext context) {
        if (context == null) {
            return false;
        }
        int role = context.getRole();
        return role == MuleRoleEnum.START_LOCAL.getCode() || role == MuleRoleEnum.RPC_LOCAL.getCode();
    }

    @Override
    public boolean beforeHandler(Class<?> beanClass, Method method, Object[] args) {
        MuleTransaction muleTransaction = TransactionLogLocalKit.get();
        TransactionKit.addMuleParticipant(muleTransaction, beanClass, method, args);
        this.transactionExecutorService.updateTransactionParticipant(muleTransaction);
        return true;
    }

    @Override
    public Object exceptionHandler(Throwable throwable) throws Throwable {
        MuleTransaction muleTransaction = TransactionLogLocalKit.get();
        MuleParticipant muleParticipant = muleTransaction.lastOne();
        if (muleParticipant.getParticipateCompensation().booleanValue()) {
            muleParticipant.setParticipateCompensation(false);
            this.transactionExecutorService.updateTransactionParticipant(muleTransaction);
        }
        throw throwable;
    }

    @Override
    public String componentName() {
        return "\u4e8b\u52a1\u672c\u5730\u53c2\u4e0e\u8005\u5904\u7406\u5668";
    }
}

