/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.mule.tccTransaction.service.factory;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ServiceLoader;
import net.lulihu.ObjectKit.CollectionKit;
import net.lulihu.ObjectKit.LogKit;
import net.lulihu.mule.tccTransaction.exception.FactoryCompontClassCastException;
import net.lulihu.mule.tccTransaction.kit.ServiceLoaderKit;
import net.lulihu.mule.tccTransaction.service.TransactionSupportService;
import net.lulihu.mule.tccTransaction.service.factory.FactoryComponentEnum;
import net.lulihu.mule.tccTransaction.service.factory.TransactionFactoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionFactoryComponent {
    private static final Logger log = LoggerFactory.getLogger(TransactionFactoryComponent.class);

    private TransactionFactoryComponent() {
    }

    public static void startFactory() throws Exception {
        LogKit.debug((Logger)log, (String)"\u5f00\u59cb\u6ce8\u518c Mule Tcc \u7ec4\u4ef6...");
        for (FactoryComponentEnum workshopSet : FactoryComponentEnum.values()) {
            ServiceLoader<?> handlerServices = ServiceLoaderKit.loadAll(workshopSet.getClazz());
            TransactionFactoryComponent.addAllComponentService(handlerServices);
        }
        for (FactoryComponentEnum workshopSet : FactoryComponentEnum.values()) {
            Collection<?> workshop = workshopSet.getWorkshop();
            workshop.stream().sorted(Comparator.comparingInt(TransactionSupportService::order));
            for (TransactionFactoryService component : workshop) {
                component.afterInitialization();
            }
        }
    }

    public static void registered(TransactionFactoryService factoryService) {
        FactoryComponentEnum componentSet = FactoryComponentEnum.getComponentSetByClazz(factoryService.getClass());
        Collection<?> factoryServiceSet = componentSet.getWorkshop();
        factoryServiceSet.add(factoryService);
        factoryServiceSet.stream().sorted(Comparator.comparingInt(TransactionSupportService::order));
        LogKit.debug((Logger)log, (String)"\u7ec4\u4ef6\u3010{}\u3011\u6210\u529f\u6ce8\u518c\u81f3Mule Tcc\u7ec4\u4ef6\u5de5\u5382...", () -> new Object[]{factoryService.componentName()});
    }

    private static void addAllComponentService(ServiceLoader<?> handlerServices) {
        if (CollectionKit.isEmpty(handlerServices)) {
            return;
        }
        Iterator<?> iterator = handlerServices.iterator();
        Object next = iterator.next();
        if (!(next instanceof TransactionFactoryService)) {
            throw new FactoryCompontClassCastException("\u5de5\u5382\u5185\u7684\u7ec4\u4ef6\u90fd\u5fc5\u987b\u5b9e\u73b0 TransactionFactoryService \u63a5\u53e3\u4f5c\u4e3a\u6807\u8bc6");
        }
        FactoryComponentEnum componentSet = FactoryComponentEnum.getComponentSetByClazz(next.getClass());
        Collection<?> factoryServiceSet = componentSet.getWorkshop();
        TransactionFactoryService component = (TransactionFactoryService)next;
        factoryServiceSet.add(component);
        LogKit.debug((Logger)log, (String)"\u7ec4\u4ef6\u3010{}\u3011\u6ce8\u518c\u6210\u529f", () -> new Object[]{component.componentName()});
        Iterator<?> serviceIterator = iterator;
        while (serviceIterator.hasNext()) {
            TransactionFactoryService componentService = (TransactionFactoryService)serviceIterator.next();
            factoryServiceSet.add(componentService);
            LogKit.debug((Logger)log, (String)"\u7ec4\u4ef6\u3010{}\u3011\u6ce8\u518c\u6210\u529f", () -> new Object[]{componentService.componentName()});
        }
    }

    public static <T> Collection<T> getWorkshopComponentSetByClazz(Class<T> clazz) {
        return FactoryComponentEnum.getComponentSetByClazz(clazz).getWorkshop();
    }
}

