/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.mule.tccTransaction.service.coordinator.db;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.lulihu.ObjectKit.LogKit;
import net.lulihu.dateTime.DateTimeKit;
import net.lulihu.mule.tccTransaction.exception.RepositoryMapperException;
import net.lulihu.mule.tccTransaction.kit.TransactionLogTemplateKit;
import net.lulihu.mule.tccTransaction.model.MuleTransaction;
import net.lulihu.mule.tccTransaction.model.MuleTransactionCompensations;
import net.lulihu.mule.tccTransaction.service.TransactionCoordinatorRepositoryService;
import net.lulihu.mule.tccTransaction.service.coordinator.db.SqlStatementExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBTransactionCoordinatorRepositoryServiceImpl
extends SqlStatementExecutor
implements TransactionCoordinatorRepositoryService {
    private static final Logger log = LoggerFactory.getLogger(DBTransactionCoordinatorRepositoryServiceImpl.class);

    @Override
    public boolean saveTransactionLog(MuleTransaction muleTransaction) {
        LogKit.debug((Logger)log, (String)"\u4fdd\u5b58\u4e8b\u52a1\u4fe1\u606f:{}", (Object)muleTransaction);
        try {
            ArrayList<Object> fieldValues = new ArrayList<Object>();
            String sqlTemplate = TransactionLogTemplateKit.insertSqlTemplate(this.appName, muleTransaction, fieldValues, this.getSerializer());
            int row = this.executeUpdate(sqlTemplate, fieldValues);
            return row != 0;
        }
        catch (IllegalAccessException e) {
            LogKit.error((Logger)log, (String)"\u751f\u6210\u6570\u636e\u5e93\u63d2\u5165\u8bed\u53e5\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
        catch (SQLException e) {
            LogKit.error((Logger)log, (String)"\u4fdd\u5b58\u4e8b\u52a1\u8bb0\u5f55\u81f3\u6570\u636e\u5e93\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
        return false;
    }

    @Override
    public boolean updateMuleTransactionLogStatus(MuleTransaction muleTransaction) {
        LogKit.debug((Logger)log, (String)"\u4fee\u6539\u4e8b\u52a1\u4fe1\u606f\u72b6\u6001:{}", (Object)muleTransaction);
        String sqlTemplate = (String)TransactionLogTemplateKit.UPDATE_STATUS_TEMPLATE.accept((Object)this.appName);
        String updateTime = DateTimeKit.date().toString("yyyy-MM-dd HH:mm:ss.SSS");
        try {
            int row = this.executeUpdate(sqlTemplate, muleTransaction.getStatus(), updateTime, muleTransaction.getTransId());
            return row != 0;
        }
        catch (SQLException e) {
            LogKit.error((Logger)log, (String)"\u4fee\u6539\u4e8b\u52a1\u4fe1\u606f\u72b6\u6001\u81f3\u6570\u636e\u5e93\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean updateParticipant(MuleTransaction muleTransaction) {
        LogKit.debug((Logger)log, (String)"\u4fee\u6539\u4e8b\u52a1\u53c2\u4e0e\u8005\u4fe1\u606f:{}", (Object)muleTransaction);
        String sqlTemplate = (String)TransactionLogTemplateKit.UPDATE_PARTICIPANT_TEMPLATE.accept((Object)this.appName);
        String updateTime = DateTimeKit.date().toString("yyyy-MM-dd HH:mm:ss.SSS");
        byte[] serialize = this.getSerializer().serialize(muleTransaction.getParticipants());
        try {
            int row = this.executeUpdate(sqlTemplate, serialize, updateTime, muleTransaction.getTransId());
            return row != 0;
        }
        catch (SQLException e) {
            LogKit.error((Logger)log, (String)"\u4fee\u6539\u4e8b\u52a1\u53c2\u4e0e\u8005\u4fe1\u606f\u81f3\u6570\u636e\u5e93\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            return false;
        }
    }

    @Override
    public MuleTransaction getMuleTransactionById(String transId) {
        LogKit.debug((Logger)log, (String)"\u6839\u636e\u4e8b\u52a1id\u3010{}\u3011\u83b7\u53d6\u4e8b\u52a1\u8bb0\u5f55", (Object)transId);
        String sqlTemplate = (String)TransactionLogTemplateKit.SELECT_TRANSACTION_BY_TRANS_ID_TEMPLATE.accept((Object)this.appName);
        try {
            return this.executeQueryOne(MuleTransaction.class, sqlTemplate, transId);
        }
        catch (Exception e) {
            throw new RepositoryMapperException("\u6839\u636e\u4e8b\u52a1id\u83b7\u53d6\u4e8b\u52a1\u8bb0\u5f55\u65f6\u53d1\u751f\u9519\u8bef", e);
        }
    }

    @Override
    public boolean delete(String transId) {
        LogKit.debug((Logger)log, (String)"\u6839\u636e\u4e8b\u52a1id\u3010{}\u3011\u5220\u9664\u4e8b\u52a1\u4fe1\u606f...", (Object)transId);
        String sqlTemplate = (String)TransactionLogTemplateKit.DELETE_TRANSACTION_BY_TRANS_ID_TEMPLATE.accept((Object)this.appName);
        try {
            int row = this.executeUpdate(sqlTemplate, transId);
            return row != 0;
        }
        catch (SQLException e) {
            LogKit.error((Logger)log, (String)"\u5220\u9664\u4e8b\u52a1\u4fe1\u606f\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            return false;
        }
    }

    @Override
    public List<MuleTransaction> getAllMuleTransaction() {
        LogKit.debug((Logger)log, (String)"\u83b7\u53d6\u6240\u6709\u4e8b\u52a1\u8bb0\u5f55...");
        try {
            String sqlTemplate = (String)TransactionLogTemplateKit.SELECT_ALL_TRANSACTION_LOG.accept((Object)this.appName);
            return this.executeQueryList(MuleTransaction.class, sqlTemplate, new Object[0]);
        }
        catch (Exception e) {
            throw new RepositoryMapperException("\u83b7\u53d6\u6240\u6709\u4e8b\u52a1\u8bb0\u5f55\u65f6\u53d1\u751f\u9519\u8bef", e);
        }
    }

    @Override
    public boolean getOptimisticLocks(MuleTransaction transaction, Integer recoverTimeInterval) {
        String sqlTemplate = (String)TransactionLogTemplateKit.TRANSACTION_OPTIMISTIC_LOCK_TEMPLATE.accept((Object)this.appName);
        String updateTime = DateTimeKit.date().toString("yyyy-MM-dd HH:mm:ss.SSS");
        try {
            int row = this.executeUpdate(sqlTemplate, updateTime, transaction.getTransId(), transaction.getVersion(), recoverTimeInterval);
            return row != 0;
        }
        catch (SQLException e) {
            throw new RepositoryMapperException("\u83b7\u53d6\u4e8b\u52a1\u4e50\u89c2\u9501\u65f6\u53d1\u751f\u9519\u8bef", e);
        }
    }

    @Override
    public boolean saveCompensationsLog(MuleTransactionCompensations transactionCompensations) {
        LogKit.debug((Logger)log, (String)"\u4fdd\u5b58\u4e8b\u52a1\u8865\u507f\u8bb0\u5f55", (Object)transactionCompensations);
        String tableName = this.appName + "_compensations";
        ArrayList<Object> fieldValues = new ArrayList<Object>();
        try {
            String sqlTemplate = TransactionLogTemplateKit.insertSqlTemplate(tableName, transactionCompensations, fieldValues, this.getSerializer());
            int row = this.executeUpdate(sqlTemplate, fieldValues);
            return row != 0;
        }
        catch (IllegalAccessException e) {
            LogKit.error((Logger)log, (String)"\u751f\u6210\u6570\u636e\u5e93\u63d2\u5165\u8bed\u53e5\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
        catch (SQLException e) {
            LogKit.error((Logger)log, (String)"\u4fdd\u5b58\u4e8b\u52a1\u8bb0\u5f55\u81f3\u6570\u636e\u5e93\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
        return false;
    }

    @Override
    public MuleTransactionCompensations getMuleTransactionCompensationsLog(MuleTransaction transaction) {
        LogKit.debug((Logger)log, (String)"\u6839\u636e\u4e8b\u52a1\u8bb0\u5f55\u83b7\u53d6\u4e8b\u52a1\u8865\u507f\u8bb0\u5f55", (Object)transaction);
        String tableName = this.appName + "_compensations";
        String sqlTemplate = (String)TransactionLogTemplateKit.SELECT_TRANSACTION_COMPENSATIONS_LOG_BY_TRANS_ID_TEMPLATE.accept((Object)tableName);
        try {
            return this.executeQueryOne(MuleTransactionCompensations.class, sqlTemplate, transaction.getTransId());
        }
        catch (Exception e) {
            throw new RepositoryMapperException("\u6839\u636e\u4e8b\u52a1id\u83b7\u53d6\u4e8b\u52a1\u8bb0\u5f55\u65f6\u53d1\u751f\u9519\u8bef", e);
        }
    }

    @Override
    public boolean deleteTransactionCompensationsLog(MuleTransactionCompensations transactionCompensations) {
        LogKit.debug((Logger)log, (String)"\u5220\u9664\u4e8b\u52a1\u8865\u507f\u4fe1\u606f:{}", (Object)transactionCompensations);
        String tableName = this.appName + "_compensations";
        String sqlTemplate = (String)TransactionLogTemplateKit.DELETE_TRANSACTION_COMPENSATIONS_LOG_BY_TRANS_ID_TEMPLATE.accept((Object)tableName);
        try {
            int row = this.executeUpdate(sqlTemplate, transactionCompensations.getTransId());
            return row != 0;
        }
        catch (SQLException e) {
            LogKit.error((Logger)log, (String)"\u5220\u9664\u4e8b\u52a1\u8865\u507f\u4fe1\u606f\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean deleteExcessCompensationRecord(int initialDelay) {
        LogKit.debug((Logger)log, (String)"\u5220\u9664\u591a\u4f59\u4e8b\u52a1\u8865\u507f\u8bb0\u5f55...");
        String compensationsTableName = this.appName + "_compensations";
        String sqlTemplate = (String)TransactionLogTemplateKit.DELETE_EXCESS_COMPENSATION_RECORD.accept(new Object[]{compensationsTableName, this.appName});
        try {
            return this.executeUpdate(sqlTemplate, initialDelay) != 0;
        }
        catch (SQLException e) {
            LogKit.error((Logger)log, (String)"\u5220\u9664\u591a\u4f59\u4e8b\u52a1\u8865\u507f\u8bb0\u5f55\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            return false;
        }
    }
}

