/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.mule.tccTransaction.service.coordinator;

import java.util.List;
import net.lulihu.ObjectKit.LogKit;
import net.lulihu.dateTime.DateTimeKit;
import net.lulihu.functional.Consumption;
import net.lulihu.functional.ConsumptionResult;
import net.lulihu.lock.ConditionLock;
import net.lulihu.mule.tccTransaction.MuleTccConfig;
import net.lulihu.mule.tccTransaction.kit.ParticipantKit;
import net.lulihu.mule.tccTransaction.kit.TransactionContextLocalKit;
import net.lulihu.mule.tccTransaction.model.MuleTransaction;
import net.lulihu.mule.tccTransaction.model.MuleTransactionCompensations;
import net.lulihu.mule.tccTransaction.model.TransactionContext;
import net.lulihu.mule.tccTransaction.service.ComponentService;
import net.lulihu.mule.tccTransaction.service.TransactionCoordinatorRepositoryService;
import net.lulihu.mule.tccTransaction.service.TransactionCoordinatorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTransactionCoordinatorServiceImpl
implements TransactionCoordinatorService,
ComponentService {
    private static final Logger log = LoggerFactory.getLogger(DefaultTransactionCoordinatorServiceImpl.class);
    private TransactionCoordinatorRepositoryService repositoryService;

    @Override
    public void initTransactionCoordinator(TransactionCoordinatorRepositoryService repositoryService, MuleTccConfig config) throws Exception {
        LogKit.debug((Logger)log, (String)"{} \u5f00\u59cb\u521d\u59cb\u5316... ", (Object)this.componentName());
        this.repositoryService = repositoryService;
        this.repositoryService.initCoordinatorRepository(config);
    }

    @Override
    public void delete(MuleTransaction muleTransaction, ConditionLock conditionLock) {
        this.exeLockMethod(conditionLock, () -> this.repositoryService.delete(muleTransaction.getTransId()));
    }

    @Override
    public void deleteByContext(TransactionContext context, ConditionLock conditionLock) {
        this.exeLockMethod(conditionLock, () -> {
            boolean delete = this.repositoryService.delete(context.getTransId());
            if (!delete) {
                this.saveCompensationsLog(context);
            }
        });
    }

    @Override
    public void save(MuleTransaction muleTransaction, ConditionLock conditionLock) {
        this.exeLockMethod(conditionLock, () -> this.repositoryService.saveTransactionLog(muleTransaction));
    }

    @Override
    public void saveCompensationsLog(MuleTransactionCompensations transactionCompensations, ConditionLock conditionLock) {
        this.exeLockMethod(conditionLock, () -> this.repositoryService.saveCompensationsLog(transactionCompensations));
    }

    @Override
    public void updateParticipant(MuleTransaction muleTransaction, ConditionLock conditionLock) {
        this.exeLockMethod(conditionLock, () -> this.repositoryService.updateParticipant(muleTransaction));
    }

    @Override
    public void updateStatus(MuleTransaction muleTransaction, ConditionLock conditionLock) {
        this.exeLockMethod(conditionLock, () -> this.repositoryService.updateMuleTransactionLogStatus(muleTransaction));
    }

    @Override
    public void cancel(MuleTransaction muleTransaction, TransactionContext transactionContext, ConditionLock conditionLock) {
        this.exeLockMethod(conditionLock, () -> this.exeParticipantMethod(false, muleTransaction, transactionContext));
    }

    @Override
    public void confirm(MuleTransaction muleTransaction, TransactionContext transactionContext, ConditionLock conditionLock) {
        this.exeLockMethod(conditionLock, () -> this.exeParticipantMethod(true, muleTransaction, transactionContext));
    }

    @Override
    public MuleTransaction getMuleTransactionById(String transId, ConditionLock conditionLock) {
        return (MuleTransaction)this.exeLockMethod(conditionLock, () -> this.repositoryService.getMuleTransactionById(transId));
    }

    @Override
    public void rpcConfirm(TransactionContext context, ConditionLock conditionLock) {
        this.exeLockMethod(conditionLock, () -> this.exeRpcParticipantMethod(true, context));
    }

    @Override
    public void rpcCancel(TransactionContext context, ConditionLock conditionLock) {
        this.exeLockMethod(conditionLock, () -> this.exeRpcParticipantMethod(false, context));
    }

    @Override
    public List<MuleTransaction> getAllMuleTransaction(ConditionLock conditionLock) {
        return (List)this.exeLockMethod(conditionLock, () -> this.repositoryService.getAllMuleTransaction());
    }

    @Override
    public boolean getOptimisticLocks(MuleTransaction transaction, Integer recoverTimeInterval, ConditionLock conditionLock) {
        return (Boolean)this.exeLockMethod(conditionLock, () -> this.repositoryService.getOptimisticLocks(transaction, recoverTimeInterval));
    }

    @Override
    public MuleTransactionCompensations getMuleTransactionCompensationsLog(MuleTransaction transaction, ConditionLock conditionLock) {
        return (MuleTransactionCompensations)this.exeLockMethod(conditionLock, () -> this.repositoryService.getMuleTransactionCompensationsLog(transaction));
    }

    @Override
    public void deleteTransactionCompensationsLog(MuleTransactionCompensations transactionCompensations, ConditionLock conditionLock) {
        this.exeLockMethod(conditionLock, () -> this.repositoryService.deleteTransactionCompensationsLog(transactionCompensations));
    }

    @Override
    public void deleteExcessCompensationRecord(int initialDelay, ConditionLock conditionLock) {
        this.exeLockMethod(conditionLock, () -> this.repositoryService.deleteExcessCompensationRecord(initialDelay));
    }

    private void exeParticipantMethod(boolean status, MuleTransaction muleTransaction, TransactionContext transactionContext) {
        boolean success = this.repositoryService.getOptimisticLocks(muleTransaction, 0);
        if (success) {
            if (status) {
                LogKit.debug((Logger)log, (String)"\u6267\u884c\u4e8b\u52a1\u786e\u8ba4:\n {} \n {}", (Object)muleTransaction, (Object)transactionContext);
            } else {
                LogKit.debug((Logger)log, (String)"\u6267\u884c\u4e8b\u52a1\u8865\u507f:\n {} \n {}", (Object)muleTransaction, (Object)transactionContext);
            }
            TransactionContextLocalKit.set(transactionContext);
            try {
                ParticipantKit.exeParticipantMethod(this, status, null, muleTransaction);
            }
            catch (Exception e) {
                LogKit.error((Logger)log, (String)e.getMessage(), (Throwable)e.getCause());
            }
        }
    }

    private void exeRpcParticipantMethod(boolean status, TransactionContext context) {
        if (status) {
            LogKit.debug((Logger)log, (String)"Rpc\u6267\u884c\u4e8b\u52a1\u786e\u8ba4:\n {} ", (Object)context);
        } else {
            LogKit.debug((Logger)log, (String)"Rpc\u6267\u884c\u4e8b\u52a1\u8865\u507f:\n {} ", (Object)context);
        }
        MuleTransaction muleTransaction = this.getMuleTransactionById(context.getTransId(), null);
        if (muleTransaction != null) {
            if (status) {
                this.confirm(muleTransaction, context, null);
            } else {
                this.cancel(muleTransaction, context, null);
            }
        } else {
            this.saveCompensationsLog(context);
        }
    }

    private void saveCompensationsLog(TransactionContext context) {
        MuleTransactionCompensations transactionCompensations = new MuleTransactionCompensations();
        transactionCompensations.setTransId(context.getTransId());
        transactionCompensations.setStatus(context.getAction());
        transactionCompensations.setCreateTime(DateTimeKit.date().toString("yyyy-MM-dd HH:mm:ss.SSS"));
        this.saveCompensationsLog(transactionCompensations, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T exeLockMethod(ConditionLock conditionLock, ConsumptionResult<T> consumption) {
        try {
            if (conditionLock != null) {
                conditionLock.getLock();
            }
            Object object = consumption.accept();
            return (T)object;
        }
        finally {
            if (conditionLock != null) {
                conditionLock.unlock();
            }
        }
    }

    private void exeLockMethod(ConditionLock conditionLock, Consumption consumption) {
        try {
            if (conditionLock != null) {
                conditionLock.getLock();
            }
            consumption.accept();
        }
        finally {
            if (conditionLock != null) {
                conditionLock.unlock();
            }
        }
    }

    @Override
    public String componentName() {
        return "\u9ed8\u8ba4\u4e8b\u52a1\u534f\u8c03\u5668";
    }
}

