/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.mule.tccTransaction.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.lulihu.dateTime.DateTimeKit;
import net.lulihu.mule.tccTransaction.annotation.DbField;
import net.lulihu.mule.tccTransaction.model.MuleParticipant;

public class MuleTransaction
implements Serializable {
    @DbField(value="trans_id")
    private String transId;
    @DbField(value="status")
    private int status;
    @DbField(value="role")
    private int role;
    @DbField(value="target_class")
    private String targetClass;
    @DbField(value="target_method")
    private String targetMethod;
    @DbField(value="participants", serializer=true)
    private List<MuleParticipant> participants;
    @DbField(value="version")
    private int version = 1;
    @DbField(value="create_time")
    private String createTime;
    @DbField(value="last_time")
    private String lastTime;

    public MuleTransaction() {
    }

    public MuleTransaction(String transId) {
        this.transId = transId;
        this.lastTime = this.createTime = DateTimeKit.date().toString("yyyy-MM-dd HH:mm:ss.SSS");
        this.participants = new ArrayList<MuleParticipant>();
    }

    public void registerParticipant(MuleParticipant muleParticipant) {
        this.participants.add(muleParticipant);
    }

    public MuleParticipant lastOne() {
        return this.participants.get(this.participants.size() - 1);
    }

    public String getTransId() {
        return this.transId;
    }

    public int getStatus() {
        return this.status;
    }

    public int getRole() {
        return this.role;
    }

    public String getTargetClass() {
        return this.targetClass;
    }

    public String getTargetMethod() {
        return this.targetMethod;
    }

    public List<MuleParticipant> getParticipants() {
        return this.participants;
    }

    public int getVersion() {
        return this.version;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public String getLastTime() {
        return this.lastTime;
    }

    public void setTransId(String transId) {
        this.transId = transId;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setRole(int role) {
        this.role = role;
    }

    public void setTargetClass(String targetClass) {
        this.targetClass = targetClass;
    }

    public void setTargetMethod(String targetMethod) {
        this.targetMethod = targetMethod;
    }

    public void setParticipants(List<MuleParticipant> participants) {
        this.participants = participants;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public void setLastTime(String lastTime) {
        this.lastTime = lastTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MuleTransaction)) {
            return false;
        }
        MuleTransaction other = (MuleTransaction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$transId = this.getTransId();
        String other$transId = other.getTransId();
        if (this$transId == null ? other$transId != null : !this$transId.equals(other$transId)) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        if (this.getRole() != other.getRole()) {
            return false;
        }
        String this$targetClass = this.getTargetClass();
        String other$targetClass = other.getTargetClass();
        if (this$targetClass == null ? other$targetClass != null : !this$targetClass.equals(other$targetClass)) {
            return false;
        }
        String this$targetMethod = this.getTargetMethod();
        String other$targetMethod = other.getTargetMethod();
        if (this$targetMethod == null ? other$targetMethod != null : !this$targetMethod.equals(other$targetMethod)) {
            return false;
        }
        List<MuleParticipant> this$participants = this.getParticipants();
        List<MuleParticipant> other$participants = other.getParticipants();
        if (this$participants == null ? other$participants != null : !((Object)this$participants).equals(other$participants)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        String this$createTime = this.getCreateTime();
        String other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !this$createTime.equals(other$createTime)) {
            return false;
        }
        String this$lastTime = this.getLastTime();
        String other$lastTime = other.getLastTime();
        return !(this$lastTime == null ? other$lastTime != null : !this$lastTime.equals(other$lastTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MuleTransaction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $transId = this.getTransId();
        result = result * 59 + ($transId == null ? 43 : $transId.hashCode());
        result = result * 59 + this.getStatus();
        result = result * 59 + this.getRole();
        String $targetClass = this.getTargetClass();
        result = result * 59 + ($targetClass == null ? 43 : $targetClass.hashCode());
        String $targetMethod = this.getTargetMethod();
        result = result * 59 + ($targetMethod == null ? 43 : $targetMethod.hashCode());
        List<MuleParticipant> $participants = this.getParticipants();
        result = result * 59 + ($participants == null ? 43 : ((Object)$participants).hashCode());
        result = result * 59 + this.getVersion();
        String $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : $createTime.hashCode());
        String $lastTime = this.getLastTime();
        result = result * 59 + ($lastTime == null ? 43 : $lastTime.hashCode());
        return result;
    }

    public String toString() {
        return "MuleTransaction(transId=" + this.getTransId() + ", status=" + this.getStatus() + ", role=" + this.getRole() + ", targetClass=" + this.getTargetClass() + ", targetMethod=" + this.getTargetMethod() + ", participants=" + this.getParticipants() + ", version=" + this.getVersion() + ", createTime=" + this.getCreateTime() + ", lastTime=" + this.getLastTime() + ")";
    }
}

