/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.mule.tccTransaction.kit;

import java.lang.reflect.Method;
import net.lulihu.ObjectKit.IDGeneratorKit;
import net.lulihu.ObjectKit.StrKit;
import net.lulihu.ToolUtil;
import net.lulihu.mule.tccTransaction.annotation.MuleTcc;
import net.lulihu.mule.tccTransaction.enums.MuleActionEnum;
import net.lulihu.mule.tccTransaction.enums.MuleRoleEnum;
import net.lulihu.mule.tccTransaction.model.MuleParticipant;
import net.lulihu.mule.tccTransaction.model.MuleTransaction;
import net.lulihu.mule.tccTransaction.model.TransactionContext;

public class TransactionKit {
    public static MuleTransaction buildMuleTransaction(String transId, MuleRoleEnum role, Class<?> beanClass, Method method, Object[] args) {
        MuleTransaction muleTransaction = new MuleTransaction(transId);
        muleTransaction.setStatus(MuleActionEnum.TRYING.getCode());
        muleTransaction.setRole(role.getCode());
        Class<?> clazz = method.getDeclaringClass();
        muleTransaction.setTargetClass(clazz.getName());
        muleTransaction.setTargetMethod(method.getName());
        TransactionKit.addMuleParticipant(muleTransaction, beanClass, method, args);
        return muleTransaction;
    }

    public static void addMuleParticipant(MuleTransaction muleTransaction, Class<?> beanClass, Method method, Object[] args) {
        String cancelMethodName;
        MuleTcc muleTcc = method.getAnnotation(MuleTcc.class);
        MuleParticipant muleParticipant = new MuleParticipant();
        muleParticipant.setTransId(muleTransaction.getTransId());
        muleParticipant.setTargetClass(beanClass);
        boolean currentMethod = muleTcc.currentMethod();
        if (currentMethod) {
            muleParticipant.setTargetMethod(method.getName());
        }
        muleParticipant.setArgs(args);
        muleParticipant.setParameterTypes(method.getParameterTypes());
        String confirmMethodName = muleTcc.confirmMethod();
        if (StrKit.notBlank((String)confirmMethodName)) {
            muleParticipant.setConfirmMethod(confirmMethodName);
        }
        if (StrKit.notBlank((String)(cancelMethodName = muleTcc.cancelMethod()))) {
            muleParticipant.setCancelMethod(cancelMethodName);
        }
        muleParticipant.setParticipateCompensation(muleTcc.exceptionNotRollBack());
        muleTransaction.registerParticipant(muleParticipant);
    }

    public static TransactionContext buildMuleTransactionContext(MuleActionEnum action, MuleRoleEnum role) {
        String transId = IDGeneratorKit.get().toString() + ToolUtil.getRandomHexString((int)14);
        TransactionContext context = new TransactionContext();
        context.setTransId(transId);
        context.setAction(action.getCode());
        context.setRole(role.getCode());
        return context;
    }
}

