/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.mule.tccTransaction.kit;

import java.lang.reflect.Method;
import net.lulihu.Assert;
import net.lulihu.ObjectKit.LogKit;
import net.lulihu.ObjectKit.MethodKit;
import net.lulihu.ObjectKit.StrKit;
import net.lulihu.mule.tccTransaction.exception.NotFindSuitableObjectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectContextHolder {
    private static final Logger log = LoggerFactory.getLogger(ObjectContextHolder.class);
    private ObjectContext objectContext;

    private ObjectContextHolder() {
    }

    public static ObjectContextHolder getInstance() {
        return ObjectContextEnum.INSTANCE.getObjectContextHolder();
    }

    public synchronized void setObjectContext(ObjectContext objectContext) {
        if (this.objectContext != null) {
            LogKit.warn((Logger)log, (String)"\u91cd\u590d\u6ce8\u5165\u5bf9\u8c61\u4e0a\u4e0b\u6587\uff0c\u4e4b\u524d\u4e0a\u4e0b\u6587\u4ee5\u53ca\u88ab\u66ff\u6362...");
        }
        this.objectContext = objectContext;
    }

    public Class<?> chooseFirstExists(Object target, Method method) {
        Class<?>[] classes;
        if (this.containsBean(target.getClass())) {
            return target.getClass();
        }
        String name = method.getName();
        Object[] parameterTypes = method.getParameterTypes();
        for (Class<?> aClass : classes = target.getClass().getInterfaces()) {
            if (!this.containsBean(target.getClass()) || !MethodKit.existSpecifiedMethod(aClass, (String)name, (Class[])parameterTypes)) continue;
            return aClass;
        }
        throw new NotFindSuitableObjectException("\u5bf9\u8c61\u7c7b\u578b\u3010{}\u3011\u6216\u8005\u6307\u5b9a\u5bf9\u8c61\u7684\u65b9\u6cd5\u3010{}({} )\u3011\u4e0d\u5b58\u5728\u4e0a\u4e0b\u6587\u4e2d...", target.getClass(), name, StrKit.listStitchingStr(type -> " " + type, (Object[])parameterTypes));
    }

    public boolean containsBean(Class<?> requiredType) {
        try {
            this.getBean(requiredType);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public <T> T getBean(Class<T> requiredType) throws NotFindSuitableObjectException {
        this.assertObjectContext();
        try {
            return this.objectContext.getBean(requiredType);
        }
        catch (NotFindSuitableObjectException e) {
            throw new NotFindSuitableObjectException("\u672a\u627e\u5230\u6307\u5b9a\u7c7b\u578b\u3010{}\u3011\u7684\u5bf9\u8c61\u53ef\u7528", requiredType, e);
        }
    }

    private void assertObjectContext() {
        Assert.notNull((Object)this.objectContext, (String)"\u5bf9\u8c61\u4e0a\u4e0b\u6587\u4e3a\u7a7a\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u5bf9\u8c61\u7c7b\u578b,\u8bf7\u68c0\u67e5\u662f\u5426\u6ce8\u5165...");
    }

    private static enum ObjectContextEnum {
        INSTANCE;

        private final ObjectContextHolder objectContextHolder = new ObjectContextHolder();

        public ObjectContextHolder getObjectContextHolder() {
            return this.objectContextHolder;
        }
    }

    public static interface ObjectContext {
        public <T> T getBean(Class<T> var1) throws NotFindSuitableObjectException;
    }
}

