/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.mule.tccTransaction.eventExecutor.disruptor;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.WorkHandler;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import net.lulihu.ObjectKit.LogKit;
import net.lulihu.ObjectKit.NumberKit;
import net.lulihu.disruptorKit.DefaultEventFactory;
import net.lulihu.disruptorKit.Event;
import net.lulihu.disruptorKit.Producer;
import net.lulihu.mule.tccTransaction.MuleTccConfig;
import net.lulihu.mule.tccTransaction.MuleTccShutdownManage;
import net.lulihu.mule.tccTransaction.eventExecutor.disruptor.DisruptorEventConsumer;
import net.lulihu.mule.tccTransaction.eventExecutor.disruptor.DisruptorTransactionEvent;
import net.lulihu.mule.tccTransaction.eventExecutor.disruptor.EventTypeEnum;
import net.lulihu.mule.tccTransaction.service.MuleTccShutdownService;
import net.lulihu.mule.tccTransaction.service.TransactionCoordinatorService;
import net.lulihu.mule.tccTransaction.service.TransactionExecutorEventService;
import net.lulihu.mule.tccTransaction.service.TransactionHandlerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDisruptorEventPublisher
implements TransactionExecutorEventService,
MuleTccShutdownService,
ExceptionHandler<Event<DisruptorTransactionEvent>> {
    private static final Logger log = LoggerFactory.getLogger(AbstractDisruptorEventPublisher.class);
    private Disruptor<Event<DisruptorTransactionEvent>> disruptor;
    private Producer<DisruptorTransactionEvent> producer;
    protected TransactionCoordinatorService transactionCoordinatorService;

    @Override
    public final void initialization(MuleTccConfig config, TransactionCoordinatorService transactionCoordinatorService) {
        this.transactionCoordinatorService = transactionCoordinatorService;
        LogKit.debug((Logger)log, (String)"\u5f00\u59cb\u521d\u59cb\u5316disruptor\u5f02\u6b65\u961f\u5217...");
        this.disruptorInitialization(config);
        LogKit.debug((Logger)log, (String)"disruptor\u5f02\u6b65\u961f\u5217\u521d\u59cb\u5316\u6210\u529f...");
        MuleTccShutdownManage.getInstance().addComponents(this);
    }

    private void disruptorInitialization(MuleTccConfig config) {
        int bufferSize = config.getBufferSize();
        bufferSize = Integer.bitCount(bufferSize) == 1 ? bufferSize : NumberKit.getClosest2IndexGreaterThanSelf((int)bufferSize);
        int consumerThreadNum = config.getConsumerThreadNum();
        WorkHandler[] consumers = new DisruptorEventConsumer[consumerThreadNum];
        for (int i = 0; i < consumerThreadNum; ++i) {
            consumers[i] = new DisruptorEventConsumer(this.transactionCoordinatorService);
        }
        AtomicInteger atomic = new AtomicInteger();
        ThreadFactory threadFactory = thread -> new Thread(new ThreadGroup("Mule-disruptor"), thread, "Mule\u5f02\u6b65\u6267\u884c\u7ebf\u7a0b-" + atomic.incrementAndGet());
        this.disruptor = new Disruptor(DefaultEventFactory.factory(), bufferSize, threadFactory, ProducerType.MULTI, (WaitStrategy)new BlockingWaitStrategy());
        this.disruptor.handleEventsWithWorkerPool(consumers);
        this.disruptor.setDefaultExceptionHandler((ExceptionHandler)this);
        this.producer = new Producer(this.disruptor.getRingBuffer());
        this.disruptor.start();
    }

    protected final void submit(EventTypeEnum eventType, Object ... args) {
        DisruptorTransactionEvent transactionEvent = new DisruptorTransactionEvent();
        transactionEvent.setEventType(eventType);
        transactionEvent.setArgs(args);
        this.producer.submit((Object)transactionEvent);
    }

    public void handleOnStartException(Throwable ex) {
        LogKit.error((Logger)log, (String)"Disruptor \u542f\u52a8\u65f6\u51fa\u73b0\u4f8b\u5916...", (Throwable)ex);
    }

    public void handleEventException(Throwable ex, long sequence, Event<DisruptorTransactionEvent> event) {
        LogKit.error((Logger)log, (String)"Disruptor \u5f02\u6b65\u7ebf\u7a0b\u5904\u7406\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef...\n\u5904\u7406\u4e8b\u4ef6\u53c2\u6570:{}", event, (Object)ex);
    }

    public void handleOnShutdownException(Throwable ex) {
        LogKit.error((Logger)log, (String)"Disruptor \u5173\u95ed\u65f6\u51fa\u73b0\u4f8b\u5916...", (Throwable)ex);
    }

    @Override
    public boolean support(TransactionHandlerService obj) {
        return true;
    }

    @Override
    public int order() {
        return 0;
    }

    @Override
    public String componentName() {
        return "Disruptor \u5f02\u6b65\u7ebf\u7a0b\u961f\u5217";
    }

    @Override
    public final void shutdown() {
        LogKit.debug((Logger)log, (String)"Disruptor \u505c\u6b62\u63a5\u6536\u65b0\u7684\u6d88\u606f...");
        LogKit.debug((Logger)log, (String)"Disruptor \u5f00\u59cb\u5904\u7406\u5185\u90e8\u5269\u4f59\u6d88\u606f...");
        this.disruptor.shutdown();
        LogKit.debug((Logger)log, (String)"Disruptor \u5173\u95ed\u6210\u529f...");
    }
}

