/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.mule.tccTransaction;

import net.lulihu.ObjectKit.LogKit;
import net.lulihu.mule.tccTransaction.MuleTccConfig;
import net.lulihu.mule.tccTransaction.MuleTccShutdownManage;
import net.lulihu.mule.tccTransaction.banner.MuleTccBanner;
import net.lulihu.mule.tccTransaction.service.MuleTccBootService;
import net.lulihu.mule.tccTransaction.service.factory.TransactionFactoryComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleTccTransactionBootApplication {
    private static final Logger log = LoggerFactory.getLogger(MuleTccTransactionBootApplication.class);
    private final MuleTccBootService muleTccBootService;
    private final MuleTccConfig muleTccConfig;

    public MuleTccTransactionBootApplication(MuleTccBootService muleTccBootService, MuleTccConfig muleTccConfig) {
        this.muleTccBootService = muleTccBootService;
        this.muleTccConfig = muleTccConfig;
        Runtime.getRuntime().addShutdownHook(new Thread(MuleTccShutdownManage.getInstance()::startShutdown, "Mule Tcc \u5173\u95ed\u7a0b\u5e8f"));
    }

    public void start() {
        MuleTccBanner.banner();
        LogKit.info((Logger)log, (String)"Mule Tcc \u5206\u5e03\u5f0f\u4e8b\u52a1\u534f\u8c03\u5668 \u5f00\u59cb\u542f\u52a8...");
        try {
            this.muleTccBootService.initialization(this.muleTccConfig);
            TransactionFactoryComponent.startFactory();
            LogKit.info((Logger)log, (String)"Mule Tcc \u5206\u5e03\u5f0f\u4e8b\u52a1\u534f\u8c03\u5668 \u542f\u52a8\u6210\u529f...");
        }
        catch (Throwable e) {
            LogKit.error((Logger)log, (String)"\u521d\u59cb\u5316Mule Tcc\u5931\u8d25", (Throwable)e);
            System.exit(-1);
        }
    }
}

