/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.materialprogressbar;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.graphics.ColorUtils;
import android.util.Log;
import me.zhanghai.android.materialprogressbar.HorizontalProgressBackgroundDrawable;
import me.zhanghai.android.materialprogressbar.IntrinsicPaddingDrawable;
import me.zhanghai.android.materialprogressbar.R;
import me.zhanghai.android.materialprogressbar.ShowBackgroundDrawable;
import me.zhanghai.android.materialprogressbar.SingleHorizontalProgressDrawable;
import me.zhanghai.android.materialprogressbar.TintableDrawable;
import me.zhanghai.android.materialprogressbar.internal.ThemeUtils;

public class HorizontalProgressDrawable
extends LayerDrawable
implements IntrinsicPaddingDrawable,
ShowBackgroundDrawable,
TintableDrawable {
    private static final String TAG = HorizontalProgressDrawable.class.getSimpleName();
    private float mBackgroundAlpha;
    private HorizontalProgressBackgroundDrawable mBackgroundDrawable;
    private SingleHorizontalProgressDrawable mSecondaryProgressDrawable;
    private SingleHorizontalProgressDrawable mProgressDrawable;
    private boolean mHasSecondaryProgressTint;
    private ColorStateList mSecondaryProgressTint;
    private boolean mHasSecondaryProgressTintColor;
    private int mSecondaryProgressTintColor;

    public HorizontalProgressDrawable(Context context) {
        super(new Drawable[]{new HorizontalProgressBackgroundDrawable(context), new SingleHorizontalProgressDrawable(context), new SingleHorizontalProgressDrawable(context)});
        this.mBackgroundAlpha = ThemeUtils.getFloatFromAttrRes(0x1010033, context);
        this.setId(0, 0x1020000);
        this.mBackgroundDrawable = (HorizontalProgressBackgroundDrawable)this.getDrawable(0);
        this.setId(1, 16908303);
        this.mSecondaryProgressDrawable = (SingleHorizontalProgressDrawable)this.getDrawable(1);
        this.setId(2, 16908301);
        this.mProgressDrawable = (SingleHorizontalProgressDrawable)this.getDrawable(2);
        int controlActivatedColor = ThemeUtils.getColorFromAttrRes(R.attr.colorControlActivated, context);
        this.setTint(controlActivatedColor);
    }

    @Override
    public boolean getShowBackground() {
        return this.mBackgroundDrawable.getShowBackground();
    }

    @Override
    public void setShowBackground(boolean show) {
        if (this.mBackgroundDrawable.getShowBackground() != show) {
            this.mBackgroundDrawable.setShowBackground(show);
            this.updateSecondaryProgressTint();
        }
    }

    @Override
    public boolean getUseIntrinsicPadding() {
        return this.mBackgroundDrawable.getUseIntrinsicPadding();
    }

    @Override
    public void setUseIntrinsicPadding(boolean useIntrinsicPadding) {
        this.mBackgroundDrawable.setUseIntrinsicPadding(useIntrinsicPadding);
        this.mSecondaryProgressDrawable.setUseIntrinsicPadding(useIntrinsicPadding);
        this.mProgressDrawable.setUseIntrinsicPadding(useIntrinsicPadding);
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void setTint(@ColorInt int tintColor) {
        int backgroundTintColor = ColorUtils.setAlphaComponent((int)tintColor, (int)Math.round((float)Color.alpha((int)tintColor) * this.mBackgroundAlpha));
        this.mBackgroundDrawable.setTint(backgroundTintColor);
        this.setSecondaryProgressTint(backgroundTintColor);
        this.mProgressDrawable.setTint(tintColor);
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void setTintList(@Nullable ColorStateList tint) {
        ColorStateList backgroundTint;
        if (tint != null) {
            if (!tint.isOpaque()) {
                Log.w((String)TAG, (String)"setTintList() called with a non-opaque ColorStateList, its original alpha will be discarded");
            }
            backgroundTint = tint.withAlpha(Math.round(255.0f * this.mBackgroundAlpha));
        } else {
            backgroundTint = null;
        }
        this.mBackgroundDrawable.setTintList(backgroundTint);
        this.setSecondaryProgressTintList(backgroundTint);
        this.mProgressDrawable.setTintList(tint);
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void setTintMode(@NonNull PorterDuff.Mode tintMode) {
        this.mBackgroundDrawable.setTintMode(tintMode);
        this.mSecondaryProgressDrawable.setTintMode(tintMode);
        this.mProgressDrawable.setTintMode(tintMode);
    }

    private void setSecondaryProgressTint(int tintColor) {
        this.mHasSecondaryProgressTintColor = true;
        this.mSecondaryProgressTintColor = tintColor;
        this.mHasSecondaryProgressTint = false;
        this.updateSecondaryProgressTint();
    }

    private void setSecondaryProgressTintList(ColorStateList tint) {
        this.mHasSecondaryProgressTintColor = false;
        this.mHasSecondaryProgressTint = true;
        this.mSecondaryProgressTint = tint;
        this.updateSecondaryProgressTint();
    }

    @SuppressLint(value={"NewApi"})
    private void updateSecondaryProgressTint() {
        if (this.mHasSecondaryProgressTintColor) {
            int tintColor = this.mSecondaryProgressTintColor;
            if (!this.getShowBackground()) {
                float backgroundAlpha = (float)Color.alpha((int)tintColor) / 255.0f;
                tintColor = ColorUtils.setAlphaComponent((int)tintColor, (int)Math.round(255.0f * this.compositeAlpha(backgroundAlpha, backgroundAlpha)));
            }
            this.mSecondaryProgressDrawable.setTint(tintColor);
        } else if (this.mHasSecondaryProgressTint) {
            ColorStateList tint = this.mSecondaryProgressTint;
            if (!this.getShowBackground()) {
                tint = tint.withAlpha(Math.round(255.0f * this.compositeAlpha(this.mBackgroundAlpha, this.mBackgroundAlpha)));
            }
            this.mSecondaryProgressDrawable.setTintList(tint);
        }
    }

    private float compositeAlpha(float alpha1, float alpha2) {
        return alpha1 + alpha2 * (1.0f - alpha1);
    }
}

