/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.materialprogressbar;

import android.animation.Animator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Animatable;
import me.zhanghai.android.materialprogressbar.BaseProgressDrawable;
import me.zhanghai.android.materialprogressbar.R;
import me.zhanghai.android.materialprogressbar.internal.ThemeUtils;

abstract class BaseIndeterminateProgressDrawable
extends BaseProgressDrawable
implements Animatable {
    protected Animator[] mAnimators;

    @SuppressLint(value={"NewApi"})
    public BaseIndeterminateProgressDrawable(Context context) {
        int controlActivatedColor = ThemeUtils.getColorFromAttrRes(R.attr.colorControlActivated, context);
        this.setTint(controlActivatedColor);
    }

    @Override
    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.isStarted()) {
            this.invalidateSelf();
        }
    }

    public void start() {
        if (this.isStarted()) {
            return;
        }
        for (Animator animator : this.mAnimators) {
            animator.start();
        }
        this.invalidateSelf();
    }

    private boolean isStarted() {
        for (Animator animator : this.mAnimators) {
            if (!animator.isStarted()) continue;
            return true;
        }
        return false;
    }

    public void stop() {
        for (Animator animator : this.mAnimators) {
            animator.end();
        }
    }

    public boolean isRunning() {
        for (Animator animator : this.mAnimators) {
            if (!animator.isRunning()) continue;
            return true;
        }
        return false;
    }
}

