/*
 * Decompiled with CFR 0.152.
 */
package icu.qimuu.qiapisdk.service;

import cn.hutool.crypto.SecureUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.json.JSONUtil;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import icu.qimuu.qiapisdk.client.QiApiClient;
import icu.qimuu.qiapisdk.exception.ApiException;
import icu.qimuu.qiapisdk.exception.ErrorCode;
import icu.qimuu.qiapisdk.exception.ErrorResponse;
import icu.qimuu.qiapisdk.model.request.BaseRequest;
import icu.qimuu.qiapisdk.model.response.ResultResponse;
import icu.qimuu.qiapisdk.service.ApiService;
import icu.qimuu.qiapisdk.utils.SignUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseService
implements ApiService {
    private static final Logger log = LoggerFactory.getLogger(BaseService.class);
    private QiApiClient qiApiClient;
    private String gatewayHost = "https://gateway.qimuu.icu/api";

    public void checkConfig(QiApiClient qiApiClient) throws ApiException {
        if (qiApiClient == null && this.getQiApiClient() == null) {
            throw new ApiException(ErrorCode.NO_AUTH_ERROR, "\u8bf7\u5148\u914d\u7f6e\u5bc6\u94a5AccessKey/SecretKey");
        }
        if (qiApiClient != null && !StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{qiApiClient.getAccessKey(), qiApiClient.getSecretKey()})) {
            this.setQiApiClient(qiApiClient);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <O, T extends ResultResponse> HttpResponse doRequest(BaseRequest<O, T> request) throws ApiException {
        try (HttpResponse httpResponse = this.getHttpRequestByRequestMethod(request).execute();){
            HttpResponse httpResponse2 = httpResponse;
            return httpResponse2;
        }
        catch (Exception e) {
            throw new ApiException(ErrorCode.OPERATION_ERROR, e.getMessage());
        }
    }

    private <O, T extends ResultResponse> HttpRequest getHttpRequestByRequestMethod(BaseRequest<O, T> request) throws ApiException {
        HttpRequest httpRequest;
        if (ObjectUtils.isEmpty(request)) {
            throw new ApiException(ErrorCode.OPERATION_ERROR, "\u8bf7\u6c42\u53c2\u6570\u9519\u8bef");
        }
        String path = request.getPath().trim();
        String method = request.getMethod().trim().toUpperCase();
        if (ObjectUtils.isEmpty((Object)method)) {
            throw new ApiException(ErrorCode.OPERATION_ERROR, "\u8bf7\u6c42\u65b9\u6cd5\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new ApiException(ErrorCode.OPERATION_ERROR, "\u8bf7\u6c42\u8def\u5f84\u4e0d\u5b58\u5728");
        }
        if (path.startsWith(this.gatewayHost)) {
            path = path.substring(this.gatewayHost.length());
        }
        log.info("\u8bf7\u6c42\u65b9\u6cd5\uff1a{}\uff0c\u8bf7\u6c42\u8def\u5f84\uff1a{}\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", new Object[]{method, path, request.getRequestParams()});
        switch (method) {
            case "GET": {
                httpRequest = HttpRequest.get((String)this.splicingGetRequest(request, path));
                break;
            }
            case "POST": {
                httpRequest = HttpRequest.post((String)(this.gatewayHost + path));
                break;
            }
            default: {
                throw new ApiException(ErrorCode.OPERATION_ERROR, "\u4e0d\u652f\u6301\u8be5\u8bf7\u6c42");
            }
        }
        return ((HttpRequest)httpRequest.addHeaders(this.getHeaders(JSONUtil.toJsonStr(request), this.qiApiClient))).body(JSONUtil.toJsonStr(request.getRequestParams()));
    }

    public <O, T extends ResultResponse> T res(BaseRequest<O, T> request) throws ApiException {
        ResultResponse rsp;
        if (this.qiApiClient == null || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.qiApiClient.getAccessKey(), this.qiApiClient.getSecretKey()})) {
            throw new ApiException(ErrorCode.NO_AUTH_ERROR, "\u8bf7\u5148\u914d\u7f6e\u5bc6\u94a5AccessKey/SecretKey");
        }
        try {
            Class<T> clazz = request.getResponseClass();
            rsp = (ResultResponse)clazz.newInstance();
        }
        catch (Exception e) {
            throw new ApiException(ErrorCode.OPERATION_ERROR, e.getMessage());
        }
        HttpResponse httpResponse = this.doRequest(request);
        String body = httpResponse.body();
        Map<String, Object> data = new HashMap<String, Object>();
        if (httpResponse.getStatus() != 200) {
            ErrorResponse errorResponse = (ErrorResponse)JSONUtil.toBean((String)body, ErrorResponse.class);
            data.put("errorMessage", errorResponse.getMessage());
            data.put("code", errorResponse.getCode());
        } else {
            try {
                data = (Map)new Gson().fromJson(body, new TypeToken<Map<String, Object>>(){}.getType());
            }
            catch (JsonSyntaxException e) {
                data.put("value", body);
            }
        }
        rsp.setData(data);
        return (T)rsp;
    }

    private <O, T extends ResultResponse> String splicingGetRequest(BaseRequest<O, T> request, String path) {
        StringBuilder urlBuilder = new StringBuilder(this.gatewayHost);
        if (urlBuilder.toString().endsWith("/") && path.startsWith("/")) {
            urlBuilder.setLength(urlBuilder.length() - 1);
        }
        urlBuilder.append(path);
        if (!request.getRequestParams().isEmpty()) {
            urlBuilder.append("?");
            for (Map.Entry<String, Object> entry : request.getRequestParams().entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue().toString();
                urlBuilder.append(key).append("=").append(value).append("&");
            }
            urlBuilder.deleteCharAt(urlBuilder.length() - 1);
        }
        log.info("GET\u8bf7\u6c42\u8def\u5f84\uff1a{}", (Object)urlBuilder);
        return urlBuilder.toString();
    }

    private Map<String, String> getHeaders(String body, QiApiClient qiApiClient) {
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        hashMap.put("accessKey", qiApiClient.getAccessKey());
        String encodedBody = SecureUtil.md5((String)body);
        hashMap.put("body", encodedBody);
        hashMap.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        hashMap.put("sign", SignUtils.getSign(encodedBody, qiApiClient.getSecretKey()));
        return hashMap;
    }

    @Override
    public <O, T extends ResultResponse> T request(BaseRequest<O, T> request) throws ApiException {
        try {
            return this.res(request);
        }
        catch (Exception e) {
            throw new ApiException(ErrorCode.OPERATION_ERROR, e.getMessage());
        }
    }

    @Override
    public <O, T extends ResultResponse> T request(QiApiClient qiApiClient, BaseRequest<O, T> request) throws ApiException {
        this.checkConfig(qiApiClient);
        return this.request(request);
    }

    public QiApiClient getQiApiClient() {
        return this.qiApiClient;
    }

    public String getGatewayHost() {
        return this.gatewayHost;
    }

    public void setQiApiClient(QiApiClient qiApiClient) {
        this.qiApiClient = qiApiClient;
    }

    public void setGatewayHost(String gatewayHost) {
        this.gatewayHost = gatewayHost;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseService)) {
            return false;
        }
        BaseService other = (BaseService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        QiApiClient this$qiApiClient = this.getQiApiClient();
        QiApiClient other$qiApiClient = other.getQiApiClient();
        if (this$qiApiClient == null ? other$qiApiClient != null : !((Object)this$qiApiClient).equals(other$qiApiClient)) {
            return false;
        }
        String this$gatewayHost = this.getGatewayHost();
        String other$gatewayHost = other.getGatewayHost();
        return !(this$gatewayHost == null ? other$gatewayHost != null : !this$gatewayHost.equals(other$gatewayHost));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseService;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        QiApiClient $qiApiClient = this.getQiApiClient();
        result = result * 59 + ($qiApiClient == null ? 43 : ((Object)$qiApiClient).hashCode());
        String $gatewayHost = this.getGatewayHost();
        result = result * 59 + ($gatewayHost == null ? 43 : $gatewayHost.hashCode());
        return result;
    }

    public String toString() {
        return "BaseService(qiApiClient=" + this.getQiApiClient() + ", gatewayHost=" + this.getGatewayHost() + ")";
    }
}

