/*
 * Decompiled with CFR 0.152.
 */
package icu.qimuu.qiapisdk.config;

import icu.qimuu.qiapisdk.client.QiApiClient;
import icu.qimuu.qiapisdk.service.ApiService;
import icu.qimuu.qiapisdk.service.impi.ApiServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(value="qi.api.client")
@ComponentScan
public class QiApiClientConfig {
    private String accessKey;
    private String secretKey;
    private String host;

    @Bean
    public QiApiClient qiApiClient() {
        return new QiApiClient(this.accessKey, this.secretKey);
    }

    @Bean
    public ApiService apiService() {
        ApiServiceImpl apiService = new ApiServiceImpl();
        apiService.setQiApiClient(new QiApiClient(this.accessKey, this.secretKey));
        if (StringUtils.isNotBlank((CharSequence)this.host)) {
            apiService.setGatewayHost(this.host);
        }
        return apiService;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getHost() {
        return this.host;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QiApiClientConfig)) {
            return false;
        }
        QiApiClientConfig other = (QiApiClientConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$accessKey = this.getAccessKey();
        String other$accessKey = other.getAccessKey();
        if (this$accessKey == null ? other$accessKey != null : !this$accessKey.equals(other$accessKey)) {
            return false;
        }
        String this$secretKey = this.getSecretKey();
        String other$secretKey = other.getSecretKey();
        if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        return !(this$host == null ? other$host != null : !this$host.equals(other$host));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QiApiClientConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $accessKey = this.getAccessKey();
        result = result * 59 + ($accessKey == null ? 43 : $accessKey.hashCode());
        String $secretKey = this.getSecretKey();
        result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        return result;
    }

    public String toString() {
        return "QiApiClientConfig(accessKey=" + this.getAccessKey() + ", secretKey=" + this.getSecretKey() + ", host=" + this.getHost() + ")";
    }
}

