/*
 * Decompiled with CFR 0.152.
 */
package com.uhf.api.cls;

import com.uhf.api.cls.BackReadOption;
import com.uhf.api.cls.ErrInfo;
import com.uhf.api.cls.GPITrigger;
import com.uhf.api.cls.GpiInfo_ST;
import com.uhf.api.cls.GpiTriggerBoundaryListener;
import com.uhf.api.cls.GpiTriggerBoundaryReasonType;
import com.uhf.api.cls.GpiTriggerBoundaryType;
import com.uhf.api.cls.GpiTriggerListener;
import com.uhf.api.cls.GpiTrigger_Type;
import com.uhf.api.cls.JniModuleAPI;
import com.uhf.api.cls.ReadExceptionListener;
import com.uhf.api.cls.ReadListener;
import java.util.List;
import java.util.Vector;

public class Reader {
    public static final int MAXANTCNT = 16;
    public static final int MAXIPSTRLEN = 50;
    public static final int HOPTABLECNT = 100;
    public static final int MAXEPCBYTESCNT = 62;
    public static final int MAXEMBDATALEN = 128;
    public static final int MAXINVPOTLSCNT = 6;
    private final int JniBytesBufferLength = 500;
    JniModuleAPI japi;
    int[] hReader;
    int m_gError;
    String addr;
    Thread m_ThreadForAll;
    long m_ThreadForAllid;
    boolean m_IsReadingForAll;
    boolean m_IsReadThRunning;
    BackReadOption m_BackReadOp;
    int m_FastReadOption;
    int[] m_BackReadAnts = new int[16];
    int m_BackReadAntsCnt;
    protected List<ReadListener> readListeners;
    protected List<ReadExceptionListener> readExceptionListeners;
    protected List<GpiTriggerListener> gpitriListener;
    protected List<GpiTriggerBoundaryListener> gpitriboundListener;

    private void CLOGS() {
    }

    private void ALOGS(String mess) {
    }

    public Reader() {
        this.hReader = new int[1];
        this.japi = new JniModuleAPI();
        this.readListeners = new Vector<ReadListener>();
        this.readExceptionListeners = new Vector<ReadExceptionListener>();
        this.gpitriListener = new Vector<GpiTriggerListener>();
        this.gpitriboundListener = new Vector<GpiTriggerBoundaryListener>();
    }

    public void Hex2Str(byte[] buf, int len, char[] out) {
        char[] hexc = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int i = 0;
        while (i < len) {
            out[i * 2] = hexc[(buf[i] & 0xFF) / 16];
            out[i * 2 + 1] = hexc[(buf[i] & 0xFF) % 16];
            ++i;
        }
    }

    private char[] bytestochars(byte[] bdata) {
        char[] cdata = new char[bdata.length];
        int i = 0;
        while (i < bdata.length) {
            cdata[i] = (char)bdata[i];
            ++i;
        }
        return cdata;
    }

    private byte[] charstobytes(char[] cdata) {
        if (cdata == null) {
            return null;
        }
        int len = 0;
        int i = 0;
        while (i < cdata.length) {
            if (cdata[i] == '\u0000') break;
            ++len;
            ++i;
        }
        byte[] bdata = new byte[len];
        i = 0;
        while (i < len) {
            bdata[i] = (byte)cdata[i];
            ++i;
        }
        return bdata;
    }

    public READER_ERR InitReader(String src, Reader_Type rtype) {
        int re = this.japi.InitReader(this.hReader, src, rtype.value());
        READER_ERR ERR = READER_ERR.valueOf(re);
        return ERR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR InitReader_Notype(String src, int rtype) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.InitReader_Notype(this.hReader, src, rtype);
            READER_ERR ERR = READER_ERR.valueOf(re);
            if (ERR == READER_ERR.MT_OK_ERR) {
                this.addr = src;
            }
            return ERR;
        }
    }

    public String GetReaderAddress() {
        return this.addr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR GetHardwareDetails(HardwareDetails val) {
        Reader reader = this;
        synchronized (reader) {
            byte[] data = new byte[500];
            int re = this.japi.GetHardwareDetails_BaseType(this.hReader[0], data);
            READER_ERR ERR = READER_ERR.valueOf(re);
            if (ERR == READER_ERR.MT_OK_ERR) {
                val.module = Module_Type.valueOf(data[0]);
                switch (data[1]) {
                    case 0: {
                        val.board = MaindBoard_Type.MAINBOARD_NONE;
                        break;
                    }
                    case 1: {
                        val.board = MaindBoard_Type.MAINBOARD_ARM7;
                        break;
                    }
                    case 2: {
                        val.board = MaindBoard_Type.MAINBOARD_SERIAL;
                        break;
                    }
                    case 3: {
                        val.board = MaindBoard_Type.MAINBOARD_WIFI;
                        break;
                    }
                    case 4: {
                        val.board = MaindBoard_Type.MAINBOARD_ARM9;
                        break;
                    }
                    case 5: {
                        val.board = MaindBoard_Type.MAINBOARD_ARM9_WIFI;
                    }
                }
                val.logictype = Reader_Type.valueOf(data[2]);
            }
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void CloseReader() {
        Reader reader = this;
        synchronized (reader) {
            this.japi.CloseReader(this.hReader[0]);
            this.addr = "";
            this.hReader[0] = 0;
            this.readListeners.clear();
            this.readExceptionListeners.clear();
            this.gpitriListener.clear();
            this.gpitriboundListener.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR GetTagData(int ant, char bank, int address, int blkcnt, byte[] data, byte[] accesspasswd, short timeout) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.GetTagData(this.hReader[0], ant, bank, address, blkcnt, data, accesspasswd, timeout);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR WriteTagData(int ant, char bank, int address, byte[] data, int datalen, byte[] accesspasswd, short timeout) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.WriteTagData(this.hReader[0], ant, bank, address, data, datalen, accesspasswd, timeout);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR WriteTagEpcEx(int ant, byte[] Epc, int epclen, byte[] accesspwd, short timeout) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.WriteTagEpcEx(this.hReader[0], ant, Epc, epclen, accesspwd, timeout);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR TagInventory(int[] ants, int antcnt, short timeout, TAGINFO[] pTInfo, int[] tagcnt) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.TagInventory_Raw(this.hReader[0], ants, antcnt, timeout, tagcnt);
            READER_ERR ERR = READER_ERR.valueOf(re);
            if (ERR == READER_ERR.MT_OK_ERR) {
                int i = 0;
                while (i < tagcnt[0]) {
                    TAGINFO pTInfoa = new TAGINFO();
                    READER_ERR er = this.GetNextTag(pTInfoa);
                    if (er == READER_ERR.MT_OK_ERR) {
                        pTInfo[i] = pTInfoa;
                    }
                    ++i;
                }
            }
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR TagInventory_Raw(int[] ants, int antcnt, short timeout, int[] tagcnt) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.TagInventory_Raw(this.hReader[0], ants, antcnt, timeout, tagcnt);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR TagInventory_BaseType(int[] ants, int antcnt, short timeout, byte[] outbuf, int[] tagcnt) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.TagInventory_BaseType(this.hReader[0], ants, antcnt, timeout, outbuf, tagcnt);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR GetNextTag(TAGINFO TI) {
        Reader reader = this;
        synchronized (reader) {
            byte[] tagbuf = new byte[230];
            int pos = 0;
            int re = this.japi.GetNextTag_BaseType(this.hReader[0], tagbuf);
            READER_ERR ERR = READER_ERR.valueOf(re);
            if (ERR == READER_ERR.MT_OK_ERR) {
                TI.ReadCnt = tagbuf[pos++];
                TI.RSSI = tagbuf[pos++];
                TI.AntennaID = tagbuf[pos++];
                TI.Frequency = (tagbuf[pos] & 0xFF) << 24 | (tagbuf[pos + 1] & 0xFF) << 16 | (tagbuf[pos + 2] & 0xFF) << 8 | tagbuf[pos + 3] & 0xFF;
                TI.TimeStamp = tagbuf[pos += 4] << 24 | tagbuf[pos + 1] << 16 | tagbuf[pos + 2] << 8 | tagbuf[pos + 3];
                pos += 4;
                TI.Res[0] = tagbuf[pos++];
                TI.Res[1] = tagbuf[pos++];
                int epclen = tagbuf[pos] << 8 | tagbuf[pos + 1];
                pos += 2;
                TI.PC[0] = tagbuf[pos++];
                TI.PC[1] = tagbuf[pos++];
                TI.EpcId = new byte[epclen];
                TI.Epclen = (short)epclen;
                System.arraycopy(tagbuf, pos, TI.EpcId, 0, epclen);
                pos += epclen;
                TI.CRC[0] = tagbuf[pos++];
                TI.CRC[1] = tagbuf[pos++];
                int emddatalen = tagbuf[pos] << 8 | tagbuf[pos + 1];
                pos += 2;
                TI.EmbededData = new byte[emddatalen];
                TI.EmbededDatalen = (short)emddatalen;
                if (emddatalen > 0) {
                    System.arraycopy(tagbuf, pos, TI.EmbededData, 0, emddatalen);
                }
            }
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR GetNextTag_BaseType(byte[] outbuf) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.GetNextTag_BaseType(this.hReader[0], outbuf);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR LockTag(int ant, byte lockobjects, short locktypes, byte[] accesspasswd, short timeout) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.LockTag(this.hReader[0], ant, lockobjects, locktypes, accesspasswd, timeout);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR KillTag(int ant, byte[] killpasswd, short timeout) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.KillTag(this.hReader[0], ant, killpasswd, timeout);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR Lock180006BTag(int ant, int startblk, int blkcnt, short timeout) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.Lock180006BTag(this.hReader[0], ant, startblk, blkcnt, timeout);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR BlockPermaLock(int ant, int readlock, int startblk, int blkrange, byte[] mask, byte[] pwd, short timeout) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.BlockPermaLock(this.hReader[0], ant, readlock, startblk, blkrange, mask, pwd, timeout);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR BlockErase(int ant, int bank, int wordaddr, int wordcnt, byte[] pwd, short timeout) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.BlockErase(this.hReader[0], ant, bank, wordaddr, wordcnt, pwd, timeout);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR EraseDataOnReader() {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.EraseDataOnReader(this.hReader[0]);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR SaveDataOnReader(int address, byte[] data, int datalen) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.SaveDataOnReader(this.hReader[0], address, data, datalen);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR ReadDataOnReader(int address, byte[] data, int datalen) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.ReadDataOnReader(this.hReader[0], address, data, datalen);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR CustomCmd(int ant, CustomCmdType cmdtype, Object CustomPara, Object CustomRet) {
        Reader reader = this;
        synchronized (reader) {
            byte[] para = null;
            byte[] ret = null;
            switch (cmdtype) {
                case IMPINJ_M4_Qt: {
                    Object CustomPara2 = (IMPINJM4QtPara)CustomPara;
                    para = new byte[22];
                    ret = new byte[10];
                    System.arraycopy(((IMPINJM4QtPara)CustomPara2).AccessPwd, 0, para, 0, 4);
                    para[4] = (byte)((((IMPINJM4QtPara)CustomPara2).CmdType & 0xFF000000) >> 24);
                    para[5] = (byte)((((IMPINJM4QtPara)CustomPara2).CmdType & 0xFF0000) >> 16);
                    para[6] = (byte)((((IMPINJM4QtPara)CustomPara2).CmdType & 0xFF00) >> 8);
                    para[7] = (byte)(((IMPINJM4QtPara)CustomPara2).CmdType & 0xFF);
                    para[8] = (byte)((((IMPINJM4QtPara)CustomPara2).MemType & 0xFF000000) >> 24);
                    para[9] = (byte)((((IMPINJM4QtPara)CustomPara2).MemType & 0xFF0000) >> 16);
                    para[10] = (byte)((((IMPINJM4QtPara)CustomPara2).MemType & 0xFF00) >> 8);
                    para[11] = (byte)(((IMPINJM4QtPara)CustomPara2).MemType & 0xFF);
                    para[12] = (byte)((((IMPINJM4QtPara)CustomPara2).PersistType & 0xFF000000) >> 24);
                    para[13] = (byte)((((IMPINJM4QtPara)CustomPara2).PersistType & 0xFF0000) >> 16);
                    para[14] = (byte)((((IMPINJM4QtPara)CustomPara2).PersistType & 0xFF00) >> 8);
                    para[15] = (byte)(((IMPINJM4QtPara)CustomPara2).PersistType & 0xFF);
                    para[16] = (byte)((((IMPINJM4QtPara)CustomPara2).RangeType & 0xFF000000) >> 24);
                    para[17] = (byte)((((IMPINJM4QtPara)CustomPara2).RangeType & 0xFF0000) >> 16);
                    para[18] = (byte)((((IMPINJM4QtPara)CustomPara2).RangeType & 0xFF00) >> 8);
                    para[19] = (byte)(((IMPINJM4QtPara)CustomPara2).RangeType & 0xFF);
                    para[20] = (byte)((((IMPINJM4QtPara)CustomPara2).TimeOut & 0xFF00) >> 8);
                    para[21] = (byte)(((IMPINJM4QtPara)CustomPara2).TimeOut & 0xFF);
                    break;
                }
                case ALIEN_Higgs3_BlockReadLock: {
                    para = new byte[7];
                    ret = new byte[7];
                    Object CustomPara2 = (ALIENHiggs3BlockReadLockPara)CustomPara;
                    System.arraycopy(((ALIENHiggs3BlockReadLockPara)CustomPara2).AccessPwd, 0, para, 0, 4);
                    para[4] = ((ALIENHiggs3BlockReadLockPara)CustomPara2).BlkBits;
                    para[5] = (byte)((((ALIENHiggs3BlockReadLockPara)CustomPara2).TimeOut & 0xFF00) >> 8);
                    para[6] = (byte)(((ALIENHiggs3BlockReadLockPara)CustomPara2).TimeOut & 0xFF);
                    break;
                }
                case NXP_ChangeEAS: {
                    para = new byte[7];
                    ret = new byte[7];
                    Object CustomPara2 = (NXPChangeEASPara)CustomPara;
                    System.arraycopy(((NXPChangeEASPara)CustomPara2).AccessPwd, 0, para, 0, 4);
                    para[4] = (byte)((NXPChangeEASPara)CustomPara2).isSet;
                    para[5] = (byte)((((NXPChangeEASPara)CustomPara2).TimeOut & 0xFF00) >> 8);
                    para[6] = (byte)(((NXPChangeEASPara)CustomPara2).TimeOut & 0xFF);
                    break;
                }
                case NXP_EASAlarm: {
                    para = new byte[5];
                    ret = new byte[5];
                    Object CustomPara2 = (NXPEASAlarmPara)CustomPara;
                    para[0] = ((NXPEASAlarmPara)CustomPara2).DR;
                    ((NXPEASAlarmPara)CustomPara2).MC = (byte)11;
                    para[1] = 11;
                    para[2] = ((NXPEASAlarmPara)CustomPara2).TrExt;
                    para[3] = (byte)((((NXPEASAlarmPara)CustomPara2).TimeOut & 0xFF00) >> 8);
                    para[4] = (byte)(((NXPEASAlarmPara)CustomPara2).TimeOut & 0xFF);
                    break;
                }
                case NXP_U8_InventoryMode: {
                    NXP_U8_InventoryModePara ctpara = (NXP_U8_InventoryModePara)CustomPara;
                    para = ctpara.Mode;
                    ret = new byte[1];
                    break;
                }
                default: {
                    return READER_ERR.MT_OP_NOT_SUPPORTED;
                }
            }
            int re = this.japi.CustomCmd_BaseType(this.hReader[0], ant, cmdtype.value(), para, ret);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR CustomCmd_BaseType(int ant, int cmdtype, byte[] CustomPara, byte[] CustomRet) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.CustomCmd_BaseType(this.hReader[0], ant, cmdtype, CustomPara, CustomRet);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR SetGPO(int gpoid, int val) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.SetGPO(this.hReader[0], gpoid, val);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR GetGPI(int gpoid, int[] val) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.GetGPI(this.hReader[0], gpoid, val);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR GetGPIEx(GpiInfo_ST gpist) {
        Reader reader = this;
        synchronized (reader) {
            byte[] gpibytes = new byte[500];
            int re = this.japi.GetGPIEx_BaseType(this.hReader[0], gpibytes);
            READER_ERR ERR = READER_ERR.valueOf(re);
            if (ERR == READER_ERR.MT_OK_ERR) {
                gpist.gpiCount = gpibytes[0];
                int i = 0;
                while (i < gpist.gpiCount) {
                    gpist.gpiStats[i].GpiId = gpibytes[1 + 2 * i];
                    gpist.gpiStats[i].State = gpibytes[2 + 2 * i];
                    ++i;
                }
            }
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR PsamTransceiver(int soltid, int coslen, byte[] cos, int[] cosresplen, byte[] cosresp, byte[] errcode, short timeout) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.PsamTransceiver(this.hReader[0], soltid, coslen, cos, cosresplen, cosresp, errcode, timeout);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    private int GetIntFrByteArray(byte[] byarray, int offset) {
        return (byarray[offset] & 0xFF) << 24 | (byarray[offset + 1] & 0xFF) << 16 | (byarray[offset + 2] & 0xFF) << 8 | byarray[offset + 3] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR ParamGet(Mtr_Param key, Object val) {
        Reader reader = this;
        synchronized (reader) {
            int re = -1;
            byte[] data = new byte[500];
            switch (key) {
                case MTR_PARAM_RF_ANTPOWER: {
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), data);
                    if (re != 0) break;
                    ((AntPowerConf)val).antcnt = data[0];
                    int i = 0;
                    while (i < data[0]) {
                        AntPower apcf = new AntPower();
                        apcf.antid = data[i * 5 + 1];
                        apcf.readPower = (short)(data[i * 5 + 2] << 8 | data[i * 5 + 3] & 0xFF);
                        apcf.writePower = (short)(data[i * 5 + 4] << 8 | data[i * 5 + 5] & 0xFF);
                        ((AntPowerConf)val).Powers[i] = apcf;
                        ++i;
                    }
                    break;
                }
                case MTR_PARAM_TAG_FILTER: {
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), data);
                    if (re != 0) break;
                    ((TagFilter_ST)val).bank = data[0];
                    ((TagFilter_ST)val).startaddr = (data[1] & 0xFF) << 24 | data[2] << 16 | data[3] << 8 | data[4] & 0xFF;
                    ((TagFilter_ST)val).flen = data[5] << 24 | data[6] << 16 | data[7] << 8 | data[8] & 0xFF;
                    int ilen = ((TagFilter_ST)val).flen / 8;
                    if (((TagFilter_ST)val).flen % 8 != 0) {
                        ++ilen;
                    }
                    System.arraycopy(data, 9, ((TagFilter_ST)val).fdata, 0, ilen);
                    ((TagFilter_ST)val).isInvert = data[9 + ilen];
                    break;
                }
                case MTR_PARAM_TAG_EMBEDEDDATA: {
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), data);
                    if (re != 0) break;
                    ((EmbededData_ST)val).bank = data[1];
                    ((EmbededData_ST)val).startaddr = data[2] << 24 | data[3] << 16 | data[4] << 8 | data[5] & 0xFF;
                    ((EmbededData_ST)val).bytecnt = data[6] << 24 | data[7] << 16 | data[8] << 8 | data[9] & 0xFF;
                    if (data[0] == 14) {
                        System.arraycopy(data, 10, ((EmbededData_ST)val).accesspwd, 0, 4);
                        break;
                    }
                    if (data[0] != 10) break;
                    ((EmbededData_ST)val).accesspwd = null;
                    break;
                }
                case MTR_PARAM_TAG_INVPOTL: {
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), data);
                    if (re != 0) break;
                    ((Inv_Potls_ST)val).potlcnt = data[0];
                    ((Inv_Potls_ST)val).potls = new Inv_Potl[data[0]];
                    int i = 0;
                    while (i < data[0]) {
                        ((Inv_Potls_ST)val).potls[i] = new Inv_Potl();
                        ((Inv_Potls_ST)val).potls[i].potl = SL_TagProtocol.valueOf(data[i * 5 + 1]);
                        ((Inv_Potls_ST)val).potls[i].weight = this.GetIntFrByteArray(data, i * 5 + 2);
                        ++i;
                    }
                    break;
                }
                case MTR_PARAM_READER_CONN_ANTS: {
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), data);
                    if (re != 0) break;
                    ((ConnAnts_ST)val).antcnt = data[0];
                    int i = 0;
                    while (i < data[0]) {
                        ((ConnAnts_ST)val).connectedants[i] = data[i + 1];
                        ++i;
                    }
                    break;
                }
                case MTR_PARAM_READER_VERSION: {
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), data);
                    if (re != 0) break;
                    ReaderVersion rdrver = (ReaderVersion)val;
                    if (data[0] == 1 && data[1] == 0 && data[2] == 0) {
                        rdrver.hardwareVer = String.valueOf(data[0]) + ".";
                        rdrver.hardwareVer = String.valueOf(rdrver.hardwareVer) + data[1] + ".";
                        rdrver.hardwareVer = String.valueOf(rdrver.hardwareVer) + data[2] + ".";
                        rdrver.hardwareVer = String.valueOf(rdrver.hardwareVer) + data[3];
                        rdrver.softwareVer = String.valueOf(data[4]) + ".";
                        rdrver.softwareVer = String.valueOf(rdrver.softwareVer) + data[5] + ".";
                        rdrver.softwareVer = String.valueOf(rdrver.softwareVer) + data[6] + ".";
                        rdrver.softwareVer = String.valueOf(rdrver.softwareVer) + data[7];
                        break;
                    }
                    byte[] v1by = new byte[]{data[0]};
                    rdrver.hardwareVer = String.valueOf(Reader.bytes_Hexstr(v1by)) + ".";
                    v1by[0] = data[1];
                    rdrver.hardwareVer = String.valueOf(rdrver.hardwareVer) + Reader.bytes_Hexstr(v1by) + ".";
                    v1by[0] = data[2];
                    rdrver.hardwareVer = String.valueOf(rdrver.hardwareVer) + Reader.bytes_Hexstr(v1by) + ".";
                    v1by[0] = data[3];
                    rdrver.hardwareVer = String.valueOf(rdrver.hardwareVer) + Reader.bytes_Hexstr(v1by);
                    v1by[0] = data[4];
                    rdrver.softwareVer = String.valueOf(Reader.bytes_Hexstr(v1by)) + ".";
                    v1by[0] = data[5];
                    rdrver.softwareVer = String.valueOf(rdrver.softwareVer) + Reader.bytes_Hexstr(v1by) + ".";
                    v1by[0] = data[6];
                    rdrver.softwareVer = String.valueOf(rdrver.softwareVer) + Reader.bytes_Hexstr(v1by) + ".";
                    v1by[0] = data[7];
                    rdrver.softwareVer = String.valueOf(rdrver.softwareVer) + Reader.bytes_Hexstr(v1by);
                    break;
                }
                case MTR_PARAM_FREQUENCY_REGION: {
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), data);
                    if (re != 0) break;
                    int rgint = (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
                    ((Region_Conf[])val)[0] = Region_Conf.valueOf(rgint);
                    break;
                }
                case MTR_PARAM_FREQUENCY_HOPTABLE: {
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), data);
                    if (re != 0) break;
                    ((HoptableData_ST)val).lenhtb = data[0];
                    int i = 0;
                    while (i < data[0]) {
                        ((HoptableData_ST)val).htb[i] = (data[i * 4 + 1] & 0xFF) << 24 | (data[i * 4 + 2] & 0xFF) << 16 | (data[i * 4 + 3] & 0xFF) << 8 | data[i * 4 + 4] & 0xFF;
                        ++i;
                    }
                    break;
                }
                case MTR_PARAM_RF_ANTPORTS_VSWR: {
                    AntPortsVSWR apvswr = (AntPortsVSWR)val;
                    data[0] = (byte)apvswr.andid;
                    data[1] = (byte)apvswr.region.value();
                    data[2] = (byte)((apvswr.power & 0xFF00) >> 8);
                    data[3] = (byte)(apvswr.power & 0xFF);
                    data[4] = (byte)apvswr.frecount;
                    int i = 0;
                    while (i < apvswr.frecount) {
                        data[5 + i * 4] = (byte)(apvswr.vswrs[i].frequency >> 24 & 0xFF);
                        data[5 + i * 4 + 1] = (byte)(apvswr.vswrs[i].frequency >> 16 & 0xFF);
                        data[5 + i * 4 + 2] = (byte)(apvswr.vswrs[i].frequency >> 8 & 0xFF);
                        data[5 + i * 4 + 3] = (byte)(apvswr.vswrs[i].frequency >> 0 & 0xFF);
                        ++i;
                    }
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), data);
                    if (re != 0) break;
                    apvswr.frecount = data[0];
                    i = 0;
                    while (i < apvswr.frecount) {
                        apvswr.vswrs[i].frequency = (data[1 + i * 5] & 0xFF) << 24 | (data[1 + i * 5 + 1] & 0xFF) << 16 | (data[1 + i * 5 + 2] & 0xFF) << 8 | data[1 + i * 5 + 3] & 0xFF;
                        float rl = (float)Math.pow(10.0, (float)(data[1 + i * 5 + 4] & 0xFF) / 10.0f / 20.0f);
                        apvswr.vswrs[i].vswr = (1.0f + rl) / (rl - 1.0f);
                        ++i;
                    }
                    break;
                }
                case MTR_PARAM_READER_IP: {
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), data);
                    if (re != 0) break;
                    ((Reader_Ip)val).ip = new byte[data[0]];
                    ((Reader_Ip)val).mask = new byte[data[1]];
                    ((Reader_Ip)val).gateway = new byte[data[2]];
                    System.arraycopy(data, 3, ((Reader_Ip)val).ip, 0, data[0]);
                    System.arraycopy(data, 3 + data[0], ((Reader_Ip)val).mask, 0, data[1]);
                    System.arraycopy(data, 3 + data[0] + data[1], ((Reader_Ip)val).gateway, 0, data[2]);
                    break;
                }
                case MTR_PARAM_CUSTOM: {
                    CustomParam_ST cpst = (CustomParam_ST)val;
                    byte[] tmppname = null;
                    try {
                        tmppname = cpst.ParamName.getBytes("US-ASCII");
                    }
                    catch (Exception rl) {
                        // empty catch block
                    }
                    System.arraycopy(tmppname, 0, data, 0, tmppname.length);
                    data[tmppname.length] = 0;
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), data);
                    if (re != 0) break;
                    int CParamlen = (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
                    cpst.ParamVal = new byte[CParamlen - 50];
                    System.arraycopy(data, 50, cpst.ParamVal, 0, CParamlen - 50);
                    break;
                }
                case MTR_PARAM_READER_WATCHDOG: 
                case MTR_PARAM_READER_ERRORDATA: {
                    byte[] retdata = (byte[])val;
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), retdata);
                    break;
                }
                default: {
                    re = this.japi.ParamGet_BaseType(this.hReader[0], key.value(), data);
                    if (re != 0) break;
                    int[] resint = (int[])val;
                    resint[0] = (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
                }
            }
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR ParamSet(Mtr_Param key, Object val) {
        Reader reader = this;
        synchronized (reader) {
            int re = -1;
            byte[] data = new byte[500];
            switch (key) {
                case MTR_PARAM_RF_ANTPOWER: {
                    data[0] = (byte)((AntPowerConf)val).antcnt;
                    int i = 0;
                    while (i < data[0]) {
                        data[i * 5 + 1] = (byte)((AntPowerConf)val).Powers[i].antid;
                        data[i * 5 + 2] = (byte)((((AntPowerConf)val).Powers[i].readPower & 0xFF00) >> 8);
                        data[i * 5 + 3] = (byte)(((AntPowerConf)val).Powers[i].readPower & 0xFF);
                        data[i * 5 + 4] = (byte)((((AntPowerConf)val).Powers[i].writePower & 0xFF00) >> 8);
                        data[i * 5 + 5] = (byte)(((AntPowerConf)val).Powers[i].writePower & 0xFF);
                        ++i;
                    }
                    re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), data);
                    break;
                }
                case MTR_PARAM_TAG_FILTER: {
                    if ((TagFilter_ST)val != null) {
                        data[0] = (byte)((TagFilter_ST)val).bank;
                        data[1] = (byte)((((TagFilter_ST)val).startaddr & 0xFF000000) >> 24);
                        data[2] = (byte)((((TagFilter_ST)val).startaddr & 0xFF0000) >> 16);
                        data[3] = (byte)((((TagFilter_ST)val).startaddr & 0xFF00) >> 8);
                        data[4] = (byte)(((TagFilter_ST)val).startaddr & 0xFF);
                        data[5] = (byte)((((TagFilter_ST)val).flen & 0xFF000000) >> 24);
                        data[6] = (byte)((((TagFilter_ST)val).flen & 0xFF0000) >> 16);
                        data[7] = (byte)((((TagFilter_ST)val).flen & 0xFF00) >> 8);
                        data[8] = (byte)(((TagFilter_ST)val).flen & 0xFF);
                        int ilen = ((TagFilter_ST)val).flen / 8;
                        if (((TagFilter_ST)val).flen % 8 != 0) {
                            ++ilen;
                        }
                        System.arraycopy(((TagFilter_ST)val).fdata, 0, data, 9, ilen);
                        data[9 + ilen] = (byte)((TagFilter_ST)val).isInvert;
                        re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), data);
                        break;
                    }
                    re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), null);
                    break;
                }
                case MTR_PARAM_TAG_EMBEDEDDATA: {
                    if ((EmbededData_ST)val != null) {
                        data[0] = ((EmbededData_ST)val).accesspwd == null ? 10 : 14;
                        data[1] = (byte)((EmbededData_ST)val).bank;
                        data[2] = (byte)((((EmbededData_ST)val).startaddr & 0xFF000000) >> 24);
                        data[3] = (byte)((((EmbededData_ST)val).startaddr & 0xFF0000) >> 16);
                        data[4] = (byte)((((EmbededData_ST)val).startaddr & 0xFF00) >> 8);
                        data[5] = (byte)(((EmbededData_ST)val).startaddr & 0xFF);
                        data[6] = (byte)((((EmbededData_ST)val).bytecnt & 0xFF000000) >> 24);
                        data[7] = (byte)((((EmbededData_ST)val).bytecnt & 0xFF0000) >> 16);
                        data[8] = (byte)((((EmbededData_ST)val).bytecnt & 0xFF00) >> 8);
                        data[9] = (byte)(((EmbededData_ST)val).bytecnt & 0xFF);
                        if (((EmbededData_ST)val).accesspwd != null) {
                            System.arraycopy(((EmbededData_ST)val).accesspwd, 0, data, 10, 4);
                        }
                        re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), data);
                        break;
                    }
                    re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), null);
                    break;
                }
                case MTR_PARAM_TAG_INVPOTL: {
                    data[0] = (byte)((Inv_Potls_ST)val).potlcnt;
                    int i = 0;
                    while (i < data[0]) {
                        data[i * 5 + 1] = (byte)((Inv_Potls_ST)val).potls[i].potl.value();
                        data[i * 5 + 2] = (byte)((((Inv_Potls_ST)val).potls[i].weight & 0xFF000000) >> 24);
                        data[i * 5 + 3] = (byte)((((Inv_Potls_ST)val).potls[i].weight & 0xFF0000) >> 16);
                        data[i * 5 + 4] = (byte)((((Inv_Potls_ST)val).potls[i].weight & 0xFF00) >> 8);
                        data[i * 5 + 5] = (byte)(((Inv_Potls_ST)val).potls[i].weight & 0xFF);
                        ++i;
                    }
                    re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), data);
                    break;
                }
                case MTR_PARAM_FREQUENCY_REGION: {
                    int rgint = ((Region_Conf)((Object)val)).value();
                    data[0] = (byte)((rgint & 0xFF000000) >> 24);
                    data[1] = (byte)((rgint & 0xFF0000) >> 16);
                    data[2] = (byte)((rgint & 0xFF00) >> 8);
                    data[3] = (byte)(rgint & 0xFF);
                    re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), data);
                    break;
                }
                case MTR_PARAM_FREQUENCY_HOPTABLE: {
                    data[0] = (byte)((HoptableData_ST)val).lenhtb;
                    int i = 0;
                    while (i < data[0]) {
                        data[i * 4 + 1] = (byte)((((HoptableData_ST)val).htb[i] & 0xFF000000) >> 24);
                        data[i * 4 + 2] = (byte)((((HoptableData_ST)val).htb[i] & 0xFF0000) >> 16);
                        data[i * 4 + 3] = (byte)((((HoptableData_ST)val).htb[i] & 0xFF00) >> 8);
                        data[i * 4 + 4] = (byte)(((HoptableData_ST)val).htb[i] & 0xFF);
                        ++i;
                    }
                    re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), data);
                    break;
                }
                case MTR_PARAM_READER_IP: {
                    int ipl = ((Reader_Ip)val).ip.length;
                    int ml = ((Reader_Ip)val).mask.length;
                    int gl = ((Reader_Ip)val).gateway.length;
                    data[0] = (byte)ipl;
                    data[1] = (byte)ml;
                    data[2] = (byte)gl;
                    System.arraycopy(((Reader_Ip)val).ip, 0, data, 3, ipl);
                    System.arraycopy(((Reader_Ip)val).mask, 0, data, 3 + ipl, ml);
                    System.arraycopy(((Reader_Ip)val).ip, 0, data, 3 + ipl + ml, gl);
                    re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), data);
                    break;
                }
                case MTR_PARAM_READER_WATCHDOG: {
                    re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), (byte[])val);
                    break;
                }
                case MTR_PARAM_TAG_MULTISELECTORS: {
                    String[] epcs = (String[])val;
                    if (epcs == null) {
                        re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), null);
                        break;
                    }
                    MultiTagSelectors_ST mts = new MultiTagSelectors_ST();
                    if (epcs.length == 0 || epcs.length > 16) {
                        return READER_ERR.MT_INVALID_PARA;
                    }
                    mts.tagselectorcnt = epcs.length;
                    int i = 0;
                    while (i < epcs.length) {
                        if (epcs[i] == null) {
                            return READER_ERR.MT_INVALID_PARA;
                        }
                        if (epcs[i].length() > 48 || epcs[i].length() % 4 != 0) {
                            return READER_ERR.MT_INVALID_PARA;
                        }
                        mts.tagselectors[i].bank = 1;
                        if (epcs[i].length() == 0) {
                            mts.tagselectors[i].startaddr = 16;
                            mts.tagselectors[i].slen = 5;
                            mts.tagselectors[i].sdata[0] = 0;
                        } else {
                            mts.tagselectors[i].startaddr = 32;
                            mts.tagselectors[i].slen = epcs[i].length() * 4;
                            this.Str2Hex(epcs[i], epcs[i].length(), mts.tagselectors[i].sdata);
                        }
                        ++i;
                    }
                    int mtspos = 0;
                    int sbytedatalen = 0;
                    data[mtspos++] = (byte)mts.tagselectorcnt;
                    int i2 = 0;
                    while (i2 < mts.tagselectorcnt) {
                        data[mtspos++] = (byte)mts.tagselectors[i2].bank;
                        data[mtspos++] = (byte)((mts.tagselectors[i2].startaddr & 0xFF000000) >> 24);
                        data[mtspos++] = (byte)((mts.tagselectors[i2].startaddr & 0xFF0000) >> 16);
                        data[mtspos++] = (byte)((mts.tagselectors[i2].startaddr & 0xFF00) >> 8);
                        data[mtspos++] = (byte)(mts.tagselectors[i2].startaddr & 0xFF);
                        data[mtspos++] = (byte)mts.tagselectors[i2].slen;
                        sbytedatalen = mts.tagselectors[i2].slen % 8 == 0 ? mts.tagselectors[i2].slen / 8 : mts.tagselectors[i2].slen / 8 + 1;
                        System.arraycopy(mts.tagselectors[i2].sdata, 0, data, mtspos, sbytedatalen);
                        mtspos += sbytedatalen;
                        ++i2;
                    }
                    re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), data);
                    break;
                }
                default: {
                    int valint = ((int[])val)[0];
                    data[0] = (byte)((valint & 0xFF000000) >> 24);
                    data[1] = (byte)((valint & 0xFF0000) >> 16);
                    data[2] = (byte)((valint & 0xFF00) >> 8);
                    data[3] = (byte)(valint & 0xFF);
                    re = this.japi.ParamSet_BaseType(this.hReader[0], key.value(), data);
                }
            }
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    public static String bytes_Hexstr(byte[] bArray) {
        StringBuffer sb = new StringBuffer(bArray.length);
        int i = 0;
        while (i < bArray.length) {
            String sTemp = Integer.toHexString(0xFF & bArray[i]);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toUpperCase());
            ++i;
        }
        return sb.toString();
    }

    public void Str2Hex(String buf, int len, byte[] hexbuf) {
        String chex = "0123456789ABCDEF";
        if (len % 2 != 0) {
            return;
        }
        int i = 0;
        while (i < len) {
            byte hnx = (byte)chex.indexOf(buf.toUpperCase().substring(i, i + 1));
            byte lnx = (byte)chex.indexOf(buf.toUpperCase().substring(i + 1, i + 2));
            hexbuf[i / 2] = (byte)(hnx << 4 & 0xFF | lnx & 0xFF);
            i += 2;
        }
    }

    public void Str2Binary(String buf, int len, byte[] binarybuf) {
        if (len % 8 != 0) {
            return;
        }
        int i = 0;
        while (i < len) {
            byte temp = 0;
            int j = 0;
            while (j < 8) {
                temp = (byte)(temp | (byte)(Byte.parseByte(buf.substring(i + j, i + j + 1)) << 7 - j));
                ++j;
            }
            int n = i / 8;
            binarybuf[n] = (byte)(binarybuf[n] | temp);
            i += 8;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR AsyncStartReading(int[] ants, int antcnt, int option) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.AsyncStartReading(this.hReader[0], ants, antcnt, option);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR AsyncStopReading() {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.AsyncStopReading(this.hReader[0]);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR AsyncGetTagCount(int[] tagcnt) {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.AsyncGetTagCount(this.hReader[0], tagcnt);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR AsyncGetNextTag(TAGINFO TI) {
        Reader reader = this;
        synchronized (reader) {
            byte[] tagbuf = new byte[500];
            int pos = 0;
            int re = this.japi.AsyncGetNextTag_BaseType(this.hReader[0], tagbuf);
            READER_ERR ERR = READER_ERR.valueOf(re);
            if (ERR == READER_ERR.MT_OK_ERR) {
                TI.ReadCnt = tagbuf[pos++];
                TI.RSSI = tagbuf[pos++];
                TI.AntennaID = tagbuf[pos++];
                TI.Frequency = (tagbuf[pos] & 0xFF) << 24 | (tagbuf[pos + 1] & 0xFF) << 16 | (tagbuf[pos + 2] & 0xFF) << 8 | tagbuf[pos + 3] & 0xFF;
                TI.TimeStamp = (tagbuf[pos += 4] & 0xFF) << 24 | (tagbuf[pos + 1] & 0xFF) << 16 | (tagbuf[pos + 2] & 0xFF) << 8 | tagbuf[pos + 3] & 0xFF;
                pos += 4;
                TI.Res[0] = tagbuf[pos++];
                TI.Res[1] = tagbuf[pos++];
                int epclen = (tagbuf[pos] & 0xFF) << 8 | tagbuf[pos + 1] & 0xFF;
                pos += 2;
                TI.PC[0] = tagbuf[pos++];
                TI.PC[1] = tagbuf[pos++];
                TI.EpcId = new byte[epclen];
                TI.Epclen = (short)epclen;
                System.arraycopy(tagbuf, pos, TI.EpcId, 0, epclen);
                pos += epclen;
                TI.CRC[0] = tagbuf[pos++];
                TI.CRC[1] = tagbuf[pos++];
                TI.protocol = SL_TagProtocol.valueOf(tagbuf[pos++]);
                int emddatalen = (tagbuf[pos] & 0xFF) << 8 | tagbuf[pos + 1] & 0xFF;
                pos += 2;
                TI.EmbededData = new byte[emddatalen];
                TI.EmbededDatalen = (short)emddatalen;
                if (emddatalen > 0) {
                    System.arraycopy(tagbuf, pos, TI.EmbededData, 0, emddatalen);
                }
            }
            return ERR;
        }
    }

    public static String GetSDKVersion() {
        String ver = "jarVersion:20180702";
        ver = String.valueOf(ver) + "soVersion:" + JniModuleAPI.GetSDKVersion();
        return ver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR GetSerialNumber(DeviceSerialNumber devsn) {
        Reader reader = this;
        synchronized (reader) {
            String sn = "";
            CustomParam_ST cpara = new CustomParam_ST();
            cpara.ParamName = "reader/rdrdetails";
            READER_ERR ret = this.ParamGet(Mtr_Param.MTR_PARAM_CUSTOM, cpara);
            if (ret != READER_ERR.MT_OK_ERR) {
                return ret;
            }
            byte[] binhv = new byte[4];
            System.arraycopy(cpara.ParamVal, 28, binhv, 0, 4);
            sn = String.valueOf(sn) + Reader.bytes_Hexstr(binhv);
            int i = 0;
            while (i < 12) {
                sn = String.valueOf(sn) + cpara.ParamVal[16 + i];
                ++i;
            }
            HardwareDetails hd = new HardwareDetails();
            this.GetHardwareDetails(hd);
            sn = hd.board == MaindBoard_Type.MAINBOARD_ARM9 ? "A9" + sn : (hd.board == MaindBoard_Type.MAINBOARD_ARM7 ? "A7" + sn : "SE" + sn);
            devsn.serailNumber = sn;
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR GetLastDetailError(ErrInfo ei) {
        Reader reader = this;
        synchronized (reader) {
            byte[] resbuf = new byte[500];
            int re = this.japi.GetLastDetailError_BaseType(this.hReader[0], resbuf);
            READER_ERR ERR = READER_ERR.valueOf(re);
            if (ERR == READER_ERR.MT_OK_ERR) {
                ei.derrcode = (resbuf[0] & 0xFF) << 24 | (resbuf[1] & 0xFF) << 16 | (resbuf[2] & 0xFF) << 8 | resbuf[3] & 0xFF;
                byte[] estrbytes = new byte[resbuf[4]];
                System.arraycopy(resbuf, 5, estrbytes, 0, resbuf[4]);
                try {
                    ei.errstr = new String(estrbytes, "ascii");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READER_ERR ResetRfidModule() {
        Reader reader = this;
        synchronized (reader) {
            int re = this.japi.ResetRfidModule(this.hReader[0]);
            READER_ERR ERR = READER_ERR.valueOf(re);
            return ERR;
        }
    }

    public static READER_ERR FirmwareLoadFromSerialPort(String serialportPath, String firmwarePath) {
        int re = JniModuleAPI.FirmwareLoadFromSerialPort(serialportPath, firmwarePath);
        READER_ERR ERR = READER_ERR.valueOf(re);
        return ERR;
    }

    public static READER_ERR RebootReader(String readeraddr) {
        int re = JniModuleAPI.RebootReader(readeraddr);
        READER_ERR ERR = READER_ERR.valueOf(re);
        return ERR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int DataTransportSend(byte[] data, int datalen, int timeout) {
        Reader reader = this;
        synchronized (reader) {
            return this.japi.DataTransportSend(this.hReader[0], data, datalen, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int DataTransportRecv(byte[] data, int datalen, int timeout) {
        Reader reader = this;
        synchronized (reader) {
            return this.japi.DataTransportRecv(this.hReader[0], data, datalen, timeout);
        }
    }

    public void addReadListener(ReadListener listener) {
        this.readListeners.add(listener);
    }

    public void removeReadListener(ReadListener listener) {
        this.readListeners.remove(listener);
    }

    public void addReadExceptionListener(ReadExceptionListener listener) {
        this.readExceptionListeners.add(listener);
    }

    public void removeReadExceptionListener(ReadExceptionListener listener) {
        this.readExceptionListeners.remove(listener);
    }

    public void addGpiTriggerListener(GpiTriggerListener listener) {
        this.gpitriListener.add(listener);
    }

    public void removeGpiTriggerListener(GpiTriggerListener listener) {
        this.gpitriListener.remove(listener);
    }

    public void addGpiTriggerBoundaryListener(GpiTriggerBoundaryListener listener) {
        this.gpitriboundListener.add(listener);
    }

    public void removeGpiTriggerBoundaryListener(GpiTriggerBoundaryListener listener) {
        this.gpitriboundListener.remove(listener);
    }

    private boolean GpiTriContains(GpiInfo_ST littleGInfo, GpiInfo_ST bigGInfo) {
        int i = 0;
        while (i < littleGInfo.gpiCount) {
            if (bigGInfo.gpiStats[littleGInfo.gpiStats[i].GpiId - 1].State != littleGInfo.gpiStats[i].State) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public READER_ERR StartReading(int[] ants, int antcnt, BackReadOption pBRO) {
        this.CLOGS();
        READER_ERR ERR = READER_ERR.MT_OK_ERR;
        if (this.m_IsReadingForAll) {
            return READER_ERR.MT_OP_EXECING;
        }
        this.m_IsReadingForAll = true;
        this.m_BackReadOp = pBRO;
        if (pBRO.IsGPITrigger) {
            if ((pBRO.GpiTrigger.TriggerType == GpiTrigger_Type.GPITRIGGER_TRI1START_TIMEOUTSTOP || pBRO.GpiTrigger.TriggerType == GpiTrigger_Type.GPITRIGGER_TRI1ORTRI2START_TIMEOUTSTOP) && pBRO.GpiTrigger.StopTriggerTimeout < 5) {
                return READER_ERR.MT_INVALID_PARA;
            }
            HardwareDetails hd = new HardwareDetails();
            this.GetHardwareDetails(hd);
            int maxgpiid = hd.logictype == Reader_Type.MODULE_ARM7_FOUR_ANTS || hd.logictype == Reader_Type.M6E_ARM7_FOUR_ANTS || hd.logictype == Reader_Type.MODULE_ARM7_TWO_ANTS || hd.logictype == Reader_Type.SL_COMMN_READER ? 4 : 2;
            if (pBRO.GpiTrigger.GpiTrigger1States.gpiCount > maxgpiid) {
                return READER_ERR.MT_INVALID_PARA;
            }
            int i = 0;
            while (i < pBRO.GpiTrigger.GpiTrigger1States.gpiCount) {
                if (pBRO.GpiTrigger.GpiTrigger1States.gpiStats[i].GpiId < 1 || pBRO.GpiTrigger.GpiTrigger1States.gpiStats[i].GpiId > maxgpiid) {
                    return READER_ERR.MT_INVALID_PARA;
                }
                ++i;
            }
            if (pBRO.GpiTrigger.TriggerType == GpiTrigger_Type.GPITRIGGER_TRI1START_TRI2STOP) {
                if (pBRO.GpiTrigger.GpiTrigger2States.gpiCount > maxgpiid) {
                    return READER_ERR.MT_INVALID_PARA;
                }
                i = 0;
                while (i < pBRO.GpiTrigger.GpiTrigger2States.gpiCount) {
                    if (pBRO.GpiTrigger.GpiTrigger2States.gpiStats[i].GpiId < 1 || pBRO.GpiTrigger.GpiTrigger2States.gpiStats[i].GpiId > maxgpiid) {
                        return READER_ERR.MT_INVALID_PARA;
                    }
                    ++i;
                }
            }
        }
        if (this.m_BackReadOp.IsFastRead) {
            int re;
            short flags = 0;
            if (this.m_BackReadOp.TMFlags.IsReadCnt) {
                flags = (short)(flags | 1);
            }
            if (this.m_BackReadOp.TMFlags.IsRSSI) {
                flags = (short)(flags | 2);
            }
            if (this.m_BackReadOp.TMFlags.IsAntennaID) {
                flags = (short)(flags | 4);
            }
            if (this.m_BackReadOp.TMFlags.IsFrequency) {
                flags = (short)(flags | 8);
            }
            if (this.m_BackReadOp.TMFlags.IsTimestamp) {
                flags = (short)(flags | 0x10);
            }
            if (this.m_BackReadOp.TMFlags.IsRFU) {
                flags = (short)(flags | 0x20);
            }
            if (this.m_BackReadOp.TMFlags.IsEmdData) {
                flags = (short)(flags | 0x80);
            }
            this.m_BackReadOp.ReadDuration = 0;
            this.m_BackReadOp.ReadInterval = 50;
            this.m_FastReadOption = flags << 8 | this.m_BackReadOp.FastReadDutyRation | 0x80;
            if (!this.m_BackReadOp.IsGPITrigger && (ERR = this.errhandle(re = this.japi.AsyncStartReading(this.hReader[0], ants, antcnt, this.m_FastReadOption))) != READER_ERR.MT_OK_ERR) {
                return ERR;
            }
        }
        this.m_BackReadAntsCnt = antcnt;
        int i = 0;
        while (i < antcnt) {
            this.m_BackReadAnts[i] = ants[i];
            ++i;
        }
        Tagnotify tf = new Tagnotify(this);
        this.m_ThreadForAll = new Thread(tf);
        this.m_ThreadForAllid = this.m_ThreadForAll.getId();
        this.m_ThreadForAll.start();
        return ERR;
    }

    public READER_ERR StopReading() {
        READER_ERR ERR;
        if (!this.m_IsReadingForAll) {
            return READER_ERR.MT_OK_ERR;
        }
        this.m_IsReadingForAll = false;
        Thread current = Thread.currentThread();
        this.m_ThreadForAllid = current.getId();
        if (this.m_ThreadForAllid == this.m_ThreadForAll.getId()) {
            READER_ERR ERR2;
            if (this.m_BackReadOp.IsFastRead && (ERR2 = this.AsyncStopReading()) != READER_ERR.MT_OK_ERR) {
                this.ALOGS("err 1892" + ERR2.toString());
                return ERR2;
            }
            return READER_ERR.MT_OK_ERR;
        }
        while (this.m_IsReadThRunning) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.m_ThreadForAll = null;
        if (this.m_BackReadOp.IsFastRead && (ERR = this.AsyncStopReading()) != READER_ERR.MT_OK_ERR) {
            this.ALOGS("err 1920" + ERR.toString());
            return ERR;
        }
        return READER_ERR.MT_OK_ERR;
    }

    private READER_ERR errhandle(int re) {
        READER_ERR err = READER_ERR.valueOf(re);
        if (err != READER_ERR.MT_OK_ERR) {
            this.m_gError = re;
            if (this.m_BackReadOp.IsFastRead) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.AsyncStopReading();
            }
            this.m_IsReadingForAll = false;
            if (this.readExceptionListeners.size() > 0) {
                Exceptionotify exfy = new Exceptionotify(this, err);
                Thread tread = new Thread(exfy);
                tread.start();
            }
        }
        return err;
    }

    private READER_ERR errhandle2(READER_ERR err) {
        if (err != READER_ERR.MT_OK_ERR) {
            if (this.m_BackReadOp.IsFastRead) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.AsyncStopReading();
            }
            this.m_IsReadingForAll = false;
            if (this.readExceptionListeners.size() > 0) {
                Exceptionotify exfy = new Exceptionotify(this, err);
                Thread tread = new Thread(exfy);
                tread.start();
            }
        }
        return err;
    }

    public class ALIENHiggs3BlockReadLockPara {
        public byte[] AccessPwd = new byte[4];
        public byte BlkBits;
        public short TimeOut;
    }

    public class AntPortsVSWR {
        public int andid;
        public short power;
        public Region_Conf region;
        public int frecount;
        public FrequencyVSWR[] vswrs = new FrequencyVSWR[100];

        public AntPortsVSWR() {
            int i = 0;
            while (i < 100) {
                this.vswrs[i] = new FrequencyVSWR();
                ++i;
            }
        }

        public String toString() {
            String ret = "";
            int i = 0;
            while (i < this.frecount) {
                ret = String.valueOf(ret) + this.vswrs[i].frequency + ":" + String.format("%.2f", Float.valueOf(this.vswrs[i].vswr)) + " ";
                ++i;
            }
            return ret;
        }
    }

    public class AntPower {
        public int antid;
        public short readPower;
        public short writePower;
    }

    public class AntPowerConf {
        public int antcnt;
        public AntPower[] Powers = new AntPower[16];
    }

    public static enum BackReadGpiTriState {
        BackReadGpi_WaitStart(0),
        BackReadGpi_WaitStop(1),
        BackReadGpi_WaitTimeout(2);

        private int value = 0;

        private BackReadGpiTriState(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public static BackReadGpiTriState valueOf(String string) {
            return Enum.valueOf(BackReadGpiTriState.class, string);
        }
    }

    public class ConnAnts_ST {
        public int antcnt;
        public int[] connectedants = new int[16];
    }

    public static enum CustomCmdType {
        NXP_SetReadProtect(0),
        NXP_ResetReadProtect(1),
        NXP_ChangeEAS(2),
        NXP_EASAlarm(3),
        NXP_Calibrate(4),
        ALIEN_Higgs2_PartialLoadImage(5),
        ALIEN_Higgs2_FullLoadImage(6),
        ALIEN_Higgs3_FastLoadImage(7),
        ALIEN_Higgs3_LoadImage(8),
        ALIEN_Higgs3_BlockReadLock(9),
        ALIEN_Higgs3_BlockPermaLock(10),
        IMPINJ_M4_Qt(11),
        NXP_U8_InventoryMode(20);

        private int value = 0;

        private CustomCmdType(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public static CustomCmdType valueOf(String string) {
            return Enum.valueOf(CustomCmdType.class, string);
        }
    }

    public class CustomParam_ST {
        public String ParamName;
        public byte[] ParamVal;
    }

    public class DeviceSerialNumber {
        public String serailNumber = "";
    }

    public class EmbededData_ST {
        public int bank;
        public int startaddr;
        public int bytecnt;
        public byte[] accesspwd;
    }

    public class EmbededSecureRead_ST {
        public int tagtype;
        public int pwdtype;
        public int ApIndexStartBitsInEpc;
        public int ApIndexBitsNumInEpc;
        public int bank;
        public int address;
        public int blkcnt;
        public int accesspwd;
    }

    private class Exceptionotify
    implements Runnable {
        Reader reader;
        READER_ERR re;

        public Exceptionotify(Reader rd, READER_ERR rer) {
            this.reader = rd;
            this.re = rer;
        }

        @Override
        public void run() {
            for (ReadExceptionListener rel : Reader.this.readExceptionListeners) {
                rel.tagReadException(this.reader, this.re);
            }
        }
    }

    public class FrequencyVSWR {
        public int frequency;
        public float vswr;
    }

    public class HardwareDetails {
        public Module_Type module;
        public MaindBoard_Type board;
        public Reader_Type logictype;
    }

    public class HoptableData_ST {
        public int[] htb = new int[100];
        public int lenhtb;
    }

    public class IMPINJM4QtPara {
        public byte[] AccessPwd = new byte[4];
        public int CmdType;
        public int MemType;
        public int PersistType;
        public int RangeType;
        public short TimeOut;
    }

    public class IMPINJM4QtResult {
        public int MemType;
        public int RangeType;
    }

    public class Inv_Potl {
        public SL_TagProtocol potl;
        public int weight;
    }

    public class Inv_Potls_ST {
        public int potlcnt;
        public Inv_Potl[] potls = new Inv_Potl[6];
    }

    public static enum Lock_Obj {
        LOCK_OBJECT_KILL_PASSWORD(1),
        LOCK_OBJECT_ACCESS_PASSWD(2),
        LOCK_OBJECT_BANK1(4),
        LOCK_OBJECT_BANK2(8),
        LOCK_OBJECT_BANK3(16);

        int p_v;

        private Lock_Obj(int v) {
            this.p_v = v;
        }

        public int value() {
            return this.p_v;
        }
    }

    public static enum Lock_Type {
        KILL_PASSWORD_UNLOCK(0),
        KILL_PASSWORD_LOCK(512),
        KILL_PASSWORD_PERM_LOCK(768),
        ACCESS_PASSWD_UNLOCK(0),
        ACCESS_PASSWD_LOCK(128),
        ACCESS_PASSWD_PERM_LOCK(192),
        BANK1_UNLOCK(0),
        BANK1_LOCK(32),
        BANK1_PERM_LOCK(48),
        BANK2_UNLOCK(0),
        BANK2_LOCK(8),
        BANK2_PERM_LOCK(12),
        BANK3_UNLOCK(0),
        BANK3_LOCK(2),
        BANK3_PERM_LOCK(3);

        int p_v;

        private Lock_Type(int v) {
            this.p_v = v;
        }

        public int value() {
            return this.p_v;
        }
    }

    public static enum MaindBoard_Type {
        MAINBOARD_NONE,
        MAINBOARD_ARM7,
        MAINBOARD_SERIAL,
        MAINBOARD_WIFI,
        MAINBOARD_ARM9,
        MAINBOARD_ARM9_WIFI;

    }

    public static enum Module_Type {
        MODOULE_NONE(0),
        MODOULE_R902_M1S(1),
        MODOULE_R902_M2S(2),
        MODOULE_M5E(3),
        MODOULE_M5E_C(4),
        MODOULE_M6E(5),
        MODOULE_PR9000(6),
        MODOULE_M5E_PRC(7),
        MODOULE_M6E_PRC(8),
        MODOULE_M6E_MICRO(9),
        MODOULE_SLR1100(10),
        MODOULE_SLR1200(11),
        MODOULE_SLR1300(12),
        MODOULE_SLR3000(13),
        MODOULE_SLR5100(14),
        MODOULE_SLR5200(15),
        MODOULE_SLR3100(16),
        MODOULE_SLR3200(17),
        MODOULE_SLR5300(18),
        MODOULE_SLR5900(19),
        MODOULE_SLR5800(20),
        MODOULE_SLR6000(21),
        MODOULE_SLR6100(22);

        private int value = 0;

        private Module_Type(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public static Module_Type valueOf(String string) {
            return Enum.valueOf(Module_Type.class, string);
        }
    }

    public static enum Mtr_Param {
        MTR_PARAM_POTL_GEN2_SESSION(0),
        MTR_PARAM_POTL_GEN2_Q(1),
        MTR_PARAM_POTL_GEN2_TAGENCODING(2),
        MTR_PARAM_POTL_GEN2_MAXEPCLEN(3),
        MTR_PARAM_RF_ANTPOWER(4),
        MTR_PARAM_RF_MAXPOWER(5),
        MTR_PARAM_RF_MINPOWER(6),
        MTR_PARAM_TAG_FILTER(7),
        MTR_PARAM_TAG_EMBEDEDDATA(8),
        MTR_PARAM_TAG_INVPOTL(9),
        MTR_PARAM_READER_CONN_ANTS(10),
        MTR_PARAM_READER_AVAILABLE_ANTPORTS(11),
        MTR_PARAM_READER_IS_CHK_ANT(12),
        MTR_PARAM_READER_VERSION(13),
        MTR_PARAM_READER_IP(14),
        MTR_PARAM_FREQUENCY_REGION(15),
        MTR_PARAM_FREQUENCY_HOPTABLE(16),
        MTR_PARAM_POTL_GEN2_BLF(17),
        MTR_PARAM_POTL_GEN2_WRITEMODE(18),
        MTR_PARAM_POTL_GEN2_TARGET(19),
        MTR_PARAM_TAGDATA_UNIQUEBYANT(20),
        MTR_PARAM_TAGDATA_UNIQUEBYEMDDATA(21),
        MTR_PARAM_TAGDATA_RECORDHIGHESTRSSI(22),
        MTR_PARAM_RF_TEMPERATURE(23),
        MTR_PARAM_RF_HOPTIME(24),
        MTR_PARAM_RF_LBT_ENABLE(25),
        MTR_PARAM_RF_SUPPORTEDREGIONS(26),
        MTR_PARAM_POTL_SUPPORTEDPROTOCOLS(27),
        MTR_PARAM_POTL_ISO180006B_BLF(28),
        MTR_PARAM_POTL_GEN2_TARI(29),
        MTR_PARAM_TRANS_TIMEOUT(30),
        MTR_PARAM_TAG_EMDSECUREREAD(31),
        MTR_PARAM_TRANSMIT_MODE(32),
        MTR_PARAM_POWERSAVE_MODE(33),
        MTR_PARAM_TAG_SEARCH_MODE(34),
        MTR_PARAM_POTL_ISO180006B_MODULATION_DEPTH(35),
        MTR_PARAM_POTL_ISO180006B_DELIMITER(36),
        MTR_PARAM_RF_ANTPORTS_VSWR(37),
        MTR_PARAM_CUSTOM(41),
        MTR_PARAM_READER_WATCHDOG(42),
        MTR_PARAM_READER_ERRORDATA(43),
        MTR_PARAM_RF_HOPANTTIME(44),
        MTR_PARAM_TAG_MULTISELECTORS(45);

        private int value = 0;

        private Mtr_Param(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public static Mtr_Param valueOf(String string) {
            return Enum.valueOf(Mtr_Param.class, string);
        }
    }

    public class MultiTagSelectors_ST {
        public TagSelector_ST[] tagselectors = new TagSelector_ST[16];
        public int tagselectorcnt;

        public MultiTagSelectors_ST() {
            int i = 0;
            while (i < 16) {
                this.tagselectors[i] = new TagSelector_ST();
                ++i;
            }
        }
    }

    public class NXPChangeEASPara {
        public byte[] AccessPwd = new byte[4];
        public int isSet;
        public short TimeOut;
    }

    public class NXPEASAlarmPara {
        public byte DR;
        public byte MC;
        public byte TrExt;
        public short TimeOut;
    }

    public class NXPEASAlarmResult {
        public byte[] EASdata = new byte[8];
    }

    public class NXP_U8_InventoryModePara {
        public byte[] Mode = new byte[1];
    }

    public static enum READER_ERR {
        MT_OK_ERR(0),
        MT_IO_ERR(1),
        MT_INTERNAL_DEV_ERR(2),
        MT_CMD_FAILED_ERR(3),
        MT_CMD_NO_TAG_ERR(4),
        MT_M5E_FATAL_ERR(5),
        MT_OP_NOT_SUPPORTED(6),
        MT_INVALID_PARA(7),
        MT_INVALID_READER_HANDLE(8),
        MT_HARDWARE_ALERT_ERR_BY_HIGN_RETURN_LOSS(9),
        MT_HARDWARE_ALERT_ERR_BY_TOO_MANY_RESET(10),
        MT_HARDWARE_ALERT_ERR_BY_NO_ANTENNAS(11),
        MT_HARDWARE_ALERT_ERR_BY_HIGH_TEMPERATURE(12),
        MT_HARDWARE_ALERT_ERR_BY_READER_DOWN(13),
        MT_HARDWARE_ALERT_ERR_BY_UNKNOWN_ERR(14),
        M6E_INIT_FAILED(15),
        MT_OP_EXECING(16),
        MT_UNKNOWN_READER_TYPE(17),
        MT_OP_INVALID(18),
        MT_HARDWARE_ALERT_BY_FAILED_RESET_MODLUE(19),
        MT_MAX_ERR_NUM(20),
        MT_MAX_INT_NUM(21),
        MT_TEST_DEV_FAULT_1(51),
        MT_TEST_DEV_FAULT_2(52),
        MT_TEST_DEV_FAULT_3(53),
        MT_TEST_DEV_FAULT_4(54),
        MT_TEST_DEV_FAULT_5(55),
        MT_UPDFWFROMSP_OPENFILE_FAILED(80),
        MT_UPDFWFROMSP_FILE_FORMAT_ERR(81),
        MT_JNI_INVALID_PARA(101),
        MT_OTHER_ERR(-268435457);

        private int value = 0;

        private READER_ERR(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public static READER_ERR valueOf(String string) {
            return Enum.valueOf(READER_ERR.class, string);
        }
    }

    public class ReaderVersion {
        public String hardwareVer;
        public String softwareVer;
    }

    public class Reader_Ip {
        public byte[] ip;
        public byte[] mask;
        public byte[] gateway;
    }

    public static enum Reader_Type {
        MODULE_TWO_ANTS(0),
        MODULE_FOUR_ANTS(1),
        MODULE_THREE_ANTS(3),
        MODULE_ONE_ANT(4),
        PR9000(5),
        MODULE_ARM7_TWO_ANTS(6),
        MODULE_ARM7_FOUR_ANTS(7),
        M6E_ARM7_FOUR_ANTS(8),
        M56_ARM7_FOUR_ANTS(9),
        R902_M1S(10),
        R902_M2S(11),
        ARM7_16ANTS(12),
        SL_COMMN_READER(13);

        private int value = 0;

        private Reader_Type(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public static Reader_Type valueOf(String string) {
            return Enum.valueOf(Reader_Type.class, string);
        }
    }

    public static enum Region_Conf {
        RG_NONE(0),
        RG_NA(1),
        RG_EU(2),
        RG_EU2(7),
        RG_EU3(8),
        RG_KR(3),
        RG_PRC(6),
        RG_PRC2(10),
        RG_OPEN(255);

        int p_v;

        private Region_Conf(int v) {
            this.p_v = v;
        }

        public int value() {
            return this.p_v;
        }

        public static Region_Conf valueOf(String string) {
            return Enum.valueOf(Region_Conf.class, string);
        }
    }

    public static enum SL_TagProtocol {
        SL_TAG_PROTOCOL_NONE(0),
        SL_TAG_PROTOCOL_ISO180006B(3),
        SL_TAG_PROTOCOL_GEN2(5),
        SL_TAG_PROTOCOL_ISO180006B_UCODE(6),
        SL_TAG_PROTOCOL_IPX64(7),
        SL_TAG_PROTOCOL_IPX256(8);

        int p_v;

        private SL_TagProtocol(int v) {
            this.p_v = v;
        }

        public int value() {
            return this.p_v;
        }

        public static SL_TagProtocol valueOf(String string) {
            return Enum.valueOf(SL_TagProtocol.class, string);
        }
    }

    public class TAGINFO
    implements Cloneable {
        public byte AntennaID;
        public int Frequency;
        public int TimeStamp;
        public short EmbededDatalen;
        public byte[] EmbededData = new byte[128];
        public byte[] Res = new byte[2];
        public short Epclen;
        public byte[] PC = new byte[2];
        public byte[] CRC = new byte[2];
        public byte[] EpcId = new byte[62];
        public int Phase;
        public SL_TagProtocol protocol;
        public int ReadCnt;
        public int RSSI;

        public Object clone() {
            TAGINFO o = null;
            try {
                o = (TAGINFO)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
            return o;
        }
    }

    public class TagFilter_ST {
        public int bank;
        public int startaddr;
        public int flen;
        public byte[] fdata = new byte[255];
        public int isInvert;
    }

    public class TagSelector_ST {
        public int bank;
        public int startaddr;
        public int slen;
        public byte[] sdata = new byte[24];
    }

    private class Tagnotify
    implements Runnable {
        Reader reader;

        public Tagnotify(Reader rd) {
            this.reader = rd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void run() {
            Tagnotify tagnotify = this;
            synchronized (tagnotify) {
                int re = 0;
                TAGINFO[] tag = null;
                Reader.this.m_IsReadThRunning = true;
                boolean isGpiTrigger = false;
                boolean isGpiTriStop = false;
                int startgpitriid = 0;
                GPITrigger pGTrigger = Reader.this.m_BackReadOp.GpiTrigger;
                long dtwstart = System.currentTimeMillis();
                long timenow = System.currentTimeMillis();
                BackReadGpiTriState BRGstate = BackReadGpiTriState.BackReadGpi_WaitStart;
                if (Reader.this.m_BackReadOp.IsGPITrigger) {
                    isGpiTrigger = true;
                    if (Reader.this.m_BackReadOp.GpiTrigger.TriggerType == GpiTrigger_Type.GPITRIGGER_TRI1START_TRI2STOP) {
                        isGpiTriStop = true;
                    }
                    pGTrigger = Reader.this.m_BackReadOp.GpiTrigger;
                }
                while (Reader.this.m_IsReadingForAll) {
                    block46: {
                        GpiInfo_ST gstates;
                        block48: {
                            boolean isStop;
                            block47: {
                                if (!isGpiTrigger) break block46;
                                boolean isStart = true;
                                isStop = true;
                                if (BRGstate != BackReadGpiTriState.BackReadGpi_WaitStart) break block47;
                                gstates = new GpiInfo_ST();
                                re = Reader.this.japi.Get_GPIEx(Reader.this.hReader[0], gstates);
                                if (Reader.this.errhandle(re) != READER_ERR.MT_OK_ERR) continue;
                                isStart = Reader.this.GpiTriContains(pGTrigger.GpiTrigger1States, gstates);
                                if (isStart) {
                                    startgpitriid = 1;
                                    if (Reader.this.gpitriListener.size() > 0) {
                                        for (GpiTriggerListener gpiTriggerListener : Reader.this.gpitriListener) {
                                            gpiTriggerListener.GpiTrigger(this.reader, gstates, startgpitriid);
                                        }
                                    }
                                } else if (pGTrigger.TriggerType == GpiTrigger_Type.GPITRIGGER_TRI1ORTRI2START_TIMEOUTSTOP && (isStart = Reader.this.GpiTriContains(pGTrigger.GpiTrigger2States, gstates))) {
                                    startgpitriid = 2;
                                    if (Reader.this.gpitriListener.size() > 0) {
                                        for (GpiTriggerListener gpiTriggerListener : Reader.this.gpitriListener) {
                                            gpiTriggerListener.GpiTrigger(this.reader, gstates, startgpitriid);
                                        }
                                    }
                                }
                                if (!isStart) continue;
                                if (Reader.this.gpitriboundListener.size() > 0) {
                                    for (GpiTriggerBoundaryListener gpiTriggerBoundaryListener : Reader.this.gpitriboundListener) {
                                        gpiTriggerBoundaryListener.GpiTriggerBoundary(this.reader, GpiTriggerBoundaryType.GPITriggerBoundary_StartInventory, GpiTriggerBoundaryReasonType.GpiTriggerBoundaryReason_ByGpi);
                                    }
                                }
                                if (isGpiTriStop) {
                                    BRGstate = BackReadGpiTriState.BackReadGpi_WaitStop;
                                } else {
                                    dtwstart = System.currentTimeMillis();
                                    BRGstate = BackReadGpiTriState.BackReadGpi_WaitTimeout;
                                }
                                if (Reader.this.m_BackReadOp.IsFastRead) {
                                    re = Reader.this.japi.AsyncStartReading(Reader.this.hReader[0], Reader.this.m_BackReadAnts, Reader.this.m_BackReadAntsCnt, Reader.this.m_FastReadOption);
                                }
                                break block46;
                            }
                            if (BRGstate != BackReadGpiTriState.BackReadGpi_WaitStop) break block48;
                            gstates = new GpiInfo_ST();
                            re = Reader.this.japi.Get_GPIEx(Reader.this.hReader[0], gstates);
                            if (Reader.this.errhandle(re) != READER_ERR.MT_OK_ERR) continue;
                            isStop = Reader.this.GpiTriContains(pGTrigger.GpiTrigger2States, gstates);
                            if (isStop) {
                                if (Reader.this.gpitriListener.size() > 0) {
                                    for (GpiTriggerListener gpiTriggerListener : Reader.this.gpitriListener) {
                                        gpiTriggerListener.GpiTrigger(this.reader, gstates, 2);
                                    }
                                }
                                BRGstate = BackReadGpiTriState.BackReadGpi_WaitStart;
                                if (Reader.this.m_BackReadOp.IsFastRead && Reader.this.errhandle(re = Reader.this.japi.AsyncStopReading(Reader.this.hReader[0])) != READER_ERR.MT_OK_ERR || Reader.this.gpitriboundListener.size() <= 0) continue;
                                for (GpiTriggerBoundaryListener gpiTriggerBoundaryListener : Reader.this.gpitriboundListener) {
                                    gpiTriggerBoundaryListener.GpiTriggerBoundary(this.reader, GpiTriggerBoundaryType.GPITriggerBoundary_StopInventory, GpiTriggerBoundaryReasonType.GpiTriggerBoundaryReason_ByGpi);
                                }
                                continue;
                            }
                            break block46;
                        }
                        if (BRGstate != BackReadGpiTriState.BackReadGpi_WaitTimeout) break block46;
                        if (pGTrigger.TriggerType == GpiTrigger_Type.GPITRIGGER_TRI1ORTRI2START_TIMEOUTSTOP) {
                            void var17_27;
                            gstates = new GpiInfo_ST();
                            GpiInfo_ST gpiInfo_ST = new GpiInfo_ST();
                            re = Reader.this.japi.Get_GPIEx(Reader.this.hReader[0], gstates);
                            if (Reader.this.errhandle(re) != READER_ERR.MT_OK_ERR) continue;
                            if (startgpitriid == 1) {
                                GpiInfo_ST gpiInfo_ST2 = pGTrigger.GpiTrigger2States;
                            } else if (startgpitriid == 2) {
                                GpiInfo_ST gpiInfo_ST3 = pGTrigger.GpiTrigger1States;
                            }
                            if (Reader.this.GpiTriContains((GpiInfo_ST)var17_27, gstates) && Reader.this.gpitriListener.size() > 0) {
                                for (GpiTriggerListener rl : Reader.this.gpitriListener) {
                                    rl.GpiTrigger(this.reader, gstates, 3 - startgpitriid);
                                }
                            }
                        }
                        if ((timenow = System.currentTimeMillis()) - dtwstart > (long)Reader.this.m_BackReadOp.GpiTrigger.StopTriggerTimeout) {
                            BRGstate = BackReadGpiTriState.BackReadGpi_WaitStart;
                            if (Reader.this.m_BackReadOp.IsFastRead && Reader.this.errhandle(re = Reader.this.japi.AsyncStopReading(Reader.this.hReader[0])) != READER_ERR.MT_OK_ERR || Reader.this.gpitriboundListener.size() <= 0) continue;
                            for (GpiTriggerBoundaryListener rl : Reader.this.gpitriboundListener) {
                                rl.GpiTriggerBoundary(this.reader, GpiTriggerBoundaryType.GPITriggerBoundary_StopInventory, GpiTriggerBoundaryReasonType.GpiTriggerBoundaryReason_ByTimeout);
                            }
                        }
                        break block46;
                        continue;
                    }
                    int[] tagcnt = new int[1];
                    if (Reader.this.m_BackReadOp.IsFastRead) {
                        re = Reader.this.japi.AsyncGetTagCount(Reader.this.hReader[0], tagcnt);
                        if (Reader.this.errhandle(re) != READER_ERR.MT_OK_ERR) {
                            Reader.this.ALOGS(String.valueOf(String.valueOf(re)) + " 2209");
                            continue;
                        }
                    } else {
                        re = Reader.this.japi.TagInventory_Raw(Reader.this.hReader[0], Reader.this.m_BackReadAnts, Reader.this.m_BackReadAntsCnt, Reader.this.m_BackReadOp.ReadDuration, tagcnt);
                        if (Reader.this.errhandle(re) != READER_ERR.MT_OK_ERR) continue;
                    }
                    Vector<TAGINFO> tagv = new Vector<TAGINFO>();
                    int i = 0;
                    while (i < tagcnt[0]) {
                        block52: {
                            block49: {
                                TAGINFO stag;
                                block51: {
                                    block50: {
                                        stag = new TAGINFO();
                                        if (!Reader.this.m_IsReadingForAll) break block49;
                                        if (!Reader.this.m_BackReadOp.IsFastRead) break block50;
                                        if (Reader.this.errhandle2(this.reader.AsyncGetNextTag(stag)) == READER_ERR.MT_OK_ERR) break block51;
                                        Reader.this.ALOGS(String.valueOf(String.valueOf(re)) + " 2226");
                                        break block52;
                                    }
                                    re = Reader.this.GetNextTag(stag).value;
                                    if (Reader.this.errhandle(re) != READER_ERR.MT_OK_ERR) break block52;
                                }
                                tagv.add(stag);
                            }
                            if (!Reader.this.m_IsReadingForAll) break;
                        }
                        ++i;
                    }
                    tag = new TAGINFO[tagv.size()];
                    tag = tagv.toArray(tag);
                    if (Reader.this.readListeners.size() > 0 && tag.length > 0) {
                        for (ReadListener rl : Reader.this.readListeners) {
                            rl.tagRead(this.reader, tag);
                        }
                    }
                    try {
                        Thread.sleep(Reader.this.m_BackReadOp.ReadInterval);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                Reader.this.m_IsReadThRunning = false;
            }
        }
    }
}

