/*
 * Decompiled with CFR 0.152.
 */
package com.uhf.api.cls;

import java.util.ArrayList;
import java.util.List;

public class R2000_calibration {
    private byte[] cmdname = null;
    private final byte HeaderC = (byte)-1;
    private final byte AA = (byte)-86;
    private final byte bb = (byte)-69;
    private static int[] crcTable;

    static {
        int[] nArray = new int[16];
        nArray[1] = 4129;
        nArray[2] = 8258;
        nArray[3] = 12387;
        nArray[4] = 16516;
        nArray[5] = 20645;
        nArray[6] = 24774;
        nArray[7] = 28903;
        nArray[8] = 33032;
        nArray[9] = 37161;
        nArray[10] = 41290;
        nArray[11] = 45419;
        nArray[12] = 49548;
        nArray[13] = 53677;
        nArray[14] = 57806;
        nArray[15] = 61935;
        crcTable = nArray;
    }

    public R2000_calibration() {
        this.cmdname = new byte[]{77, 111, 100, 117, 108, 101, 116, 101, 99, 104};
    }

    public static byte[] calcCrc(byte[] message, int offset, int length) {
        int crc = 65535;
        int i = offset;
        while (i < offset + length) {
            crc = (crc << 4 | message[i] >> 4 & 0xF) ^ crcTable[crc >> 12];
            crc &= 0xFFFF;
            crc = (crc << 4 | message[i] >> 0 & 0xF) ^ crcTable[crc >> 12];
            crc &= 0xFFFF;
            ++i;
        }
        byte[] CRC = new byte[]{(byte)((crc & 0xFF00) >> 8), (byte)(crc & 0xFF)};
        return CRC;
    }

    public static short calcCrc_short(byte[] message) {
        int crc = 65535;
        int i = 0;
        while (i < message.length) {
            crc = (crc << 4 | message[i] >> 4 & 0xF) ^ crcTable[crc >> 12];
            crc &= 0xFFFF;
            crc = (crc << 4 | message[i] >> 0 & 0xF) ^ crcTable[crc >> 12];
            crc &= 0xFFFF;
            ++i;
        }
        return (short)crc;
    }

    public static byte[] ListBtobytes(List<Byte> lb) {
        Byte[] by = new Byte[lb.size()];
        byte[] by2 = new byte[lb.size()];
        lb.toArray(by);
        int i = 0;
        while (i < by2.length) {
            by2[i] = by[i];
            ++i;
        }
        return by2;
    }

    public static byte[] shortTobytes(short data) {
        byte[] redata = new byte[]{(byte)((data & 0xFF00) >> 8), (byte)(data & 0xFF)};
        return redata;
    }

    public static byte[] intTobytes(int data) {
        byte[] redata = new byte[]{(byte)((data & 0xFF000000) >> 24), (byte)((data & 0xFF0000) >> 16), (byte)((data & 0xFF00) >> 8), (byte)(data & 0xFF)};
        return redata;
    }

    public static List<Byte> shortTolistbytes(short data) {
        ArrayList<Byte> redata = new ArrayList<Byte>();
        redata.add((byte)((data & 0xFF00) >> 8));
        redata.add((byte)(data & 0xFF));
        return redata;
    }

    public static List<Byte> intTolistbytes(int data) {
        ArrayList<Byte> redata = new ArrayList<Byte>();
        redata.add((byte)((data & 0xFF000000) >> 24));
        redata.add((byte)((data & 0xFF0000) >> 16));
        redata.add((byte)((data & 0xFF00) >> 8));
        redata.add((byte)(data & 0xFF));
        return redata;
    }

    public static List<Byte> bytesTolistbytes(byte[] data) {
        ArrayList<Byte> redata = new ArrayList<Byte>();
        int i = 0;
        while (i < data.length) {
            redata.add(data[i]);
            ++i;
        }
        return redata;
    }

    public static List<Integer> intsTolistints(int[] data) {
        ArrayList<Integer> redata = new ArrayList<Integer>();
        int i = 0;
        while (i < data.length) {
            redata.add(data[i]);
            ++i;
        }
        return redata;
    }

    public static short bytesToshort(byte[] data) {
        return (short)((data[1] & 0xFF) << 8 | (data[0] & 0xFF) << 0);
    }

    public static int bytesToint(byte[] data) {
        return (data[3] & 0xFF) << 24 | (data[2] & 0xFF) << 16 | (data[1] & 0xFF) << 8 | (data[0] & 0xFF) << 0;
    }

    public static int bytesToint(byte[] data, int st) {
        return (data[st + 3] & 0xFF) << 24 | (data[st + 2] & 0xFF) << 16 | (data[st + 1] & 0xFF) << 8 | (data[st] & 0xFF) << 0;
    }

    public byte[] GetSendCmd(byte cmd, byte[] data) {
        ArrayList<Byte> lb = new ArrayList<Byte>();
        lb.add((byte)-1);
        if (data != null) {
            lb.add((byte)data.length);
        } else {
            lb.add((byte)0);
        }
        lb.add(cmd);
        if (data != null) {
            lb.addAll(R2000_calibration.bytesTolistbytes(data));
        }
        lb.add((byte)0);
        lb.add((byte)0);
        byte[] crc = R2000_calibration.calcCrc(R2000_calibration.ListBtobytes(lb), 1, lb.size() - 1);
        lb.set(lb.size() - 1, crc[1]);
        lb.set(lb.size() - 2, crc[0]);
        return R2000_calibration.ListBtobytes(lb);
    }

    public byte[] GetSendCmd(R2000cmd cmdot, byte[] data) {
        ArrayList<Byte> lbs = new ArrayList<Byte>();
        lbs.add((byte)-1);
        if (data != null) {
            lbs.add((byte)(data.length + 14));
        } else {
            lbs.add((byte)14);
        }
        lbs.add((byte)-86);
        lbs.addAll(R2000_calibration.bytesTolistbytes(this.cmdname));
        byte[] bs = R2000_calibration.shortTobytes((short)cmdot.value);
        lbs.addAll(R2000_calibration.bytesTolistbytes(bs));
        if (data != null) {
            lbs.addAll(R2000_calibration.bytesTolistbytes(data));
        }
        int vall = bs[0] + bs[1];
        if (data != null) {
            int i = 0;
            while (i < data.length) {
                vall += data[i];
                ++i;
            }
        }
        lbs.add((byte)(vall & 0xFF));
        lbs.add((byte)-69);
        lbs.add((byte)0);
        lbs.add((byte)0);
        byte[] crc = R2000_calibration.calcCrc(R2000_calibration.ListBtobytes(lbs), 1, lbs.size() - 3);
        lbs.set(lbs.size() - 1, crc[1]);
        lbs.set(lbs.size() - 2, crc[0]);
        return R2000_calibration.ListBtobytes(lbs);
    }

    public class ENGTest_DATA {
        byte subcmd;
        int arg0;
        int arg1;

        public ENGTest_DATA(byte scmd, int a0, int a1) {
            this.subcmd = scmd;
            this.arg0 = a0;
            this.arg1 = a1;
        }

        public byte[] ToByteData() {
            ArrayList<Byte> lb = new ArrayList<Byte>();
            lb.add(this.subcmd);
            lb.addAll(R2000_calibration.intTolistbytes(this.arg0));
            lb.addAll(R2000_calibration.intTolistbytes(this.arg1));
            return R2000_calibration.ListBtobytes(lb);
        }
    }

    public class GrossGains_DATA {
        List<Integer> Lad = new ArrayList<Integer>();

        public List<Integer> LAD() {
            return this.Lad;
        }

        public GrossGains_DATA(int addr) {
            this.Lad.add(addr);
        }

        public GrossGains_DATA(byte[] data) {
            int i = 0;
            while (i < data.length) {
                int val = R2000_calibration.bytesToint(data, ++i);
                this.Lad.add(val);
                i += 4;
            }
        }

        public void AddTo(int datav) {
            if (this.Lad != null) {
                this.Lad.add(datav);
            }
        }

        public byte[] ToByteData() {
            ArrayList<Byte> lb = new ArrayList<Byte>();
            if (this.Lad != null) {
                int i = 0;
                while (i < this.Lad.size()) {
                    lb.add((byte)i);
                    lb.addAll(R2000_calibration.intTolistbytes(this.Lad.get(i)));
                    ++i;
                }
            }
            return R2000_calibration.ListBtobytes(lb);
        }
    }

    public class MAC_DATA
    extends OEM_DATA {
        public MAC_DATA(short addr, int datav) {
            super(addr, datav);
        }

        public MAC_DATA(short addr) {
            super(addr);
        }

        public MAC_DATA(byte[] data) {
            super(data);
        }
    }

    public class OEM_DATA {
        List<Adpair> La;
        List<Short> Lad;

        public Adpair[] GetAddr() {
            if (this.La != null) {
                return (Adpair[])this.La.toArray();
            }
            return new Adpair[0];
        }

        public OEM_DATA(short addr, int datav) {
            this.La = new ArrayList<Adpair>();
            Adpair ad = new Adpair();
            ad.addr = addr;
            ad.val = datav;
            this.La.add(ad);
        }

        public OEM_DATA(short addr) {
            this.Lad = new ArrayList<Short>();
            this.Lad.add(addr);
        }

        public OEM_DATA(byte[] data) {
            int allen = data.length / 6;
            this.La = new ArrayList<Adpair>();
            int p = 0;
            int i = 0;
            while (i < allen) {
                byte[] addrb = new byte[2];
                byte[] valb = new byte[4];
                System.arraycopy(data, p, addrb, 0, 2);
                System.arraycopy(data, p += 2, valb, 0, 4);
                p += 4;
                Adpair ad = new Adpair();
                ad.addr = (short)((addrb[1] & 0xFF) << 8 | (addrb[0] & 0xFF) << 0);
                ad.val = (valb[3] & 0xFF) << 24 | (valb[2] & 0xFF) << 16 | (valb[1] & 0xFF) << 8 | (valb[0] & 0xFF) << 0;
                this.La.add(ad);
                ++i;
            }
        }

        public void AddTo(short addr, int datav) {
            if (this.La != null) {
                Adpair ad = new Adpair();
                ad.addr = addr;
                ad.val = datav;
                this.La.add(ad);
            } else if (this.Lad != null) {
                this.Lad.add(addr);
            }
        }

        public byte[] ToByteData() {
            int i;
            ArrayList<Byte> lb = new ArrayList<Byte>();
            if (this.La != null) {
                i = 0;
                while (i < this.La.size()) {
                    lb.addAll(R2000_calibration.shortTolistbytes(this.La.get((int)i).addr));
                    lb.addAll(R2000_calibration.intTolistbytes(this.La.get((int)i).val));
                    ++i;
                }
            }
            if (this.Lad != null) {
                i = 0;
                while (i < this.Lad.size()) {
                    lb.addAll(R2000_calibration.shortTolistbytes(this.Lad.get(i)));
                    ++i;
                }
            }
            return R2000_calibration.ListBtobytes(lb);
        }

        public class Adpair {
            public short addr;
            public int val;
        }
    }

    public class Pabiascal_DATA {
        int paa2;
        int paa1;
        int paa0;

        public Pabiascal_DATA(int a2, int a1, int a0) {
            this.paa2 = a2;
            this.paa1 = a1;
            this.paa0 = a0;
        }

        public byte[] ToByteData() {
            ArrayList<Byte> lb = new ArrayList<Byte>();
            lb.addAll(R2000_calibration.intTolistbytes(this.paa2));
            lb.addAll(R2000_calibration.intTolistbytes(this.paa1));
            lb.addAll(R2000_calibration.intTolistbytes(this.paa0));
            return R2000_calibration.ListBtobytes(lb);
        }
    }

    public static enum R2000cmd {
        OEMformat(43562),
        OEMwrite(43522),
        OEMread(43523),
        ENGTEST(43524),
        GROSSGAINSCAL(43547),
        DCOFFSETCAL(43556),
        SetTestFre(43559),
        PABIASCAL(43564),
        writeMAC(43566),
        readMAC(43567),
        carrier(43569),
        ReturnLossTest(43594);

        private int value = 0;

        private R2000cmd(int value) {
            this.value = value;
        }
    }

    public static enum Region {
        UNSPEC(0),
        NA(1),
        EU(2),
        KR(3),
        IN(4),
        JP(5),
        PRC(6),
        EU2(7),
        EU3(8),
        KR2(9),
        PRC2(10),
        OPEN(255);

        private int value = 0;

        private Region(int value) {
            this.value = value;
        }
    }

    public static enum SubCmd {
        ReadAD(11),
        SetTestAntPow(12),
        SendControl(22),
        En_low_power_gpio(170);

        private int value = 0;

        public int Value() {
            return this.value;
        }

        private SubCmd(int value) {
            this.value = value;
        }
    }

    public class TestFre_DATA {
        int reserved;
        int freq;

        public TestFre_DATA(int res, int fre) {
            this.reserved = res;
            this.freq = fre;
        }

        public byte[] ToByteData() {
            ArrayList<Byte> lb = new ArrayList<Byte>();
            lb.addAll(R2000_calibration.intTolistbytes(this.reserved));
            lb.addAll(R2000_calibration.intTolistbytes(this.freq));
            return R2000_calibration.ListBtobytes(lb);
        }
    }

    public class VSWRReturnloss_DATA {
        List<Integer> lifre = new ArrayList<Integer>();
        List<Integer> ants = new ArrayList<Integer>();
        Region regb;
        List<Byte> lires;
        int power;

        public List<Integer> LiFre() {
            return this.lifre;
        }

        public List<Byte> Lires() {
            return this.lires;
        }

        public List<Integer> Ants() {
            return this.ants;
        }

        public Region Regb() {
            return this.regb;
        }

        public int Power() {
            return this.power;
        }

        public VSWRReturnloss_DATA(int pow, int[] lifreary, int[] antsary, Region reg) {
            this.lifre.addAll(R2000_calibration.intsTolistints(lifreary));
            this.ants.addAll(R2000_calibration.intsTolistints(antsary));
            this.power = pow;
            this.regb = reg;
        }

        public VSWRReturnloss_DATA(byte[] bytedata) {
            this.lires = new ArrayList<Byte>();
            this.power = bytedata[0] << 8 | bytedata[1];
            this.regb = Region.values()[bytedata[3]];
            int i = 5;
            while (i < bytedata.length) {
                this.lifre.add(bytedata[i] << 16 | bytedata[i + 1] << 8 | bytedata[i + 2]);
                this.lires.add(bytedata[i + 3]);
                i += 4;
            }
        }

        public byte[] ToByteData() {
            ArrayList<Byte> lb = new ArrayList<Byte>();
            lb.add((byte)((this.power & 0xFF00) >> 8));
            lb.add((byte)(this.power & 0xFF));
            lb.add((byte)0);
            lb.add((byte)this.regb.value);
            if (this.lifre.size() > 0) {
                lb.add((byte)this.lifre.size());
                int i = 0;
                while (i < this.lifre.size()) {
                    lb.add((byte)((this.lifre.get(i) & 0xFF0000) >> 16));
                    lb.add((byte)((this.lifre.get(i) & 0xFF00) >> 8));
                    lb.add((byte)(this.lifre.get(i) & 0xFF));
                    ++i;
                }
            } else {
                lb.add((byte)0);
            }
            return R2000_calibration.ListBtobytes(lb);
        }
    }
}

