/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.grapher.graphviz;

import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.grapher.InterfaceNode;
import com.google.inject.grapher.NameFactory;
import com.google.inject.grapher.graphviz.GraphvizNode;
import com.google.inject.grapher.graphviz.GraphvizRenderer;
import com.google.inject.grapher.graphviz.NodeStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceNodeFactory
implements InterfaceNode.Factory<String, InterfaceNode<String>> {
    private final GraphvizRenderer renderer;
    private final NameFactory nameFactory;

    @Inject
    public InterfaceNodeFactory(GraphvizRenderer renderer, NameFactory nameFactory) {
        this.renderer = renderer;
        this.nameFactory = nameFactory;
    }

    @Override
    public InterfaceNode<String> newInterfaceNode(String nodeId) {
        GraphvizNode node = new GraphvizNode(nodeId);
        this.renderer.addNode(node);
        return this.newAdaptor(node);
    }

    private GraphvizNodeAdaptor newAdaptor(GraphvizNode node) {
        return new GraphvizNodeAdaptor(node);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class GraphvizNodeAdaptor
    implements InterfaceNode<String> {
        protected final GraphvizNode node;

        public GraphvizNodeAdaptor(GraphvizNode node) {
            this.node = node;
            this.node.setStyle(NodeStyle.DASHED);
        }

        @Override
        public void setKey(Key<?> key) {
            String title = InterfaceNodeFactory.this.nameFactory.getClassName(key);
            this.node.setTitle(title);
            this.node.addSubtitle(0, InterfaceNodeFactory.this.nameFactory.getAnnotationName(key));
        }

        @Override
        public void setSource(Object source) {
        }
    }
}

