/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.util;

import com.alipay.config.AlipayConfig;
import com.alipay.util.SignUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderInfoUtil2_0 {
    public static Map<String, String> buildAuthInfoMap(String pid, String app_id, String target_id) {
        HashMap<String, String> keyValues = new HashMap<String, String>();
        keyValues.put("app_id", app_id);
        keyValues.put("pid", pid);
        keyValues.put("apiname", "com.alipay.account.auth");
        keyValues.put("app_name", "mc");
        keyValues.put("biz_type", "openservice");
        keyValues.put("product_id", "APP_FAST_LOGIN");
        keyValues.put("scope", "kuaijie");
        keyValues.put("target_id", target_id);
        keyValues.put("auth_type", "AUTHACCOUNT");
        keyValues.put("sign_type", "RSA");
        return keyValues;
    }

    public static Map<String, String> buildOrderParamMap(String outTradeNo, String total_amount, String subject, String body, String notify_url) {
        HashMap<String, String> keyValues = new HashMap<String, String>();
        keyValues.put("app_id", AlipayConfig.APPID);
        keyValues.put("notify_url", notify_url);
        keyValues.put("biz_content", "{\"timeout_express\":\"30m\",\"product_code\":\"QUICK_MSECURITY_PAY\",\"total_amount\":\"" + total_amount + "\",\"subject\":\"" + subject + "\",\"body\":\"" + body + "\",\"out_trade_no\":\"" + outTradeNo + "\"}");
        keyValues.put("charset", "utf-8");
        keyValues.put("method", "alipay.trade.app.pay");
        keyValues.put("sign_type", "RSA");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timestamp = format.format(Calendar.getInstance().getTime());
        keyValues.put("timestamp", timestamp);
        keyValues.put("version", "1.0");
        return keyValues;
    }

    public static String buildOrderParam(Map<String, String> map) {
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < keys.size() - 1) {
            String key = (String)keys.get(i);
            String value = map.get(key);
            sb.append(OrderInfoUtil2_0.buildKeyValue(key, value, true));
            sb.append("&");
            ++i;
        }
        String tailKey = (String)keys.get(keys.size() - 1);
        String tailValue = map.get(tailKey);
        sb.append(OrderInfoUtil2_0.buildKeyValue(tailKey, tailValue, true));
        return sb.toString();
    }

    private static String buildKeyValue(String key, String value, boolean isEncode) {
        StringBuilder sb = new StringBuilder();
        sb.append(key);
        sb.append("=");
        if (isEncode) {
            try {
                sb.append(URLEncoder.encode(value, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                sb.append(value);
            }
        } else {
            sb.append(value);
        }
        return sb.toString();
    }

    public static String getSign(Map<String, String> map) {
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        Collections.sort(keys);
        StringBuilder authInfo = new StringBuilder();
        int i = 0;
        while (i < keys.size() - 1) {
            String key = (String)keys.get(i);
            String value = map.get(key);
            authInfo.append(OrderInfoUtil2_0.buildKeyValue(key, value, false));
            authInfo.append("&");
            ++i;
        }
        String tailKey = (String)keys.get(keys.size() - 1);
        String tailValue = map.get(tailKey);
        authInfo.append(OrderInfoUtil2_0.buildKeyValue(tailKey, tailValue, false));
        String oriSign = SignUtils.sign(authInfo.toString(), AlipayConfig.RSA_PRIVATE);
        String encodedSign = "";
        try {
            encodedSign = URLEncoder.encode(oriSign, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return "sign=" + encodedSign;
    }

    private static String getOutTradeNo() {
        SimpleDateFormat format = new SimpleDateFormat("MMddHHmmss", Locale.getDefault());
        Date date = new Date();
        String key = format.format(date);
        Random r = new Random();
        key = String.valueOf(key) + r.nextInt();
        key = key.substring(0, 15);
        return key;
    }
}

