/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.repository.config.RepositoryComponentProvider;
import org.springframework.data.repository.config.RepositoryConfigurationSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RepositoryConfigurationSourceSupport
implements RepositoryConfigurationSource {
    protected static final String DEFAULT_REPOSITORY_IMPL_POSTFIX = "Impl";

    @Override
    public Collection<String> getCandidates(ResourceLoader loader) {
        RepositoryComponentProvider scanner = new RepositoryComponentProvider(this.getIncludeFilters());
        scanner.setResourceLoader(loader);
        for (TypeFilter filter : this.getExcludeFilters()) {
            scanner.addExcludeFilter(filter);
        }
        HashSet<String> result = new HashSet<String>();
        for (String basePackage : this.getBasePackages()) {
            Set components = scanner.findCandidateComponents(basePackage);
            for (BeanDefinition definition : components) {
                result.add(definition.getBeanClassName());
            }
        }
        return result;
    }

    protected Iterable<TypeFilter> getExcludeFilters() {
        return Collections.emptySet();
    }

    protected Iterable<TypeFilter> getIncludeFilters() {
        return Collections.emptySet();
    }
}

