/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hwpf.HWPFDocumentCore;
import org.apache.poi.hwpf.model.ComplexFileTable;
import org.apache.poi.hwpf.model.OldCHPBinTable;
import org.apache.poi.hwpf.model.OldPAPBinTable;
import org.apache.poi.hwpf.model.OldSectionTable;
import org.apache.poi.hwpf.model.PieceDescriptor;
import org.apache.poi.hwpf.model.TextPiece;
import org.apache.poi.hwpf.model.TextPieceTable;
import org.apache.poi.hwpf.usermodel.Range;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.LittleEndian;

public class HWPFOldDocument
extends HWPFDocumentCore {
    private TextPieceTable tpt;
    private StringBuilder _text;

    public HWPFOldDocument(POIFSFileSystem fs) throws IOException {
        this(fs.getRoot());
    }

    public HWPFOldDocument(DirectoryNode directory) throws IOException {
        super(directory);
        int sedTableOffset = LittleEndian.getInt((byte[])this._mainStream, (int)136);
        int sedTableSize = LittleEndian.getInt((byte[])this._mainStream, (int)140);
        int chpTableOffset = LittleEndian.getInt((byte[])this._mainStream, (int)184);
        int chpTableSize = LittleEndian.getInt((byte[])this._mainStream, (int)188);
        int papTableOffset = LittleEndian.getInt((byte[])this._mainStream, (int)192);
        int papTableSize = LittleEndian.getInt((byte[])this._mainStream, (int)196);
        int complexTableOffset = LittleEndian.getInt((byte[])this._mainStream, (int)352);
        ComplexFileTable cft = null;
        StringBuffer text = new StringBuffer();
        if (this._fib.getFibBase().isFComplex()) {
            cft = new ComplexFileTable(this._mainStream, this._mainStream, complexTableOffset, this._fib.getFibBase().getFcMin());
            this.tpt = cft.getTextPieceTable();
            for (TextPiece tp : this.tpt.getTextPieces()) {
                text.append((CharSequence)tp.getStringBuilder());
            }
        } else {
            PieceDescriptor pd = new PieceDescriptor(new byte[]{0, 0, 0, 0, 0, 127, 0, 0}, 0);
            pd.setFilePosition(this._fib.getFibBase().getFcMin());
            this.tpt = new TextPieceTable();
            byte[] textData = new byte[this._fib.getFibBase().getFcMac() - this._fib.getFibBase().getFcMin()];
            System.arraycopy(this._mainStream, this._fib.getFibBase().getFcMin(), textData, 0, textData.length);
            TextPiece tp = new TextPiece(0, textData.length, textData, pd);
            this.tpt.add(tp);
            text.append((CharSequence)tp.getStringBuilder());
        }
        this._text = this.tpt.getText();
        this._cbt = new OldCHPBinTable(this._mainStream, chpTableOffset, chpTableSize, this._fib.getFibBase().getFcMin(), this.tpt);
        this._pbt = new OldPAPBinTable(this._mainStream, papTableOffset, papTableSize, this._fib.getFibBase().getFcMin(), this.tpt);
        this._st = new OldSectionTable(this._mainStream, sedTableOffset, sedTableSize, this._fib.getFibBase().getFcMin(), this.tpt);
        boolean preserveBinTables = false;
        try {
            preserveBinTables = Boolean.parseBoolean(System.getProperty("org.apache.poi.hwpf.preserveBinTables"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!preserveBinTables) {
            this._cbt.rebuild(cft);
            this._pbt.rebuild(this._text, cft);
        }
    }

    @Override
    public Range getOverallRange() {
        return new Range(0, this._fib.getFibBase().getFcMac() - this._fib.getFibBase().getFcMin(), this);
    }

    @Override
    public Range getRange() {
        return this.getOverallRange();
    }

    @Override
    public TextPieceTable getTextTable() {
        return this.tpt;
    }

    @Override
    public StringBuilder getText() {
        return this._text;
    }

    public void write() throws IOException {
        throw new IllegalStateException("Writing is not available for the older file formats");
    }

    public void write(File out) throws IOException {
        throw new IllegalStateException("Writing is not available for the older file formats");
    }

    public void write(OutputStream out) throws IOException {
        throw new IllegalStateException("Writing is not available for the older file formats");
    }
}

