/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.variable;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.variable.SerializableType;
import org.activiti.engine.impl.variable.ValueFields;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongJsonType
extends SerializableType {
    private static final Logger logger = LoggerFactory.getLogger(LongJsonType.class);
    protected final int minLength;
    protected ObjectMapper objectMapper;
    protected boolean serializePOJOsInVariablesToJson;
    protected String javaClassFieldForJackson;

    public LongJsonType(int minLength, ObjectMapper objectMapper, boolean serializePOJOsInVariablesToJson, String javaClassFieldForJackson) {
        this.minLength = minLength;
        this.objectMapper = objectMapper;
        this.serializePOJOsInVariablesToJson = serializePOJOsInVariablesToJson;
        this.javaClassFieldForJackson = javaClassFieldForJackson;
    }

    @Override
    public String getTypeName() {
        return "longJson";
    }

    @Override
    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        if (JsonNode.class.isAssignableFrom(value.getClass()) || this.objectMapper.canSerialize(value.getClass()) && this.serializePOJOsInVariablesToJson) {
            try {
                return this.objectMapper.writeValueAsString(value).length() >= this.minLength;
            }
            catch (JsonProcessingException e) {
                logger.error("Error writing json variable of type " + value.getClass(), (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public byte[] serialize(Object value, ValueFields valueFields) {
        if (value == null) {
            return null;
        }
        String json = null;
        try {
            json = this.objectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            logger.error("Error writing long json variable " + valueFields.getName(), (Throwable)e);
        }
        try {
            return json.getBytes("utf-8");
        }
        catch (Exception e) {
            throw new ActivitiException("Error getting bytes from json variable", e);
        }
    }

    @Override
    public Object deserialize(byte[] bytes, ValueFields valueFields) {
        JsonNode classNode;
        Object jsonValue = null;
        if (jsonValue == null) {
            try {
                jsonValue = this.objectMapper.readTree(bytes);
            }
            catch (Exception e) {
                logger.error("Error reading json variable " + valueFields.getName(), (Throwable)e);
            }
        }
        if (jsonValue != null && StringUtils.isNotBlank((CharSequence)this.javaClassFieldForJackson) && (classNode = jsonValue.get(this.javaClassFieldForJackson)) != null) {
            String type = classNode.asText();
            Class<?> cls = null;
            try {
                cls = Class.forName(type, false, this.getClass().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                logger.warn("Unable to obtain type for json variable object " + valueFields.getName(), (Throwable)e);
            }
            if (cls != null) {
                jsonValue = this.objectMapper.convertValue(jsonValue, cls);
            }
        }
        return jsonValue;
    }
}

