/*
 * Decompiled with CFR 0.152.
 */
package io.seata.discovery.registry;

import io.seata.common.exception.NotSupportYetException;
import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.config.ConfigurationFactory;
import io.seata.discovery.registry.FileRegistryServiceImpl;
import io.seata.discovery.registry.RegistryProvider;
import io.seata.discovery.registry.RegistryService;
import io.seata.discovery.registry.RegistryType;
import java.util.Objects;

public class RegistryFactory {
    private static volatile RegistryService instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RegistryService getInstance() {
        if (instance != null) return instance;
        Class<RegistryFactory> clazz = RegistryFactory.class;
        synchronized (RegistryFactory.class) {
            if (instance != null) return instance;
            instance = RegistryFactory.buildRegistryService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static RegistryService buildRegistryService() {
        RegistryType registryType;
        String registryTypeName = ConfigurationFactory.CURRENT_FILE_INSTANCE.getConfig("registry.type");
        try {
            registryType = RegistryType.getType(registryTypeName);
        }
        catch (Exception exx) {
            throw new NotSupportYetException("not support registry type: " + registryTypeName);
        }
        if (RegistryType.File == registryType) {
            return FileRegistryServiceImpl.getInstance();
        }
        return EnhancedServiceLoader.load(RegistryProvider.class, Objects.requireNonNull(registryType).name()).provide();
    }
}

