/*
 * Decompiled with CFR 0.152.
 */
package com.stoyanr.evictor.map;

import com.stoyanr.evictor.ConcurrentMapWithTimedEviction;
import com.stoyanr.evictor.EvictionScheduler;
import com.stoyanr.evictor.map.EvictibleEntry;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public class ConcurrentMapWithTimedEvictionDecorator<K, V>
extends AbstractMap<K, V>
implements ConcurrentMapWithTimedEviction<K, V> {
    private final ConcurrentMap<K, EvictibleEntry<K, V>> delegate;
    private final EvictionScheduler<K, V> scheduler;
    private final transient EntrySet entrySet;

    public ConcurrentMapWithTimedEvictionDecorator(ConcurrentMap<K, EvictibleEntry<K, V>> delegate, EvictionScheduler<K, V> scheduler) {
        if (delegate == null || scheduler == null) {
            throw new NullPointerException("Delegate to be used cannot be null");
        }
        this.delegate = delegate;
        this.scheduler = scheduler;
        this.entrySet = new EntrySet();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean containsKey(Object key) {
        EvictibleEntry e = (EvictibleEntry)this.delegate.get(key);
        return e != null && !this.evictIfExpired(e);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException("Value to be checked for contains cannot be null");
        }
        for (EvictibleEntry e : this.delegate.values()) {
            if (!e.getValue().equals(value) || this.evictIfExpired(e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        EvictibleEntry e = (EvictibleEntry)this.delegate.get(key);
        return e == null || this.evictIfExpired(e) ? null : (V)e.getValue();
    }

    @Override
    public V put(K key, V value) {
        return this.put(key, value, 0L);
    }

    @Override
    public V put(K key, V value, long evictMs) {
        EvictibleEntry<K, V> e = new EvictibleEntry<K, V>(this, key, value, evictMs);
        EvictibleEntry<K, V> oe = this.delegate.put(key, e);
        if (oe != null) {
            this.cancelEviction(oe);
        }
        this.scheduleEviction(e);
        return oe == null || oe.shouldEvict() ? null : (V)oe.getValue();
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.putIfAbsent(key, value, 0L);
    }

    @Override
    public V putIfAbsent(K key, V value, long evictMs) {
        EvictibleEntry<K, V> oe;
        do {
            EvictibleEntry<K, V> e;
            if ((oe = this.delegate.putIfAbsent(key, e = new EvictibleEntry<K, V>(this, key, value, evictMs))) != null) continue;
            this.scheduleEviction(e);
            return null;
        } while (this.evictIfExpired(oe));
        return oe.getValue();
    }

    @Override
    public V remove(Object key) {
        EvictibleEntry oe = (EvictibleEntry)this.delegate.remove(key);
        if (oe != null) {
            this.cancelEviction(oe);
        }
        return oe == null || oe.shouldEvict() ? null : (V)oe.getValue();
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (value == null) {
            throw new NullPointerException("Value to be checked to cannot be null");
        }
        EvictibleEntry oe = (EvictibleEntry)this.delegate.get(key);
        if (oe == null || this.evictIfExpired(oe) || !oe.getValue().equals(value)) {
            return false;
        }
        boolean removed = this.delegate.remove(key, oe);
        this.cancelEviction(oe);
        return removed;
    }

    @Override
    public V replace(K key, V value) {
        return this.replace(key, value, 0L);
    }

    @Override
    public V replace(K key, V value, long evictMs) {
        EvictibleEntry<K, V> oe = (EvictibleEntry<K, V>)this.delegate.get(key);
        if (oe == null || this.evictIfExpired(oe)) {
            return null;
        }
        EvictibleEntry<K, V> e = new EvictibleEntry<K, V>(this, key, value, evictMs);
        oe = this.delegate.replace(key, e);
        if (oe != null) {
            this.cancelEviction(oe);
            this.scheduleEviction(e);
        }
        return oe != null ? (V)oe.getValue() : null;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.replace(key, oldValue, newValue, 0L);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue, long evictMs) {
        if (oldValue == null) {
            throw new NullPointerException("Old value cannot be nul");
        }
        EvictibleEntry oe = (EvictibleEntry)this.delegate.get(key);
        if (oe == null || this.evictIfExpired(oe) || !oldValue.equals(oe.getValue())) {
            return false;
        }
        EvictibleEntry<K, V> e = new EvictibleEntry<K, V>(this, key, newValue, evictMs);
        boolean replaced = this.delegate.replace(key, oe, e);
        if (replaced) {
            this.cancelEviction(oe);
            this.scheduleEviction(e);
        }
        return replaced;
    }

    @Override
    public void clear() {
        this.cancelAllEvictions();
        this.delegate.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet;
    }

    private boolean evictIfExpired(EvictibleEntry<K, V> e) {
        return this.evictIfExpired(e, true);
    }

    private boolean evictIfExpired(EvictibleEntry<K, V> e, boolean cancelPendingEviction) {
        boolean result = e.shouldEvict();
        if (result) {
            this.evict(e, cancelPendingEviction);
        }
        return result;
    }

    void evict(EvictibleEntry<K, V> e, boolean cancelPendingEviction) {
        this.delegate.remove(e.getKey(), e);
        if (cancelPendingEviction) {
            this.cancelEviction(e);
        }
    }

    private void scheduleEviction(EvictibleEntry<K, V> e) {
        this.scheduler.scheduleEviction(e);
    }

    private void cancelEviction(EvictibleEntry<K, V> e) {
        this.scheduler.cancelEviction(e);
    }

    private void cancelAllEvictions() {
        for (EvictibleEntry e : this.delegate.values()) {
            this.scheduler.cancelEviction(e);
        }
    }

    private final class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<K, EvictibleEntry<K, V>>> iterator;
        private volatile Map.Entry<K, V> currentEntry;

        public EntryIterator() {
            this.iterator = ConcurrentMapWithTimedEvictionDecorator.this.delegate.entrySet().iterator();
            this.currentEntry = null;
        }

        @Override
        public Map.Entry<K, V> next() {
            this.currentEntry = this.iterator.next().getValue();
            return this.currentEntry;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public synchronized void remove() {
            if (this.currentEntry == null) {
                throw new IllegalStateException("There is no entry that can be removed");
            }
            ConcurrentMapWithTimedEvictionDecorator.this.remove(this.currentEntry.getKey(), this.currentEntry.getValue());
            this.currentEntry = null;
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object value = ConcurrentMapWithTimedEvictionDecorator.this.get(e.getKey());
            return value != null && value.equals(e.getValue());
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            return ConcurrentMapWithTimedEvictionDecorator.this.putIfAbsent(entry.getKey(), entry.getValue()) == null;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return ConcurrentMapWithTimedEvictionDecorator.this.remove(e.getKey(), e.getValue());
        }

        @Override
        public int size() {
            return ConcurrentMapWithTimedEvictionDecorator.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public void clear() {
            ConcurrentMapWithTimedEvictionDecorator.this.clear();
        }
    }
}

