/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel.util;

import java.security.AccessController;

public final class JCSecureLoader {
    private JCSecureLoader() {
    }

    public static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
    }

    public static ClassLoader getClassClassLoader(Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getClassLoader();
        }
        return AccessController.doPrivileged(() -> clazz.getClassLoader());
    }

    public static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(() -> ClassLoader.getSystemClassLoader());
    }

    public static void setContextClassLoader(ClassLoader classLoader) {
        if (System.getSecurityManager() == null) {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        AccessController.doPrivileged(() -> {
            Thread.currentThread().setContextClassLoader(classLoader);
            return null;
        });
    }
}

