/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFormatter;
import com.helger.jcodemodel.JOp;
import com.helger.jcodemodel.util.JCValueEnforcer;
import javax.annotation.Nonnull;

public class JConditional
implements IJStatement {
    private final IJExpression m_aTestExpr;
    private final JBlock m_aThenBlock = new JBlock();
    private JBlock m_aElseBlock;

    protected JConditional(@Nonnull IJExpression iJExpression) {
        JCValueEnforcer.notNull(iJExpression, "Test expression");
        this.m_aTestExpr = iJExpression;
    }

    @Nonnull
    public IJExpression test() {
        return this.m_aTestExpr;
    }

    @Nonnull
    public JBlock _then() {
        return this.m_aThenBlock;
    }

    @Nonnull
    public JBlock _else() {
        if (this.m_aElseBlock == null) {
            this.m_aElseBlock = new JBlock();
        }
        return this.m_aElseBlock;
    }

    @Nonnull
    public JConditional _elseif(@Nonnull IJExpression iJExpression) {
        return this._else()._if(iJExpression);
    }

    @Override
    public void state(@Nonnull JFormatter jFormatter) {
        if (this.m_aTestExpr == JExpr.TRUE) {
            this.m_aThenBlock.generateBody(jFormatter);
            return;
        }
        if (this.m_aTestExpr == JExpr.FALSE) {
            this.m_aElseBlock.generateBody(jFormatter);
            return;
        }
        if (JOp.hasTopOp(this.m_aTestExpr)) {
            jFormatter.print("if ").generable(this.m_aTestExpr);
        } else {
            jFormatter.print("if (").generable(this.m_aTestExpr).print(')');
        }
        jFormatter.generable(this.m_aThenBlock);
        if (this.m_aElseBlock != null) {
            jFormatter.print("else").generable(this.m_aElseBlock);
        }
        jFormatter.newline();
    }
}

