/*
 * Decompiled with CFR 0.152.
 */
package com.anji.plus.gaea.http;

import com.alibaba.fastjson.JSONObject;
import com.anji.plus.gaea.http.ssl.SslSocketClient;
import java.io.IOException;
import java.time.Duration;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpClientUtils {
    private static final OkHttpClient httpClient;
    private static final MediaType MEDIA_TYPE;

    public static Response get(String url, Headers headers) throws IOException {
        Request request = new Request.Builder().url(url).headers(headers).get().build();
        return httpClient.newCall(request).execute();
    }

    public static void getAsyn(String url, Headers headers, Callback callback) {
        Request request = new Request.Builder().url(url).headers(headers).get().build();
        httpClient.newCall(request).enqueue(callback);
    }

    public static Response post(String url, Headers headers, Object body) throws IOException {
        RequestBody requestBody = RequestBody.create((MediaType)MEDIA_TYPE, (String)JSONObject.toJSONString((Object)body));
        Request request = new Request.Builder().url(url).headers(headers).post(requestBody).build();
        return httpClient.newCall(request).execute();
    }

    public static void postAsyn(String url, Headers headers, Object body, Callback callback) {
        RequestBody requestBody = RequestBody.create((MediaType)MEDIA_TYPE, (String)JSONObject.toJSONString((Object)body));
        Request request = new Request.Builder().url(url).headers(headers).post(requestBody).build();
        httpClient.newCall(request).enqueue(callback);
    }

    public static Response put(String url, Headers headers, Object body) throws IOException {
        RequestBody requestBody = RequestBody.create((MediaType)MEDIA_TYPE, (String)JSONObject.toJSONString((Object)body));
        Request request = new Request.Builder().url(url).headers(headers).put(requestBody).build();
        return httpClient.newCall(request).execute();
    }

    public static void putAsyn(String url, Headers headers, Object body, Callback callback) {
        RequestBody requestBody = RequestBody.create((MediaType)MEDIA_TYPE, (String)JSONObject.toJSONString((Object)body));
        Request request = new Request.Builder().url(url).headers(headers).put(requestBody).build();
        httpClient.newCall(request).enqueue(callback);
    }

    public static Response del(String url, Headers headers) throws IOException {
        Request request = new Request.Builder().url(url).headers(headers).delete().build();
        return httpClient.newCall(request).execute();
    }

    public static void delAsyn(String url, Headers headers, Callback callback) {
        Request request = new Request.Builder().url(url).headers(headers).delete().build();
        httpClient.newCall(request).enqueue(callback);
    }

    static {
        MEDIA_TYPE = MediaType.parse((String)"application/json; charset=UTF-8");
        httpClient = new OkHttpClient.Builder().sslSocketFactory(SslSocketClient.getSSLSocketFactory(), SslSocketClient.trustManager()).hostnameVerifier(SslSocketClient.getHostnameVerifier()).connectTimeout(Duration.ofSeconds(90L)).readTimeout(Duration.ofSeconds(90L)).build();
    }
}

