/*
 * Decompiled with CFR 0.152.
 */
package com.anji.plus.gaea.exception.advice;

import com.anji.plus.gaea.bean.ResponseBean;
import com.anji.plus.gaea.exception.BusinessException;
import com.anji.plus.gaea.i18.MessageSourceHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.NoSuchMessageException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class ExceptionHandlerAdvice {
    private Logger logger = LoggerFactory.getLogger(ExceptionHandlerAdvice.class);
    @Autowired
    private MessageSourceHolder messageSourceHolder;

    @ExceptionHandler(value={BusinessException.class})
    public ResponseBean handleBusinessException(BusinessException businessException) {
        return ResponseBean.builder().code(businessException.getCode()).args(businessException.getArgs()).build();
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseBean methodArgumentNotValidException(MethodArgumentNotValidException methodArgumentNotValidException) {
        String message;
        String code = methodArgumentNotValidException.getBindingResult().getFieldError().getDefaultMessage();
        try {
            message = this.messageSourceHolder.getMessage(code, null);
        }
        catch (NoSuchMessageException exception) {
            message = code;
        }
        return ResponseBean.builder().code("500").message(message).build();
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseBean exception(Exception exception) {
        this.logger.error("\u7cfb\u7edf\u5f02\u5e38", (Throwable)exception);
        ResponseBean.Builder builder = ResponseBean.builder();
        builder.code("500");
        builder.message(this.messageSourceHolder.getMessage("500", null));
        builder.args(new String[]{exception.getMessage()});
        return builder.build();
    }
}

