/*
 * Decompiled with CFR 0.152.
 */
package com.anji.plus.gaea.annotation.condition;

import com.anji.plus.gaea.annotation.condition.ConditionalOnGaeaComponent;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class OnGaeaComponentCondition
extends SpringBootCondition {
    private String prefix = "spring.gaea.subscribes.";

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Map annotationAttributes = metadata.getAnnotationAttributes(ConditionalOnGaeaComponent.class.getName());
        String componentName = String.valueOf(annotationAttributes.get("value"));
        ConditionOutcome endpointOutcome = this.getEndpointOutcome(context, componentName);
        if (endpointOutcome != null) {
            return endpointOutcome;
        }
        return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.of((String)"gaea\uff0cnot load ", (Object[])new Object[0]));
    }

    protected ConditionOutcome getEndpointOutcome(ConditionContext context, String componentName) {
        String enabledProperty;
        Environment environment = context.getEnvironment();
        if (environment.containsProperty(enabledProperty = this.prefix + componentName + ".enabled")) {
            boolean match = (Boolean)environment.getProperty(enabledProperty, Boolean.class, (Object)true);
            return new ConditionOutcome(match, ConditionMessage.forCondition(ConditionalOnGaeaComponent.class, (Object[])new Object[0]).because(this.prefix + componentName + ".enabled is " + match));
        }
        return null;
    }
}

