/*
 * Decompiled with CFR 0.152.
 */
package com.anji.plus.gaea;

import com.alibaba.fastjson.JSONObject;
import com.anji.plus.gaea.GaeaProperties;
import com.anji.plus.gaea.bean.ResponseBean;
import com.anji.plus.gaea.cache.CacheHelper;
import com.anji.plus.gaea.cache.RedisCacheHelper;
import com.anji.plus.gaea.config.MybatisPlusMetaObjectHandler;
import com.anji.plus.gaea.curd.mapper.injected.CustomSqlInjector;
import com.anji.plus.gaea.event.listener.ExceptionApplicationListener;
import com.anji.plus.gaea.holder.UserContentHolder;
import com.anji.plus.gaea.holder.UserContext;
import com.anji.plus.gaea.i18.MessageLocaleResolver;
import com.anji.plus.gaea.i18.MessageSourceHolder;
import com.anji.plus.gaea.init.InitRequestUrlMappings;
import com.anji.plus.gaea.intercept.AccessKeyInterceptor;
import com.anji.plus.gaea.utils.ApplicationContextUtils;
import com.anji.plus.gaea.utils.JwtBean;
import com.baomidou.mybatisplus.autoconfigure.MybatisPlusAutoConfiguration;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.extension.plugins.OptimisticLockerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.MDC;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableConfigurationProperties(value={GaeaProperties.class})
public class GaeaAutoConfiguration {
    @Bean
    public ApplicationContextUtils applicationContextUtils() {
        return new ApplicationContextUtils();
    }

    @Bean
    public JwtBean jwtBean(GaeaProperties gaeaProperties) {
        return new JwtBean(gaeaProperties);
    }

    @Bean
    @ConditionalOnClass(value={RedisAutoConfiguration.class})
    @ConditionalOnMissingBean
    public CacheHelper cacheHelper() {
        return new RedisCacheHelper();
    }

    @Bean
    public ExceptionApplicationListener exceptionApplicationListener() {
        return new ExceptionApplicationListener();
    }

    @Configuration
    @ConditionalOnClass(value={MybatisPlusAutoConfiguration.class})
    public class GaeaMybatisPlusAutoConfiguration {
        @Bean
        public OptimisticLockerInterceptor optimisticLockerInterceptor() {
            return new OptimisticLockerInterceptor();
        }

        @Bean
        public CustomSqlInjector customSqlInjector() {
            return new CustomSqlInjector();
        }

        @Bean
        public PaginationInterceptor paginationInterceptor() {
            return new PaginationInterceptor();
        }

        @Bean
        @ConditionalOnMissingBean(value={MetaObjectHandler.class})
        public MybatisPlusMetaObjectHandler mybatisPlusMetaObjectHandler() {
            return new MybatisPlusMetaObjectHandler();
        }
    }

    @Configuration
    @ConditionalOnClass(value={WebMvcConfigurer.class})
    public static class GaeaWebMvcConfigurer
    implements WebMvcConfigurer {
        public void addInterceptors(InterceptorRegistry registry) {
            InterceptorRegistration interceptorRegistration = registry.addInterceptor((HandlerInterceptor)new AccessKeyInterceptor());
            interceptorRegistration.addPathPatterns(new String[]{"/**"});
        }
    }

    @Configuration
    @ConditionalOnClass(value={WebMvcConfigurer.class})
    @ComponentScan(value={"com.anji.plus.gaea.controller", "com.anji.plus.gaea.exception.advice"})
    public static class WebGaeaAutoConfiguration {
        @Bean
        public InitRequestUrlMappings initRequestUrlMappings() {
            return new InitRequestUrlMappings();
        }

        @Bean
        public FilterRegistrationBean registrationBean(JwtBean jwtBean) {
            FilterRegistrationBean registrationBean = new FilterRegistrationBean();
            registrationBean.setFilter((request, response, chain) -> {
                if (request instanceof HttpServletRequest) {
                    HttpServletRequest httpServletRequest = (HttpServletRequest)request;
                    String authorization = httpServletRequest.getHeader("Authorization");
                    String orgCode = httpServletRequest.getHeader("orgCode");
                    String sysCode = httpServletRequest.getHeader("systemCode");
                    String locale = httpServletRequest.getHeader("locale");
                    UserContext userContext = UserContentHolder.getContext();
                    if (StringUtils.isNotBlank((CharSequence)locale)) {
                        userContext.setLocale(Locale.forLanguageTag(locale));
                    }
                    if (StringUtils.isNotBlank((CharSequence)authorization)) {
                        try {
                            String username = jwtBean.getUsername(authorization);
                            Integer userType = jwtBean.getUserType(authorization);
                            String tenant = jwtBean.getTenant(authorization);
                            userContext.setUsername(username);
                            userContext.setType(userType);
                            userContext.setTenantCode(tenant);
                            MDC.put((String)"loginName", (String)username);
                            if (StringUtils.isNotBlank((CharSequence)orgCode)) {
                                userContext.setOrgCode(orgCode);
                            }
                            if (StringUtils.isNotBlank((CharSequence)sysCode)) {
                                userContext.setSysCode(sysCode);
                            }
                            userContext.getParams().put("orgCode", orgCode);
                        }
                        catch (Exception e) {
                            ResponseBean responseBean = ResponseBean.builder().code("500").message("The Token has expired").build();
                            response.getWriter().print(JSONObject.toJSONString((Object)responseBean));
                            return;
                        }
                    }
                }
                chain.doFilter(request, response);
                UserContentHolder.clearContext();
            });
            registrationBean.addUrlPatterns(new String[]{"/*"});
            registrationBean.setName("userOrgCodeFilter");
            registrationBean.setOrder(-2147483548);
            return registrationBean;
        }

        @Configuration
        @ConditionalOnClass(value={LocaleResolver.class})
        @ConditionalOnMissingBean(value={MessageLocaleResolver.class})
        public class MessageI18AutoConfiguration {
            @Bean
            public MessageLocaleResolver localeResolver() {
                return new MessageLocaleResolver();
            }

            @Bean
            public MessageSourceHolder messageSourceHolder() {
                return new MessageSourceHolder();
            }
        }
    }
}

