/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.model;

import com.aliyun.openservices.ots.internal.OTSUtil;
import com.aliyun.openservices.ots.model.ColumnType;
import com.aliyun.openservices.ots.model.PrimaryKeyType;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class ViewMeta {
    private String viewName;
    private Map<String, PrimaryKeyType> primaryKeys = new LinkedHashMap<String, PrimaryKeyType>();
    private Map<String, ColumnType> attributeColumns = new LinkedHashMap<String, ColumnType>();

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        if (viewName == null) {
            throw new NullPointerException();
        }
        if (!OTSUtil.nameValid(viewName)) {
            throw new IllegalArgumentException();
        }
        this.viewName = viewName;
    }

    public Map<String, PrimaryKeyType> getPrimaryKeys() {
        return Collections.unmodifiableMap(this.primaryKeys);
    }

    public void addPrimaryKey(String name, PrimaryKeyType type) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (type == null) {
            throw new NullPointerException();
        }
        if (!OTSUtil.nameValid(name)) {
            throw new IllegalArgumentException();
        }
        this.primaryKeys.put(name, type);
    }

    public Map<String, ColumnType> getAttributeColumns() {
        return Collections.unmodifiableMap(this.attributeColumns);
    }

    public void addAttributeColumn(String name, ColumnType type) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (type == null) {
            throw new NullPointerException();
        }
        if (!OTSUtil.nameValid(name)) {
            throw new IllegalArgumentException();
        }
        this.attributeColumns.put(name, type);
    }

    ViewMeta() {
    }

    public ViewMeta(String viewName) {
        if (viewName == null) {
            throw new NullPointerException();
        }
        OTSUtil.ensureNameValid(viewName);
        this.viewName = viewName;
    }
}

