/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.model;

import com.aliyun.openservices.ots.model.PrimaryKeyType;

public class PrimaryKeyValue {
    private String value;
    private PrimaryKeyType type;

    public PrimaryKeyValue(String value, PrimaryKeyType type) {
        this.value = value;
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public PrimaryKeyType getType() {
        return this.type;
    }

    public static PrimaryKeyValue fromString(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return new PrimaryKeyValue(value, PrimaryKeyType.STRING);
    }

    public static PrimaryKeyValue fromLong(long value) {
        return new PrimaryKeyValue(Long.toString(value), PrimaryKeyType.INTEGER);
    }

    public static PrimaryKeyValue fromBoolean(boolean value) {
        return new PrimaryKeyValue(Boolean.toString(value).toUpperCase(), PrimaryKeyType.BOOLEAN);
    }

    public String toString() {
        return this.value;
    }

    public long toLong() {
        if (this.type != PrimaryKeyType.INTEGER) {
            throw new IllegalStateException("\u6570\u636e\u7c7b\u578b\u4e0d\u662fINTEGER\u3002");
        }
        return Long.parseLong(this.value);
    }

    public boolean toBoolean() {
        if (this.type != PrimaryKeyType.BOOLEAN) {
            throw new IllegalStateException("\u6570\u636e\u7c7b\u578b\u4e0d\u662fBOOLEAN\u3002");
        }
        return Boolean.parseBoolean(this.value);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PrimaryKeyValue)) {
            return false;
        }
        PrimaryKeyValue val = (PrimaryKeyValue)o;
        return this.type == val.type && this.value.equals(val.value);
    }

    public int hashCode() {
        return this.value.hashCode() ^ this.type.hashCode();
    }
}

