/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.model;

import com.aliyun.openservices.ots.internal.OTSUtil;
import com.aliyun.openservices.ots.internal.model.RequestMeta;
import com.aliyun.openservices.ots.model.ColumnType;
import com.aliyun.openservices.ots.model.ColumnValue;
import com.aliyun.openservices.ots.model.MultiDeleteRowItem;
import com.aliyun.openservices.ots.model.MultiGetRowItem;
import com.aliyun.openservices.ots.model.MultiPutRowItem;
import com.aliyun.openservices.ots.model.PartitionKeyRange;
import com.aliyun.openservices.ots.model.PartitionKeyType;
import com.aliyun.openservices.ots.model.PartitionKeyValue;
import com.aliyun.openservices.ots.model.PartitionRangeSchema;
import com.aliyun.openservices.ots.model.PartitionSchema;
import com.aliyun.openservices.ots.model.PrimaryKeyRange;
import com.aliyun.openservices.ots.model.PrimaryKeyType;
import com.aliyun.openservices.ots.model.PrimaryKeyValue;
import com.aliyun.openservices.ots.model.RangeRowQueryCriteria;
import com.aliyun.openservices.ots.model.Row;
import com.aliyun.openservices.ots.model.RowChange;
import com.aliyun.openservices.ots.model.RowDeleteChange;
import com.aliyun.openservices.ots.model.RowListing;
import com.aliyun.openservices.ots.model.RowOperationStatus;
import com.aliyun.openservices.ots.model.RowPutChange;
import com.aliyun.openservices.ots.model.SingleRowQueryCriteria;
import com.aliyun.openservices.ots.model.TableMeta;
import com.aliyun.openservices.ots.model.ViewMeta;
import com.aliyun.openservices.ots.protocol.OtsProtocol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class OTSProtocolHelper {
    public static OtsProtocol.ColumnType toPBColumnType(PartitionKeyType pkType) {
        switch (pkType) {
            case INTEGER: {
                return OtsProtocol.ColumnType.INTEGER;
            }
            case STRING: {
                return OtsProtocol.ColumnType.STRING;
            }
        }
        throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("InvalidPartitionKeyType", pkType.toString()));
    }

    public static OtsProtocol.ColumnType toPBColumnType(PrimaryKeyType pkType) {
        switch (pkType) {
            case BOOLEAN: {
                return OtsProtocol.ColumnType.BOOLEAN;
            }
            case INTEGER: {
                return OtsProtocol.ColumnType.INTEGER;
            }
            case STRING: {
                return OtsProtocol.ColumnType.STRING;
            }
        }
        throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("InvalidPrimaryKeyType", pkType.toString()));
    }

    public static PrimaryKeyType toPrimaryKeyType(OtsProtocol.ColumnType type) {
        switch (type) {
            case BOOLEAN: {
                return PrimaryKeyType.BOOLEAN;
            }
            case INTEGER: {
                return PrimaryKeyType.INTEGER;
            }
            case STRING: {
                return PrimaryKeyType.STRING;
            }
        }
        throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("InvalidPrimaryKeyType", type.toString()));
    }

    public static OtsProtocol.ColumnType toPBColumnType(ColumnType colType) {
        switch (colType) {
            case BOOLEAN: {
                return OtsProtocol.ColumnType.BOOLEAN;
            }
            case INTEGER: {
                return OtsProtocol.ColumnType.INTEGER;
            }
            case STRING: {
                return OtsProtocol.ColumnType.STRING;
            }
            case DOUBLE: {
                return OtsProtocol.ColumnType.DOUBLE;
            }
        }
        throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("InvalidColumnType", colType.toString()));
    }

    public static ColumnType toColumnType(OtsProtocol.ColumnType type) {
        switch (type) {
            case BOOLEAN: {
                return ColumnType.BOOLEAN;
            }
            case DOUBLE: {
                return ColumnType.DOUBLE;
            }
            case INTEGER: {
                return ColumnType.INTEGER;
            }
            case STRING: {
                return ColumnType.STRING;
            }
        }
        throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("InvalidColumnType", type.toString()));
    }

    public static OtsProtocol.ColumnValue buildColumnValue(PartitionKeyValue partKey) {
        OtsProtocol.ColumnValue.Builder builder = OtsProtocol.ColumnValue.newBuilder();
        switch (partKey.getType()) {
            case INTEGER: {
                builder.setType(OtsProtocol.ColumnType.INTEGER);
                builder.setValueI(partKey.toLong());
                break;
            }
            case STRING: {
                builder.setType(OtsProtocol.ColumnType.STRING);
                builder.setValueS(partKey.toString());
                break;
            }
            default: {
                throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("InvalidPartitionKeyType", partKey.getType().toString()));
            }
        }
        return builder.build();
    }

    public static OtsProtocol.ColumnValue buildColumnValue(PrimaryKeyValue primaryKey) {
        OtsProtocol.ColumnValue.Builder builder = OtsProtocol.ColumnValue.newBuilder();
        switch (primaryKey.getType()) {
            case INTEGER: {
                builder.setType(OtsProtocol.ColumnType.INTEGER);
                builder.setValueI(primaryKey.toLong());
                break;
            }
            case STRING: {
                builder.setType(OtsProtocol.ColumnType.STRING);
                builder.setValueS(primaryKey.toString());
                break;
            }
            case BOOLEAN: {
                builder.setType(OtsProtocol.ColumnType.BOOLEAN);
                builder.setValueB(primaryKey.toBoolean());
                break;
            }
            default: {
                throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("InvalidPartitionKeyType", primaryKey.getType().toString()));
            }
        }
        return builder.build();
    }

    public static OtsProtocol.ColumnValue buildRangeKeyValue(PrimaryKeyValue value) {
        OtsProtocol.ColumnValue.Builder builder = OtsProtocol.ColumnValue.newBuilder();
        if (value == PrimaryKeyRange.INF_MIN) {
            builder.setType(OtsProtocol.ColumnType.INF_MIN);
            return builder.build();
        }
        if (value == PrimaryKeyRange.INF_MAX) {
            builder.setType(OtsProtocol.ColumnType.INF_MAX);
            return builder.build();
        }
        return OTSProtocolHelper.buildColumnValue(value);
    }

    public static PrimaryKeyValue toPrimaryKeyValue(OtsProtocol.ColumnValue value) {
        switch (value.getType()) {
            case BOOLEAN: {
                if (!value.hasValueB()) {
                    throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("ValueNotSet", "ColumnValue.value_b"));
                }
                return PrimaryKeyValue.fromBoolean(value.getValueB());
            }
            case INTEGER: {
                if (!value.hasValueI()) {
                    throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("ValueNotSet", "ColumnValue.value_i"));
                }
                return PrimaryKeyValue.fromLong(value.getValueI());
            }
            case STRING: {
                if (!value.hasValueS()) {
                    throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("ValueNotSet", "ColumnValue.value_s"));
                }
                return PrimaryKeyValue.fromString(value.getValueS());
            }
        }
        throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("InvalidPrimaryKeyType", value.getType().toString()));
    }

    public static OtsProtocol.ColumnValue buildColumnValue(ColumnValue column) {
        OtsProtocol.ColumnValue.Builder builder = OtsProtocol.ColumnValue.newBuilder();
        switch (column.getType()) {
            case INTEGER: {
                builder.setType(OtsProtocol.ColumnType.INTEGER);
                builder.setValueI(column.toLong());
                break;
            }
            case STRING: {
                builder.setType(OtsProtocol.ColumnType.STRING);
                builder.setValueS(column.toString());
                break;
            }
            case BOOLEAN: {
                builder.setType(OtsProtocol.ColumnType.BOOLEAN);
                builder.setValueB(column.toBoolean());
                break;
            }
            case DOUBLE: {
                builder.setType(OtsProtocol.ColumnType.DOUBLE);
                builder.setValueD(column.toDouble());
                break;
            }
            default: {
                throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("InvalidPartitionKeyType", column.getType().toString()));
            }
        }
        return builder.build();
    }

    public static ColumnValue toColumnValue(OtsProtocol.ColumnValue value) {
        switch (value.getType()) {
            case BOOLEAN: {
                if (!value.hasValueB()) {
                    throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("ValueNotSet", "ColumnValue.value_b"));
                }
                return ColumnValue.fromBoolean(value.getValueB());
            }
            case INTEGER: {
                if (!value.hasValueI()) {
                    throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("ValueNotSet", "ColumnValue.value_i"));
                }
                return ColumnValue.fromLong(value.getValueI());
            }
            case STRING: {
                if (!value.hasValueS()) {
                    throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("ValueNotSet", "ColumnValue.value_s"));
                }
                return ColumnValue.fromString(value.getValueS());
            }
            case DOUBLE: {
                if (!value.hasValueD()) {
                    throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("ValueNotSet", "ColumnValue.value_d"));
                }
                return ColumnValue.fromDouble(value.getValueD());
            }
        }
        throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("InvalidColumnType", value.getType().toString()));
    }

    public static OtsProtocol.Column buildColumn(String name, PrimaryKeyValue value) {
        OtsProtocol.Column.Builder builder = OtsProtocol.Column.newBuilder();
        builder.setName(name);
        builder.setValue(OTSProtocolHelper.buildColumnValue(value));
        return builder.build();
    }

    public static OtsProtocol.Column buildColumn(String name, ColumnValue value) {
        OtsProtocol.Column.Builder builder = OtsProtocol.Column.newBuilder();
        builder.setName(name);
        builder.setValue(OTSProtocolHelper.buildColumnValue(value));
        return builder.build();
    }

    public static OtsProtocol.PartitionRange buildPartitionRange(PartitionKeyRange range) {
        OtsProtocol.PartitionRange.Builder builder = OtsProtocol.PartitionRange.newBuilder();
        builder.setBegin(OTSProtocolHelper.buildColumnValue(range.getBegin()));
        builder.setEnd(OTSProtocolHelper.buildColumnValue(range.getEnd()));
        return builder.build();
    }

    public static OtsProtocol.ColumnSchema buildColumnSchema(String name, PrimaryKeyType type) {
        OtsProtocol.ColumnSchema.Builder builder = OtsProtocol.ColumnSchema.newBuilder();
        builder.setName(name);
        builder.setType(OTSProtocolHelper.toPBColumnType(type));
        return builder.build();
    }

    public static OtsProtocol.ColumnSchema buildColumnSchema(String name, ColumnType type) {
        OtsProtocol.ColumnSchema.Builder builder = OtsProtocol.ColumnSchema.newBuilder();
        builder.setName(name);
        builder.setType(OTSProtocolHelper.toPBColumnType(type));
        return builder.build();
    }

    public static OtsProtocol.ViewMeta buildViewMeta(ViewMeta viewMeta) {
        OtsProtocol.ViewMeta.Builder builder = OtsProtocol.ViewMeta.newBuilder();
        builder.setViewName(viewMeta.getViewName());
        for (Map.Entry<String, PrimaryKeyType> entry : viewMeta.getPrimaryKeys().entrySet()) {
            builder.addPrimaryKeys(OTSProtocolHelper.buildColumnSchema(entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<String, Enum> entry : viewMeta.getAttributeColumns().entrySet()) {
            builder.addColumns(OTSProtocolHelper.buildColumnSchema(entry.getKey(), (ColumnType)entry.getValue()));
        }
        return builder.build();
    }

    public static OtsProtocol.TableMeta buildTableMeta(TableMeta tableMeta) {
        OtsProtocol.TableMeta.Builder builder = OtsProtocol.TableMeta.newBuilder();
        builder.setTableName(tableMeta.getTableName());
        for (ViewMeta viewMeta : tableMeta.getViews()) {
            builder.addViews(OTSProtocolHelper.buildViewMeta(viewMeta));
        }
        for (Map.Entry entry : tableMeta.getPrimaryKeys().entrySet()) {
            builder.addPrimaryKeys(OTSProtocolHelper.buildColumnSchema((String)entry.getKey(), (PrimaryKeyType)((Object)entry.getValue())));
        }
        String tableGroupName = tableMeta.getTableGroupName();
        if (tableGroupName != null && !tableGroupName.isEmpty()) {
            builder.setTableGroupName(tableGroupName);
        }
        return builder.build();
    }

    public static OtsProtocol.GetRowParameter buildGetRowParameter(SingleRowQueryCriteria criteria) {
        OtsProtocol.GetRowParameter.Builder builder = OtsProtocol.GetRowParameter.newBuilder();
        builder.setTableName(OTSUtil.getQueryEntityName(criteria));
        for (Map.Entry<String, PrimaryKeyValue> entry : criteria.getPrimaryKeys().entrySet()) {
            builder.addPrimaryKeys(OTSProtocolHelper.buildColumn(entry.getKey(), entry.getValue()));
        }
        for (String name : criteria.getColumnNames()) {
            builder.addColumnNames(name);
        }
        return builder.build();
    }

    public static OtsProtocol.Row buildRow(Map<String, PrimaryKeyValue> primaryKeys, Map<String, ColumnValue> attributeColumns) {
        OtsProtocol.Row.Builder builder = OtsProtocol.Row.newBuilder();
        for (Map.Entry<String, PrimaryKeyValue> entry : primaryKeys.entrySet()) {
            builder.addPrimaryKeys(OTSProtocolHelper.buildColumn(entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : attributeColumns.entrySet()) {
            builder.addColumns(OTSProtocolHelper.buildColumn(entry.getKey(), (ColumnValue)entry.getValue()));
        }
        return builder.build();
    }

    public static OtsProtocol.RowPutChange buildRowPutChange(RowPutChange rowChange) {
        OtsProtocol.RowPutChange.Builder builder = OtsProtocol.RowPutChange.newBuilder();
        builder.setRow(OTSProtocolHelper.buildRow(rowChange.getPrimaryKeys(), rowChange.getAttributeColumns()));
        switch (rowChange.getChecking()) {
            case INSERT: {
                builder.setCheckingType(OtsProtocol.RowPutChange.CheckingType.INSERT);
                break;
            }
            case NO: {
                builder.setCheckingType(OtsProtocol.RowPutChange.CheckingType.NO);
                break;
            }
            case UPDATE: {
                builder.setCheckingType(OtsProtocol.RowPutChange.CheckingType.UPDATE);
            }
        }
        return builder.build();
    }

    public static OtsProtocol.RowDeleteChange buildRowDeleteChange(RowDeleteChange rowChange) {
        OtsProtocol.RowDeleteChange.Builder builder = OtsProtocol.RowDeleteChange.newBuilder();
        for (Map.Entry<String, PrimaryKeyValue> entry : rowChange.getPrimaryKeys().entrySet()) {
            builder.addPrimaryKeys(OTSProtocolHelper.buildColumn(entry.getKey(), entry.getValue()));
        }
        for (String name : rowChange.getColumnNames()) {
            builder.addColumnNames(name);
        }
        return builder.build();
    }

    public static OtsProtocol.PutRowParameter buildPutRowParameter(String tableName, RowPutChange rowChange) {
        OtsProtocol.PutRowParameter.Builder builder = OtsProtocol.PutRowParameter.newBuilder();
        builder.setTableName(tableName);
        builder.setRowChange(OTSProtocolHelper.buildRowPutChange(rowChange));
        return builder.build();
    }

    public static OtsProtocol.DeleteRowParameter buildDeleteRowParameter(String tableName, RowDeleteChange rowChange) {
        OtsProtocol.DeleteRowParameter.Builder builder = OtsProtocol.DeleteRowParameter.newBuilder();
        builder.setTableName(tableName);
        builder.setRowChange(OTSProtocolHelper.buildRowDeleteChange(rowChange));
        return builder.build();
    }

    public static byte[] buildCreateTableGroupRequest(String tableGroupName, PartitionKeyType pkType) {
        OtsProtocol.CreateTableGroupRequest.Builder builder = OtsProtocol.CreateTableGroupRequest.newBuilder();
        builder.setTableGroupName(tableGroupName);
        builder.setPartitionKeyType(OTSProtocolHelper.toPBColumnType(pkType));
        return builder.build().toByteArray();
    }

    public static byte[] buildCreateTableGroupExRequest(String tableGroupName, PartitionSchema partitionSchema) {
        OtsProtocol.CreateTableGroupExRequest.Builder builder = OtsProtocol.CreateTableGroupExRequest.newBuilder();
        builder.setTableGroupName(tableGroupName);
        if (!(partitionSchema instanceof PartitionRangeSchema)) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("InvalidPartitionSchema"));
        }
        PartitionRangeSchema ps = (PartitionRangeSchema)partitionSchema;
        for (PartitionKeyRange range : ps.getRanges()) {
            builder.addPartitions(OTSProtocolHelper.buildPartitionRange(range));
        }
        return builder.build().toByteArray();
    }

    public static byte[] buildDeleteTableGroupRequest(String tableGroupName) {
        OtsProtocol.DeleteTableGroupRequest.Builder builder = OtsProtocol.DeleteTableGroupRequest.newBuilder();
        builder.setTableGroupName(tableGroupName);
        return builder.build().toByteArray();
    }

    public static byte[] buildCreateTableRequest(TableMeta tableMeta) {
        OtsProtocol.CreateTableRequest.Builder builder = OtsProtocol.CreateTableRequest.newBuilder();
        builder.setTableMeta(OTSProtocolHelper.buildTableMeta(tableMeta));
        return builder.build().toByteArray();
    }

    public static byte[] buildCreateTableExRequest(TableMeta tableMeta, PartitionSchema schema) {
        OtsProtocol.CreateTableExRequest.Builder builder = OtsProtocol.CreateTableExRequest.newBuilder();
        builder.setTableMeta(OTSProtocolHelper.buildTableMeta(tableMeta));
        if (!(schema instanceof PartitionRangeSchema)) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("InvalidPartitionSchema"));
        }
        PartitionRangeSchema ps = (PartitionRangeSchema)schema;
        for (PartitionKeyRange range : ps.getRanges()) {
            builder.addPartitions(OTSProtocolHelper.buildPartitionRange(range));
        }
        return builder.build().toByteArray();
    }

    public static byte[] buildGetTableMetaRequest(String tableName) {
        OtsProtocol.GetTableMetaRequest.Builder builder = OtsProtocol.GetTableMetaRequest.newBuilder();
        builder.setTableName(tableName);
        return builder.build().toByteArray();
    }

    public static byte[] buildDeleteTableRequest(String tableName) {
        OtsProtocol.DeleteTableRequest.Builder builder = OtsProtocol.DeleteTableRequest.newBuilder();
        builder.setTableName(tableName);
        return builder.build().toByteArray();
    }

    public static byte[] buildGetRowRequest(SingleRowQueryCriteria criteria, String transactionId) {
        OtsProtocol.GetRowRequest.Builder builder = OtsProtocol.GetRowRequest.newBuilder();
        builder.setGetRowParameter(OTSProtocolHelper.buildGetRowParameter(criteria));
        if (transactionId != null && !transactionId.isEmpty()) {
            builder.setTransactionId(transactionId);
        }
        return builder.build().toByteArray();
    }

    public static byte[] buildGetRowsByRangeRequest(RangeRowQueryCriteria criteria, String transactionId, String nextToken) {
        OtsProtocol.GetRowsByRangeRequest.Builder builder = OtsProtocol.GetRowsByRangeRequest.newBuilder();
        builder.setTableName(OTSUtil.getQueryEntityName(criteria));
        for (Map.Entry<String, PrimaryKeyValue> entry : criteria.getPrimaryKeys().entrySet()) {
            builder.addPrimaryKeyPrefix(OTSProtocolHelper.buildColumn(entry.getKey(), entry.getValue()));
        }
        builder.setRangeKeyName(criteria.getRange().getPrimaryKeyName());
        builder.setRangeBegin(OTSProtocolHelper.buildRangeKeyValue(criteria.getRange().getBegin()));
        builder.setRangeEnd(OTSProtocolHelper.buildRangeKeyValue(criteria.getRange().getEnd()));
        for (String name : criteria.getColumnNames()) {
            builder.addColumnNames(name);
        }
        builder.setIsReverse(criteria.getIsReverse());
        if (criteria.getTop() >= 0) {
            builder.setLimit(criteria.getTop());
        }
        if (nextToken != null && !nextToken.isEmpty()) {
            builder.setNextToken(nextToken);
        } else {
            builder.setNextToken("");
        }
        if (transactionId != null && !transactionId.isEmpty()) {
            builder.setTransactionId(transactionId);
        }
        return builder.build().toByteArray();
    }

    public static byte[] buildMultiGetRowRequest(List<SingleRowQueryCriteria> criterias) {
        OtsProtocol.MultiGetRowRequest.Builder builder = OtsProtocol.MultiGetRowRequest.newBuilder();
        for (SingleRowQueryCriteria criteria : criterias) {
            builder.addParameters(OTSProtocolHelper.buildGetRowParameter(criteria));
        }
        return builder.build().toByteArray();
    }

    public static byte[] buildDeleteRowRequest(String tableName, RowDeleteChange rowChange, String transactionId) {
        OtsProtocol.DeleteRowRequest.Builder builder = OtsProtocol.DeleteRowRequest.newBuilder();
        builder.setDeleteRowParameter(OTSProtocolHelper.buildDeleteRowParameter(tableName, rowChange));
        if (transactionId != null && !transactionId.isEmpty()) {
            builder.setTransactionId(transactionId);
        }
        return builder.build().toByteArray();
    }

    public static byte[] buildMultiDeleteRowRequest(List<MultiDeleteRowItem> rowChanges) {
        OtsProtocol.MultiDeleteRowRequest.Builder builder = OtsProtocol.MultiDeleteRowRequest.newBuilder();
        for (MultiDeleteRowItem item : rowChanges) {
            builder.addParameters(OTSProtocolHelper.buildDeleteRowParameter(item.getTableName(), item.getRowDeleteChange()));
        }
        return builder.build().toByteArray();
    }

    public static byte[] buildBatchModifyRowRequest(String tableName, Collection<RowChange> rowChanges, String transactionId) {
        OtsProtocol.BatchModifyRowRequest.Builder builder = OtsProtocol.BatchModifyRowRequest.newBuilder();
        builder.setTableName(tableName);
        for (RowChange rowChange : rowChanges) {
            OtsProtocol.ModifyItem.Builder miBuilder = OtsProtocol.ModifyItem.newBuilder();
            if (rowChange instanceof RowPutChange) {
                miBuilder.setType(OtsProtocol.ModifyItem.ModifyType.PUT);
                miBuilder.setRowPutChange(OTSProtocolHelper.buildRowPutChange((RowPutChange)rowChange));
            } else if (rowChange instanceof RowDeleteChange) {
                miBuilder.setType(OtsProtocol.ModifyItem.ModifyType.DELETE);
                miBuilder.setRowDeleteChange(OTSProtocolHelper.buildRowDeleteChange((RowDeleteChange)rowChange));
            }
            builder.addModifyItems(miBuilder.build());
        }
        if (transactionId != null && !transactionId.isEmpty()) {
            builder.setTransactionId(transactionId);
        }
        return builder.build().toByteArray();
    }

    public static byte[] buildPutRowRequest(String tableName, RowPutChange rowChange, String transactionId) {
        OtsProtocol.PutRowRequest.Builder builder = OtsProtocol.PutRowRequest.newBuilder();
        builder.setPutRowParameter(OTSProtocolHelper.buildPutRowParameter(tableName, rowChange));
        if (transactionId != null && !transactionId.isEmpty()) {
            builder.setTransactionId(transactionId);
        }
        return builder.build().toByteArray();
    }

    public static byte[] buildMultiPutRowRequest(List<MultiPutRowItem> rowChanges) {
        OtsProtocol.MultiPutRowRequest.Builder builder = OtsProtocol.MultiPutRowRequest.newBuilder();
        for (MultiPutRowItem item : rowChanges) {
            builder.addParameters(OTSProtocolHelper.buildPutRowParameter(item.getTableName(), item.getRowPutChange()));
        }
        return builder.build().toByteArray();
    }

    public static byte[] buildStartTransactionRequest(String entityName, PartitionKeyValue pkValue) {
        OtsProtocol.StartTransactionRequest.Builder builder = OtsProtocol.StartTransactionRequest.newBuilder();
        builder.setEntityName(entityName);
        builder.setPartitionKeyValue(OTSProtocolHelper.buildColumnValue(pkValue));
        return builder.build().toByteArray();
    }

    public static byte[] buildCommitTransaction(String transactionId) {
        OtsProtocol.CommitTransactionRequest.Builder builder = OtsProtocol.CommitTransactionRequest.newBuilder();
        builder.setTransactionId(transactionId);
        return builder.build().toByteArray();
    }

    public static byte[] buildAbortTransaction(String transactionId) {
        OtsProtocol.AbortTransactionRequest.Builder builder = OtsProtocol.AbortTransactionRequest.newBuilder();
        builder.setTransactionId(transactionId);
        return builder.build().toByteArray();
    }

    public static TableMeta parseGetTableMetaResponse(OtsProtocol.GetTableMetaResponse response) {
        OtsProtocol.TableMeta tm = response.getTableMeta();
        TableMeta tableMeta = new TableMeta(tm.getTableName());
        for (OtsProtocol.ViewMeta vm : tm.getViewsList()) {
            ViewMeta viewMeta = new ViewMeta(vm.getViewName());
            for (OtsProtocol.ColumnSchema pk : vm.getPrimaryKeysList()) {
                viewMeta.addPrimaryKey(pk.getName(), OTSProtocolHelper.toPrimaryKeyType(pk.getType()));
            }
            for (OtsProtocol.ColumnSchema col : vm.getColumnsList()) {
                viewMeta.addAttributeColumn(col.getName(), OTSProtocolHelper.toColumnType(col.getType()));
            }
            tableMeta.addView(viewMeta);
        }
        for (OtsProtocol.ColumnSchema pk : tm.getPrimaryKeysList()) {
            tableMeta.addPrimaryKey(pk.getName(), OTSProtocolHelper.toPrimaryKeyType(pk.getType()));
        }
        if (tm.hasTableGroupName()) {
            tableMeta.setTableGroupName(tm.getTableGroupName());
        }
        return tableMeta;
    }

    public static Row parseRow(OtsProtocol.Row pbRow) {
        Row row = new Row();
        for (OtsProtocol.Column pk : pbRow.getPrimaryKeysList()) {
            row.addColumn(pk.getName(), OTSProtocolHelper.toColumnValue(pk.getValue()));
        }
        for (OtsProtocol.Column col : pbRow.getColumnsList()) {
            row.addColumn(col.getName(), OTSProtocolHelper.toColumnValue(col.getValue()));
        }
        return row;
    }

    public static Row parseGetRowResponse(OtsProtocol.GetRowResponse response) {
        return OTSProtocolHelper.parseRow(response.getRow());
    }

    public static RowListing parseGetRowsByRangeResponse(OtsProtocol.GetRowsByRangeResponse response) {
        RowListing result = new RowListing();
        ArrayList<Row> rows = new ArrayList<Row>(response.getRowsCount());
        for (OtsProtocol.Row row : response.getRowsList()) {
            rows.add(OTSProtocolHelper.parseRow(row));
        }
        result.setRows(rows);
        if (response.hasNextToken()) {
            result.setNextToken(response.getNextToken());
        }
        return result;
    }

    public static List<MultiGetRowItem> parseMultiGetRowResponse(OtsProtocol.MultiGetRowResponse response, RequestMeta requestMeta) {
        ArrayList<MultiGetRowItem> result = new ArrayList<MultiGetRowItem>(response.getItemsCount());
        for (OtsProtocol.MultiGetRowResponseItem itemRes : response.getItemsList()) {
            MultiGetRowItem item = new MultiGetRowItem();
            item.setRequestID(requestMeta.getRequestID());
            item.setHostID(requestMeta.getHostID());
            item.setTableName(itemRes.getTableName());
            if (itemRes.getIsSucceed()) {
                if (!itemRes.hasTableName() || !itemRes.hasRow()) {
                    throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("ValueNotSet", "MultiGetRowResponseItem.table_name or MultiGetRowResponseItem.row"));
                }
                if (!itemRes.hasError()) {
                    item.setCode("OK");
                } else {
                    item.setCode(itemRes.getError().getCode());
                }
                item.setRow(OTSProtocolHelper.parseRow(itemRes.getRow()));
            } else {
                if (!itemRes.hasError()) {
                    throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("ValueNotSet", "MultiGetRowResponseItem.error"));
                }
                OtsProtocol.ErrorMessage errMsg = itemRes.getError();
                item.setCode(errMsg.getCode());
                if (errMsg.hasMessage()) {
                    item.setMessage(errMsg.getMessage());
                }
            }
            result.add(item);
        }
        return result;
    }

    public static List<RowOperationStatus> parseMultiPutRowResponse(OtsProtocol.MultiPutRowResponse response, RequestMeta requestMeta) {
        ArrayList<RowOperationStatus> result = new ArrayList<RowOperationStatus>();
        for (OtsProtocol.ErrorMessage errMsg : response.getMessagesList()) {
            RowOperationStatus status = new RowOperationStatus();
            status.setRequestID(requestMeta.getRequestID());
            status.setHostID(requestMeta.getHostID());
            status.setCode(errMsg.getCode());
            if (errMsg.hasMessage()) {
                status.setMessage(errMsg.getMessage());
            }
            result.add(status);
        }
        return result;
    }

    public static List<RowOperationStatus> parseMultiDeleteRowResponse(OtsProtocol.MultiDeleteRowResponse response, RequestMeta requestMeta) {
        ArrayList<RowOperationStatus> result = new ArrayList<RowOperationStatus>();
        for (OtsProtocol.ErrorMessage errMsg : response.getMessagesList()) {
            RowOperationStatus status = new RowOperationStatus();
            status.setRequestID(requestMeta.getRequestID());
            status.setHostID(requestMeta.getHostID());
            status.setCode(errMsg.getCode());
            if (errMsg.hasMessage()) {
                status.setMessage(errMsg.getMessage());
            }
            result.add(status);
        }
        return result;
    }
}

