/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal;

import com.aliyun.common.utils.ResourceManager;
import com.aliyun.openservices.ClientException;
import com.aliyun.openservices.ots.model.ColumnType;
import com.aliyun.openservices.ots.model.ColumnValue;
import com.aliyun.openservices.ots.model.PartitionKeyType;
import com.aliyun.openservices.ots.model.PartitionKeyValue;
import com.aliyun.openservices.ots.model.PrimaryKeyRange;
import com.aliyun.openservices.ots.model.PrimaryKeyType;
import com.aliyun.openservices.ots.model.PrimaryKeyValue;
import com.aliyun.openservices.ots.model.RowQueryCriteria;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;

public class OTSUtil {
    public static final ResourceManager OTS_RESOURCE_MANAGER = ResourceManager.getInstance("ots");

    public static boolean nameValid(String name) {
        assert (name != null);
        String pattern = "^[a-zA-Z_][\\w]{0,99}$";
        return name.matches(pattern);
    }

    public static void ensureNameValid(String name) {
        if (!OTSUtil.nameValid(name)) {
            throw new IllegalArgumentException(OTS_RESOURCE_MANAGER.getFormattedString("NameIsInvalid", name));
        }
    }

    public static byte[] dataEncode(String data) {
        try {
            return data.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"Unsupported encoding\uff1autf-8");
        }
    }

    public static String dataDecode(byte[] bytes) {
        try {
            CharsetDecoder decoder = Charset.forName("utf-8").newDecoder().onMalformedInput(CodingErrorAction.REPORT);
            CharBuffer cb = decoder.decode(ByteBuffer.wrap(bytes));
            return cb.toString();
        }
        catch (CharacterCodingException e) {
            throw new ClientException(OTS_RESOURCE_MANAGER.getFormattedString("ValueInInvalidCharset", new String(bytes)));
        }
    }

    public static int stringtoUTF8Bytes(String str, byte[] buffer) {
        int index = 0;
        for (int i = 0; i < str.length(); ++i) {
            char strChar = str.charAt(i);
            if ((strChar & 0xFF80) == 0) {
                buffer[index++] = (byte)(strChar & 0xFF);
                continue;
            }
            if ((strChar & 0xF800) == 0) {
                buffer[index++] = (byte)(strChar >> 6 | 0xC0);
                buffer[index++] = (byte)(strChar & 0x3F | 0x80);
                continue;
            }
            buffer[index++] = (byte)(strChar >> 12 | 0xE0);
            buffer[index++] = (byte)(strChar >> 6 & 0x3F | 0x80);
            buffer[index++] = (byte)(strChar & 0x3F | 0x80);
        }
        return index;
    }

    public static String getParameterString(PartitionKeyValue value) {
        assert (value != null);
        if (value.getType() == PartitionKeyType.STRING) {
            return String.format("'%s'", value.getValue());
        }
        return value.getValue();
    }

    public static String getParameterString(PrimaryKeyValue value) {
        assert (value != null);
        if (value.getType() == PrimaryKeyType.STRING) {
            return String.format("'%s'", value.getValue());
        }
        if (value.getType() == null) {
            assert (value.getValue() == PrimaryKeyRange.INF_MAX.getValue() || value.getValue() == PrimaryKeyRange.INF_MIN.getValue());
            return value.getValue();
        }
        return value.getValue();
    }

    public static String getParameterString(ColumnValue value) {
        assert (value != null);
        if (value.getType() == ColumnType.STRING) {
            return String.format("'%s'", value.getValue());
        }
        return value.getValue();
    }

    public static String getQueryEntityName(RowQueryCriteria criteria) {
        String entityName = criteria.getTableName();
        String viewName = criteria.getViewName();
        if (viewName != null && viewName.length() > 0) {
            entityName = entityName + "." + viewName;
        }
        return entityName;
    }

    public static int compare(PrimaryKeyValue left, PrimaryKeyValue right) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        if (left.equals(PrimaryKeyRange.INF_MIN)) {
            return right.equals(PrimaryKeyRange.INF_MIN) ? 0 : -1;
        }
        if (left.equals(PrimaryKeyRange.INF_MAX)) {
            return right.equals(PrimaryKeyRange.INF_MAX) ? 0 : 1;
        }
        if (right.equals(PrimaryKeyRange.INF_MIN)) {
            return left.equals(PrimaryKeyRange.INF_MIN) ? 0 : 1;
        }
        if (right.equals(PrimaryKeyRange.INF_MAX)) {
            return left.equals(PrimaryKeyRange.INF_MAX) ? 0 : -1;
        }
        assert (left.getType() != null && right.getType() != null && left.getType() == right.getType());
        if (left.getType() == PrimaryKeyType.INTEGER) {
            long lRight;
            long lLeft = left.toLong();
            if (lLeft > (lRight = right.toLong())) {
                return 1;
            }
            if (lLeft < lRight) {
                return -1;
            }
            return 0;
        }
        if (left.getType() == PrimaryKeyType.BOOLEAN) {
            if (left.getValue() == right.getValue()) {
                return 0;
            }
            if (left.toBoolean()) {
                return 1;
            }
            return -1;
        }
        assert (left.getType() == PrimaryKeyType.STRING);
        return left.getValue().compareTo(right.getValue());
    }

    public static boolean isPKInf(PrimaryKeyValue pk) {
        return pk == PrimaryKeyRange.INF_MAX || pk == PrimaryKeyRange.INF_MIN;
    }
}

