/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal;

import com.aliyun.common.auth.ServiceCredentials;
import com.aliyun.common.comm.ServiceClient;
import com.aliyun.common.utils.CodingUtils;
import com.aliyun.openservices.ClientException;
import com.aliyun.openservices.HttpMethod;
import com.aliyun.openservices.ots.OTSException;
import com.aliyun.openservices.ots.OTSServiceConfiguration;
import com.aliyun.openservices.ots.internal.OTSOperation;
import com.aliyun.openservices.ots.internal.OTSResultParserFactory;
import com.aliyun.openservices.ots.internal.OTSUtil;
import com.aliyun.openservices.ots.internal.model.ResponseContentWithMeta;
import com.aliyun.openservices.ots.model.OTSProtocolHelper;
import com.aliyun.openservices.ots.model.PartitionKeyValue;
import com.aliyun.openservices.ots.protocol.OtsProtocol;
import com.google.protobuf.Message;
import java.net.URI;

public class OTSTransactionOperation
extends OTSOperation {
    private static final String ACTION_STARTTRANSACTION = "StartTransaction";
    private static final String ACTION_COMMITTRANSACTION = "CommitTransaction";
    private static final String ACTION_ABORTTRANSACTION = "AbortTransaction";

    public OTSTransactionOperation(URI endpoint, ServiceClient client, ServiceCredentials credentials, OTSServiceConfiguration serviceConfig) {
        super(endpoint, client, credentials, serviceConfig);
    }

    public OTSTransactionOperation(URI endpoint, ServiceClient client, ServiceCredentials credentials) {
        super(endpoint, client, credentials, new OTSServiceConfiguration());
    }

    public String startTransaction(String entityName, PartitionKeyValue pkValue) throws OTSException, ClientException {
        CodingUtils.assertParameterNotNull(entityName, " entityName");
        OTSUtil.ensureNameValid(entityName);
        CodingUtils.assertParameterNotNull(pkValue, "pkValue");
        ResponseContentWithMeta result = (ResponseContentWithMeta)this.invoke(ACTION_STARTTRANSACTION, HttpMethod.POST, null, OTSProtocolHelper.buildStartTransactionRequest(entityName, pkValue), OTSResultParserFactory.createFactory().createProtocolBufferResultParser((Message)OtsProtocol.StartTransactionResponse.getDefaultInstance()));
        return ((OtsProtocol.StartTransactionResponse)result.getMessage()).getTransactionId();
    }

    public void commitTransaction(String transactionId) throws OTSException, ClientException {
        CodingUtils.assertStringNotNullOrEmpty(transactionId, "transactionId");
        this.invokeNoResult(ACTION_COMMITTRANSACTION, HttpMethod.POST, null, OTSProtocolHelper.buildCommitTransaction(transactionId));
    }

    public void abortTransaction(String transactionId) throws OTSException, ClientException {
        CodingUtils.assertStringNotNullOrEmpty(transactionId, "transactionId");
        this.invokeNoResult(ACTION_ABORTTRANSACTION, HttpMethod.POST, null, OTSProtocolHelper.buildAbortTransaction(transactionId));
    }
}

