/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal;

import com.aliyun.common.auth.ServiceCredentials;
import com.aliyun.common.comm.ServiceClient;
import com.aliyun.common.utils.CodingUtils;
import com.aliyun.openservices.ClientException;
import com.aliyun.openservices.HttpMethod;
import com.aliyun.openservices.ots.OTSException;
import com.aliyun.openservices.ots.OTSServiceConfiguration;
import com.aliyun.openservices.ots.internal.OTSOperation;
import com.aliyun.openservices.ots.internal.OTSResultParserFactory;
import com.aliyun.openservices.ots.internal.OTSUtil;
import com.aliyun.openservices.ots.internal.model.ResponseContentWithMeta;
import com.aliyun.openservices.ots.model.OTSProtocolHelper;
import com.aliyun.openservices.ots.model.PartitionKeyType;
import com.aliyun.openservices.ots.model.PartitionSchema;
import com.aliyun.openservices.ots.model.TableMeta;
import com.aliyun.openservices.ots.model.ViewMeta;
import com.aliyun.openservices.ots.protocol.OtsProtocol;
import com.google.protobuf.Message;
import java.net.URI;
import java.util.List;

public class OTSTableOperation
extends OTSOperation {
    private static final String ACTION_CREATETABLEGROUP = "CreateTableGroup";
    private static final String ACTION_CREATETABLEGROUP_EX = "CreateTableGroupEx";
    private static final String ACTION_LISTTABLEGROUP = "ListTableGroup";
    private static final String ACTION_DELETETABLEGROUP = "DeleteTableGroup";
    private static final String ACTION_CREATETABLE = "CreateTable";
    private static final String ACTION_CREATETABLE_EX = "CreateTableEx";
    private static final String ACTION_GETTABLEMETA = "GetTableMeta";
    private static final String ACTION_LISTTABLE = "ListTable";
    private static final String ACTION_DELETETABLE = "DeleteTable";

    public OTSTableOperation(URI endpoint, ServiceClient client, ServiceCredentials credentials, OTSServiceConfiguration serviceConfig) {
        super(endpoint, client, credentials, serviceConfig);
    }

    public OTSTableOperation(URI endpoint, ServiceClient client, ServiceCredentials credentials) {
        super(endpoint, client, credentials, new OTSServiceConfiguration());
    }

    public void createTableGroup(String tableGroupName, PartitionKeyType pkType) throws OTSException, ClientException {
        CodingUtils.assertParameterNotNull(tableGroupName, "tableGroupName");
        OTSUtil.ensureNameValid(tableGroupName);
        this.invokeNoResult(ACTION_CREATETABLEGROUP, HttpMethod.POST, null, OTSProtocolHelper.buildCreateTableGroupRequest(tableGroupName, pkType));
    }

    public void createTableGroupEx(String tableGroupName, PartitionSchema partitionSchema) throws OTSException, ClientException {
        CodingUtils.assertParameterNotNull(tableGroupName, "tableGroupName");
        OTSUtil.ensureNameValid(tableGroupName);
        this.invokeNoResult(ACTION_CREATETABLEGROUP_EX, HttpMethod.POST, null, OTSProtocolHelper.buildCreateTableGroupExRequest(tableGroupName, partitionSchema));
    }

    public List<String> listTableGroups() throws OTSException, ClientException {
        ResponseContentWithMeta result = (ResponseContentWithMeta)this.invoke(ACTION_LISTTABLEGROUP, HttpMethod.POST, null, null, OTSResultParserFactory.createFactory().createProtocolBufferResultParser((Message)OtsProtocol.ListTableGroupResponse.getDefaultInstance()));
        return ((OtsProtocol.ListTableGroupResponse)result.getMessage()).getTableGroupNamesList();
    }

    public void deleteTableGroup(String tableGroupName) throws OTSException, ClientException {
        CodingUtils.assertParameterNotNull(tableGroupName, "tableGroupName");
        OTSUtil.ensureNameValid(tableGroupName);
        this.invokeNoResult(ACTION_DELETETABLEGROUP, HttpMethod.POST, null, OTSProtocolHelper.buildDeleteTableGroupRequest(tableGroupName));
    }

    public void createTable(TableMeta tableMeta) throws OTSException, ClientException {
        CodingUtils.assertParameterNotNull(tableMeta, "tableMeta");
        if (tableMeta.getPrimaryKeys().size() == 0) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("TableMetaHasNoPK"));
        }
        for (ViewMeta viewMeta : tableMeta.getViews()) {
            if (viewMeta.getPrimaryKeys().size() != 0) continue;
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("ViewMetaHasNoPK"));
        }
        this.invokeNoResult(ACTION_CREATETABLE, HttpMethod.POST, null, OTSProtocolHelper.buildCreateTableRequest(tableMeta));
    }

    public void createTableEx(TableMeta tableMeta, PartitionSchema schema) throws OTSException, ClientException {
        CodingUtils.assertParameterNotNull(tableMeta, "tableMeta");
        if (tableMeta.getPrimaryKeys().size() == 0) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("TableMetaHasNoPK"));
        }
        for (ViewMeta viewMeta : tableMeta.getViews()) {
            if (viewMeta.getPrimaryKeys().size() != 0) continue;
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("ViewMetaHasNoPK"));
        }
        this.invokeNoResult(ACTION_CREATETABLE_EX, HttpMethod.POST, null, OTSProtocolHelper.buildCreateTableExRequest(tableMeta, schema));
    }

    public TableMeta getTableMeta(String tableName) throws OTSException, ClientException {
        CodingUtils.assertParameterNotNull(tableName, "tableName");
        OTSUtil.ensureNameValid(tableName);
        ResponseContentWithMeta result = (ResponseContentWithMeta)this.invoke(ACTION_GETTABLEMETA, HttpMethod.POST, null, OTSProtocolHelper.buildGetTableMetaRequest(tableName), OTSResultParserFactory.createFactory().createProtocolBufferResultParser((Message)OtsProtocol.GetTableMetaResponse.getDefaultInstance()));
        return OTSProtocolHelper.parseGetTableMetaResponse((OtsProtocol.GetTableMetaResponse)result.getMessage());
    }

    public List<String> listTables() throws OTSException, ClientException {
        ResponseContentWithMeta result = (ResponseContentWithMeta)this.invoke(ACTION_LISTTABLE, HttpMethod.POST, null, null, OTSResultParserFactory.createFactory().createProtocolBufferResultParser((Message)OtsProtocol.ListTableResponse.getDefaultInstance()));
        return ((OtsProtocol.ListTableResponse)result.getMessage()).getTableNamesList();
    }

    public void deleteTable(String tableName) throws OTSException, ClientException {
        CodingUtils.assertParameterNotNull(tableName, "tableName");
        OTSUtil.ensureNameValid(tableName);
        this.invokeNoResult(ACTION_DELETETABLE, HttpMethod.POST, null, OTSProtocolHelper.buildDeleteTableRequest(tableName));
    }
}

