/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal;

import com.aliyun.common.auth.ServiceCredentials;
import com.aliyun.common.comm.ExecutionContext;
import com.aliyun.common.comm.HttpMesssage;
import com.aliyun.common.comm.RequestMessage;
import com.aliyun.common.comm.ServiceClient;
import com.aliyun.common.parser.ResultParser;
import com.aliyun.common.utils.BinaryUtil;
import com.aliyun.openservices.ClientException;
import com.aliyun.openservices.HttpMethod;
import com.aliyun.openservices.ServiceException;
import com.aliyun.openservices.ots.OTSException;
import com.aliyun.openservices.ots.OTSServiceConfiguration;
import com.aliyun.openservices.ots.internal.OTSCompressUtil;
import com.aliyun.openservices.ots.internal.OTSContentMD5ResponseHandler;
import com.aliyun.openservices.ots.internal.OTSDeflateResponseHandler;
import com.aliyun.openservices.ots.internal.OTSErrorResponseHandler;
import com.aliyun.openservices.ots.internal.OTSExceptionFactory;
import com.aliyun.openservices.ots.internal.OTSRequestSigner;
import com.aliyun.openservices.ots.internal.OTSRetryStrategyFactroy;
import com.aliyun.openservices.ots.internal.OTSUtil;
import com.aliyun.openservices.ots.internal.OTSValidationResponseHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.Deflater;

public abstract class OTSOperation {
    private URI endpoint;
    private ServiceClient client;
    private ServiceCredentials credentials;
    private OTSServiceConfiguration serviceConfig;

    public OTSOperation(URI endpoint, ServiceClient client, ServiceCredentials credentials, OTSServiceConfiguration serviceConfig) {
        assert (endpoint != null && client != null && credentials != null && serviceConfig != null);
        this.endpoint = endpoint;
        this.client = client;
        this.credentials = credentials;
        this.serviceConfig = serviceConfig;
    }

    protected <T> T invoke(String otsAction, HttpMethod httpMethod, Map<String, String> queryParameters, byte[] content, ResultParser resultParser) throws OTSException, ClientException {
        RequestMessage request = this.buildRequest(otsAction, httpMethod, queryParameters, content);
        try {
            return this.client.sendRequest(request, this.createContext(otsAction, queryParameters), resultParser);
        }
        catch (ServiceException e) {
            throw this.handleException(e);
        }
    }

    protected void invokeNoResult(String otsAction, HttpMethod httpMethod, Map<String, String> queryParameters, byte[] content) throws OTSException, ClientException {
        RequestMessage request = this.buildRequest(otsAction, httpMethod, queryParameters, content);
        HttpMesssage response = null;
        try {
            response = this.client.sendRequest(request, this.createContext(otsAction, queryParameters));
        }
        catch (ServiceException e) {
            throw this.handleException(e);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private ExecutionContext createContext(String otsAction, Map<String, String> parameters) {
        ExecutionContext ec = new ExecutionContext();
        ec.setCharset("utf-8");
        ec.setSigner(new OTSRequestSigner(otsAction, this.credentials));
        ec.setRetryStrategy(OTSRetryStrategyFactroy.getFactory().getStrategy(otsAction, parameters));
        if (this.serviceConfig.isEnableResponseContentMD5Checking()) {
            ec.getResponseHandlers().add(new OTSContentMD5ResponseHandler());
        }
        ec.getResponseHandlers().add(new OTSDeflateResponseHandler());
        ec.getResponseHandlers().add(new OTSErrorResponseHandler());
        ec.getResponseHandlers().add(new OTSValidationResponseHandler(this.credentials, otsAction));
        return ec;
    }

    private RequestMessage buildRequest(String otsAction, HttpMethod httpMethod, Map<String, String> parameters, byte[] content) {
        return this.buildRequest(this.endpoint, otsAction, httpMethod, parameters, content, this.credentials);
    }

    private RequestMessage buildRequest(URI endpoint, String action, HttpMethod httpMethod, Map<String, String> parameters, byte[] content, ServiceCredentials credentials) {
        assert (endpoint != null && action != null && httpMethod != null && credentials != null);
        if (parameters == null) {
            parameters = new LinkedHashMap<String, String>();
        }
        if (content == null) {
            content = new byte[]{};
        }
        RequestMessage request = new RequestMessage();
        request.setMethod(httpMethod);
        request.setEndpoint(endpoint);
        request.setResourcePath(action);
        request.setParameters(parameters);
        byte[] dataToSend = null;
        if (this.serviceConfig.isEnableRequestCompression()) {
            try {
                dataToSend = OTSCompressUtil.compress(new ByteArrayInputStream(content), new Deflater());
            }
            catch (IOException e) {
                throw new ClientException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("RequestCompressFail", e.getMessage()));
            }
            request.addHeader("x-ots-request-compress-type", "deflate");
            request.addHeader("x-ots-request-compress-size", Integer.toString(content.length));
        } else {
            dataToSend = content;
        }
        request.setContent(new ByteArrayInputStream(dataToSend));
        request.setContentLength(dataToSend.length);
        this.addRequiredHeaders(request, dataToSend);
        return request;
    }

    private void addRequiredHeaders(RequestMessage request, byte[] content) {
        request.addHeader("x-ots-contentmd5", BinaryUtil.toBase64String(BinaryUtil.calculateMd5(content)));
        request.addHeader("x-ots-apiversion", "2013-05-10");
        if (this.serviceConfig.isEnableResponseCompression()) {
            request.addHeader("x-ots-response-compress-type", "deflate");
        }
    }

    private OTSException handleException(ServiceException e) {
        if (e instanceof OTSException) {
            return (OTSException)e;
        }
        return OTSExceptionFactory.create("\u8bf7\u6c42\u5931\u8d25\uff1a" + e.getMessage(), e);
    }
}

