/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal;

import com.aliyun.common.comm.ResponseHandler;
import com.aliyun.common.comm.ResponseMessage;
import com.aliyun.common.utils.ResourceManager;
import com.aliyun.openservices.ClientException;
import com.aliyun.openservices.ots.OTSException;
import com.aliyun.openservices.ots.internal.OTSExceptionFactory;
import com.aliyun.openservices.ots.internal.OTSUtil;
import com.aliyun.openservices.ots.protocol.OtsProtocol;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class OTSErrorResponseHandler
implements ResponseHandler {
    @Override
    public void handle(ResponseMessage responseData) throws OTSException, ClientException {
        assert (responseData != null);
        if (responseData.isSuccessful()) {
            return;
        }
        InputStream errorStream = responseData.getContent();
        if (errorStream == null) {
            throw OTSExceptionFactory.createResponseException(ResourceManager.getInstance("common").getString("ServerReturnsUnknownError"), null);
        }
        Map<String, String> headers = responseData.getHeaders();
        if (!headers.containsKey("x-ots-requestid")) {
            throw OTSExceptionFactory.createResponseException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("MissingHeader", "x-ots-requestid"), null);
        }
        if (!headers.containsKey("x-ots-hostid")) {
            throw OTSExceptionFactory.createResponseException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("MissingHeader", "x-ots-hostid"), null);
        }
        try {
            OtsProtocol.ErrorMessage errMsg = OtsProtocol.ErrorMessage.parseFrom(errorStream);
            throw OTSExceptionFactory.create(errMsg, headers.get("x-ots-requestid"), headers.get("x-ots-hostid"));
        }
        catch (IOException e) {
            throw OTSExceptionFactory.createResponseException(ResourceManager.getInstance("common").getString("ServerReturnsUnknownError"), e);
        }
    }
}

