/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal;

import com.aliyun.common.comm.RequestHandler;
import com.aliyun.common.comm.ServiceClient;
import com.aliyun.openservices.ClientException;
import com.aliyun.openservices.HttpMethod;
import com.aliyun.openservices.ServiceException;
import com.aliyun.openservices.ots.internal.OTSCompressUtil;
import com.aliyun.openservices.ots.internal.OTSUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.zip.Deflater;

public class OTSDeflateRequestHandler
implements RequestHandler {
    public static final String OTS_COMPRESS_TYPE = "deflate";
    private boolean enableResponseCompress = false;
    private boolean enableRequestCompress = false;

    public OTSDeflateRequestHandler(boolean enableRequestCompress, boolean enableResponseCompress) {
        this.enableRequestCompress = enableRequestCompress;
        this.enableResponseCompress = enableResponseCompress;
    }

    @Override
    public void handle(ServiceClient.Request message) throws ServiceException, ClientException {
        if (this.enableRequestCompress) {
            this.compressRequestContent(message);
        }
        if (this.enableResponseCompress) {
            message.addHeader("x-ots-response-compress-type", OTS_COMPRESS_TYPE);
        }
    }

    private void compressRequestContent(ServiceClient.Request message) {
        if (message.getMethod() != HttpMethod.POST) {
            return;
        }
        try {
            Deflater compresser = new Deflater();
            InputStream oldInput = message.getContent();
            byte[] compressedData = OTSCompressUtil.compress(oldInput, compresser);
            oldInput.close();
            message.setContent(new ByteArrayInputStream(compressedData));
            message.setContentLength(compressedData.length);
            message.addHeader("x-ots-request-compress-type", OTS_COMPRESS_TYPE);
            message.addHeader("x-ots-request-compress-size", Integer.toString(compresser.getTotalIn()));
        }
        catch (Exception e) {
            throw new ClientException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("RequestCompressFail", e.getMessage()));
        }
    }
}

