/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal;

import com.aliyun.common.auth.ServiceCredentials;
import com.aliyun.common.comm.ServiceClient;
import com.aliyun.common.utils.CodingUtils;
import com.aliyun.openservices.ClientException;
import com.aliyun.openservices.HttpMethod;
import com.aliyun.openservices.ots.OTSException;
import com.aliyun.openservices.ots.OTSServiceConfiguration;
import com.aliyun.openservices.ots.internal.OTSOperation;
import com.aliyun.openservices.ots.internal.OTSResultParserFactory;
import com.aliyun.openservices.ots.internal.OTSUtil;
import com.aliyun.openservices.ots.internal.model.ResponseContentWithMeta;
import com.aliyun.openservices.ots.model.MultiDeleteRowItem;
import com.aliyun.openservices.ots.model.MultiGetRowItem;
import com.aliyun.openservices.ots.model.MultiPutRowItem;
import com.aliyun.openservices.ots.model.OTSProtocolHelper;
import com.aliyun.openservices.ots.model.PrimaryKeyRange;
import com.aliyun.openservices.ots.model.RangeRowQueryCriteria;
import com.aliyun.openservices.ots.model.Row;
import com.aliyun.openservices.ots.model.RowChange;
import com.aliyun.openservices.ots.model.RowDeleteChange;
import com.aliyun.openservices.ots.model.RowListing;
import com.aliyun.openservices.ots.model.RowOperationStatus;
import com.aliyun.openservices.ots.model.RowPutChange;
import com.aliyun.openservices.ots.model.SingleRowQueryCriteria;
import com.aliyun.openservices.ots.protocol.OtsProtocol;
import com.google.protobuf.Message;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class OTSDataOperation
extends OTSOperation {
    private static final String ACTION_GETROW = "GetRow";
    private static final String ACTION_GETROWSBYRANGE = "GetRowsByRange";
    private static final String ACTION_MULTIGETROW = "MultiGetRow";
    private static final String ACTION_PUTDATA = "PutRow";
    private static final String ACTION_MULTIPUTROW = "MultiPutRow";
    private static final String ACTION_MULTIDELETEROW = "MultiDeleteRow";
    private static final String ACTION_DELETEDATA = "DeleteRow";
    private static final String ACTION_BATCHMODIFYDATA = "BatchModifyRow";

    public OTSDataOperation(URI endpoint, ServiceClient client, ServiceCredentials credentials, OTSServiceConfiguration serviceConfig) {
        super(endpoint, client, credentials, serviceConfig);
    }

    public OTSDataOperation(URI endpoint, ServiceClient client, ServiceCredentials credentials) {
        super(endpoint, client, credentials, new OTSServiceConfiguration());
    }

    public Row getRow(SingleRowQueryCriteria criteria, String transactionId) throws OTSException, ClientException {
        CodingUtils.assertParameterNotNull(criteria, "criteria");
        if (criteria.getPrimaryKeys().size() == 0) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("MustSetPrimaryKey"));
        }
        ResponseContentWithMeta result = (ResponseContentWithMeta)this.invoke(ACTION_GETROW, HttpMethod.POST, null, OTSProtocolHelper.buildGetRowRequest(criteria, transactionId), OTSResultParserFactory.createFactory().createProtocolBufferResultParser((Message)OtsProtocol.GetRowResponse.getDefaultInstance()));
        return OTSProtocolHelper.parseGetRowResponse((OtsProtocol.GetRowResponse)result.getMessage());
    }

    public List<Row> getRowsByRange(RangeRowQueryCriteria criteria, String transactionId) throws OTSException, ClientException {
        ArrayList<Row> rowList = new ArrayList<Row>();
        String nextToken = null;
        do {
            RowListing rowListing = this.getRowsByRange(criteria, transactionId, nextToken);
            nextToken = rowListing.getNextToken();
            rowList.addAll(rowListing.getRows());
        } while (nextToken != null);
        return rowList;
    }

    public RowListing getRowsByRange(RangeRowQueryCriteria criteria, String transactionId, String nextToken) throws OTSException, ClientException {
        CodingUtils.assertParameterNotNull(criteria, "criteria");
        if (criteria.getRange() == null) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("MustSetCriteriaRange"));
        }
        boolean isReverse = criteria.getIsReverse();
        if (!isReverse && PrimaryKeyRange.INF_MAX.equals(criteria.getRange().getBegin())) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("BeginIsInfMax"));
        }
        if (isReverse && PrimaryKeyRange.INF_MIN.equals(criteria.getRange().getBegin())) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("BeginIsInfMin"));
        }
        int comp = OTSUtil.compare(criteria.getRange().getBegin(), criteria.getRange().getEnd());
        if (!isReverse && comp > 0 || isReverse && comp < 0) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("BeginEndIncorrect"));
        }
        ResponseContentWithMeta result = (ResponseContentWithMeta)this.invoke(ACTION_GETROWSBYRANGE, HttpMethod.POST, null, OTSProtocolHelper.buildGetRowsByRangeRequest(criteria, transactionId, nextToken), OTSResultParserFactory.createFactory().createProtocolBufferResultParser((Message)OtsProtocol.GetRowsByRangeResponse.getDefaultInstance()));
        return OTSProtocolHelper.parseGetRowsByRangeResponse((OtsProtocol.GetRowsByRangeResponse)result.getMessage());
    }

    public List<MultiGetRowItem> multiGetRow(List<SingleRowQueryCriteria> criterias) throws OTSException, ClientException {
        CodingUtils.assertParameterNotNull(criterias, "criterias");
        for (SingleRowQueryCriteria criteria : criterias) {
            CodingUtils.assertParameterNotNull(criteria, "criteria");
            if (criteria.getPrimaryKeys().size() != 0) continue;
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("MustSetPrimaryKey"));
        }
        ResponseContentWithMeta result = (ResponseContentWithMeta)this.invoke(ACTION_MULTIGETROW, HttpMethod.POST, null, OTSProtocolHelper.buildMultiGetRowRequest(criterias), OTSResultParserFactory.createFactory().createProtocolBufferResultParser((Message)OtsProtocol.MultiGetRowResponse.getDefaultInstance()));
        return OTSProtocolHelper.parseMultiGetRowResponse((OtsProtocol.MultiGetRowResponse)result.getMessage(), result.getMeta());
    }

    public void putData(String tableName, RowPutChange rowChange, String transactionId) throws OTSException, ClientException {
        CodingUtils.assertParameterNotNull(tableName, "tableName");
        OTSUtil.ensureNameValid(tableName);
        CodingUtils.assertParameterNotNull(rowChange, "rowChange");
        if (rowChange.getPrimaryKeys().size() == 0) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("MustSetPrimaryKey"));
        }
        this.invokeNoResult(ACTION_PUTDATA, HttpMethod.POST, null, OTSProtocolHelper.buildPutRowRequest(tableName, rowChange, transactionId));
    }

    public List<RowOperationStatus> multiPutRow(List<MultiPutRowItem> rowChanges) {
        CodingUtils.assertParameterNotNull(rowChanges, "rowChanges");
        for (MultiPutRowItem row : rowChanges) {
            OTSUtil.ensureNameValid(row.getTableName());
            if (row.getRowPutChange().getPrimaryKeys().size() != 0) continue;
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("MustSetPrimaryKey"));
        }
        ResponseContentWithMeta result = (ResponseContentWithMeta)this.invoke(ACTION_MULTIPUTROW, HttpMethod.POST, null, OTSProtocolHelper.buildMultiPutRowRequest(rowChanges), OTSResultParserFactory.createFactory().createProtocolBufferResultParser((Message)OtsProtocol.MultiPutRowResponse.getDefaultInstance()));
        return OTSProtocolHelper.parseMultiPutRowResponse((OtsProtocol.MultiPutRowResponse)result.getMessage(), result.getMeta());
    }

    public void deleteData(String tableName, RowDeleteChange rowChange, String transactionId) throws OTSException, ClientException {
        CodingUtils.assertParameterNotNull(tableName, "tableName");
        OTSUtil.ensureNameValid(tableName);
        CodingUtils.assertParameterNotNull(rowChange, "rowChange");
        if (rowChange.getPrimaryKeys().size() == 0) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("MustSetPrimaryKey"));
        }
        this.invokeNoResult(ACTION_DELETEDATA, HttpMethod.POST, null, OTSProtocolHelper.buildDeleteRowRequest(tableName, rowChange, transactionId));
    }

    public List<RowOperationStatus> multiDeleteRow(List<MultiDeleteRowItem> rowChanges) {
        CodingUtils.assertParameterNotNull(rowChanges, "rowChanges");
        for (MultiDeleteRowItem row : rowChanges) {
            OTSUtil.ensureNameValid(row.getTableName());
            if (row.getRowDeleteChange().getPrimaryKeys().size() != 0) continue;
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("MustSetPrimaryKey"));
        }
        ResponseContentWithMeta result = (ResponseContentWithMeta)this.invoke(ACTION_MULTIDELETEROW, HttpMethod.POST, null, OTSProtocolHelper.buildMultiDeleteRowRequest(rowChanges), OTSResultParserFactory.createFactory().createProtocolBufferResultParser((Message)OtsProtocol.MultiDeleteRowResponse.getDefaultInstance()));
        return OTSProtocolHelper.parseMultiDeleteRowResponse((OtsProtocol.MultiDeleteRowResponse)result.getMessage(), result.getMeta());
    }

    public void batchModifyData(String tableName, Collection<RowChange> rowChanges, String transactionId) throws OTSException, ClientException {
        CodingUtils.assertParameterNotNull(tableName, "tableName");
        OTSUtil.ensureNameValid(tableName);
        CodingUtils.assertParameterNotNull(rowChanges, "rowChange");
        if (rowChanges.size() == 0) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("RowChangesIsEmpty"));
        }
        for (RowChange rowChange : rowChanges) {
            if (rowChange.getPrimaryKeys().size() != 0) continue;
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("MustSetPrimaryKey"));
        }
        this.invokeNoResult(ACTION_BATCHMODIFYDATA, HttpMethod.POST, null, OTSProtocolHelper.buildBatchModifyRowRequest(tableName, rowChanges, transactionId));
    }
}

