/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots;

import com.aliyun.common.auth.ServiceCredentials;
import com.aliyun.common.comm.DefaultServiceClient;
import com.aliyun.common.comm.ServiceClient;
import com.aliyun.common.utils.CodingUtils;
import com.aliyun.openservices.ClientConfiguration;
import com.aliyun.openservices.ClientException;
import com.aliyun.openservices.ots.OTS;
import com.aliyun.openservices.ots.OTSException;
import com.aliyun.openservices.ots.OTSServiceConfiguration;
import com.aliyun.openservices.ots.internal.OTSDataOperation;
import com.aliyun.openservices.ots.internal.OTSTableOperation;
import com.aliyun.openservices.ots.internal.OTSTransactionOperation;
import com.aliyun.openservices.ots.internal.OTSUtil;
import com.aliyun.openservices.ots.model.MultiDeleteRowItem;
import com.aliyun.openservices.ots.model.MultiGetRowItem;
import com.aliyun.openservices.ots.model.MultiPutRowItem;
import com.aliyun.openservices.ots.model.PartitionKeyType;
import com.aliyun.openservices.ots.model.PartitionKeyValue;
import com.aliyun.openservices.ots.model.PartitionSchema;
import com.aliyun.openservices.ots.model.RangeRowQueryCriteria;
import com.aliyun.openservices.ots.model.Row;
import com.aliyun.openservices.ots.model.RowChange;
import com.aliyun.openservices.ots.model.RowDeleteChange;
import com.aliyun.openservices.ots.model.RowListing;
import com.aliyun.openservices.ots.model.RowOperationStatus;
import com.aliyun.openservices.ots.model.RowPutChange;
import com.aliyun.openservices.ots.model.SingleRowQueryCriteria;
import com.aliyun.openservices.ots.model.TableMeta;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;

public class OTSClient
implements OTS {
    private URI endpoint;
    private ServiceCredentials credentials;
    private ServiceClient client;
    private OTSServiceConfiguration serviceConfig;
    private OTSTableOperation tableOp;
    private OTSTransactionOperation transactionOp;
    private OTSDataOperation dataOp;

    public OTSClient(String accessKeyId, String accessKeySecret) {
        this("http://ots.aliyuncs.com", accessKeyId, accessKeySecret, null);
    }

    public OTSClient(String endpoint, String accessKeyId, String accessKeySecret) {
        this(endpoint, accessKeyId, accessKeySecret, null);
    }

    public OTSClient(String endpoint, String accessKeyId, String accessKeySecret, ClientConfiguration config) {
        this(endpoint, accessKeyId, accessKeySecret, config, null);
    }

    public OTSClient(String endpoint, String accessKeyId, String accessKeySecret, ClientConfiguration config, OTSServiceConfiguration otsConfig) {
        CodingUtils.assertStringNotNullOrEmpty(endpoint, "endpoint");
        CodingUtils.assertStringNotNullOrEmpty(accessKeyId, "accessKeyId");
        CodingUtils.assertStringNotNullOrEmpty(accessKeySecret, "accessKeySecret");
        try {
            if (!endpoint.startsWith("http://")) {
                throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("EndpointProtocolInvalid"));
            }
            this.endpoint = new URI(endpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("EndpointInvalid"), e);
        }
        this.credentials = new ServiceCredentials(accessKeyId, accessKeySecret);
        this.client = new DefaultServiceClient(config != null ? config : new ClientConfiguration());
        this.serviceConfig = otsConfig != null ? otsConfig : new OTSServiceConfiguration();
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    @Override
    public void createTableGroup(String tableGroupName, PartitionKeyType pkType) throws OTSException, ClientException {
        this.getTableOperation().createTableGroup(tableGroupName, pkType);
    }

    @Override
    public List<String> listTableGroups() throws OTSException, ClientException {
        return this.getTableOperation().listTableGroups();
    }

    @Override
    public void createTableGroupEx(String tableGroupName, PartitionSchema schema) throws OTSException, ClientException {
        this.getTableOperation().createTableGroupEx(tableGroupName, schema);
    }

    @Override
    public void createTableEx(TableMeta tableMeta, PartitionSchema schema) throws OTSException, ClientException {
        this.getTableOperation().createTableEx(tableMeta, schema);
    }

    @Override
    public void deleteTableGroup(String tableGroupName) throws OTSException, ClientException {
        this.getTableOperation().deleteTableGroup(tableGroupName);
    }

    @Override
    public void createTable(TableMeta tableMeta) throws OTSException, ClientException {
        this.getTableOperation().createTable(tableMeta);
    }

    @Override
    public TableMeta getTableMeta(String tableName) throws OTSException, ClientException {
        return this.getTableOperation().getTableMeta(tableName);
    }

    @Override
    public List<String> listTables() throws OTSException, ClientException {
        return this.getTableOperation().listTables();
    }

    @Override
    public void deleteTable(String tableName) throws OTSException, ClientException {
        this.getTableOperation().deleteTable(tableName);
    }

    @Override
    public String startTransaction(String entityName, PartitionKeyValue pkValue) throws OTSException, ClientException {
        return this.getTransactionOperation().startTransaction(entityName, pkValue);
    }

    @Override
    public void commitTransaction(String transactionId) throws OTSException, ClientException {
        this.getTransactionOperation().commitTransaction(transactionId);
    }

    @Override
    public void abortTransaction(String transactionId) throws OTSException, ClientException {
        this.getTransactionOperation().abortTransaction(transactionId);
    }

    @Override
    public Row getRow(SingleRowQueryCriteria criteria, String transactionId) throws OTSException, ClientException {
        return this.getDataOperation().getRow(criteria, transactionId);
    }

    @Override
    public List<Row> getRowsByRange(RangeRowQueryCriteria criteria, String transactionId) throws OTSException, ClientException {
        return this.getDataOperation().getRowsByRange(criteria, transactionId);
    }

    @Override
    public RowListing getRowsByRange(RangeRowQueryCriteria criteria, String transactionId, String nextToken) throws OTSException, ClientException {
        return this.getDataOperation().getRowsByRange(criteria, transactionId, nextToken);
    }

    @Override
    public List<MultiGetRowItem> multiGetRow(List<SingleRowQueryCriteria> criterias) throws OTSException, ClientException {
        return this.getDataOperation().multiGetRow(criterias);
    }

    @Override
    public void putData(String tableName, RowPutChange rowChange, String transactionId) throws OTSException, ClientException {
        this.getDataOperation().putData(tableName, rowChange, transactionId);
    }

    @Override
    public List<RowOperationStatus> multiPutRow(List<MultiPutRowItem> rowChanges) throws OTSException, ClientException {
        return this.getDataOperation().multiPutRow(rowChanges);
    }

    @Override
    public void deleteData(String tableName, RowDeleteChange rowChange, String transactionId) throws OTSException, ClientException {
        this.getDataOperation().deleteData(tableName, rowChange, transactionId);
    }

    @Override
    public List<RowOperationStatus> multiDeleteRow(List<MultiDeleteRowItem> rowChanges) throws OTSException, ClientException {
        return this.getDataOperation().multiDeleteRow(rowChanges);
    }

    @Override
    public void batchModifyData(String tableName, Collection<RowChange> rowChanges, String transactionId) throws OTSException, ClientException {
        this.getDataOperation().batchModifyData(tableName, rowChanges, transactionId);
    }

    private OTSTableOperation getTableOperation() {
        if (this.tableOp == null) {
            this.tableOp = new OTSTableOperation(this.endpoint, this.client, this.credentials, this.serviceConfig);
        }
        return this.tableOp;
    }

    private OTSTransactionOperation getTransactionOperation() {
        if (this.transactionOp == null) {
            this.transactionOp = new OTSTransactionOperation(this.endpoint, this.client, this.credentials, this.serviceConfig);
        }
        return this.transactionOp;
    }

    private OTSDataOperation getDataOperation() {
        if (this.dataOp == null) {
            this.dataOp = new OTSDataOperation(this.endpoint, this.client, this.credentials, this.serviceConfig);
        }
        return this.dataOp;
    }
}

